/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.jvm.plugins;

import java.util.Collections;
import java.util.Map;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.SourceTransformTaskConfig;
import org.gradle.language.base.internal.registry.LanguageTransform;
import org.gradle.language.base.internal.registry.LanguageTransformContainer;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.jvm.internal.DefaultJvmResourceLanguageSourceSet;
import org.gradle.language.jvm.tasks.ProcessResources;
import org.gradle.model.Mutate;
import org.gradle.model.RuleSource;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class JvmResourcesPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPluginManager().apply(ComponentModelBasePlugin.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JvmResources
    implements LanguageTransform<JvmResourceSet, org.gradle.jvm.JvmResources> {
        private JvmResources() {
        }

        public Class<JvmResourceSet> getSourceSetType() {
            return JvmResourceSet.class;
        }

        public Map<String, Class<?>> getBinaryTools() {
            return Collections.emptyMap();
        }

        public Class<org.gradle.jvm.JvmResources> getOutputType() {
            return org.gradle.jvm.JvmResources.class;
        }

        public SourceTransformTaskConfig getTransformTask() {
            return new SourceTransformTaskConfig(){

                public String getTaskPrefix() {
                    return "process";
                }

                public Class<? extends DefaultTask> getTaskType() {
                    return ProcessResources.class;
                }

                public void configureTask(Task task, BinarySpec binary, LanguageSourceSet sourceSet, ServiceRegistry serviceRegistry) {
                    ProcessResources resourcesTask = (ProcessResources)task;
                    JvmResourceSet resourceSet = (JvmResourceSet)sourceSet;
                    JvmBinarySpec jvmBinary = (JvmBinarySpec)binary;
                    resourcesTask.from(new Object[]{resourceSet.getSource()});
                    resourcesTask.setDestinationDir(jvmBinary.getResourcesDir());
                    for (Task jarTask : binary.getTasks().withType(Jar.class)) {
                        jarTask.dependsOn(new Object[]{resourcesTask});
                    }
                }
            };
        }

        public boolean applyToBinary(BinarySpec binary) {
            return binary instanceof JvmBinarySpec;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @LanguageType
        void registerLanguage(LanguageTypeBuilder<JvmResourceSet> builder) {
            builder.setLanguageName("resources");
            builder.defaultImplementation(DefaultJvmResourceLanguageSourceSet.class);
        }

        @Mutate
        void registerLanguageTransform(LanguageTransformContainer languages, ServiceRegistry serviceRegistry) {
            languages.add((Object)new JvmResources());
        }
    }
}

