/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.file.DefaultSourceDirectorySet;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.jvm.ClassDirectoryBinaryNamingScheme;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.platform.base.internal.BinaryNamingScheme;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.GUtil;

public class DefaultSourceSet
implements SourceSet {
    private final String name;
    private FileCollection compileClasspath;
    private FileCollection runtimeClasspath;
    private final SourceDirectorySet javaSource;
    private final SourceDirectorySet allJavaSource;
    private final SourceDirectorySet resources;
    private final String displayName;
    private final SourceDirectorySet allSource;
    private final BinaryNamingScheme namingScheme;
    private DefaultSourceSetOutput output;

    public DefaultSourceSet(String name, FileResolver fileResolver) {
        this.name = name;
        this.displayName = GUtil.toWords((CharSequence)this.name);
        this.namingScheme = new ClassDirectoryBinaryNamingScheme(name);
        String javaSrcDisplayName = String.format("%s Java source", this.displayName);
        this.javaSource = new DefaultSourceDirectorySet(javaSrcDisplayName, fileResolver);
        this.javaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource = new DefaultSourceDirectorySet(javaSrcDisplayName, fileResolver);
        this.allJavaSource.getFilter().include(new String[]{"**/*.java"});
        this.allJavaSource.source(this.javaSource);
        String resourcesDisplayName = String.format("%s resources", this.displayName);
        this.resources = new DefaultSourceDirectorySet(resourcesDisplayName, fileResolver);
        this.resources.getFilter().exclude((Spec)new Spec<FileTreeElement>(){

            public boolean isSatisfiedBy(FileTreeElement element) {
                return DefaultSourceSet.this.javaSource.contains(element.getFile());
            }
        });
        String allSourceDisplayName = String.format("%s source", this.displayName);
        this.allSource = new DefaultSourceDirectorySet(allSourceDisplayName, fileResolver);
        this.allSource.source(this.resources);
        this.allSource.source(this.javaSource);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("source set '%s'", this.getDisplayName());
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getClassesTaskName() {
        return this.getTaskName(null, "classes");
    }

    public String getCompileTaskName(String language) {
        return this.getTaskName("compile", language);
    }

    public String getCompileJavaTaskName() {
        return this.getCompileTaskName("java");
    }

    public String getProcessResourcesTaskName() {
        return this.getTaskName("process", "resources");
    }

    public String getJarTaskName() {
        return this.getTaskName(null, "jar");
    }

    public String getTaskName(String verb, String target) {
        return this.namingScheme.getTaskName(verb, target);
    }

    private String getTaskBaseName() {
        return this.name.equals("main") ? "" : GUtil.toCamelCase((CharSequence)this.name);
    }

    public String getCompileConfigurationName() {
        return StringUtils.uncapitalize((String)String.format("%sCompile", this.getTaskBaseName()));
    }

    public String getRuntimeConfigurationName() {
        return StringUtils.uncapitalize((String)String.format("%sRuntime", this.getTaskBaseName()));
    }

    public SourceSetOutput getOutput() {
        return this.output;
    }

    public void setClasses(DefaultSourceSetOutput classes) {
        this.output = classes;
    }

    public SourceSet compiledBy(Object ... taskPaths) {
        this.output.builtBy(taskPaths);
        return this;
    }

    public FileCollection getCompileClasspath() {
        return this.compileClasspath;
    }

    public FileCollection getRuntimeClasspath() {
        return this.runtimeClasspath;
    }

    public void setCompileClasspath(FileCollection classpath) {
        this.compileClasspath = classpath;
    }

    public void setRuntimeClasspath(FileCollection classpath) {
        this.runtimeClasspath = classpath;
    }

    public SourceDirectorySet getJava() {
        return this.javaSource;
    }

    public SourceSet java(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getJava());
        return this;
    }

    public SourceDirectorySet getAllJava() {
        return this.allJavaSource;
    }

    public SourceDirectorySet getResources() {
        return this.resources;
    }

    public SourceSet resources(Closure configureClosure) {
        ConfigureUtil.configure((Closure)configureClosure, (Object)this.getResources());
        return this;
    }

    public SourceDirectorySet getAllSource() {
        return this.allSource;
    }
}

