/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.artifacts.publish.DefaultPublishArtifact;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.tasks.scala.IncrementalCompileOptions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.tasks.Jar;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.sources.BaseLanguageSourceSet;
import org.gradle.language.java.JavaSourceSet;
import org.gradle.language.java.plugins.JavaLanguagePlugin;
import org.gradle.language.jvm.JvmResourceSet;
import org.gradle.language.routes.RoutesSourceSet;
import org.gradle.language.routes.internal.DefaultRoutesSourceSet;
import org.gradle.language.scala.ScalaLanguageSourceSet;
import org.gradle.language.scala.internal.DefaultScalaLanguageSourceSet;
import org.gradle.language.scala.plugins.ScalaLanguagePlugin;
import org.gradle.language.scala.tasks.PlatformScalaCompile;
import org.gradle.language.twirl.TwirlSourceSet;
import org.gradle.language.twirl.internal.DefaultTwirlSourceSet;
import org.gradle.model.Model;
import org.gradle.model.ModelMap;
import org.gradle.model.Mutate;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.Validate;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentBinaries;
import org.gradle.platform.base.ComponentType;
import org.gradle.platform.base.ComponentTypeBuilder;
import org.gradle.platform.base.LanguageType;
import org.gradle.platform.base.LanguageTypeBuilder;
import org.gradle.platform.base.internal.DefaultPlatformRequirement;
import org.gradle.platform.base.internal.PlatformRequirement;
import org.gradle.platform.base.internal.PlatformResolver;
import org.gradle.platform.base.internal.PlatformResolvers;
import org.gradle.play.JvmClasses;
import org.gradle.play.PlayApplicationBinarySpec;
import org.gradle.play.PlayApplicationSpec;
import org.gradle.play.PublicAssets;
import org.gradle.play.internal.DefaultPlayApplicationBinarySpec;
import org.gradle.play.internal.DefaultPlayApplicationSpec;
import org.gradle.play.internal.PlayApplicationBinarySpecInternal;
import org.gradle.play.internal.PlayApplicationSpecInternal;
import org.gradle.play.internal.PlayPlatformResolver;
import org.gradle.play.internal.PlaySourceSetRules;
import org.gradle.play.internal.platform.PlayPlatformInternal;
import org.gradle.play.internal.run.PlayApplicationRunnerFactory;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.play.plugins.PlayPluginConfigurations;
import org.gradle.play.tasks.PlayRun;
import org.gradle.play.tasks.RoutesCompile;
import org.gradle.play.tasks.TwirlCompile;
import org.gradle.util.VersionNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Incubating
public class PlayApplicationPlugin
implements Plugin<Project> {
    public static final int DEFAULT_HTTP_PORT = 9000;
    public static final String RUN_GROUP = "Run";
    private final ModelRegistry modelRegistry;

    @Inject
    public PlayApplicationPlugin(ModelRegistry modelRegistry) {
        this.modelRegistry = modelRegistry;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(JavaLanguagePlugin.class);
        project.getPluginManager().apply(ScalaLanguagePlugin.class);
        project.getExtensions().create("playConfigurations", PlayPluginConfigurations.class, new Object[]{project.getConfigurations(), project.getDependencies()});
        this.modelRegistry.getRoot().applyToAllLinksTransitive(ModelType.of(PlayApplicationSpec.class), PlaySourceSetRules.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Rules
    extends RuleSource {
        Rules() {
        }

        @Model
        PlayPluginConfigurations configurations(ExtensionContainer extensions) {
            return (PlayPluginConfigurations)extensions.getByType(PlayPluginConfigurations.class);
        }

        @Model
        PlayToolChainInternal playToolChain(ServiceRegistry serviceRegistry) {
            return (PlayToolChainInternal)serviceRegistry.get(PlayToolChainInternal.class);
        }

        @Model
        FileResolver fileResolver(ServiceRegistry serviceRegistry) {
            return (FileResolver)serviceRegistry.get(FileResolver.class);
        }

        @ComponentType
        void register(ComponentTypeBuilder<PlayApplicationSpec> builder) {
            builder.defaultImplementation(DefaultPlayApplicationSpec.class);
        }

        @Mutate
        public void registerPlatformResolver(PlatformResolvers platformResolvers) {
            platformResolvers.register((PlatformResolver)new PlayPlatformResolver());
        }

        @Mutate
        void createDefaultPlayApp(ModelMap<PlayApplicationSpec> builder) {
            builder.create("play");
        }

        @BinaryType
        void registerApplication(BinaryTypeBuilder<PlayApplicationBinarySpec> builder) {
            builder.defaultImplementation(DefaultPlayApplicationBinarySpec.class);
            builder.internalView(PlayApplicationBinarySpecInternal.class);
        }

        @LanguageType
        void registerTwirlLanguageType(LanguageTypeBuilder<TwirlSourceSet> builder) {
            builder.setLanguageName("twirl");
            builder.defaultImplementation(DefaultTwirlSourceSet.class);
        }

        @LanguageType
        void registerRoutesLanguageType(LanguageTypeBuilder<RoutesSourceSet> builder) {
            builder.setLanguageName("routes");
            builder.defaultImplementation(DefaultRoutesSourceSet.class);
        }

        @Validate
        void failOnMultiplePlayComponents(ModelMap<PlayApplicationSpec> container) {
            if (container.size() >= 2) {
                throw new GradleException("Multiple components of type 'PlayApplicationSpec' are not supported.");
            }
        }

        @Validate
        void failOnMultipleTargetPlatforms(ModelMap<PlayApplicationSpec> playApplications) {
            playApplications.afterEach((Action)new Action<PlayApplicationSpec>(){

                public void execute(PlayApplicationSpec playApplication) {
                    PlayApplicationSpecInternal playApplicationInternal = (PlayApplicationSpecInternal)playApplication;
                    if (playApplicationInternal.getTargetPlatforms().size() > 1) {
                        throw new GradleException("Multiple target platforms for 'PlayApplicationSpec' is not (yet) supported.");
                    }
                }
            });
        }

        @Validate
        void failIfInjectedRouterIsUsedWithOldVersion(ModelMap<PlayApplicationBinarySpec> playApplicationBinaries) {
            playApplicationBinaries.afterEach((Action)new Action<PlayApplicationBinarySpec>(){

                public void execute(PlayApplicationBinarySpec playApplicationBinary) {
                    if (playApplicationBinary.getApplication().getInjectedRoutesGenerator()) {
                        PlayPlatform playPlatform = playApplicationBinary.getTargetPlatform();
                        VersionNumber minSupportedVersion = VersionNumber.parse((String)"2.4.0");
                        VersionNumber playVersion = VersionNumber.parse((String)playPlatform.getPlayVersion());
                        if (playVersion.compareTo(minSupportedVersion) < 0) {
                            throw new GradleException("Injected routers are only supported in Play 2.4 or newer.");
                        }
                    }
                }
            });
        }

        @ComponentBinaries
        void createBinaries(ModelMap<PlayApplicationBinarySpec> binaries, final PlayApplicationSpec componentSpec, final PlatformResolvers platforms, final PlayToolChainInternal playToolChainInternal, final PlayPluginConfigurations configurations, ServiceRegistry serviceRegistry, final @Path(value="buildDir") File buildDir, final ProjectIdentifier projectIdentifier) {
            FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            final String binaryName = String.format("%sBinary", componentSpec.getName());
            binaries.create(binaryName, (Action)new Action<PlayApplicationBinarySpec>(){

                public void execute(PlayApplicationBinarySpec playBinary) {
                    PlayApplicationBinarySpecInternal playBinaryInternal = (PlayApplicationBinarySpecInternal)playBinary;
                    playBinaryInternal.setApplication(componentSpec);
                    File binaryBuildDir = new File(buildDir, binaryName);
                    PlayPlatform chosenPlatform = Rules.this.resolveTargetPlatform(componentSpec, platforms);
                    Rules.this.initialiseConfigurations(configurations, chosenPlatform);
                    playBinaryInternal.setTargetPlatform(chosenPlatform);
                    playBinaryInternal.setToolChain(playToolChainInternal);
                    File mainJar = new File(binaryBuildDir, String.format("lib/%s.jar", projectIdentifier.getName()));
                    File assetsJar = new File(binaryBuildDir, String.format("lib/%s-assets.jar", projectIdentifier.getName()));
                    playBinaryInternal.setJarFile(mainJar);
                    playBinaryInternal.setAssetsJarFile(assetsJar);
                    configurations.getPlay().addArtifact((PublishArtifact)new DefaultPublishArtifact(projectIdentifier.getName(), "jar", "jar", null, new Date(), mainJar, new Object[]{playBinaryInternal}));
                    configurations.getPlay().addArtifact((PublishArtifact)new DefaultPublishArtifact(projectIdentifier.getName(), "jar", "jar", "assets", new Date(), assetsJar, new Object[]{playBinaryInternal}));
                    JvmClasses classes = playBinary.getClasses();
                    classes.setClassesDir(new File(binaryBuildDir, "classes"));
                    ModelMap jvmResourceSets = componentSpec.getSources().withType(JvmResourceSet.class);
                    for (JvmResourceSet jvmResourceSet : jvmResourceSets.values()) {
                        for (File resourceDir : jvmResourceSet.getSource()) {
                            classes.addResourceDir(resourceDir);
                        }
                    }
                    PublicAssets assets = playBinary.getAssets();
                    assets.addAssetDir(new File(projectIdentifier.getProjectDir(), "public"));
                    playBinaryInternal.setClasspath(configurations.getPlay().getAllArtifacts());
                }
            });
        }

        private PlayPlatform resolveTargetPlatform(PlayApplicationSpec componentSpec, PlatformResolvers platforms) {
            PlatformRequirement targetPlatform = this.getTargetPlatform((PlayApplicationSpecInternal)componentSpec);
            return (PlayPlatform)platforms.resolve(PlayPlatform.class, targetPlatform);
        }

        private PlatformRequirement getTargetPlatform(PlayApplicationSpecInternal playApplicationSpec) {
            if (playApplicationSpec.getTargetPlatforms().isEmpty()) {
                String defaultPlayPlatform = String.format("play-%s", "2.3.9");
                return DefaultPlatformRequirement.create((String)defaultPlayPlatform);
            }
            return (PlatformRequirement)playApplicationSpec.getTargetPlatforms().get(0);
        }

        private void initialiseConfigurations(PlayPluginConfigurations configurations, PlayPlatform playPlatform) {
            configurations.getPlayPlatform().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play"));
            configurations.getPlayTest().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play-test"));
            configurations.getPlayRun().addDependency(((PlayPlatformInternal)playPlatform).getDependencyNotation("play-docs"));
            this.addRunSupportDependencies(configurations, playPlatform);
        }

        private void addRunSupportDependencies(PlayPluginConfigurations configurations, PlayPlatform playPlatform) {
            String playVersion = playPlatform.getPlayVersion();
            String scalaCompatibilityVersion = playPlatform.getScalaPlatform().getScalaCompatibilityVersion();
            Iterable<Dependency> runSupportDependencies = PlayApplicationRunnerFactory.createPlayRunAdapter(playPlatform).getRunsupportClasspathDependencies(playVersion, scalaCompatibilityVersion);
            for (Dependency dependencyNotation : runSupportDependencies) {
                configurations.getPlayRun().addDependency(dependencyNotation);
            }
        }

        @Mutate
        void createGeneratedScalaSourceSets(ModelMap<PlayApplicationBinarySpec> binaries, ServiceRegistry serviceRegistry) {
            this.createGeneratedScalaSourceSetsForType(TwirlSourceSet.class, binaries, serviceRegistry);
            this.createGeneratedScalaSourceSetsForType(RoutesSourceSet.class, binaries, serviceRegistry);
        }

        void createGeneratedScalaSourceSetsForType(final Class<? extends LanguageSourceSet> languageSourceSetType, ModelMap<PlayApplicationBinarySpec> binaries, ServiceRegistry serviceRegistry) {
            final FileResolver fileResolver = (FileResolver)serviceRegistry.get(FileResolver.class);
            final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
            binaries.all((Action)new Action<PlayApplicationBinarySpec>(){

                public void execute(PlayApplicationBinarySpec playApplicationBinarySpec) {
                    for (LanguageSourceSet languageSourceSet : playApplicationBinarySpec.getInputs().withType(languageSourceSetType)) {
                        String name = String.format("%sScalaSources", languageSourceSet.getName());
                        ScalaLanguageSourceSet twirlScalaSources = (ScalaLanguageSourceSet)BaseLanguageSourceSet.create(DefaultScalaLanguageSourceSet.class, (String)name, (String)playApplicationBinarySpec.getName(), (FileResolver)fileResolver, (Instantiator)instantiator);
                        playApplicationBinarySpec.getGeneratedScala().put(languageSourceSet, twirlScalaSources);
                    }
                }
            });
        }

        @BinaryTasks
        void createTwirlCompileTasks(ModelMap<Task> tasks, final PlayApplicationBinarySpec binary, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir) {
            for (final TwirlSourceSet twirlSourceSet : binary.getInputs().withType(TwirlSourceSet.class)) {
                String twirlCompileTaskName = String.format("compile%s%s", StringUtils.capitalize((String)binary.getName()), StringUtils.capitalize((String)twirlSourceSet.getName()));
                final File twirlCompileOutputDirectory = this.srcOutputDirectory(buildDir, binary, twirlCompileTaskName);
                tasks.create(twirlCompileTaskName, TwirlCompile.class, (Action)new Action<TwirlCompile>(){

                    public void execute(TwirlCompile twirlCompile) {
                        twirlCompile.setDescription("Compiles twirl templates for the '" + twirlSourceSet.getName() + "' source set.");
                        twirlCompile.setPlatform(binary.getTargetPlatform());
                        twirlCompile.setSource(twirlSourceSet.getSource());
                        twirlCompile.setOutputDirectory(twirlCompileOutputDirectory);
                        ScalaLanguageSourceSet twirlScalaSources = binary.getGeneratedScala().get(twirlSourceSet);
                        twirlScalaSources.getSource().srcDir((Object)twirlCompileOutputDirectory);
                        twirlScalaSources.builtBy(new Object[]{twirlCompile});
                    }
                });
            }
        }

        @BinaryTasks
        void createRoutesCompileTasks(ModelMap<Task> tasks, final PlayApplicationBinarySpec binary, ServiceRegistry serviceRegistry, @Path(value="buildDir") File buildDir) {
            for (final RoutesSourceSet routesSourceSet : binary.getInputs().withType(RoutesSourceSet.class)) {
                String routesCompileTaskName = String.format("compile%s%s", StringUtils.capitalize((String)binary.getName()), StringUtils.capitalize((String)routesSourceSet.getName()));
                final File routesCompilerOutputDirectory = this.srcOutputDirectory(buildDir, binary, routesCompileTaskName);
                tasks.create(routesCompileTaskName, RoutesCompile.class, (Action)new Action<RoutesCompile>(){

                    public void execute(RoutesCompile routesCompile) {
                        routesCompile.setDescription("Generates routes for the '" + routesSourceSet.getName() + "' source set.");
                        routesCompile.setPlatform(binary.getTargetPlatform());
                        routesCompile.setAdditionalImports(new ArrayList<String>());
                        routesCompile.setSource(routesSourceSet.getSource());
                        routesCompile.setOutputDirectory(routesCompilerOutputDirectory);
                        routesCompile.setInjectedRoutesGenerator(binary.getApplication().getInjectedRoutesGenerator());
                        ScalaLanguageSourceSet routesScalaSources = binary.getGeneratedScala().get(routesSourceSet);
                        routesScalaSources.getSource().srcDir((Object)routesCompilerOutputDirectory);
                        routesScalaSources.builtBy(new Object[]{routesCompile});
                    }
                });
            }
        }

        @BinaryTasks
        void createScalaCompileTask(ModelMap<Task> tasks, final PlayApplicationBinarySpec binary, final @Path(value="buildDir") File buildDir) {
            final String scalaCompileTaskName = String.format("compile%s%s", StringUtils.capitalize((String)binary.getName()), "Scala");
            tasks.create(scalaCompileTaskName, PlatformScalaCompile.class, (Action)new Action<PlatformScalaCompile>(){

                public void execute(PlatformScalaCompile scalaCompile) {
                    scalaCompile.setDescription("Compiles all scala and java source sets for the '" + binary.getName() + "' binary.");
                    scalaCompile.setDestinationDir(binary.getClasses().getClassesDir());
                    scalaCompile.setPlatform(binary.getTargetPlatform().getScalaPlatform());
                    String targetCompatibility = binary.getTargetPlatform().getJavaPlatform().getTargetCompatibility().getMajorVersion();
                    scalaCompile.setSourceCompatibility(targetCompatibility);
                    scalaCompile.setTargetCompatibility(targetCompatibility);
                    IncrementalCompileOptions incrementalOptions = scalaCompile.getScalaCompileOptions().getIncrementalOptions();
                    incrementalOptions.setAnalysisFile(new File(buildDir, String.format("tmp/scala/compilerAnalysis/%s.analysis", scalaCompileTaskName)));
                    for (LanguageSourceSet languageSourceSet : binary.getInputs().withType(ScalaLanguageSourceSet.class)) {
                        scalaCompile.source(new Object[]{languageSourceSet.getSource()});
                        scalaCompile.dependsOn(new Object[]{languageSourceSet});
                    }
                    for (LanguageSourceSet languageSourceSet : binary.getInputs().withType(JavaSourceSet.class)) {
                        scalaCompile.source(new Object[]{languageSourceSet.getSource()});
                        scalaCompile.dependsOn(new Object[]{languageSourceSet});
                    }
                    for (LanguageSourceSet languageSourceSet : binary.getGeneratedScala().values()) {
                        scalaCompile.source(new Object[]{languageSourceSet.getSource()});
                        scalaCompile.dependsOn(new Object[]{languageSourceSet});
                    }
                    scalaCompile.setClasspath(((PlayApplicationBinarySpecInternal)binary).getClasspath());
                    binary.getClasses().builtBy(new Object[]{scalaCompile});
                }
            });
        }

        @BinaryTasks
        void createJarTasks(ModelMap<Task> tasks, final PlayApplicationBinarySpec binary) {
            String jarTaskName = String.format("create%sJar", StringUtils.capitalize((String)binary.getName()));
            tasks.create(jarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription("Assembles the application jar for the '" + binary.getName() + "' binary.");
                    jar.setDestinationDir(binary.getJarFile().getParentFile());
                    jar.setArchiveName(binary.getJarFile().getName());
                    jar.from(new Object[]{binary.getClasses().getClassesDir()});
                    jar.from(new Object[]{binary.getClasses().getResourceDirs()});
                    jar.dependsOn(new Object[]{binary.getClasses()});
                }
            });
            String assetsJarTaskName = String.format("create%sAssetsJar", StringUtils.capitalize((String)binary.getName()));
            tasks.create(assetsJarTaskName, Jar.class, (Action)new Action<Jar>(){

                public void execute(Jar jar) {
                    jar.setDescription("Assembles the assets jar for the '" + binary.getName() + "' binary.");
                    jar.setDestinationDir(binary.getAssetsJarFile().getParentFile());
                    jar.setArchiveName(binary.getAssetsJarFile().getName());
                    jar.setClassifier("assets");
                    CopySpecInternal newSpec = jar.getRootSpec().addChild();
                    newSpec.from(new Object[]{binary.getAssets().getAssetDirs()});
                    newSpec.into((Object)"public");
                    jar.dependsOn(new Object[]{binary.getAssets()});
                }
            });
        }

        @Mutate
        void createPlayRunTask(ModelMap<Task> tasks, ModelMap<PlayApplicationBinarySpecInternal> playBinaries, ServiceRegistry serviceRegistry, final PlayPluginConfigurations configurations, ProjectIdentifier projectIdentifier, final PlayToolChainInternal playToolChain) {
            for (final PlayApplicationBinarySpecInternal binary : playBinaries) {
                String runTaskName = String.format("run%s", StringUtils.capitalize((String)binary.getName()));
                tasks.create(runTaskName, PlayRun.class, (Action)new Action<PlayRun>(){

                    public void execute(PlayRun playRun) {
                        playRun.setDescription("Runs the Play application for local development.");
                        playRun.setGroup(PlayApplicationPlugin.RUN_GROUP);
                        playRun.setHttpPort(9000);
                        playRun.setPlayToolProvider(playToolChain.select(binary.getTargetPlatform()));
                        playRun.setApplicationJar(binary.getJarFile());
                        playRun.setAssetsJar(binary.getAssetsJarFile());
                        playRun.setAssetsDirs(binary.getAssets().getAssetDirs());
                        playRun.setRuntimeClasspath(configurations.getPlayRun().getNonChangingArtifacts());
                        playRun.setChangingClasspath(configurations.getPlayRun().getChangingArtifacts());
                        playRun.dependsOn(new Object[]{binary.getBuildTask()});
                    }
                });
            }
        }

        private File srcOutputDirectory(File buildDir, PlayApplicationBinarySpec binary, String taskName) {
            return new File(buildDir, String.format("%s/src/%s", binary.getName(), taskName));
        }
    }
}

