/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.Lists;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaExtractionContext;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Contextual
public class InvalidManagedModelElementTypeException
extends RuntimeException {
    private static String createPathString(ModelSchemaExtractionContext<?> extractionContext) {
        StringBuilder prefix = new StringBuilder("  ");
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        LinkedList descriptions = Lists.newLinkedList();
        for (ModelSchemaExtractionContext<?> current = extractionContext; current != null; current = current.getParent()) {
            descriptions.push(current.getDescription());
        }
        writer.println((String)descriptions.pop());
        while (!descriptions.isEmpty()) {
            writer.print(prefix);
            writer.print("\\--- ");
            writer.print((String)descriptions.pop());
            if (descriptions.isEmpty()) continue;
            writer.println();
            prefix.append("  ");
        }
        return out.toString();
    }

    private static String getMessage(ModelSchemaExtractionContext<?> extractionContext, String message) {
        ModelType<?> type = extractionContext.getType();
        StringWriter out = new StringWriter();
        PrintWriter writer = new PrintWriter(out);
        writer.print("Invalid managed model type " + type + ": " + message);
        if (extractionContext.getParent() != null) {
            writer.println();
            writer.println("The type was analyzed due to the following dependencies:");
            writer.print(InvalidManagedModelElementTypeException.createPathString(extractionContext));
        }
        return out.toString();
    }

    public InvalidManagedModelElementTypeException(ModelSchemaExtractionContext<?> extractionContext, String message) {
        this(extractionContext, message, null);
    }

    public InvalidManagedModelElementTypeException(ModelSchemaExtractionContext<?> extractionContext, String message, Throwable throwable) {
        super(InvalidManagedModelElementTypeException.getMessage(extractionContext, message), throwable);
    }
}

