/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.language.base.internal.DependentSourceSetInternal;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.DependencySpecContainer;
import org.gradle.reporting.ReportRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceSetRenderer
extends ReportRenderer<LanguageSourceSet, TextReportBuilder> {
    static final Comparator<LanguageSourceSet> SORT_ORDER = new Comparator<LanguageSourceSet>(){

        @Override
        public int compare(LanguageSourceSet o1, LanguageSourceSet o2) {
            return o1.getDisplayName().compareToIgnoreCase(o2.getDisplayName());
        }
    };

    SourceSetRenderer() {
    }

    public void render(LanguageSourceSet sourceSet, TextReportBuilder builder) {
        builder.heading(StringUtils.capitalize((String)sourceSet.getDisplayName()));
        this.renderSourceSetDirectories(sourceSet, builder);
        this.renderSourceSetDependencies(sourceSet, builder);
    }

    private void renderSourceSetDirectories(LanguageSourceSet sourceSet, TextReportBuilder builder) {
        Set srcDirs = sourceSet.getSource().getSrcDirs();
        if (srcDirs.isEmpty()) {
            builder.item("No source directories");
        } else {
            Set filterIncludes;
            Set excludes;
            for (File file : srcDirs) {
                builder.item("srcDir", file);
            }
            SourceDirectorySet source = sourceSet.getSource();
            Set includes = source.getIncludes();
            if (!includes.isEmpty()) {
                builder.item("includes", includes);
            }
            if (!(excludes = source.getExcludes()).isEmpty()) {
                builder.item("excludes", excludes);
            }
            if (!(filterIncludes = source.getFilter().getIncludes()).isEmpty()) {
                builder.item("limit to", filterIncludes);
            }
        }
    }

    private void renderSourceSetDependencies(LanguageSourceSet sourceSet, TextReportBuilder builder) {
        DependencySpecContainer dependencies;
        if (sourceSet instanceof DependentSourceSetInternal && !(dependencies = ((DependentSourceSetInternal)sourceSet).getDependencies()).isEmpty()) {
            builder.collection("dependencies", dependencies.getDependencies(), new ReportRenderer<DependencySpec, TextReportBuilder>(){

                public void render(DependencySpec model, TextReportBuilder output) throws IOException {
                    ArrayList parts = Lists.newArrayList();
                    if (model.getProjectPath() != null) {
                        parts.add("project '" + model.getProjectPath() + "'");
                    }
                    if (model.getLibraryName() != null) {
                        parts.add("library '" + model.getLibraryName() + "'");
                    }
                    output.item(Joiner.on((char)' ').join((Iterable)parts));
                }
            }, "dependencies");
        }
    }
}

