/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.internal.model;

import com.google.common.base.Strings;
import java.util.Collections;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionSelector;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.component.external.model.DefaultModuleComponentSelector;
import org.gradle.internal.component.local.model.DefaultLibraryComponentSelector;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetaData;
import org.gradle.internal.component.model.DependencyMetaData;
import org.gradle.internal.component.model.LocalComponentDependencyMetaData;
import org.gradle.platform.base.DependencySpec;

public class DefaultLibraryLocalComponentMetaData
extends DefaultLocalComponentMetaData {
    private static final String VERSION = "<local component>";
    private static final ExcludeRule[] EXCLUDE_RULES = new ExcludeRule[0];
    private static final String CONFIGURATION_COMPILE = "compile";

    private DefaultLibraryLocalComponentMetaData(ModuleVersionIdentifier id, ComponentIdentifier componentIdentifier) {
        super(id, componentIdentifier, "release");
    }

    public static DefaultLibraryLocalComponentMetaData newMetaData(LibraryBinaryIdentifier componentId, TaskDependency buildDependencies) {
        DefaultModuleVersionIdentifier id = new DefaultModuleVersionIdentifier(componentId.getProjectPath(), componentId.getLibraryName(), VERSION);
        DefaultLibraryLocalComponentMetaData metaData = new DefaultLibraryLocalComponentMetaData((ModuleVersionIdentifier)id, (ComponentIdentifier)componentId);
        metaData.addConfiguration("API", String.format("Request metadata: %s", componentId.getDisplayName()), Collections.emptySet(), Collections.singleton("API"), true, true, buildDependencies);
        return metaData;
    }

    public void addDependency(DependencySpec dependency, String defaultProject) {
        String projectPath = dependency.getProjectPath();
        String libraryName = dependency.getLibraryName();
        if (projectPath == null && libraryName != null && libraryName.contains(":")) {
            String[] components = libraryName.split(":");
            DefaultModuleVersionSelector requested = new DefaultModuleVersionSelector(components[0], components[1], components[2]);
            ModuleComponentSelector selector = DefaultModuleComponentSelector.newSelector((ModuleVersionSelector)requested);
            this.addDependency(this.createDependencyMetaData((ComponentSelector)selector, (ModuleVersionSelector)requested, CONFIGURATION_COMPILE));
        } else {
            if (Strings.isNullOrEmpty((String)projectPath)) {
                projectPath = defaultProject;
            }
            DefaultLibraryComponentSelector selector = new DefaultLibraryComponentSelector(projectPath, libraryName);
            DefaultModuleVersionSelector requested = new DefaultModuleVersionSelector(Strings.nullToEmpty((String)projectPath), Strings.nullToEmpty((String)libraryName), this.getId().getVersion());
            DependencyMetaData localComponentDependencyMetaData = this.createDependencyMetaData((ComponentSelector)selector, (ModuleVersionSelector)requested, "API");
            this.addDependency(localComponentDependencyMetaData);
        }
    }

    private DependencyMetaData createDependencyMetaData(ComponentSelector selector, ModuleVersionSelector requested, String configuration) {
        return new LocalComponentDependencyMetaData(selector, requested, "API", configuration, Collections.emptySet(), EXCLUDE_RULES, false, false, true);
    }
}

