/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal;

import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasksCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBinaryTasksCollection
extends DefaultDomainObjectSet<Task>
implements BinaryTasksCollection {
    private final BinarySpec binary;
    private final ITaskFactory taskFactory;

    public DefaultBinaryTasksCollection(BinarySpec binarySpecInternal, ITaskFactory taskFactory) {
        super(Task.class);
        this.binary = binarySpecInternal;
        this.taskFactory = taskFactory;
    }

    @Override
    public Task getBuild() {
        return this.binary.getBuildTask();
    }

    public <T extends Task> T findSingleTaskWithType(Class<T> type) {
        DomainObjectSet tasks = this.withType(type);
        if (tasks.size() == 0) {
            return null;
        }
        if (tasks.size() > 1) {
            throw new UnknownDomainObjectException(String.format("Multiple tasks with type '%s' found.", type.getSimpleName()));
        }
        return (T)((Task)tasks.iterator().next());
    }

    @Override
    public <T extends Task> void create(String name, Class<T> type, Action<? super T> config) {
        Task task = (Task)this.taskFactory.create(name, type);
        this.add(task);
        config.execute((Object)task);
    }
}

