/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.Cast;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.InvalidModelRuleDeclarationException;
import org.gradle.model.internal.core.DirectNodeNoInputsModelAction;
import org.gradle.model.internal.core.DomainObjectCollectionBackedModelMap;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.InstanceModelView;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NamedEntityInstantiator;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.InvalidModelException;
import org.gradle.platform.base.internal.registry.AbstractAnnotationDrivenComponentModelRuleExtractor;
import org.gradle.platform.base.internal.registry.ModelMapBasedRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTasksModelRuleExtractor
extends AbstractAnnotationDrivenComponentModelRuleExtractor<BinaryTasks> {
    public <R, S> ExtractedModelRule registration(MethodRuleDefinition<R, S> ruleDefinition) {
        return this.createRegistration(ruleDefinition);
    }

    private <R, S extends BinarySpec> ExtractedModelRule createRegistration(MethodRuleDefinition<R, ?> ruleDefinition) {
        try {
            AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector dataCollector = new AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector(this);
            this.verifyMethodSignature(dataCollector, ruleDefinition);
            Class binaryType = dataCollector.getParameterType(BinarySpec.class);
            final BinaryTaskRule binaryTaskRule = new BinaryTaskRule(binaryType, ruleDefinition);
            return new ExtractedModelAction(ModelActionRole.Defaults, (List)ImmutableList.of(ComponentModelBasePlugin.class), DirectNodeNoInputsModelAction.of((ModelReference)ModelReference.of((String)"binaries"), (ModelRuleDescriptor)new SimpleModelRuleDescriptor("binaries*.create()"), (Action)new Action<MutableModelNode>(){

                public void execute(MutableModelNode modelNode) {
                    modelNode.applyToAllLinks(ModelActionRole.Finalize, (ModelAction)binaryTaskRule);
                }
            }));
        }
        catch (InvalidModelException e) {
            throw this.invalidModelRule(ruleDefinition, e);
        }
    }

    private void verifyMethodSignature(AbstractAnnotationDrivenComponentModelRuleExtractor.RuleMethodDataCollector taskDataCollector, MethodRuleDefinition<?, ?> ruleDefinition) {
        this.assertIsVoidMethod(ruleDefinition);
        this.visitSubject(taskDataCollector, ruleDefinition, Task.class);
        this.visitDependency(taskDataCollector, ruleDefinition, ModelType.of(BinarySpec.class));
    }

    protected InvalidModelRuleDeclarationException invalidModelRule(MethodRuleDefinition<?, ?> ruleDefinition, InvalidModelException e) {
        StringBuilder sb = new StringBuilder();
        ruleDefinition.getDescriptor().describeTo((Appendable)sb);
        sb.append(" is not a valid BinaryTask model rule method.");
        return new InvalidModelRuleDeclarationException(sb.toString(), (Throwable)((Object)e));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BinaryTaskRule<R, T extends BinarySpec>
    extends ModelMapBasedRule<R, Task, T, T> {
        public BinaryTaskRule(Class<T> binaryType, MethodRuleDefinition<R, ?> ruleDefinition) {
            super(ModelReference.of(binaryType), binaryType, ruleDefinition, ModelReference.of(ITaskFactory.class));
        }

        protected void execute(MutableModelNode modelNode, final T binary, List<ModelView<?>> inputs) {
            NamedEntityInstantiator taskFactory = (NamedEntityInstantiator)Cast.uncheckedCast((Object)ModelViews.getInstance(inputs.get(0), ITaskFactory.class));
            DomainObjectCollectionBackedModelMap<Task> cast = DomainObjectCollectionBackedModelMap.wrap(Task.class, binary.getTasks(), taskFactory, new Task.Namer(), new Action<Task>(){

                public void execute(Task task) {
                    binary.getTasks().add(task);
                    binary.builtBy(new Object[]{task});
                }
            });
            ArrayList inputsWithBinary = new ArrayList(inputs.size());
            inputsWithBinary.addAll(inputs.subList(1, inputs.size()));
            inputsWithBinary.add(InstanceModelView.of((ModelPath)this.getSubject().getPath(), (ModelType)this.getSubject().getType(), binary));
            this.invoke(inputsWithBinary, cast, binary, binary);
        }
    }
}

