/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.platform.base.internal.registry;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.util.BiFunction;
import org.gradle.language.base.plugins.ComponentModelBasePlugin;
import org.gradle.model.internal.core.AbstractModelActionWithView;
import org.gradle.model.internal.core.ExtractedModelAction;
import org.gradle.model.internal.core.ExtractedModelRule;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.MethodRuleDefinition;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.type.ModelType;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.BinaryType;
import org.gradle.platform.base.BinaryTypeBuilder;
import org.gradle.platform.base.ComponentSpec;
import org.gradle.platform.base.binary.BaseBinarySpec;
import org.gradle.platform.base.binary.internal.BinarySpecFactory;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.ComponentSpecAware;
import org.gradle.platform.base.internal.builder.TypeBuilderFactory;
import org.gradle.platform.base.internal.builder.TypeBuilderInternal;
import org.gradle.platform.base.internal.registry.AbstractTypeBuilder;
import org.gradle.platform.base.internal.registry.TypeModelRuleExtractor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTypeModelRuleExtractor
extends TypeModelRuleExtractor<BinaryType, BinarySpec, BaseBinarySpec> {
    public BinaryTypeModelRuleExtractor(ModelSchemaStore schemaStore) {
        super("binary", BinarySpec.class, BaseBinarySpec.class, BinaryTypeBuilder.class, schemaStore, new TypeBuilderFactory<BinarySpec>(){

            @Override
            public TypeBuilderInternal<BinarySpec> create(ModelSchema<? extends BinarySpec> schema) {
                return new DefaultBinaryTypeBuilder(schema);
            }
        });
    }

    @Override
    protected <R, S> ExtractedModelRule createRegistration(MethodRuleDefinition<R, S> ruleDefinition, ModelType<? extends BinarySpec> type, TypeBuilderInternal<BinarySpec> builder) {
        ImmutableList dependencies = ImmutableList.of(ComponentModelBasePlugin.class);
        ModelType implementation = this.determineImplementationType(type, builder);
        ImmutableSet internalViews = ImmutableSet.copyOf((Iterable)Iterables.transform(builder.getInternalViews(), (Function)new Function<Class<?>, ModelType<?>>(){

            public ModelType<?> apply(Class<?> type) {
                return ModelType.of(type);
            }
        }));
        RegistrationAction<? extends BinarySpec> mutator = RegistrationAction.create(type, implementation, internalViews, ruleDefinition.getDescriptor());
        return new ExtractedModelAction(ModelActionRole.Defaults, (List)dependencies, mutator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegistrationAction<S extends BinarySpec>
    extends AbstractModelActionWithView<BinarySpecFactory> {
        private static final ModelType<BinarySpecInternal> BINARY_SPEC_INTERNAL_MODEL_TYPE = ModelType.of(BinarySpecInternal.class);
        private final ModelType<S> publicType;
        private final ModelType<? extends BaseBinarySpec> implementationType;
        private final Set<ModelType<?>> internalViews;

        public static <S extends BinarySpec> RegistrationAction<S> create(ModelType<S> publicType, ModelType<? extends BaseBinarySpec> implementationType, Set<ModelType<?>> internalViews, ModelRuleDescriptor descriptor) {
            return new RegistrationAction<S>(publicType, implementationType, internalViews, descriptor);
        }

        private RegistrationAction(ModelType<S> publicType, ModelType<? extends BaseBinarySpec> implementationType, Set<ModelType<?>> internalViews, ModelRuleDescriptor descriptor) {
            super(ModelReference.of(BinarySpecFactory.class), descriptor, new ModelReference[]{ModelReference.of(ServiceRegistry.class), ModelReference.of(ITaskFactory.class)});
            this.publicType = publicType;
            this.implementationType = implementationType;
            this.internalViews = internalViews;
        }

        public void execute(MutableModelNode modelNode, BinarySpecFactory binaries, List<ModelView<?>> inputs) {
            InstanceFactory.TypeRegistrationBuilder registration = binaries.register(this.publicType, this.descriptor);
            if (this.implementationType != null) {
                ServiceRegistry serviceRegistry = (ServiceRegistry)ModelViews.assertType(inputs.get(0), (ModelType)ModelType.of(ServiceRegistry.class)).getInstance();
                final Instantiator instantiator = (Instantiator)serviceRegistry.get(Instantiator.class);
                final ITaskFactory taskFactory = (ITaskFactory)ModelViews.assertType(inputs.get(1), (ModelType)ModelType.of(ITaskFactory.class)).getInstance();
                registration.withImplementation((ModelType)Cast.uncheckedCast(this.implementationType), new BiFunction<S, String, MutableModelNode>(){

                    public S apply(String name, MutableModelNode modelNode1) {
                        BinarySpec binarySpec = (BinarySpec)Cast.uncheckedCast(BaseBinarySpec.create(RegistrationAction.this.publicType.getConcreteClass(), RegistrationAction.this.implementationType.getConcreteClass(), name, instantiator, taskFactory));
                        Object parentObject = modelNode1.getParent().getParent().getPrivateData();
                        if (parentObject instanceof ComponentSpec && binarySpec instanceof ComponentSpecAware) {
                            ((ComponentSpecAware)((Object)binarySpec)).setComponent((ComponentSpec)parentObject);
                        }
                        return binarySpec;
                    }
                });
                binaries.registerDomainObjectFactory(this.publicType.getConcreteClass(), this.descriptor, new NamedDomainObjectFactory<S>(){

                    public S create(String name) {
                        return (BinarySpec)Cast.uncheckedCast(BaseBinarySpec.create(RegistrationAction.this.publicType.getConcreteClass(), RegistrationAction.this.implementationType.getConcreteClass(), name, instantiator, taskFactory));
                    }
                });
                if (BINARY_SPEC_INTERNAL_MODEL_TYPE.isAssignableFrom(this.implementationType)) {
                    registration.withInternalView(BINARY_SPEC_INTERNAL_MODEL_TYPE);
                }
            }
            for (ModelType<?> internalView : this.internalViews) {
                registration.withInternalView(internalView);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultBinaryTypeBuilder
    extends AbstractTypeBuilder<BinarySpec>
    implements BinaryTypeBuilder<BinarySpec> {
        public DefaultBinaryTypeBuilder(ModelSchema<? extends BinarySpec> schema) {
            super(BinaryType.class, schema);
        }
    }
}

