/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.DoubleIterable;
import com.gs.collections.api.bag.primitive.ImmutableDoubleBag;
import com.gs.collections.api.factory.bag.primitive.ImmutableDoubleBagFactory;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableDoubleEmptyBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableDoubleHashBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableDoubleSingletonBag;

public class ImmutableDoubleBagFactoryImpl
implements ImmutableDoubleBagFactory {
    public ImmutableDoubleBag of() {
        return this.with();
    }

    public ImmutableDoubleBag with() {
        return ImmutableDoubleEmptyBag.INSTANCE;
    }

    public ImmutableDoubleBag of(double one) {
        return this.with(one);
    }

    public ImmutableDoubleBag with(double one) {
        return new ImmutableDoubleSingletonBag(one);
    }

    public ImmutableDoubleBag of(double ... items) {
        return this.with(items);
    }

    public ImmutableDoubleBag with(double ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableDoubleHashBag.newBagWith(items);
    }

    public ImmutableDoubleBag ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    public ImmutableDoubleBag withAll(DoubleIterable items) {
        if (items instanceof ImmutableDoubleBag) {
            return (ImmutableDoubleBag)items;
        }
        return this.with(items.toArray());
    }
}

