/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.IntIterable;
import com.gs.collections.api.bag.primitive.ImmutableIntBag;
import com.gs.collections.api.factory.bag.primitive.ImmutableIntBagFactory;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableIntEmptyBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableIntHashBag;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableIntSingletonBag;

public class ImmutableIntBagFactoryImpl
implements ImmutableIntBagFactory {
    public ImmutableIntBag of() {
        return this.with();
    }

    public ImmutableIntBag with() {
        return ImmutableIntEmptyBag.INSTANCE;
    }

    public ImmutableIntBag of(int one) {
        return this.with(one);
    }

    public ImmutableIntBag with(int one) {
        return new ImmutableIntSingletonBag(one);
    }

    public ImmutableIntBag of(int ... items) {
        return this.with(items);
    }

    public ImmutableIntBag with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntHashBag.newBagWith(items);
    }

    public ImmutableIntBag ofAll(IntIterable items) {
        return this.withAll(items);
    }

    public ImmutableIntBag withAll(IntIterable items) {
        if (items instanceof ImmutableIntBag) {
            return (ImmutableIntBag)items;
        }
        return this.with(items.toArray());
    }
}

