/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.list.immutable;

import com.gs.collections.api.block.function.Function;
import com.gs.collections.api.block.function.Function0;
import com.gs.collections.api.block.function.Function2;
import com.gs.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import com.gs.collections.api.block.function.primitive.IntObjectToIntFunction;
import com.gs.collections.api.block.function.primitive.LongObjectToLongFunction;
import com.gs.collections.api.block.predicate.Predicate;
import com.gs.collections.api.block.predicate.Predicate2;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.list.ImmutableList;
import com.gs.collections.api.partition.list.PartitionImmutableList;
import com.gs.collections.api.stack.MutableStack;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.factory.Lists;
import com.gs.collections.impl.factory.Stacks;
import com.gs.collections.impl.list.immutable.AbstractImmutableList;
import com.gs.collections.impl.partition.list.PartitionFastList;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableEmptyList<T>
extends AbstractImmutableList<T>
implements Serializable,
RandomAccess {
    static final ImmutableList<?> INSTANCE = new ImmutableEmptyList();
    private static final PartitionImmutableList<?> EMPTY = new PartitionFastList().toImmutable();
    private static final long serialVersionUID = 1L;

    ImmutableEmptyList() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public ImmutableList<T> newWithout(T element) {
        return this;
    }

    @Override
    public ImmutableList<T> newWithoutAll(Iterable<? extends T> elements) {
        return this;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean contains(Object obj) {
        return false;
    }

    @Override
    public T get(int index) {
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
    }

    @Override
    public void forEach(Procedure<? super T> procedure) {
    }

    @Override
    public void reverseForEach(Procedure<? super T> procedure) {
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
    }

    public ImmutableList<T> newWith(T newItem) {
        return Lists.immutable.of(newItem);
    }

    @Override
    public T min(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T max(Comparator<? super T> comparator) {
        throw new NoSuchElementException();
    }

    @Override
    public T min() {
        throw new NoSuchElementException();
    }

    @Override
    public T max() {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T minBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <V extends Comparable<? super V>> T maxBy(Function<? super T, ? extends V> function) {
        throw new NoSuchElementException();
    }

    @Override
    public <S> ImmutableList<Pair<T, S>> zip(Iterable<S> that) {
        return Lists.immutable.of();
    }

    @Override
    public <S, R extends Collection<Pair<T, S>>> R zip(Iterable<S> that, R target) {
        return target;
    }

    @Override
    public ImmutableList<Pair<T, Integer>> zipWithIndex() {
        return Lists.immutable.of();
    }

    @Override
    public MutableStack<T> toStack() {
        return Stacks.mutable.of();
    }

    @Override
    public <R extends Collection<Pair<T, Integer>>> R zipWithIndex(R target) {
        return target;
    }

    @Override
    public ImmutableList<T> select(Predicate<? super T> predicate) {
        return this;
    }

    @Override
    public <P, R extends Collection<T>> R selectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        return targetCollection;
    }

    @Override
    public ImmutableList<T> reject(Predicate<? super T> predicate) {
        return this;
    }

    @Override
    public <P, R extends Collection<T>> R rejectWith(Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        return targetCollection;
    }

    @Override
    public PartitionImmutableList<T> partition(Predicate<? super T> predicate) {
        return EMPTY;
    }

    @Override
    public <V> ImmutableList<V> collect(Function<? super T, ? extends V> function) {
        return Lists.immutable.of();
    }

    @Override
    public <V> ImmutableList<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return Lists.immutable.of();
    }

    @Override
    public <P, V, R extends Collection<V>> R collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        return targetCollection;
    }

    @Override
    public <V> ImmutableList<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return Lists.immutable.of();
    }

    @Override
    public <V, R extends Collection<V>> R flatCollect(Function<? super T, ? extends Iterable<V>> function, R targetCollection) {
        return targetCollection;
    }

    @Override
    public T detect(Predicate<? super T> predicate) {
        return null;
    }

    @Override
    public int count(Predicate<? super T> predicate) {
        return 0;
    }

    @Override
    public <P> int countWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return 0;
    }

    @Override
    public boolean anySatisfy(Predicate<? super T> predicate) {
        return false;
    }

    @Override
    public boolean allSatisfy(Predicate<? super T> predicate) {
        return true;
    }

    @Override
    public boolean noneSatisfy(Predicate<? super T> predicate) {
        return true;
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return false;
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return true;
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return true;
    }

    @Override
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super T, ? extends IV> function) {
        return injectedValue;
    }

    @Override
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super T> intObjectToIntFunction) {
        return injectedValue;
    }

    @Override
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super T> longObjectToLongFunction) {
        return injectedValue;
    }

    @Override
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super T> doubleObjectToDoubleFunction) {
        return injectedValue;
    }

    @Override
    public T getFirst() {
        return null;
    }

    @Override
    public T getLast() {
        return null;
    }

    @Override
    public int indexOf(Object object) {
        return -1;
    }

    @Override
    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof List)) {
            return false;
        }
        List list = (List)otherList;
        return list.isEmpty();
    }

    @Override
    public int hashCode() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean notEmpty() {
        return false;
    }

    @Override
    public <R extends Collection<T>> R select(Predicate<? super T> predicate, R target) {
        return target;
    }

    @Override
    public <R extends Collection<T>> R reject(Predicate<? super T> predicate, R target) {
        return target;
    }

    @Override
    public <V, R extends Collection<V>> R collect(Function<? super T, ? extends V> function, R target) {
        return target;
    }

    @Override
    public <V, R extends Collection<V>> R collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function, R target) {
        return target;
    }

    @Override
    public T detectIfNone(Predicate<? super T> predicate, Function0<? extends T> function) {
        return (T)function.value();
    }

    @Override
    public String toString() {
        return "[]";
    }

    @Override
    public String makeString() {
        return "";
    }

    @Override
    public String makeString(String separator) {
        return "";
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    @Override
    public void appendString(Appendable appendable) {
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ImmutableList<T> takeWhile(Predicate<? super T> predicate) {
        return this;
    }

    @Override
    public ImmutableList<T> dropWhile(Predicate<? super T> predicate) {
        return this;
    }

    @Override
    public PartitionImmutableList<T> partitionWhile(Predicate<? super T> predicate) {
        return EMPTY;
    }
}

