/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.map.mutable.primitive;

import com.gs.collections.api.FloatIterable;
import com.gs.collections.api.IntIterable;
import com.gs.collections.api.LazyFloatIterable;
import com.gs.collections.api.LazyIntIterable;
import com.gs.collections.api.RichIterable;
import com.gs.collections.api.bag.primitive.MutableFloatBag;
import com.gs.collections.api.bag.primitive.MutableIntBag;
import com.gs.collections.api.block.function.primitive.FloatFunction;
import com.gs.collections.api.block.function.primitive.FloatFunction0;
import com.gs.collections.api.block.function.primitive.FloatToFloatFunction;
import com.gs.collections.api.block.function.primitive.FloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.IntToFloatFunction;
import com.gs.collections.api.block.function.primitive.IntToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.FloatPredicate;
import com.gs.collections.api.block.predicate.primitive.IntFloatPredicate;
import com.gs.collections.api.block.predicate.primitive.IntPredicate;
import com.gs.collections.api.block.procedure.Procedure;
import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.block.procedure.primitive.FloatProcedure;
import com.gs.collections.api.block.procedure.primitive.IntFloatProcedure;
import com.gs.collections.api.block.procedure.primitive.IntProcedure;
import com.gs.collections.api.block.procedure.primitive.ObjectIntProcedure;
import com.gs.collections.api.collection.MutableCollection;
import com.gs.collections.api.collection.primitive.ImmutableFloatCollection;
import com.gs.collections.api.collection.primitive.MutableFloatCollection;
import com.gs.collections.api.iterator.FloatIterator;
import com.gs.collections.api.iterator.IntIterator;
import com.gs.collections.api.list.primitive.MutableFloatList;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.api.map.primitive.ImmutableIntFloatMap;
import com.gs.collections.api.map.primitive.IntFloatMap;
import com.gs.collections.api.map.primitive.MutableIntFloatMap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.set.primitive.FloatSet;
import com.gs.collections.api.set.primitive.ImmutableIntSet;
import com.gs.collections.api.set.primitive.IntSet;
import com.gs.collections.api.set.primitive.MutableFloatSet;
import com.gs.collections.api.set.primitive.MutableIntSet;
import com.gs.collections.api.tuple.primitive.IntFloatPair;
import com.gs.collections.impl.bag.mutable.primitive.FloatHashBag;
import com.gs.collections.impl.bag.mutable.primitive.IntHashBag;
import com.gs.collections.impl.collection.mutable.primitive.SynchronizedFloatCollection;
import com.gs.collections.impl.collection.mutable.primitive.UnmodifiableFloatCollection;
import com.gs.collections.impl.factory.Sets;
import com.gs.collections.impl.factory.primitive.FloatLists;
import com.gs.collections.impl.factory.primitive.IntFloatMaps;
import com.gs.collections.impl.factory.primitive.IntSets;
import com.gs.collections.impl.lazy.AbstractLazyIterable;
import com.gs.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import com.gs.collections.impl.lazy.primitive.LazyFloatIterableAdapter;
import com.gs.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import com.gs.collections.impl.list.mutable.FastList;
import com.gs.collections.impl.list.mutable.primitive.FloatArrayList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import com.gs.collections.impl.map.mutable.primitive.SynchronizedIntFloatMap;
import com.gs.collections.impl.map.mutable.primitive.UnmodifiableIntFloatMap;
import com.gs.collections.impl.set.mutable.primitive.FloatHashSet;
import com.gs.collections.impl.set.mutable.primitive.IntHashSet;
import com.gs.collections.impl.set.mutable.primitive.SynchronizedIntSet;
import com.gs.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import com.gs.collections.impl.tuple.primitive.PrimitiveTuples;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntFloatHashMap
implements MutableIntFloatMap,
Externalizable {
    static final float EMPTY_VALUE = 0.0f;
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_KEY = 0;
    private static final int REMOVED_KEY = 1;
    private static final int OCCUPIED_DATA_RATIO = 2;
    private static final int OCCUPIED_SENTINEL_RATIO = 4;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private int[] keys;
    private float[] values;
    private int occupiedWithData;
    private int occupiedWithSentinels;
    private SentinelValues sentinelValues;

    public IntFloatHashMap() {
        this.allocateTable(16);
    }

    public IntFloatHashMap(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initial capacity cannot be less than 0");
        }
        int capacity = this.smallestPowerOfTwoGreaterThan(this.fastCeil(initialCapacity * 2));
        this.allocateTable(capacity);
    }

    private int smallestPowerOfTwoGreaterThan(int n) {
        return n > 1 ? Integer.highestOneBit(n - 1) << 1 : 1;
    }

    public IntFloatHashMap(IntFloatMap map) {
        this(Math.max(map.size(), 8));
        this.putAll(map);
    }

    private int fastCeil(float v) {
        int possibleResult = (int)v;
        if (v - (float)possibleResult > 0.0f) {
            ++possibleResult;
        }
        return possibleResult;
    }

    public static IntFloatHashMap newWithKeysValues(int key1, float value1) {
        return new IntFloatHashMap(1).withKeyValue(key1, value1);
    }

    public static IntFloatHashMap newWithKeysValues(int key1, float value1, int key2, float value2) {
        return new IntFloatHashMap(2).withKeysValues(key1, value1, key2, value2);
    }

    public static IntFloatHashMap newWithKeysValues(int key1, float value1, int key2, float value2, int key3, float value3) {
        return new IntFloatHashMap(3).withKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public static IntFloatHashMap newWithKeysValues(int key1, float value1, int key2, float value2, int key3, float value3, int key4, float value4) {
        return new IntFloatHashMap(4).withKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntFloatMap)) {
            return false;
        }
        IntFloatMap other = (IntFloatMap)obj;
        if (this.size() != other.size()) {
            return false;
        }
        if (this.sentinelValues == null) {
            if (other.containsKey(0) || other.containsKey(1)) {
                return false;
            }
        } else {
            if (this.sentinelValues.containsZeroKey && (!other.containsKey(0) || Float.compare(this.sentinelValues.zeroValue, other.getOrThrow(0)) != 0)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && (!other.containsKey(1) || Float.compare(this.sentinelValues.oneValue, other.getOrThrow(1)) != 0)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntFloatHashMap.isNonSentinel(key) || other.containsKey(key) && Float.compare(this.values[i], other.getOrThrow(key)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += 0 ^ Float.floatToIntBits(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result += 1 ^ Float.floatToIntBits(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result += this.keys[i] ^ Float.floatToIntBits(this.values[i]);
        }
        return result;
    }

    public String toString() {
        StringBuilder appendable = new StringBuilder();
        appendable.append("{");
        boolean first = true;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                appendable.append(String.valueOf(0)).append("=").append(String.valueOf(this.sentinelValues.zeroValue));
                first = false;
            }
            if (this.sentinelValues.containsOneKey) {
                if (!first) {
                    appendable.append(", ");
                }
                appendable.append(String.valueOf(1)).append("=").append(String.valueOf(this.sentinelValues.oneValue));
                first = false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            int key = this.keys[i];
            if (!IntFloatHashMap.isNonSentinel(key)) continue;
            if (!first) {
                appendable.append(", ");
            }
            appendable.append(String.valueOf(key)).append("=").append(String.valueOf(this.values[i]));
            first = false;
        }
        appendable.append("}");
        return appendable.toString();
    }

    public int size() {
        return this.occupiedWithData + (this.sentinelValues == null ? 0 : this.sentinelValues.size());
    }

    public boolean isEmpty() {
        return this.occupiedWithData == 0 && (this.sentinelValues == null || this.sentinelValues.size() == 0);
    }

    public boolean notEmpty() {
        return this.occupiedWithData != 0 || this.sentinelValues != null && this.sentinelValues.size() != 0;
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            boolean first = true;
            if (this.sentinelValues != null) {
                if (this.sentinelValues.containsZeroKey) {
                    appendable.append(String.valueOf(this.sentinelValues.zeroValue));
                    first = false;
                }
                if (this.sentinelValues.containsOneKey) {
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(this.sentinelValues.oneValue));
                    first = false;
                }
            }
            for (int i = 0; i < this.keys.length; ++i) {
                int key = this.keys[i];
                if (!IntFloatHashMap.isNonSentinel(key)) continue;
                if (!first) {
                    appendable.append(separator);
                }
                appendable.append(String.valueOf(this.values[i]));
                first = false;
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    public float[] toArray() {
        float[] array = new float[this.size()];
        int index = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                array[index] = this.sentinelValues.zeroValue;
                ++index;
            }
            if (this.sentinelValues.containsOneKey) {
                array[index] = this.sentinelValues.oneValue;
                ++index;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i])) continue;
            array[index] = this.values[i];
            ++index;
        }
        return array;
    }

    public boolean contains(float value) {
        return this.containsValue(value);
    }

    public boolean containsAll(float ... source) {
        for (float each : source) {
            if (this.contains(each)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(FloatIterable source) {
        return source.allSatisfy(new FloatPredicate(){

            public boolean accept(float value) {
                return IntFloatHashMap.this.contains(value);
            }
        });
    }

    public void forEach(FloatProcedure procedure) {
        this.forEachValue(procedure);
    }

    public MutableFloatCollection select(FloatPredicate predicate) {
        FloatArrayList result = new FloatArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public MutableFloatCollection reject(FloatPredicate predicate) {
        FloatArrayList result = new FloatArrayList();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                result.add(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                result.add(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            result.add(this.values[i]);
        }
        return result;
    }

    public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
        FastList target = FastList.newList(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                target.add(function.valueOf(this.sentinelValues.zeroValue));
            }
            if (this.sentinelValues.containsOneKey) {
                target.add(function.valueOf(this.sentinelValues.oneValue));
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i])) continue;
            target.add(function.valueOf(this.values[i]));
        }
        return target;
    }

    public float detectIfNone(FloatPredicate predicate, float value) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return this.values[i];
        }
        return value;
    }

    public int count(FloatPredicate predicate) {
        int count = 0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                ++count;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                ++count;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return true;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return true;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(FloatPredicate predicate) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(this.sentinelValues.zeroValue)) {
                return false;
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(this.sentinelValues.oneValue)) {
                return false;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.values[i])) continue;
            return false;
        }
        return true;
    }

    public <V> V injectInto(V injectedValue, ObjectFloatToObjectFunction<? super V, ? extends V> function) {
        Object result = injectedValue;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result = function.valueOf(result, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                result = function.valueOf(result, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result = function.valueOf(result, this.values[i]);
        }
        return result;
    }

    public MutableFloatList toList() {
        return FloatArrayList.newList((FloatIterable)this);
    }

    public MutableFloatSet toSet() {
        return FloatHashSet.newSet((FloatIterable)this);
    }

    public MutableFloatBag toBag() {
        return FloatHashBag.newBag((FloatIterable)this);
    }

    public LazyFloatIterable asLazy() {
        return new LazyFloatIterableAdapter((FloatIterable)this);
    }

    public void clear() {
        this.sentinelValues = null;
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, 0.0f);
    }

    public void put(int key, float value) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addEmptyKeyValue(value);
            return;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
            }
            this.addRemovedKeyValue(value);
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = value;
            return;
        }
        this.addKeyValueAtIndex(key, value, index);
    }

    public void putAll(IntFloatMap map) {
        map.forEachKeyValue(new IntFloatProcedure(){

            public void value(int key, float value) {
                IntFloatHashMap.this.put(key, value);
            }
        });
    }

    public void removeKey(int key) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return;
            }
            this.removeEmptyKey();
            return;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return;
            }
            this.removeRemovedKey();
            return;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            this.values[index] = 0.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
        }
    }

    public void remove(int key) {
        this.removeKey(key);
    }

    public float removeKeyIfAbsent(int key, float value) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return value;
            }
            float oldValue = this.sentinelValues.zeroValue;
            this.removeEmptyKey();
            return oldValue;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return value;
            }
            float oldValue = this.sentinelValues.oneValue;
            this.removeRemovedKey();
            return oldValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.keys[index] = 1;
            float oldValue = this.values[index];
            this.values[index] = 0.0f;
            --this.occupiedWithData;
            ++this.occupiedWithSentinels;
            if (this.occupiedWithSentinels > this.maxOccupiedWithSentinels()) {
                this.rehash();
            }
            return oldValue;
        }
        return value;
    }

    public float getIfAbsentPut(int key, float value) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float getIfAbsentPut(int key, FloatFunction0 function) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.value();
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.value();
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.value();
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        float value = function.value();
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public <P> float getIfAbsentPutWith(int key, FloatFunction<? super P> function, P parameter) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.floatValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.floatValueOf(parameter);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.floatValueOf(parameter);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.floatValueOf(parameter);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        float value = function.floatValueOf(parameter);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float getIfAbsentPutWithKey(int key, IntToFloatFunction function) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsZeroKey) {
                return this.sentinelValues.zeroValue;
            }
            float value = function.valueOf(key);
            this.addEmptyKeyValue(value);
            return value;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                float value = function.valueOf(key);
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(value);
                return value;
            }
            if (this.sentinelValues.containsOneKey) {
                return this.sentinelValues.oneValue;
            }
            float value = function.valueOf(key);
            this.addRemovedKeyValue(value);
            return value;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        float value = function.valueOf(key);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public float addToValue(int key, float toBeAdded) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue += toBeAdded;
            } else {
                this.addEmptyKeyValue(toBeAdded);
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(toBeAdded);
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue += toBeAdded;
            } else {
                this.addRemovedKeyValue(toBeAdded);
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            int n = index;
            this.values[n] = this.values[n] + toBeAdded;
            return this.values[index];
        }
        this.addKeyValueAtIndex(key, toBeAdded, index);
        return this.values[index];
    }

    private void addKeyValueAtIndex(int key, float value, int index) {
        if (this.keys[index] == 1) {
            --this.occupiedWithSentinels;
        }
        this.keys[index] = key;
        this.values[index] = value;
        ++this.occupiedWithData;
        if (this.occupiedWithData > this.maxOccupiedWithData()) {
            this.rehashAndGrow();
        }
    }

    private void addEmptyKeyValue(float value) {
        this.sentinelValues.containsZeroKey = true;
        this.sentinelValues.zeroValue = value;
    }

    private void removeEmptyKey() {
        if (this.sentinelValues.containsOneKey) {
            this.sentinelValues.containsZeroKey = false;
            this.sentinelValues.zeroValue = 0.0f;
        } else {
            this.sentinelValues = null;
        }
    }

    private void addRemovedKeyValue(float value) {
        this.sentinelValues.containsOneKey = true;
        this.sentinelValues.oneValue = value;
    }

    private void removeRemovedKey() {
        if (this.sentinelValues.containsZeroKey) {
            this.sentinelValues.containsOneKey = false;
            this.sentinelValues.oneValue = 0.0f;
        } else {
            this.sentinelValues = null;
        }
    }

    public float updateValue(int key, float initialValueIfAbsent, FloatToFloatFunction function) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsZeroKey) {
                this.sentinelValues.zeroValue = function.valueOf(this.sentinelValues.zeroValue);
            } else {
                this.addEmptyKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null) {
                this.sentinelValues = new SentinelValues();
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            } else if (this.sentinelValues.containsOneKey) {
                this.sentinelValues.oneValue = function.valueOf(this.sentinelValues.oneValue);
            } else {
                this.addRemovedKeyValue(function.valueOf(initialValueIfAbsent));
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            this.values[index] = function.valueOf(this.values[index]);
            return this.values[index];
        }
        float value = function.valueOf(initialValueIfAbsent);
        this.addKeyValueAtIndex(key, value, index);
        return value;
    }

    public IntFloatHashMap withKeyValue(int key1, float value1) {
        this.put(key1, value1);
        return this;
    }

    public IntFloatHashMap withKeysValues(int key1, float value1, int key2, float value2) {
        this.put(key1, value1);
        this.put(key2, value2);
        return this;
    }

    public IntFloatHashMap withKeysValues(int key1, float value1, int key2, float value2, int key3, float value3) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        return this;
    }

    public IntFloatHashMap withKeysValues(int key1, float value1, int key2, float value2, int key3, float value3, int key4, float value4) {
        this.put(key1, value1);
        this.put(key2, value2);
        this.put(key3, value3);
        this.put(key4, value4);
        return this;
    }

    public IntFloatHashMap withoutKey(int key) {
        this.removeKey(key);
        return this;
    }

    public IntFloatHashMap withoutAllKeys(IntIterable keys) {
        keys.forEach(new IntProcedure(){

            public void value(int key) {
                IntFloatHashMap.this.removeKey(key);
            }
        });
        return this;
    }

    public MutableIntFloatMap asUnmodifiable() {
        return new UnmodifiableIntFloatMap(this);
    }

    public MutableIntFloatMap asSynchronized() {
        return new SynchronizedIntFloatMap(this);
    }

    public ImmutableIntFloatMap toImmutable() {
        return IntFloatMaps.immutable.ofAll((IntFloatMap)this);
    }

    public float get(int key) {
        return this.getIfAbsent(key, 0.0f);
    }

    public float getIfAbsent(int key, float ifAbsent) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                return ifAbsent;
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                return ifAbsent;
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (this.keys[index] == key) {
            return this.values[index];
        }
        return ifAbsent;
    }

    public float getOrThrow(int key) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsZeroKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.zeroValue;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            if (this.sentinelValues == null || !this.sentinelValues.containsOneKey) {
                throw new IllegalStateException("Key " + key + " not present.");
            }
            return this.sentinelValues.oneValue;
        }
        int index = this.probe(key);
        if (IntFloatHashMap.isNonSentinel(this.keys[index])) {
            return this.values[index];
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        if (IntFloatHashMap.isEmptyKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsZeroKey;
        }
        if (IntFloatHashMap.isRemovedKey(key)) {
            return this.sentinelValues != null && this.sentinelValues.containsOneKey;
        }
        return this.keys[this.probe(key)] == key;
    }

    public boolean containsValue(float value) {
        if (this.sentinelValues != null && this.sentinelValues.containsValue(value)) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || Float.compare(this.values[i], value) != 0) continue;
            return true;
        }
        return false;
    }

    public void forEachValue(FloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.values[i]);
        }
    }

    public void forEachKey(IntProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1);
            }
        }
        for (int key : this.keys) {
            if (!IntFloatHashMap.isNonSentinel(key)) continue;
            procedure.value(key);
        }
    }

    public void forEachKeyValue(IntFloatProcedure procedure) {
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                procedure.value(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                procedure.value(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i])) continue;
            procedure.value(this.keys[i], this.values[i]);
        }
    }

    public LazyIntIterable keysView() {
        return new KeysView();
    }

    public RichIterable<IntFloatPair> keyValuesView() {
        return new KeyValuesView();
    }

    public IntFloatHashMap select(IntFloatPredicate predicate) {
        IntFloatHashMap result = new IntFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public IntFloatHashMap reject(IntFloatPredicate predicate) {
        IntFloatHashMap result = new IntFloatHashMap();
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey && !predicate.accept(0, this.sentinelValues.zeroValue)) {
                result.put(0, this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey && !predicate.accept(1, this.sentinelValues.oneValue)) {
                result.put(1, this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i], this.values[i])) continue;
            result.put(this.keys[i], this.values[i]);
        }
        return result;
    }

    public double sum() {
        double result = 0.0;
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                result += (double)this.sentinelValues.zeroValue;
            }
            if (this.sentinelValues.containsOneKey) {
                result += (double)this.sentinelValues.oneValue;
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i])) continue;
            result += (double)this.values[i];
        }
        return result;
    }

    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FloatIterator iterator = this.floatIterator();
        float max = iterator.next();
        while (iterator.hasNext()) {
            float value = iterator.next();
            if (Float.compare(max, value) >= 0) continue;
            max = value;
        }
        return max;
    }

    public float maxIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.max();
    }

    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        FloatIterator iterator = this.floatIterator();
        float min = iterator.next();
        while (iterator.hasNext()) {
            float value = iterator.next();
            if (Float.compare(value, min) >= 0) continue;
            min = value;
        }
        return min;
    }

    public float minIfEmpty(float defaultValue) {
        if (this.isEmpty()) {
            return defaultValue;
        }
        return this.min();
    }

    public double average() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        return this.sum() / (double)this.size();
    }

    public double median() {
        if (this.isEmpty()) {
            throw new ArithmeticException();
        }
        float[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            float first = sortedArray[middleIndex];
            float second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public float[] toSortedArray() {
        float[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public MutableFloatList toSortedList() {
        return FloatArrayList.newList((FloatIterable)this).sortThis();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.sentinelValues != null) {
            if (this.sentinelValues.containsZeroKey) {
                out.writeInt(0);
                out.writeFloat(this.sentinelValues.zeroValue);
            }
            if (this.sentinelValues.containsOneKey) {
                out.writeInt(1);
                out.writeFloat(this.sentinelValues.oneValue);
            }
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!IntFloatHashMap.isNonSentinel(this.keys[i])) continue;
            out.writeInt(this.keys[i]);
            out.writeFloat(this.values[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.put(in.readInt(), in.readFloat());
        }
    }

    public void compact() {
        this.rehash(this.smallestPowerOfTwoGreaterThan(this.size()));
    }

    private void rehash() {
        this.rehash(this.keys.length);
    }

    private void rehashAndGrow() {
        this.rehash(this.keys.length << 1);
    }

    private void rehash(int newCapacity) {
        int oldLength = this.keys.length;
        int[] old = this.keys;
        float[] oldValues = this.values;
        this.allocateTable(newCapacity);
        this.occupiedWithData = 0;
        this.occupiedWithSentinels = 0;
        for (int i = 0; i < oldLength; ++i) {
            if (!IntFloatHashMap.isNonSentinel(old[i])) continue;
            this.put(old[i], oldValues[i]);
        }
    }

    int probe(int element) {
        int index = this.spread(element);
        int keyAtIndex = this.keys[index];
        if (keyAtIndex == element || keyAtIndex == 0) {
            return index;
        }
        int removedIndex = keyAtIndex == 1 ? index : -1;
        int nextIndex = index;
        int probe = 17;
        while (true) {
            nextIndex += probe;
            probe += 17;
            if (this.keys[nextIndex &= this.keys.length - 1] == element) {
                return nextIndex;
            }
            if (this.keys[nextIndex] == 1) {
                if (removedIndex != -1) continue;
                removedIndex = nextIndex;
                continue;
            }
            if (this.keys[nextIndex] == 0) break;
        }
        return removedIndex == -1 ? nextIndex : removedIndex;
    }

    int spread(int element) {
        int code = element;
        code ^= 0x3D ^ code >> 16;
        code += code << 3;
        code ^= code >> 4;
        code *= 668265261;
        code ^= code >> 15;
        return code & this.keys.length - 1;
    }

    private void allocateTable(int sizeToAllocate) {
        this.keys = new int[sizeToAllocate];
        this.values = new float[sizeToAllocate];
    }

    private static boolean isEmptyKey(int key) {
        return key == 0;
    }

    private static boolean isRemovedKey(int key) {
        return key == 1;
    }

    private static boolean isNonSentinel(int key) {
        return !IntFloatHashMap.isEmptyKey(key) && !IntFloatHashMap.isRemovedKey(key);
    }

    private int maxOccupiedWithData() {
        int capacity = this.keys.length;
        return Math.min(capacity - 1, capacity / 2);
    }

    private int maxOccupiedWithSentinels() {
        return this.keys.length / 4;
    }

    public MutableIntSet keySet() {
        return new KeySet();
    }

    public MutableFloatCollection values() {
        return new ValuesCollection();
    }

    static /* synthetic */ int[] access$802(IntFloatHashMap x0, int[] x1) {
        x0.keys = x1;
        return x1;
    }

    static /* synthetic */ float[] access$1002(IntFloatHashMap x0, float[] x1) {
        x0.values = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeyValuesView
    extends AbstractLazyIterable<IntFloatPair> {
        private KeyValuesView() {
        }

        public void forEach(Procedure<? super IntFloatPair> procedure) {
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0, IntFloatHashMap.this.sentinelValues.zeroValue));
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1, IntFloatHashMap.this.sentinelValues.oneValue));
                }
            }
            for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                if (!IntFloatHashMap.isNonSentinel(IntFloatHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(IntFloatHashMap.this.keys[i], IntFloatHashMap.this.values[i]));
            }
        }

        public void forEachWithIndex(ObjectIntProcedure<? super IntFloatPair> objectIntProcedure) {
            int index = 0;
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(0, IntFloatHashMap.this.sentinelValues.zeroValue), index);
                    ++index;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                    objectIntProcedure.value((Object)PrimitiveTuples.pair(1, IntFloatHashMap.this.sentinelValues.oneValue), index);
                    ++index;
                }
            }
            for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                if (!IntFloatHashMap.isNonSentinel(IntFloatHashMap.this.keys[i])) continue;
                objectIntProcedure.value((Object)PrimitiveTuples.pair(IntFloatHashMap.this.keys[i], IntFloatHashMap.this.values[i]), index);
                ++index;
            }
        }

        public <P> void forEachWith(Procedure2<? super IntFloatPair, ? super P> procedure, P parameter) {
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    procedure.value((Object)PrimitiveTuples.pair(0, IntFloatHashMap.this.sentinelValues.zeroValue), parameter);
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                    procedure.value((Object)PrimitiveTuples.pair(1, IntFloatHashMap.this.sentinelValues.oneValue), parameter);
                }
            }
            for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                if (!IntFloatHashMap.isNonSentinel(IntFloatHashMap.this.keys[i])) continue;
                procedure.value((Object)PrimitiveTuples.pair(IntFloatHashMap.this.keys[i], IntFloatHashMap.this.values[i]), parameter);
            }
        }

        public Iterator<IntFloatPair> iterator() {
            return new InternalKeyValuesIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class InternalKeyValuesIterator
        implements Iterator<IntFloatPair> {
            private int count;
            private int position;
            private boolean handledZero;
            private boolean handledOne;

            @Override
            public IntFloatPair next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next() called, but the iterator is exhausted");
                }
                ++this.count;
                if (!this.handledZero) {
                    this.handledZero = true;
                    if (IntFloatHashMap.this.containsKey(0)) {
                        return PrimitiveTuples.pair(0, IntFloatHashMap.this.sentinelValues.zeroValue);
                    }
                }
                if (!this.handledOne) {
                    this.handledOne = true;
                    if (IntFloatHashMap.this.containsKey(1)) {
                        return PrimitiveTuples.pair(1, IntFloatHashMap.this.sentinelValues.oneValue);
                    }
                }
                int[] keys = IntFloatHashMap.this.keys;
                while (!IntFloatHashMap.isNonSentinel(keys[this.position])) {
                    ++this.position;
                }
                IntFloatPair result = PrimitiveTuples.pair(keys[this.position], IntFloatHashMap.this.values[this.position]);
                ++this.position;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
            }

            @Override
            public boolean hasNext() {
                return this.count != IntFloatHashMap.this.size();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValuesCollection
    implements MutableFloatCollection {
        private ValuesCollection() {
        }

        public void clear() {
            IntFloatHashMap.this.clear();
        }

        public MutableFloatCollection select(FloatPredicate predicate) {
            return IntFloatHashMap.this.select(predicate);
        }

        public MutableFloatCollection reject(FloatPredicate predicate) {
            return IntFloatHashMap.this.reject(predicate);
        }

        public float detectIfNone(FloatPredicate predicate, float ifNone) {
            return IntFloatHashMap.this.detectIfNone(predicate, ifNone);
        }

        public <V> MutableCollection<V> collect(FloatToObjectFunction<? extends V> function) {
            return IntFloatHashMap.this.collect(function);
        }

        public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
            return IntFloatHashMap.this.injectInto(injectedValue, function);
        }

        public double sum() {
            return IntFloatHashMap.this.sum();
        }

        public float max() {
            return IntFloatHashMap.this.max();
        }

        public float maxIfEmpty(float defaultValue) {
            return IntFloatHashMap.this.maxIfEmpty(defaultValue);
        }

        public float min() {
            return IntFloatHashMap.this.min();
        }

        public float minIfEmpty(float defaultValue) {
            return IntFloatHashMap.this.minIfEmpty(defaultValue);
        }

        public double average() {
            return IntFloatHashMap.this.average();
        }

        public double median() {
            return IntFloatHashMap.this.median();
        }

        public float[] toSortedArray() {
            return IntFloatHashMap.this.toSortedArray();
        }

        public MutableFloatList toSortedList() {
            return IntFloatHashMap.this.toSortedList();
        }

        public MutableFloatCollection with(float element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableFloatCollection without(float element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableFloatCollection withAll(FloatIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableFloatCollection withoutAll(FloatIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public MutableFloatCollection asUnmodifiable() {
            return UnmodifiableFloatCollection.of(this);
        }

        public MutableFloatCollection asSynchronized() {
            return SynchronizedFloatCollection.of(this);
        }

        public ImmutableFloatCollection toImmutable() {
            return FloatLists.immutable.withAll((FloatIterable)this);
        }

        public boolean contains(float value) {
            return IntFloatHashMap.this.containsValue(value);
        }

        public boolean containsAll(float ... source) {
            return IntFloatHashMap.this.containsAll(source);
        }

        public boolean containsAll(FloatIterable source) {
            return IntFloatHashMap.this.containsAll(source);
        }

        public MutableFloatList toList() {
            return IntFloatHashMap.this.toList();
        }

        public MutableFloatSet toSet() {
            return IntFloatHashMap.this.toSet();
        }

        public MutableFloatBag toBag() {
            return IntFloatHashMap.this.toBag();
        }

        public LazyFloatIterable asLazy() {
            return new LazyFloatIterableAdapter((FloatIterable)this);
        }

        public boolean isEmpty() {
            return IntFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntFloatHashMap.this.notEmpty();
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntFloatHashMap.this.sentinelValues != null) {
                    if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(IntFloatHashMap.this.sentinelValues.zeroValue));
                        first = false;
                    }
                    if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(IntFloatHashMap.this.sentinelValues.oneValue));
                        first = false;
                    }
                }
                for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                    int key = IntFloatHashMap.this.keys[i];
                    if (!IntFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(IntFloatHashMap.this.values[i]));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public FloatIterator floatIterator() {
            return IntFloatHashMap.this.floatIterator();
        }

        public void forEach(FloatProcedure procedure) {
            IntFloatHashMap.this.forEach(procedure);
        }

        public int count(FloatPredicate predicate) {
            return IntFloatHashMap.this.count(predicate);
        }

        public boolean anySatisfy(FloatPredicate predicate) {
            return IntFloatHashMap.this.anySatisfy(predicate);
        }

        public boolean allSatisfy(FloatPredicate predicate) {
            return IntFloatHashMap.this.allSatisfy(predicate);
        }

        public boolean noneSatisfy(FloatPredicate predicate) {
            return IntFloatHashMap.this.noneSatisfy(predicate);
        }

        public boolean add(float element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(float ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(FloatIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(float item) {
            int oldSize = IntFloatHashMap.this.size();
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey && Float.compare(item, IntFloatHashMap.this.sentinelValues.zeroValue) == 0) {
                    IntFloatHashMap.this.removeKey(0);
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && Float.compare(item, IntFloatHashMap.this.sentinelValues.oneValue) == 0) {
                    IntFloatHashMap.this.removeKey(1);
                }
            }
            for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                if (!IntFloatHashMap.isNonSentinel(IntFloatHashMap.this.keys[i]) || Float.compare(item, IntFloatHashMap.this.values[i]) != 0) continue;
                IntFloatHashMap.this.removeKey(IntFloatHashMap.this.keys[i]);
            }
            return oldSize != IntFloatHashMap.this.size();
        }

        public boolean removeAll(FloatIterable source) {
            int oldSize = IntFloatHashMap.this.size();
            FloatIterator iterator = source.floatIterator();
            while (iterator.hasNext()) {
                this.remove(iterator.next());
            }
            return oldSize != IntFloatHashMap.this.size();
        }

        public boolean removeAll(float ... source) {
            int oldSize = IntFloatHashMap.this.size();
            for (float item : source) {
                this.remove(item);
            }
            return oldSize != IntFloatHashMap.this.size();
        }

        public boolean retainAll(FloatIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof FloatSet ? (FloatSet)source : source.toSet();
            IntFloatHashMap retained = IntFloatHashMap.this.select(new IntFloatPredicate((FloatSet)sourceSet){
                final /* synthetic */ FloatSet val$sourceSet;
                {
                    this.val$sourceSet = floatSet;
                }

                public boolean accept(int key, float value) {
                    return this.val$sourceSet.contains(value);
                }
            });
            if (retained.size() != oldSize) {
                IntFloatHashMap.access$802(IntFloatHashMap.this, retained.keys);
                IntFloatHashMap.access$1002(IntFloatHashMap.this, retained.values);
                IntFloatHashMap.this.sentinelValues = retained.sentinelValues;
                IntFloatHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntFloatHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(float ... source) {
            return this.retainAll((FloatIterable)FloatHashSet.newSetWith(source));
        }

        public int size() {
            return IntFloatHashMap.this.size();
        }

        public float[] toArray() {
            return IntFloatHashMap.this.toArray();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class KeySet
    implements MutableIntSet {
        private KeySet() {
        }

        public IntIterator intIterator() {
            return new KeySetIterator();
        }

        public void forEach(IntProcedure procedure) {
            IntFloatHashMap.this.forEachKey(procedure);
        }

        public int count(IntPredicate predicate) {
            int count = 0;
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    ++count;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    ++count;
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                ++count;
            }
            return count;
        }

        public boolean anySatisfy(IntPredicate predicate) {
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return true;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return true;
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return true;
            }
            return false;
        }

        public boolean allSatisfy(IntPredicate predicate) {
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    return false;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean noneSatisfy(IntPredicate predicate) {
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return false;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return false;
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return false;
            }
            return true;
        }

        public boolean add(int element) {
            throw new UnsupportedOperationException("Cannot call add() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(int ... source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean addAll(IntIterable source) {
            throw new UnsupportedOperationException("Cannot call addAll() on " + this.getClass().getSimpleName());
        }

        public boolean remove(int key) {
            int oldSize = IntFloatHashMap.this.size();
            IntFloatHashMap.this.removeKey(key);
            return oldSize != IntFloatHashMap.this.size();
        }

        public boolean removeAll(IntIterable source) {
            int oldSize = IntFloatHashMap.this.size();
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                IntFloatHashMap.this.removeKey(iterator.next());
            }
            return oldSize != IntFloatHashMap.this.size();
        }

        public boolean removeAll(int ... source) {
            int oldSize = IntFloatHashMap.this.size();
            for (int item : source) {
                IntFloatHashMap.this.removeKey(item);
            }
            return oldSize != IntFloatHashMap.this.size();
        }

        public boolean retainAll(IntIterable source) {
            int oldSize = this.size();
            Object sourceSet = source instanceof IntSet ? (IntSet)source : source.toSet();
            IntFloatHashMap retained = IntFloatHashMap.this.select(new IntFloatPredicate((IntSet)sourceSet){
                final /* synthetic */ IntSet val$sourceSet;
                {
                    this.val$sourceSet = intSet;
                }

                public boolean accept(int key, float value) {
                    return this.val$sourceSet.contains(key);
                }
            });
            if (retained.size() != oldSize) {
                IntFloatHashMap.access$802(IntFloatHashMap.this, retained.keys);
                IntFloatHashMap.access$1002(IntFloatHashMap.this, retained.values);
                IntFloatHashMap.this.sentinelValues = retained.sentinelValues;
                IntFloatHashMap.this.occupiedWithData = retained.occupiedWithData;
                IntFloatHashMap.this.occupiedWithSentinels = retained.occupiedWithSentinels;
                return true;
            }
            return false;
        }

        public boolean retainAll(int ... source) {
            return this.retainAll((IntIterable)IntHashSet.newSetWith(source));
        }

        public void clear() {
            IntFloatHashMap.this.clear();
        }

        public MutableIntSet select(IntPredicate predicate) {
            IntHashSet result = new IntHashSet();
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    result.add(0);
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    result.add(1);
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableIntSet reject(IntPredicate predicate) {
            IntHashSet result = new IntHashSet();
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey && !predicate.accept(0)) {
                    result.add(0);
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && !predicate.accept(1)) {
                    result.add(1);
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key) || predicate.accept(key)) continue;
                result.add(key);
            }
            return result;
        }

        public MutableIntSet with(int element) {
            throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
        }

        public MutableIntSet without(int element) {
            throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
        }

        public MutableIntSet withAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
        }

        public MutableIntSet withoutAll(IntIterable elements) {
            throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
        }

        public int detectIfNone(IntPredicate predicate, int ifNone) {
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey && predicate.accept(0)) {
                    return 0;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && predicate.accept(1)) {
                    return 1;
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key) || !predicate.accept(key)) continue;
                return key;
            }
            return ifNone;
        }

        public <V> MutableSet<V> collect(IntToObjectFunction<? extends V> function) {
            MutableSet result = Sets.mutable.with();
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result.add(function.valueOf(0));
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                    result.add(function.valueOf(1));
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key)) continue;
                result.add(function.valueOf(key));
            }
            return result;
        }

        public MutableIntSet asUnmodifiable() {
            return UnmodifiableIntSet.of(this);
        }

        public MutableIntSet asSynchronized() {
            return SynchronizedIntSet.of(this);
        }

        public long sum() {
            long sum = 0L;
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    sum += 0L;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                    ++sum;
                }
            }
            for (int key : IntFloatHashMap.this.keys) {
                if (!IntFloatHashMap.isNonSentinel(key)) continue;
                sum += (long)key;
            }
            return sum;
        }

        public int max() {
            if (IntFloatHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int max = 0;
            boolean isMaxSet = false;
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    max = 0;
                    isMaxSet = true;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && (!isMaxSet || max < 1)) {
                    max = 1;
                    isMaxSet = true;
                }
            }
            for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                if (!IntFloatHashMap.isNonSentinel(IntFloatHashMap.this.keys[i]) || isMaxSet && max >= IntFloatHashMap.this.keys[i]) continue;
                max = IntFloatHashMap.this.keys[i];
                isMaxSet = true;
            }
            return max;
        }

        public int maxIfEmpty(int defaultValue) {
            if (IntFloatHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.max();
        }

        public int min() {
            if (IntFloatHashMap.this.isEmpty()) {
                throw new NoSuchElementException();
            }
            int min = 0;
            boolean isMinSet = false;
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    min = 0;
                    isMinSet = true;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey && (!isMinSet || 1 < min)) {
                    min = 1;
                    isMinSet = true;
                }
            }
            for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                if (!IntFloatHashMap.isNonSentinel(IntFloatHashMap.this.keys[i]) || isMinSet && IntFloatHashMap.this.keys[i] >= min) continue;
                min = IntFloatHashMap.this.keys[i];
                isMinSet = true;
            }
            return min;
        }

        public int minIfEmpty(int defaultValue) {
            if (IntFloatHashMap.this.isEmpty()) {
                return defaultValue;
            }
            return this.min();
        }

        public double average() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            return (double)this.sum() / (double)this.size();
        }

        public double median() {
            if (this.isEmpty()) {
                throw new ArithmeticException();
            }
            int[] sortedArray = this.toSortedArray();
            int middleIndex = sortedArray.length >> 1;
            if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
                int first = sortedArray[middleIndex];
                int second = sortedArray[middleIndex - 1];
                return ((double)first + (double)second) / 2.0;
            }
            return sortedArray[middleIndex];
        }

        public int[] toSortedArray() {
            int[] array = this.toArray();
            Arrays.sort(array);
            return array;
        }

        public MutableIntList toSortedList() {
            return IntArrayList.newList((IntIterable)this).sortThis();
        }

        public int[] toArray() {
            int size = IntFloatHashMap.this.size();
            final int[] result = new int[size];
            IntFloatHashMap.this.forEachKey(new IntProcedure(){
                private int index;

                public void value(int each) {
                    result[this.index] = each;
                    ++this.index;
                }
            });
            return result;
        }

        public boolean contains(int value) {
            return IntFloatHashMap.this.containsKey(value);
        }

        public boolean containsAll(int ... source) {
            for (int item : source) {
                if (IntFloatHashMap.this.containsKey(item)) continue;
                return false;
            }
            return true;
        }

        public boolean containsAll(IntIterable source) {
            IntIterator iterator = source.intIterator();
            while (iterator.hasNext()) {
                if (IntFloatHashMap.this.containsKey(iterator.next())) continue;
                return false;
            }
            return true;
        }

        public MutableIntList toList() {
            return IntArrayList.newList((IntIterable)this);
        }

        public MutableIntSet toSet() {
            return IntHashSet.newSet((IntIterable)this);
        }

        public MutableIntBag toBag() {
            return IntHashBag.newBag((IntIterable)this);
        }

        public LazyIntIterable asLazy() {
            return new LazyIntIterableAdapter((IntIterable)this);
        }

        public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
            Object result = injectedValue;
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result = function.valueOf(result, 0);
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                    result = function.valueOf(result, 1);
                }
            }
            for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                if (!IntFloatHashMap.isNonSentinel(IntFloatHashMap.this.keys[i])) continue;
                result = function.valueOf(result, IntFloatHashMap.this.keys[i]);
            }
            return result;
        }

        public IntSet freeze() {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".freeze() not implemented yet");
        }

        public ImmutableIntSet toImmutable() {
            return IntSets.immutable.withAll((IntIterable)this);
        }

        public int size() {
            return IntFloatHashMap.this.size();
        }

        public boolean isEmpty() {
            return IntFloatHashMap.this.isEmpty();
        }

        public boolean notEmpty() {
            return IntFloatHashMap.this.notEmpty();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof IntSet)) {
                return false;
            }
            IntSet other = (IntSet)obj;
            return this.size() == other.size() && this.containsAll(other.toArray());
        }

        public int hashCode() {
            int result = 0;
            if (IntFloatHashMap.this.sentinelValues != null) {
                if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                    result += 0;
                }
                if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                    ++result;
                }
            }
            for (int i = 0; i < IntFloatHashMap.this.keys.length; ++i) {
                if (!IntFloatHashMap.isNonSentinel(IntFloatHashMap.this.keys[i])) continue;
                result += IntFloatHashMap.this.keys[i];
            }
            return result;
        }

        public String toString() {
            return this.makeString("[", ", ", "]");
        }

        public String makeString() {
            return this.makeString(", ");
        }

        public String makeString(String separator) {
            return this.makeString("", separator, "");
        }

        public String makeString(String start, String separator, String end) {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendString(stringBuilder, start, separator, end);
            return ((Object)stringBuilder).toString();
        }

        public void appendString(Appendable appendable) {
            this.appendString(appendable, ", ");
        }

        public void appendString(Appendable appendable, String separator) {
            this.appendString(appendable, "", separator, "");
        }

        public void appendString(Appendable appendable, String start, String separator, String end) {
            try {
                appendable.append(start);
                boolean first = true;
                if (IntFloatHashMap.this.sentinelValues != null) {
                    if (IntFloatHashMap.this.sentinelValues.containsZeroKey) {
                        appendable.append(String.valueOf(0));
                        first = false;
                    }
                    if (IntFloatHashMap.this.sentinelValues.containsOneKey) {
                        if (!first) {
                            appendable.append(separator);
                        }
                        appendable.append(String.valueOf(1));
                        first = false;
                    }
                }
                for (int key : IntFloatHashMap.this.keys) {
                    if (!IntFloatHashMap.isNonSentinel(key)) continue;
                    if (!first) {
                        appendable.append(separator);
                    }
                    appendable.append(String.valueOf(key));
                    first = false;
                }
                appendable.append(end);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class KeySetIterator
    implements IntIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private KeySetIterator() {
        }

        public boolean hasNext() {
            return this.count < IntFloatHashMap.this.size();
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntFloatHashMap.this.containsKey(0)) {
                    return 0;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntFloatHashMap.this.containsKey(1)) {
                    return 1;
                }
            }
            int[] keys = IntFloatHashMap.this.keys;
            while (!IntFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            int result = keys[this.position];
            ++this.position;
            return result;
        }
    }

    private class KeysView
    extends AbstractLazyIntIterable {
        private KeysView() {
        }

        public IntIterator intIterator() {
            return new KeySetIterator();
        }

        public void forEach(IntProcedure procedure) {
            IntFloatHashMap.this.forEachKey(procedure);
        }
    }

    private class InternalFloatIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalFloatIterator() {
        }

        public boolean hasNext() {
            return this.count < IntFloatHashMap.this.size();
        }

        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (IntFloatHashMap.this.containsKey(0)) {
                    return IntFloatHashMap.this.get(0);
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (IntFloatHashMap.this.containsKey(1)) {
                    return IntFloatHashMap.this.get(1);
                }
            }
            int[] keys = IntFloatHashMap.this.keys;
            while (!IntFloatHashMap.isNonSentinel(keys[this.position])) {
                ++this.position;
            }
            float result = IntFloatHashMap.this.values[this.position];
            ++this.position;
            return result;
        }
    }

    private static final class SentinelValues {
        private boolean containsZeroKey;
        private boolean containsOneKey;
        private float zeroValue;
        private float oneValue;

        private SentinelValues() {
        }

        public int size() {
            return (this.containsZeroKey ? 1 : 0) + (this.containsOneKey ? 1 : 0);
        }

        public boolean containsValue(float value) {
            boolean valueEqualsZeroValue = this.containsZeroKey && Float.compare(this.zeroValue, value) == 0;
            boolean valueEqualsOneValue = this.containsOneKey && Float.compare(this.oneValue, value) == 0;
            return valueEqualsZeroValue || valueEqualsOneValue;
        }
    }
}

