/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.stack.immutable.primitive;

import com.gs.collections.api.CharIterable;
import com.gs.collections.api.factory.stack.primitive.ImmutableCharStackFactory;
import com.gs.collections.api.stack.primitive.ImmutableCharStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableCharArrayStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableCharEmptyStack;
import com.gs.collections.impl.stack.immutable.primitive.ImmutableCharSingletonStack;

public class ImmutableCharStackFactoryImpl
implements ImmutableCharStackFactory {
    public ImmutableCharStack of() {
        return this.with();
    }

    public ImmutableCharStack with() {
        return ImmutableCharEmptyStack.INSTANCE;
    }

    public ImmutableCharStack of(char one) {
        return this.with(one);
    }

    public ImmutableCharStack with(char one) {
        return new ImmutableCharSingletonStack(one);
    }

    public ImmutableCharStack of(char ... items) {
        return this.with(items);
    }

    public ImmutableCharStack with(char ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableCharArrayStack.newStackWith(items);
    }

    public ImmutableCharStack ofAll(CharIterable items) {
        return this.withAll(items);
    }

    public ImmutableCharStack withAll(CharIterable items) {
        if (items instanceof ImmutableCharStack) {
            return (ImmutableCharStack)items;
        }
        return this.with(items.toArray());
    }

    public ImmutableCharStack ofAllReversed(CharIterable items) {
        return this.withAllReversed(items);
    }

    public ImmutableCharStack withAllReversed(CharIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableCharArrayStack.newStackFromTopToBottom(items);
    }
}

