/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.proxy;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.grails.datastore.mapping.core.Session;
import org.grails.datastore.mapping.proxy.EntityProxyMethodHandler;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.util.ReflectionUtils;

public class SessionEntityProxyMethodHandler
extends EntityProxyMethodHandler {
    private final Session session;
    private final Class cls;
    private final Serializable id;
    protected Object target;

    public SessionEntityProxyMethodHandler(Class proxyClass, Session session, Class cls, Serializable id) {
        super(proxyClass);
        this.session = session;
        this.cls = cls;
        this.id = id;
    }

    @Override
    protected Object resolveDelegate(Object self) {
        if (this.target == null) {
            this.initializeTarget();
            if (this.target == null) {
                throw new DataIntegrityViolationException("Proxy for [" + this.cls.getName() + ":" + this.id + "] could not be initialized");
            }
        }
        return this.target;
    }

    protected void initializeTarget() {
        this.target = this.session.retrieve(this.cls, this.id);
    }

    @Override
    protected Object isProxyInitiated(Object self) {
        return this.target != null;
    }

    @Override
    protected Object getProxyKey(Object self) {
        return this.id;
    }

    @Override
    protected Object handleInvocationFallback(Object self, Method thisMethod, Object[] args) {
        Object actualTarget = this.getProxyTarget(self);
        if (!thisMethod.getDeclaringClass().isInstance(actualTarget)) {
            if (Modifier.isPublic(thisMethod.getModifiers())) {
                try {
                    thisMethod = actualTarget.getClass().getMethod(thisMethod.getName(), thisMethod.getParameterTypes());
                }
                catch (Exception e) {
                    ReflectionUtils.handleReflectionException((Exception)e);
                }
            } else {
                thisMethod = ReflectionUtils.findMethod(actualTarget.getClass(), (String)thisMethod.getName(), (Class[])thisMethod.getParameterTypes());
            }
        }
        return ReflectionUtils.invokeMethod((Method)thisMethod, (Object)actualTarget, (Object[])args);
    }
}

