/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.repackage;

import java.io.File;
import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.bundling.Jar;
import org.springframework.boot.gradle.PluginFeatures;
import org.springframework.boot.gradle.SpringBootPluginExtension;
import org.springframework.boot.gradle.repackage.RepackageTask;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryCallback;
import org.springframework.util.StringUtils;

public class RepackagePluginFeatures
implements PluginFeatures {
    public static final String REPACKAGE_TASK_NAME = "bootRepackage";

    @Override
    public void apply(Project project) {
        this.addRepackageTask(project);
        this.registerRepackageTaskProperty(project);
    }

    private void addRepackageTask(Project project) {
        RepackageTask task = (RepackageTask)project.getTasks().create(REPACKAGE_TASK_NAME, RepackageTask.class);
        task.setDescription("Repackage existing JAR and WAR archives so that they can be executed from the command line using 'java -jar'");
        task.setGroup("build");
        Configuration runtimeConfiguration = project.getConfigurations().getByName("runtime");
        TaskDependency runtimeProjectDependencyJarTasks = runtimeConfiguration.getTaskDependencyFromProjectDependency(true, "jar");
        task.dependsOn(new Object[]{project.getConfigurations().getByName("archives").getAllArtifacts().getBuildDependencies(), runtimeProjectDependencyJarTasks});
        this.registerOutput(project, task);
        this.ensureTaskRunsOnAssembly(project, (Task)task);
    }

    private void registerOutput(Project project, final RepackageTask task) {
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(Project project) {
                project.getTasks().withType(Jar.class, (Action)new RegisterInputsOutputsAction(task));
                Object withJar = task.getWithJarTask();
                if (withJar != null) {
                    task.dependsOn(new Object[]{withJar});
                }
            }
        });
    }

    private void ensureTaskRunsOnAssembly(Project project, Task task) {
        project.getTasks().getByName("assemble").dependsOn(new Object[]{task});
    }

    private void registerRepackageTaskProperty(Project project) {
        project.getExtensions().getExtraProperties().set("BootRepackage", RepackageTask.class);
    }

    private static class RegisterInputsOutputsAction
    implements Action<Jar> {
        private final RepackageTask task;
        private final Project project;

        public RegisterInputsOutputsAction(RepackageTask task) {
            this.task = task;
            this.project = task.getProject();
        }

        public void execute(Jar jarTask) {
            if ("".equals(jarTask.getClassifier())) {
                String classifier = this.task.getClassifier();
                if (classifier == null) {
                    SpringBootPluginExtension extension = (SpringBootPluginExtension)this.project.getExtensions().getByType(SpringBootPluginExtension.class);
                    classifier = extension.getClassifier();
                    this.task.setClassifier(classifier);
                }
                if (classifier != null) {
                    this.setupInputOutputs(jarTask, classifier);
                }
            }
        }

        private void setupInputOutputs(Jar jarTask, String classifier) {
            Logger logger = this.project.getLogger();
            logger.debug("Using classifier: " + classifier + " for task " + this.task.getName());
            File inputFile = jarTask.getArchivePath();
            String outputName = inputFile.getName();
            outputName = String.valueOf(StringUtils.stripFilenameExtension((String)outputName)) + "-" + classifier + "." + StringUtils.getFilenameExtension((String)outputName);
            File outputFile = new File(inputFile.getParentFile(), outputName);
            this.task.getInputs().file((Object)jarTask);
            this.addLibraryDependencies(this.task);
            this.task.getOutputs().file((Object)outputFile);
            this.task.setOutputFile(outputFile);
        }

        private void addLibraryDependencies(final RepackageTask task) {
            try {
                task.getLibraries().doWithLibraries(new LibraryCallback(){

                    public void library(Library library) throws IOException {
                        task.getInputs().file((Object)library.getFile());
                    }
                });
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }
}

