/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen;

import java.util.Stack;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.batik.ext.awt.g2d.TransformStackElement;
import org.apache.batik.svggen.AbstractSVGConverter;
import org.apache.batik.svggen.SVGDescriptor;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGTransformDescriptor;

public class SVGTransform
extends AbstractSVGConverter {
    private static double radiansToDegrees = 57.29577951308232;

    public SVGTransform(SVGGeneratorContext sVGGeneratorContext) {
        super(sVGGeneratorContext);
    }

    @Override
    public SVGDescriptor toSVG(GraphicContext graphicContext) {
        return new SVGTransformDescriptor(this.toSVGTransform(graphicContext));
    }

    public final String toSVGTransform(GraphicContext graphicContext) {
        return this.toSVGTransform(graphicContext.getTransformStack());
    }

    public final String toSVGTransform(TransformStackElement[] transformStackElementArray) {
        int n = transformStackElementArray.length;
        Stack stack = new Stack(){

            public Object push(Object object) {
                Object object2;
                if (((TransformStackElement)object).isIdentity()) {
                    object2 = this.pop();
                } else {
                    super.push(object);
                    object2 = null;
                }
                return object2;
            }

            public Object pop() {
                Object var1_1 = null;
                if (!super.empty()) {
                    var1_1 = super.pop();
                }
                return var1_1;
            }
        };
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        TransformStackElement transformStackElement = null;
        while (n2 < n) {
            n4 = n2;
            if (transformStackElement == null) {
                transformStackElement = (TransformStackElement)transformStackElementArray[n2].clone();
            }
            bl = true;
            for (n3 = ++n4; n3 < n && (bl = transformStackElement.concatenate(transformStackElementArray[n3])); ++n3) {
            }
            n2 = n3;
            transformStackElement = stack.push(transformStackElement);
        }
        if (transformStackElement != null) {
            stack.push(transformStackElement);
        }
        int n5 = stack.size();
        StringBuffer stringBuffer = new StringBuffer(n5 * 8);
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuffer.append(this.convertTransform((TransformStackElement)stack.get(n2)));
            stringBuffer.append(" ");
        }
        String string = stringBuffer.toString().trim();
        return string;
    }

    final String convertTransform(TransformStackElement transformStackElement) {
        StringBuffer stringBuffer = new StringBuffer();
        double[] dArray = transformStackElement.getTransformParameters();
        switch (transformStackElement.getType().toInt()) {
            case 0: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("translate");
                stringBuffer.append("(");
                stringBuffer.append(this.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[1]));
                stringBuffer.append(")");
                break;
            }
            case 1: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("rotate");
                stringBuffer.append("(");
                stringBuffer.append(this.doubleString(radiansToDegrees * dArray[0]));
                stringBuffer.append(")");
                break;
            }
            case 2: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("scale");
                stringBuffer.append("(");
                stringBuffer.append(this.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[1]));
                stringBuffer.append(")");
                break;
            }
            case 3: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("matrix");
                stringBuffer.append("(");
                stringBuffer.append(1);
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[1]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(1);
                stringBuffer.append(",");
                stringBuffer.append(0);
                stringBuffer.append(",");
                stringBuffer.append(0);
                stringBuffer.append(")");
                break;
            }
            case 4: {
                if (transformStackElement.isIdentity()) break;
                stringBuffer.append("matrix");
                stringBuffer.append("(");
                stringBuffer.append(this.doubleString(dArray[0]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[1]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[2]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[3]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[4]));
                stringBuffer.append(",");
                stringBuffer.append(this.doubleString(dArray[5]));
                stringBuffer.append(")");
                break;
            }
            default: {
                throw new Error();
            }
        }
        return stringBuffer.toString();
    }
}

