/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import javajs.util.PT;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.i18n.GT;
import org.jmol.script.ScriptException;
import org.jmol.viewer.Viewer;

public abstract class ScriptError
implements JmolScriptEvaluator {
    public Viewer vwr;
    public boolean chk;
    protected boolean ignoreError;
    protected boolean error;
    protected String errorMessage;
    protected String errorMessageUntranslated;
    protected String errorType;
    protected int iCommandError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_backgroundModelError = 1;
    public static final int ERROR_badArgumentCount = 2;
    static final int ERROR_badMillerIndices = 3;
    public static final int ERROR_badRGBColor = 4;
    static final int ERROR_booleanExpected = 5;
    static final int ERROR_booleanOrNumberExpected = 6;
    static final int ERROR_booleanOrWhateverExpected = 7;
    static final int ERROR_colorExpected = 8;
    static final int ERROR_colorOrPaletteRequired = 9;
    static final int ERROR_commandExpected = 10;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 11;
    static final int ERROR_drawObjectNotDefined = 12;
    public static final int ERROR_endOfStatementUnexpected = 13;
    public static final int ERROR_expressionExpected = 14;
    public static final int ERROR_expressionOrIntegerExpected = 15;
    static final int ERROR_filenameExpected = 16;
    public static final int ERROR_fileNotFoundException = 17;
    public static final int ERROR_incompatibleArguments = 18;
    public static final int ERROR_insufficientArguments = 19;
    static final int ERROR_integerExpected = 20;
    static final int ERROR_integerOutOfRange = 21;
    public static final int ERROR_invalidArgument = 22;
    public static final int ERROR_invalidParameterOrder = 23;
    public static final int ERROR_keywordExpected = 24;
    public static final int ERROR_moCoefficients = 25;
    public static final int ERROR_moIndex = 26;
    public static final int ERROR_moModelError = 27;
    public static final int ERROR_moOccupancy = 28;
    public static final int ERROR_moOnlyOne = 29;
    public static final int ERROR_multipleModelsDisplayedNotOK = 30;
    public static final int ERROR_noData = 31;
    public static final int ERROR_noPartialCharges = 32;
    static final int ERROR_noUnitCell = 33;
    public static final int ERROR_numberExpected = 34;
    static final int ERROR_numberMustBe = 35;
    static final int ERROR_numberOutOfRange = 36;
    static final int ERROR_objectNameExpected = 37;
    static final int ERROR_planeExpected = 38;
    static final int ERROR_propertyNameExpected = 39;
    static final int ERROR_spaceGroupNotFound = 40;
    static final int ERROR_stringExpected = 41;
    static final int ERROR_stringOrIdentifierExpected = 42;
    static final int ERROR_tooManyPoints = 43;
    static final int ERROR_tooManyScriptLevels = 44;
    static final int ERROR_unrecognizedAtomProperty = 45;
    static final int ERROR_unrecognizedBondProperty = 46;
    static final int ERROR_unrecognizedCommand = 47;
    static final int ERROR_unrecognizedExpression = 48;
    static final int ERROR_unrecognizedObject = 49;
    static final int ERROR_unrecognizedParameter = 50;
    static final int ERROR_unrecognizedParameterWarning = 51;
    static final int ERROR_unrecognizedShowParameter = 52;
    public static final int ERROR_what = 53;
    public static final int ERROR_writeWhat = 54;
    static final int ERROR_multipleModelsNotOK = 55;
    static final int ERROR_cannotSet = 56;

    protected abstract void showString(String var1);

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getErrorMessageUntranslated() {
        return this.errorMessageUntranslated == null ? this.errorMessage : this.errorMessageUntranslated;
    }

    public void invArg() throws ScriptException {
        this.error(22);
    }

    public void bad() throws ScriptException {
        this.error(2);
    }

    public void integerOutOfRange(int n, int n2) throws ScriptException {
        this.errorOrWarn(21, "" + n, "" + n2, null, true);
    }

    protected void numberOutOfRange(float f, float f2) throws ScriptException {
        this.errorOrWarn(36, "" + f, "" + f2, null, true);
    }

    public void error(int n) throws ScriptException {
        this.errorOrWarn(n, null, null, null, false);
    }

    public void errorStr(int n, String string) throws ScriptException {
        this.errorOrWarn(n, string, null, null, false);
    }

    public void errorStr2(int n, String string, String string2) throws ScriptException {
        this.errorOrWarn(n, string, string2, null, false);
    }

    void errorMore(int n, String string, String string2, String string3) throws ScriptException {
        this.errorOrWarn(n, string, string2, string3, false);
    }

    protected void warning(int n, String string, String string2) throws ScriptException {
        this.errorOrWarn(n, string, string2, null, true);
    }

    private void errorOrWarn(int n, String string, String string2, String string3, boolean bl) throws ScriptException {
        String string4;
        String string5 = this.ignoreError ? null : ScriptError.errorString(n, string, string2, string3, true);
        String string6 = string4 = this.ignoreError || !GT.getDoTranslate() ? null : ScriptError.errorString(n, string, string2, string3, false);
        if (!bl) {
            this.evalError(string5, string4);
        }
        this.showString(string5);
    }

    public void evalError(String string, String string2) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            string2 = string;
        }
        if (!this.chk) {
            this.setCursorWait(false);
            this.vwr.setBooleanProperty("refreshing", true);
            this.vwr.setStringProperty("_errormessage", string2);
        }
        throw new ScriptException(this, string, string2, true);
    }

    public void setCursorWait(boolean bl) {
        if (!this.chk) {
            this.vwr.setCursor(bl ? 3 : 0);
        }
    }

    static String errorString(int n, String string, String string2, String string3, boolean bl) {
        String string4;
        boolean bl2 = false;
        if (!bl && (bl2 = GT.getDoTranslate())) {
            GT.setDoTranslate(false);
        }
        switch (n) {
            default: {
                string4 = "Unknown error message number: " + n;
                break;
            }
            case 0: {
                string4 = GT._("x y z axis expected");
                break;
            }
            case 1: {
                string4 = GT._("{0} not allowed with background model displayed");
                break;
            }
            case 2: {
                string4 = GT._("bad argument count");
                break;
            }
            case 3: {
                string4 = GT._("Miller indices cannot all be zero.");
                break;
            }
            case 4: {
                string4 = GT._("bad [R,G,B] color");
                break;
            }
            case 5: {
                string4 = GT._("boolean expected");
                break;
            }
            case 6: {
                string4 = GT._("boolean or number expected");
                break;
            }
            case 7: {
                string4 = GT._("boolean, number, or {0} expected");
                break;
            }
            case 56: {
                string4 = GT._("cannot set value");
                break;
            }
            case 8: {
                string4 = GT._("color expected");
                break;
            }
            case 9: {
                string4 = GT._("a color or palette name (Jmol, Rasmol) is required");
                break;
            }
            case 10: {
                string4 = GT._("command expected");
                break;
            }
            case 11: {
                string4 = GT._("{x y z} or $name or (atom expression) required");
                break;
            }
            case 12: {
                string4 = GT._("draw object not defined");
                break;
            }
            case 13: {
                string4 = GT._("unexpected end of script command");
                break;
            }
            case 14: {
                string4 = GT._("valid (atom expression) expected");
                break;
            }
            case 15: {
                string4 = GT._("(atom expression) or integer expected");
                break;
            }
            case 16: {
                string4 = GT._("filename expected");
                break;
            }
            case 17: {
                string4 = GT._("file not found");
                break;
            }
            case 18: {
                string4 = GT._("incompatible arguments");
                break;
            }
            case 19: {
                string4 = GT._("insufficient arguments");
                break;
            }
            case 20: {
                string4 = GT._("integer expected");
                break;
            }
            case 21: {
                string4 = GT._("integer out of range ({0} - {1})");
                break;
            }
            case 22: {
                string4 = GT._("invalid argument");
                break;
            }
            case 23: {
                string4 = GT._("invalid parameter order");
                break;
            }
            case 24: {
                string4 = GT._("keyword expected");
                break;
            }
            case 25: {
                string4 = GT._("no MO coefficient data available");
                break;
            }
            case 26: {
                string4 = GT._("An MO index from 1 to {0} is required");
                break;
            }
            case 27: {
                string4 = GT._("no MO basis/coefficient data available for this frame");
                break;
            }
            case 28: {
                string4 = GT._("no MO occupancy data available");
                break;
            }
            case 29: {
                string4 = GT._("Only one molecular orbital is available in this file");
                break;
            }
            case 30: {
                string4 = GT._("{0} require that only one model be displayed");
                break;
            }
            case 55: {
                string4 = GT._("{0} requires that only one model be loaded");
                break;
            }
            case 31: {
                string4 = GT._("No data available");
                break;
            }
            case 32: {
                string4 = GT._("No partial charges were read from the file; Jmol needs these to render the MEP data.");
                break;
            }
            case 33: {
                string4 = GT._("No unit cell");
                break;
            }
            case 34: {
                string4 = GT._("number expected");
                break;
            }
            case 35: {
                string4 = GT._("number must be ({0} or {1})");
                break;
            }
            case 36: {
                string4 = GT._("decimal number out of range ({0} - {1})");
                break;
            }
            case 37: {
                string4 = GT._("object name expected after '$'");
                break;
            }
            case 38: {
                string4 = GT._("plane expected -- either three points or atom expressions or {0} or {1} or {2}");
                break;
            }
            case 39: {
                string4 = GT._("property name expected");
                break;
            }
            case 40: {
                string4 = GT._("space group {0} was not found.");
                break;
            }
            case 41: {
                string4 = GT._("quoted string expected");
                break;
            }
            case 42: {
                string4 = GT._("quoted string or identifier expected");
                break;
            }
            case 43: {
                string4 = GT._("too many rotation points were specified");
                break;
            }
            case 44: {
                string4 = GT._("too many script levels");
                break;
            }
            case 45: {
                string4 = GT._("unrecognized atom property");
                break;
            }
            case 46: {
                string4 = GT._("unrecognized bond property");
                break;
            }
            case 47: {
                string4 = GT._("unrecognized command");
                break;
            }
            case 48: {
                string4 = GT._("runtime unrecognized expression");
                break;
            }
            case 49: {
                string4 = GT._("unrecognized object");
                break;
            }
            case 50: {
                string4 = GT._("unrecognized {0} parameter");
                break;
            }
            case 51: {
                string4 = GT._("unrecognized {0} parameter in Jmol state script (set anyway)");
                break;
            }
            case 52: {
                string4 = GT._("unrecognized SHOW parameter --  use {0}");
                break;
            }
            case 53: {
                string4 = "{0}";
                break;
            }
            case 54: {
                string4 = GT._("write what? {0} or {1} \"filename\"");
            }
        }
        if (string4.indexOf("{0}") < 0) {
            if (string != null) {
                string4 = string4 + ": " + string;
            }
        } else {
            if ((string4 = PT.rep(string4, "{0}", string)).indexOf("{1}") >= 0) {
                string4 = PT.rep(string4, "{1}", string2);
            } else if (string2 != null) {
                string4 = string4 + ": " + string2;
            }
            if (string4.indexOf("{2}") >= 0) {
                string4 = PT.rep(string4, "{2}", string2);
            }
        }
        if (bl2) {
            GT.setDoTranslate(true);
        }
        return string4;
    }

    public static String getErrorLineMessage(String string, String string2, int n, int n2, String string3) {
        String string4 = "\n----";
        if (string2 != null || string != null) {
            string4 = string4 + "line " + n + " command " + (n2 + 1) + " of " + (string == null ? string2 : (string.equals("try") ? "try" : "function " + string)) + ":";
        }
        string4 = string4 + "\n         " + string3;
        return string4;
    }

    protected void setErrorMessage(String string) {
        this.errorMessageUntranslated = null;
        if (string == null) {
            this.error = false;
            this.errorType = null;
            this.errorMessage = null;
            this.iCommandError = -1;
            return;
        }
        this.error = true;
        if (this.errorMessage == null) {
            this.errorMessage = GT._("script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }
}

