/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import com.oracle.truffle.api.utilities.ValueProfile;
import java.util.ArrayList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.arguments.CheckArityNode;
import org.jruby.truffle.nodes.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeGen;
import org.jruby.truffle.nodes.cast.BooleanCastWithDefaultNodeGen;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.coerce.NameToJavaStringNode;
import org.jruby.truffle.nodes.coerce.NameToJavaStringNodeGen;
import org.jruby.truffle.nodes.coerce.NameToSymbolOrStringNodeGen;
import org.jruby.truffle.nodes.coerce.ToPathNodeGen;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeGen;
import org.jruby.truffle.nodes.constants.ReadConstantNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.core.RaiseIfFrozenNode;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.methods.CanBindMethodToModuleNode;
import org.jruby.truffle.nodes.methods.CanBindMethodToModuleNodeGen;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeGen;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeGen;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.MethodFilter;
import org.jruby.truffle.runtime.core.ModuleFields;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.IdUtil;

@CoreClass(name="Module")
public abstract class ModuleNodes {
    public static DynamicObject createRubyModule(RubyContext context, DynamicObject selfClass, DynamicObject lexicalParent, String name, Node currentNode) {
        DynamicObject module;
        ModuleFields model = new ModuleFields(context, lexicalParent, name);
        model.rubyModuleObject = module = Layouts.MODULE.createModule(Layouts.CLASS.getInstanceFactory(selfClass), model);
        if (lexicalParent != null) {
            Layouts.MODULE.getFields(module).getAdoptedByLexicalParent(context, lexicalParent, name, currentNode);
        } else if (Layouts.MODULE.getFields((DynamicObject)module).givenBaseName != null) {
            Layouts.MODULE.getFields(module).setFullName(Layouts.MODULE.getFields((DynamicObject)module).givenBaseName);
        }
        return module;
    }

    @CoreMethod(names={"singleton_class?"})
    public static abstract class IsSingletonClassNode
    extends CoreMethodArrayArgumentsNode {
        public IsSingletonClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isRubyClass(rubyModule)"})
        public Object doModule(DynamicObject rubyModule) {
            return false;
        }

        @Specialization(guards={"isRubyClass(rubyClass)"})
        public Object doClass(DynamicObject rubyClass) {
            return Layouts.CLASS.getIsSingleton(rubyClass);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            return ModuleNodes.createRubyModule(this.getContext(), rubyClass, null, null, this);
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class SetMethodVisibilityNode
    extends RubyNode {
        private final Visibility visibility;
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;

        public SetMethodVisibilityNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        public abstract DynamicObject executeSetMethodVisibility(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization
        public DynamicObject setMethodVisibility(VirtualFrame frame, DynamicObject module, Object name) {
            String methodName = this.nameToJavaStringNode.executeToJavaString(frame, name);
            InternalMethod method = Layouts.MODULE.getFields(module).deepMethodSearch(this.getContext(), methodName);
            if (method == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(methodName, module, this));
            }
            if (this.visibility == Visibility.MODULE_FUNCTION) {
                Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method.withVisibility(Visibility.PRIVATE));
                Layouts.MODULE.getFields(this.singletonClassNode.executeSingletonClass(module)).addMethod(this.getContext(), this, method.withVisibility(Visibility.PUBLIC));
            } else {
                Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method.withVisibility(this.visibility));
            }
            return module;
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="names")})
    public static abstract class SetVisibilityNode
    extends RubyNode {
        private final Visibility visibility;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public SetVisibilityNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, visibility, null, null);
        }

        public abstract DynamicObject executeSetVisibility(VirtualFrame var1, DynamicObject var2, Object[] var3);

        @Specialization
        public DynamicObject setVisibility(VirtualFrame frame, DynamicObject module, Object[] names) {
            if (names.length == 0) {
                this.setCurrentVisibility(this.visibility);
            } else {
                for (Object name : names) {
                    this.setMethodVisibilityNode.executeSetMethodVisibility(frame, module, name);
                }
            }
            return module;
        }

        private void setCurrentVisibility(Visibility visibility) {
            Frame callerFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_WRITE, true);
            DeclarationContext.changeVisibility(callerFrame, visibility);
        }
    }

    @CoreMethod(names={"undef_method"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class UndefMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;
        @Node.Child
        RaiseIfFrozenNode raiseIfFrozenNode;
        @Node.Child
        CallDispatchHeadNode methodUndefinedNode;

        public UndefMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
            this.raiseIfFrozenNode = new RaiseIfFrozenNode(new SelfNode(context, sourceSection));
            this.methodUndefinedNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public DynamicObject undefMethods(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.undefMethod(frame, module, this.nameToJavaStringNode.executeToJavaString(frame, name));
            }
            return module;
        }

        private void undefMethod(VirtualFrame frame, DynamicObject module, String name) {
            this.raiseIfFrozenNode.execute(frame);
            Layouts.MODULE.getFields(module).undefMethod(this.getContext(), this, name);
            this.methodUndefinedNode.call(frame, module, "method_undefined", null, this.getSymbol(name));
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject module) {
            String name = Layouts.MODULE.getFields(module).getName();
            return this.createString(StringOperations.encodeByteList(name, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"remove_method"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class RemoveMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;
        @Node.Child
        RaiseIfFrozenNode raiseIfFrozenNode;
        @Node.Child
        CallDispatchHeadNode methodRemovedNode;

        public RemoveMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
            this.raiseIfFrozenNode = new RaiseIfFrozenNode(new SelfNode(context, sourceSection));
            this.methodRemovedNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        @Specialization
        public DynamicObject removeMethods(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.removeMethod(frame, module, this.nameToJavaStringNode.executeToJavaString(frame, name));
            }
            return module;
        }

        private void removeMethod(VirtualFrame frame, DynamicObject module, String name) {
            this.raiseIfFrozenNode.execute(frame);
            CompilerDirectives.transferToInterpreter();
            if (!Layouts.MODULE.getFields(module).getMethods().containsKey(name)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorMethodNotDefinedIn(module, name, this));
            }
            Layouts.MODULE.getFields(module).removeMethod(name);
            this.methodRemovedNode.call(frame, module, "method_removed", null, this.getSymbol(name));
        }
    }

    @CoreMethod(names={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class RemoveConstNode
    extends CoreMethodNode {
        public RemoveConstNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        Object removeConstant(DynamicObject module, String name) {
            RubyConstant oldConstant = Layouts.MODULE.getFields(module).removeConstant(this.getContext(), this, name);
            if (oldConstant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorConstantNotDefined(module, name, this));
            }
            if (oldConstant.isAutoload()) {
                return this.nil();
            }
            return oldConstant.getValue();
        }
    }

    @CoreMethod(names={"remove_class_variable"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class RemoveClassVariableNode
    extends CoreMethodNode {
        public RemoveClassVariableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object removeClassVariableString(DynamicObject module, String name) {
            RubyContext.checkClassVariableName(this.getContext(), name, this);
            return Layouts.MODULE.getFields(module).removeClassVariable(this.getContext(), this, name);
        }
    }

    @CoreMethod(names={"protected"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class ProtectedNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public ProtectedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PROTECTED, null, null);
        }

        @Specialization
        public DynamicObject doProtected(VirtualFrame frame, DynamicObject module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"public_constant"}, rest=true)
    public static abstract class PublicConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;

        public PublicConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject publicConstant(VirtualFrame frame, DynamicObject module, Object[] args) {
            for (Object arg : args) {
                String name = this.nameToJavaStringNode.executeToJavaString(frame, arg);
                Layouts.MODULE.getFields(module).changeConstantVisibility(this.getContext(), this, name, false);
            }
            return module;
        }
    }

    @CoreMethod(names={"private_constant"}, rest=true)
    public static abstract class PrivateConstantNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;

        public PrivateConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject privateConstant(VirtualFrame frame, DynamicObject module, Object[] args) {
            for (Object arg : args) {
                String name = this.nameToJavaStringNode.executeToJavaString(frame, arg);
                Layouts.MODULE.getFields(module).changeConstantVisibility(this.getContext(), this, name, true);
            }
            return module;
        }
    }

    @CoreMethod(names={"instance_method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class InstanceMethodNode
    extends CoreMethodNode {
        public InstanceMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public DynamicObject instanceMethod(DynamicObject module, String name) {
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null || method.isUndefined()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, module, this));
            }
            return Layouts.UNBOUND_METHOD.createUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodFactory(), module, method);
        }
    }

    @CoreMethod(names={"instance_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class InstanceMethodsNode
    extends CoreMethodNode {
        public InstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public DynamicObject instanceMethods(DynamicObject module, boolean includeAncestors) {
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(module).filterMethods(this.getContext(), includeAncestors, MethodFilter.PUBLIC_PROTECTED).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"public_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class PublicMethodDefinedNode
    extends CoreMethodNode {
        public PublicMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isPublicMethodDefined(DynamicObject module, String name) {
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility() == Visibility.PUBLIC;
        }
    }

    @CoreMethod(names={"public_instance_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class PublicInstanceMethodsNode
    extends CoreMethodNode {
        public PublicInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public DynamicObject publicInstanceMethods(DynamicObject module, boolean includeAncestors) {
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(module).filterMethods(this.getContext(), includeAncestors, MethodFilter.PUBLIC).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"public_instance_method"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class PublicInstanceMethodNode
    extends CoreMethodNode {
        public PublicInstanceMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public DynamicObject publicInstanceMethod(DynamicObject module, String name) {
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null || method.isUndefined()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, module, this));
            }
            if (method.getVisibility() != Visibility.PUBLIC) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateMethod(name, module, this));
            }
            return Layouts.UNBOUND_METHOD.createUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodFactory(), module, method);
        }
    }

    @CoreMethod(names={"private_instance_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class PrivateInstanceMethodsNode
    extends CoreMethodNode {
        public PrivateInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public DynamicObject privateInstanceMethods(DynamicObject module, boolean includeAncestors) {
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(module).filterMethods(this.getContext(), includeAncestors, MethodFilter.PRIVATE).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"protected_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ProtectedMethodDefinedNode
    extends CoreMethodNode {
        public ProtectedMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isProtectedMethodDefined(DynamicObject module, String name) {
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility().isProtected();
        }
    }

    @CoreMethod(names={"protected_instance_methods"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="includeAncestors")})
    public static abstract class ProtectedInstanceMethodsNode
    extends CoreMethodNode {
        public ProtectedInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"includeAncestors"})
        public RubyNode coerceToBoolean(RubyNode includeAncestors) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, includeAncestors);
        }

        @Specialization
        public DynamicObject protectedInstanceMethods(DynamicObject module, boolean includeAncestors) {
            CompilerDirectives.transferToInterpreter();
            Object[] objects = Layouts.MODULE.getFields(module).filterMethods(this.getContext(), includeAncestors, MethodFilter.PROTECTED).toArray();
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"private_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class PrivateMethodDefinedNode
    extends CoreMethodNode {
        public PrivateMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isPrivateMethodDefined(DynamicObject module, String name) {
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility().isPrivate();
        }
    }

    @CoreMethod(names={"private_class_method"}, rest=true)
    public static abstract class PrivateClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public PrivateClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, Visibility.PRIVATE, null, null);
        }

        @Specialization
        public DynamicObject privateClassMethod(VirtualFrame frame, DynamicObject module, Object[] names) {
            DynamicObject singletonClass = this.singletonClassNode.executeSingletonClass(module);
            for (Object name : names) {
                this.setMethodVisibilityNode.executeSetMethodVisibility(frame, singletonClass, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"prepend_features"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class PrependFeaturesNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        TaintResultNode taintResultNode;

        public PrependFeaturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @Specialization(guards={"isRubyModule(target)"})
        public DynamicObject prependFeatures(DynamicObject features, DynamicObject target) {
            if (RubyGuards.isRubyClass(features)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("prepend_features must be called only on modules", this));
            }
            Layouts.MODULE.getFields(target).prepend(this.getContext(), this, features);
            this.taintResultNode.maybeTaint(features, target);
            return this.nil();
        }
    }

    @CoreMethod(names={"private"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class PrivateNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public PrivateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PRIVATE, null, null);
        }

        public abstract DynamicObject executePrivate(VirtualFrame var1, DynamicObject var2, Object[] var3);

        @Specialization
        public DynamicObject doPrivate(VirtualFrame frame, DynamicObject module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"public_class_method"}, rest=true)
    public static abstract class PublicClassMethodNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SingletonClassNode singletonClassNode;
        @Node.Child
        SetMethodVisibilityNode setMethodVisibilityNode;

        public PublicClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
            this.setMethodVisibilityNode = ModuleNodesFactory.SetMethodVisibilityNodeGen.create(context, sourceSection, Visibility.PUBLIC, null, null);
        }

        @Specialization
        public DynamicObject publicClassMethod(VirtualFrame frame, DynamicObject module, Object[] names) {
            DynamicObject singletonClass = this.singletonClassNode.executeSingletonClass(module);
            for (Object name : names) {
                this.setMethodVisibilityNode.executeSetMethodVisibility(frame, singletonClass, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"public"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class PublicNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public PublicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.PUBLIC, null, null);
        }

        public abstract DynamicObject executePublic(VirtualFrame var1, DynamicObject var2, Object[] var3);

        @Specialization
        public DynamicObject doPublic(VirtualFrame frame, DynamicObject module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"nesting"}, onSingleton=true)
    public static abstract class NestingNode
    extends CoreMethodArrayArgumentsNode {
        public NestingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject nesting() {
            DynamicObject enclosing;
            CompilerDirectives.transferToInterpreter();
            ArrayList<DynamicObject> modules = new ArrayList<DynamicObject>();
            InternalMethod method = RubyCallStack.getCallingMethod(this.getContext());
            DynamicObject object = this.getContext().getCoreLibrary().getObjectClass();
            for (LexicalScope lexicalScope = method == null ? null : method.getSharedMethodInfo().getLexicalScope(); lexicalScope != null && (enclosing = lexicalScope.getLiveModule()) != object; lexicalScope = lexicalScope.getParent()) {
                modules.add(enclosing);
            }
            Object[] objects = modules.toArray(new Object[modules.size()]);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodArrayArgumentsNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object name(DynamicObject module, @Cached(value="createIdentityProfile()") ValueProfile fieldsProfile) {
            ModuleFields fields = fieldsProfile.profile(Layouts.MODULE.getFields(module));
            if (!fields.hasPartialName()) {
                return this.nil();
            }
            return this.createString(StringOperations.encodeByteList(fields.getName(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"module_function"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class ModuleFunctionNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public ModuleFunctionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeGen.create(context, sourceSection, Visibility.MODULE_FUNCTION, null, null);
        }

        @Specialization
        public DynamicObject moduleFunction(VirtualFrame frame, DynamicObject module, Object[] names) {
            if (RubyGuards.isRubyClass(module) && !this.getContext().getCoreLibrary().isLoadingRubyCore()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("module_function must be called for modules", this));
            }
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"method_defined?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class MethodDefinedNode
    extends CoreMethodNode {
        public MethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CreateCast(value={"inherit"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, inherit);
        }

        @Specialization
        public boolean isMethodDefined(DynamicObject module, String name, boolean inherit) {
            CompilerDirectives.transferToInterpreter();
            InternalMethod method = inherit ? ModuleOperations.lookupMethod(module, name) : Layouts.MODULE.getFields(module).getMethods().get(name);
            return method != null && !method.getVisibility().isPrivate();
        }
    }

    @CoreMethod(names={"included_modules"})
    public static abstract class IncludedModulesNode
    extends CoreMethodArrayArgumentsNode {
        public IncludedModulesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject includedModules(DynamicObject module) {
            CompilerDirectives.transferToInterpreter();
            ArrayList<DynamicObject> modules = new ArrayList<DynamicObject>();
            for (DynamicObject included : Layouts.MODULE.getFields(module).ancestors()) {
                if (RubyGuards.isRubyClass(included) || included == module) continue;
                modules.add(included);
            }
            Object[] objects = modules.toArray(new Object[modules.size()]);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"included"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class IncludedNode
    extends CoreMethodArrayArgumentsNode {
        public IncludedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject included(Object subclass) {
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodArrayArgumentsNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isRubyClass(self)", "isRubyModule(from)", "!isRubyClass(from)"})
        public Object initializeCopyModule(DynamicObject self, DynamicObject from) {
            Layouts.MODULE.getFields(self).initCopy(from);
            return this.nil();
        }

        @Specialization(guards={"isRubyClass(self)", "isRubyClass(from)"})
        public Object initializeCopy(DynamicObject self, DynamicObject from) {
            if (from == this.getContext().getCoreLibrary().getBasicObjectClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't copy the root class", this));
            }
            if (Layouts.CLASS.getIsSingleton(from)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't copy singleton class", this));
            }
            Layouts.MODULE.getFields(self).initCopy(from);
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private ClassExecNode classExecNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract DynamicObject executeInitialize(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        void classEval(VirtualFrame frame, DynamicObject module, DynamicObject block) {
            if (this.classExecNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.classExecNode = this.insert(ModuleNodesFactory.ClassExecNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            this.classExecNode.executeClassExec(frame, module, new Object[0], block);
        }

        @Specialization
        public DynamicObject initialize(DynamicObject module, NotProvided block) {
            return module;
        }

        @Specialization
        public DynamicObject initialize(VirtualFrame frame, DynamicObject module, DynamicObject block) {
            this.classEval(frame, module, block);
            return module;
        }
    }

    @CoreMethod(names={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class ExtendObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public ExtendObjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public DynamicObject extendObject(DynamicObject module, DynamicObject object) {
            if (RubyGuards.isRubyClass(module)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorWrongArgumentType(module, "Module", this));
            }
            Layouts.MODULE.getFields(this.singletonClassNode.executeSingletonClass(object)).include(this.getContext(), this, module);
            return module;
        }
    }

    @CoreMethod(names={"define_method"}, needsBlock=true, required=1, optional=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="proc"), @NodeChild(type=RubyNode.class, value="block")})
    public static abstract class DefineMethodNode
    extends CoreMethodNode {
        public DefineMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject defineMethod(DynamicObject module, String name, NotProvided proc, NotProvided block) {
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("needs either proc or block", this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject defineMethodBlock(DynamicObject module, String name, NotProvided proc, DynamicObject block) {
            return this.defineMethodProc(module, name, block, NotProvided.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyProc(proc)"})
        public DynamicObject defineMethodProc(DynamicObject module, String name, DynamicObject proc, NotProvided block) {
            return this.defineMethod(module, name, proc);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyMethod(methodObject)"})
        public DynamicObject defineMethodMethod(DynamicObject module, String name, DynamicObject methodObject, NotProvided block, @Cached(value="createCanBindMethodToModuleNode()") CanBindMethodToModuleNode canBindMethodToModuleNode) {
            InternalMethod method = Layouts.METHOD.getMethod(methodObject);
            if (!canBindMethodToModuleNode.executeCanBindMethodToModule(method, module)) {
                CompilerDirectives.transferToInterpreter();
                DynamicObject declaringModule = method.getDeclaringModule();
                if (RubyGuards.isRubyClass(declaringModule) && Layouts.CLASS.getIsSingleton(declaringModule)) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't bind singleton method to a different class", this));
                }
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("class must be a subclass of " + Layouts.MODULE.getFields(declaringModule).getName(), this));
            }
            Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method.withName(name));
            return this.getSymbol(name);
        }

        @Specialization(guards={"isRubyUnboundMethod(method)"})
        public DynamicObject defineMethod(VirtualFrame frame, DynamicObject module, String name, DynamicObject method, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            DynamicObject origin = Layouts.UNBOUND_METHOD.getOrigin(method);
            if (!ModuleOperations.canBindMethodTo(origin, module)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("bind argument must be a subclass of " + Layouts.MODULE.getFields(origin).getName(), this));
            }
            return this.addMethod(module, name, Layouts.UNBOUND_METHOD.getMethod(method));
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject defineMethod(DynamicObject module, String name, DynamicObject proc) {
            RootCallTarget callTarget = (RootCallTarget)Layouts.PROC.getCallTargetForLambdas(proc);
            RubyRootNode rootNode = (RubyRootNode)callTarget.getRootNode();
            SharedMethodInfo info = Layouts.PROC.getSharedMethodInfo(proc).withName(name);
            RubyNode body = NodeUtil.cloneNode(rootNode.getBody());
            CallMethodWithProcBody newBody = new CallMethodWithProcBody(this.getContext(), info.getSourceSection(), Layouts.PROC.getDeclarationFrame(proc), body);
            RubyRootNode newRootNode = new RubyRootNode(this.getContext(), info.getSourceSection(), rootNode.getFrameDescriptor(), info, newBody);
            RootCallTarget newCallTarget = Truffle.getRuntime().createCallTarget(newRootNode);
            InternalMethod method = new InternalMethod(info, name, module, Visibility.PUBLIC, newCallTarget);
            return this.addMethod(module, name, method);
        }

        private DynamicObject addMethod(DynamicObject module, String name, InternalMethod method) {
            method = method.withName(name);
            if (ModuleOperations.isMethodPrivateFromName(name)) {
                method = method.withVisibility(Visibility.PRIVATE);
            }
            Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method);
            return this.getSymbol(name);
        }

        protected CanBindMethodToModuleNode createCanBindMethodToModuleNode() {
            return CanBindMethodToModuleNodeGen.create(this.getContext(), this.getSourceSection(), null, null);
        }

        private static class CallMethodWithProcBody
        extends RubyNode {
            private final MaterializedFrame declarationFrame;
            @Node.Child
            private RubyNode procBody;

            public CallMethodWithProcBody(RubyContext context, SourceSection sourceSection, MaterializedFrame declarationFrame, RubyNode procBody) {
                super(context, sourceSection);
                this.declarationFrame = declarationFrame;
                this.procBody = procBody;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                RubyArguments.setDeclarationFrame(frame.getArguments(), this.declarationFrame);
                return this.procBody.execute(frame);
            }
        }
    }

    @CoreMethod(names={"const_set"}, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class ConstSetNode
    extends CoreMethodNode {
        public ConstSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public Object setConstant(DynamicObject module, String name, Object value) {
            CompilerDirectives.transferToInterpreter();
            if (!IdUtil.isValidConstantName19((String)name)) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("wrong constant name %s", name), name, this));
            }
            Layouts.MODULE.getFields(module).setConstant(this.getContext(), this, name, value);
            return value;
        }
    }

    @CoreMethod(names={"const_missing"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ConstMissingNode
    extends CoreMethodNode {
        public ConstMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object constMissing(DynamicObject module, String name) {
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, name, this));
        }
    }

    @CoreMethod(names={"const_get"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class ConstGetNode
    extends CoreMethodNode {
        @Node.Child
        private ReadConstantNode readConstantNode;

        public ConstGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.readConstantNode = new ReadConstantNode(context, sourceSection, true, true, null, null);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToSymbolOrString(RubyNode name) {
            return NameToSymbolOrStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CreateCast(value={"inherit"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, inherit);
        }

        @Specialization(guards={"inherit", "isRubySymbol(name)"})
        public Object getConstant(VirtualFrame frame, DynamicObject module, DynamicObject name, boolean inherit) {
            return this.readConstantNode.readConstant(frame, module, Layouts.SYMBOL.getString(name));
        }

        @Specialization(guards={"!inherit", "isRubySymbol(name)"})
        public Object getConstantNoInherit(DynamicObject module, DynamicObject name, boolean inherit) {
            return this.getConstantNoInherit(module, Layouts.SYMBOL.getString(name), this);
        }

        @Specialization(guards={"inherit", "isRubyString(name)", "!isScoped(name)"})
        public Object getConstantString(VirtualFrame frame, DynamicObject module, DynamicObject name, boolean inherit) {
            return this.readConstantNode.readConstant(frame, module, name.toString());
        }

        @Specialization(guards={"!inherit", "isRubyString(name)", "!isScoped(name)"})
        public Object getConstantNoInheritString(DynamicObject module, DynamicObject name, boolean inherit) {
            return this.getConstantNoInherit(module, name.toString(), this);
        }

        @Specialization(guards={"isRubyString(fullName)", "isScoped(fullName)"})
        public Object getConstantScoped(DynamicObject module, DynamicObject fullName, boolean inherit) {
            return this.getConstantScoped(module, fullName.toString(), inherit);
        }

        @CompilerDirectives.TruffleBoundary
        private Object getConstantNoInherit(DynamicObject module, String name, Node currentNode) {
            RubyConstant constant = ModuleOperations.lookupConstantWithInherit(this.getContext(), module, name, false, currentNode);
            if (constant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, name, this));
            }
            return constant.getValue();
        }

        @CompilerDirectives.TruffleBoundary
        private Object getConstantScoped(DynamicObject module, String fullName, boolean inherit) {
            RubyConstant constant = ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this);
            if (constant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, fullName, this));
            }
            return constant.getValue();
        }

        @CompilerDirectives.TruffleBoundary
        boolean isScoped(DynamicObject name) {
            assert (RubyGuards.isRubyString(name));
            return name.toString().contains("::");
        }
    }

    @CoreMethod(names={"const_defined?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class ConstDefinedNode
    extends CoreMethodNode {
        public ConstDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CreateCast(value={"inherit"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, inherit);
        }

        @Specialization
        public boolean isConstDefined(DynamicObject module, String fullName, boolean inherit) {
            CompilerDirectives.transferToInterpreter();
            return ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this) != null;
        }
    }

    @CoreMethod(names={"constants"}, optional=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="inherit")})
    public static abstract class ConstantsNode
    extends CoreMethodNode {
        public ConstantsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"inherit"})
        public RubyNode coerceToBoolean(RubyNode inherit) {
            return BooleanCastWithDefaultNodeGen.create(this.getContext(), this.getSourceSection(), true, inherit);
        }

        @Specialization
        public DynamicObject constants(DynamicObject module, boolean inherit) {
            CompilerDirectives.transferToInterpreter();
            ArrayList<DynamicObject> constantsArray = new ArrayList<DynamicObject>();
            Map<String, RubyConstant> constants = inherit ? ModuleOperations.getAllConstants(module) : Layouts.MODULE.getFields(module).getConstants();
            for (Map.Entry<String, RubyConstant> constant : constants.entrySet()) {
                if (constant.getValue().isPrivate()) continue;
                constantsArray.add(this.getSymbol(constant.getKey()));
            }
            Object[] objects = constantsArray.toArray(new Object[constantsArray.size()]);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"class_variables"})
    public static abstract class ClassVariablesNode
    extends CoreMethodArrayArgumentsNode {
        public ClassVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject getClassVariables(DynamicObject module) {
            CompilerDirectives.transferToInterpreter();
            DynamicObject array = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), null, 0);
            for (String variable : ModuleOperations.getAllClassVariables(module).keySet()) {
                ArrayOperations.append(array, this.getSymbol(variable));
            }
            return array;
        }
    }

    @CoreMethod(names={"class_variable_set"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="value")})
    public static abstract class ClassVariableSetNode
    extends CoreMethodNode {
        public ClassVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object setClassVariable(DynamicObject module, String name, Object value) {
            RubyContext.checkClassVariableName(this.getContext(), name, this);
            ModuleOperations.setClassVariable(this.getContext(), module, name, value, this);
            return value;
        }
    }

    @CoreMethod(names={"class_variable_get"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ClassVariableGetNode
    extends CoreMethodNode {
        public ClassVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object getClassVariable(DynamicObject module, String name) {
            RubyContext.checkClassVariableName(this.getContext(), name, this);
            Object value = ModuleOperations.lookupClassVariable(module, name);
            if (value == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedClassVariable(module, name, this));
            }
            return value;
        }
    }

    @CoreMethod(names={"class_variable_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name")})
    public static abstract class ClassVariableDefinedNode
    extends CoreMethodNode {
        public ClassVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isClassVariableDefinedString(DynamicObject module, String name) {
            RubyContext.checkClassVariableName(this.getContext(), name, this);
            Object value = ModuleOperations.lookupClassVariable(module, name);
            return value != null;
        }
    }

    @CoreMethod(names={"class_exec", "module_exec"}, rest=true, needsBlock=true)
    public static abstract class ClassExecNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public ClassExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context, DeclarationContext.CLASS_EVAL);
        }

        public abstract Object executeClassExec(VirtualFrame var1, DynamicObject var2, Object[] var3, DynamicObject var4);

        @Specialization
        public Object classExec(VirtualFrame frame, DynamicObject self, Object[] args, DynamicObject block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, self, args);
        }

        @Specialization
        public Object classExec(VirtualFrame frame, DynamicObject self, Object[] args, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().noBlockGiven(this));
        }
    }

    @CoreMethod(names={"class_eval", "module_eval"}, optional=3, needsBlock=true)
    public static abstract class ClassEvalNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yield;
        @Node.Child
        private ToStrNode toStrNode;

        public ClassEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context, DeclarationContext.CLASS_EVAL);
        }

        protected DynamicObject toStr(VirtualFrame frame, Object object) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = this.insert(ToStrNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.toStrNode.executeToStr(frame, object);
        }

        @Specialization(guards={"isRubyString(code)"})
        public Object classEval(DynamicObject module, DynamicObject code, NotProvided file, NotProvided line, NotProvided block) {
            return this.classEvalSource(module, code, "(eval)");
        }

        @Specialization(guards={"isRubyString(code)", "isRubyString(file)"})
        public Object classEval(DynamicObject module, DynamicObject code, DynamicObject file, NotProvided line, NotProvided block) {
            return this.classEvalSource(module, code, file.toString());
        }

        @Specialization(guards={"isRubyString(code)", "isRubyString(file)"})
        public Object classEval(DynamicObject module, DynamicObject code, DynamicObject file, int line, NotProvided block) {
            return this.classEvalSource(module, code, file.toString(), line);
        }

        @Specialization(guards={"wasProvided(code)"})
        public Object classEval(VirtualFrame frame, DynamicObject module, Object code, NotProvided file, NotProvided line, NotProvided block) {
            return this.classEvalSource(module, this.toStr(frame, code), file.toString());
        }

        @Specialization(guards={"isRubyString(code)", "wasProvided(file)"})
        public Object classEval(VirtualFrame frame, DynamicObject module, DynamicObject code, Object file, NotProvided line, NotProvided block) {
            return this.classEvalSource(module, code, this.toStr(frame, file).toString());
        }

        private Object classEvalSource(DynamicObject module, DynamicObject code, String file) {
            return this.classEvalSource(module, code, file, 1);
        }

        @CompilerDirectives.TruffleBoundary
        private Object classEvalSource(DynamicObject module, DynamicObject code, String file, int line) {
            assert (RubyGuards.isRubyString(code));
            MaterializedFrame callerFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize();
            Encoding encoding = StringOperations.getByteList(code).getEncoding();
            CompilerDirectives.transferToInterpreter();
            String space = new String(new char[line - 1]).replace("\u0000", "\n");
            Source source = Source.fromText(space + code.toString(), file);
            return this.getContext().parseAndExecute(source, encoding, TranslatorDriver.ParserContext.MODULE, module, callerFrame, true, DeclarationContext.CLASS_EVAL, this);
        }

        @Specialization
        public Object classEval(VirtualFrame frame, DynamicObject self, NotProvided code, NotProvided file, NotProvided line, DynamicObject block) {
            return this.yield.dispatchWithModifiedSelf(frame, block, self, self);
        }

        @Specialization
        public Object classEval(DynamicObject self, NotProvided code, NotProvided file, NotProvided line, NotProvided block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(0, 1, 2, this));
        }

        @Specialization(guards={"wasProvided(code)"})
        public Object classEval(DynamicObject self, Object code, NotProvided file, NotProvided line, DynamicObject block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(1, 0, this));
        }
    }

    @CoreMethod(names={"autoload?"}, required=1)
    public static abstract class AutoloadQueryNode
    extends CoreMethodArrayArgumentsNode {
        public AutoloadQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubySymbol(name)"})
        public Object autoloadQuerySymbol(DynamicObject module, DynamicObject name) {
            return this.autoloadQuery(module, Layouts.SYMBOL.getString(name));
        }

        @Specialization(guards={"isRubyString(name)"})
        public Object autoloadQueryString(DynamicObject module, DynamicObject name) {
            return this.autoloadQuery(module, name.toString());
        }

        private Object autoloadQuery(DynamicObject module, String name) {
            RubyConstant constant = ModuleOperations.lookupConstant(this.getContext(), module, name);
            if (constant == null || !constant.isAutoload()) {
                return this.nil();
            }
            return constant.getValue();
        }
    }

    @CoreMethod(names={"autoload"}, required=2)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="name"), @NodeChild(type=RubyNode.class, value="filename")})
    public static abstract class AutoloadNode
    extends CoreMethodNode {
        @Node.Child
        private StringNodes.EmptyNode emptyNode;
        private final ConditionProfile invalidConstantName = ConditionProfile.createBinaryProfile();
        private final ConditionProfile emptyFilename = ConditionProfile.createBinaryProfile();
        private final ConditionProfile alreadyLoaded = ConditionProfile.createBinaryProfile();

        public AutoloadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.emptyNode = StringNodesFactory.EmptyNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceNameToString(RubyNode name) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), name);
        }

        @CreateCast(value={"filename"})
        public RubyNode coerceFilenameToPath(RubyNode filename) {
            return ToPathNodeGen.create(this.getContext(), this.getSourceSection(), filename);
        }

        @Specialization(guards={"isRubyString(filename)"})
        public DynamicObject autoload(DynamicObject module, String name, DynamicObject filename) {
            if (this.invalidConstantName.profile(!IdUtil.isValidConstantName19((String)name))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("autoload must be constant name: %s", name), name, this));
            }
            if (this.emptyFilename.profile(this.emptyNode.empty(filename))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("empty file name", this));
            }
            if (this.alreadyLoaded.profile(Layouts.MODULE.getFields(module).getConstants().get(name) != null)) {
                return this.nil();
            }
            Layouts.MODULE.getFields(module).setAutoloadConstant(this.getContext(), this, name, filename);
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_writer"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrWriterNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrWriterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public DynamicObject attrWriter(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_reader"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrReaderNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;

        public AttrReaderNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
        }

        @Specialization
        public DynamicObject attrReader(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_accessor"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrAccessorNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrAccessorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public DynamicObject attrAccessor(VirtualFrame frame, DynamicObject module, Object[] names) {
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"attr"}, rest=true, visibility=Visibility.PRIVATE)
    public static abstract class AttrNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        GenerateAccessorNode generateGetterNode;
        @Node.Child
        GenerateAccessorNode generateSetterNode;

        public AttrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.generateGetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, true, null, null);
            this.generateSetterNode = ModuleNodesFactory.GenerateAccessorNodeGen.create(context, sourceSection, false, null, null);
        }

        @Specialization
        public DynamicObject attr(VirtualFrame frame, DynamicObject module, Object[] names) {
            boolean setter;
            if (names.length == 2 && names[1] instanceof Boolean) {
                setter = (Boolean)names[1];
                names = new Object[]{names[0]};
            } else {
                setter = false;
            }
            for (Object name : names) {
                this.generateGetterNode.executeGenerateAccessor(frame, module, name);
                if (!setter) continue;
                this.generateSetterNode.executeGenerateAccessor(frame, module, name);
            }
            return this.nil();
        }
    }

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class GenerateAccessorNode
    extends RubyNode {
        final boolean isGetter;
        @Node.Child
        NameToJavaStringNode nameToJavaStringNode;

        public GenerateAccessorNode(RubyContext context, SourceSection sourceSection, boolean isGetter) {
            super(context, sourceSection);
            this.isGetter = isGetter;
            this.nameToJavaStringNode = NameToJavaStringNodeGen.create(context, sourceSection, null);
        }

        public abstract DynamicObject executeGenerateAccessor(VirtualFrame var1, DynamicObject var2, Object var3);

        @Specialization
        public DynamicObject generateAccessor(VirtualFrame frame, DynamicObject module, Object nameObject) {
            RubyNode accessInstanceVariable;
            String name = this.nameToJavaStringNode.executeToJavaString(frame, nameObject);
            CompilerDirectives.transferToInterpreter();
            FrameInstance callerFrame = RubyCallStack.getCallerFrame(this.getContext());
            SourceSection sourceSection = callerFrame.getCallNode().getEncapsulatingSourceSection();
            Visibility visibility = DeclarationContext.findVisibility(callerFrame.getFrame(FrameInstance.FrameAccess.READ_ONLY, true));
            Arity arity = this.isGetter ? Arity.NO_ARGUMENTS : Arity.ONE_REQUIRED;
            String ivar = "@" + name;
            String accessorName = this.isGetter ? name : name + "=";
            String indicativeName = name + "(attr_" + (this.isGetter ? "reader" : "writer") + ")";
            RubyNode checkArity = CheckArityNode.create(this.getContext(), sourceSection, arity);
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, LexicalScope.NONE, arity, indicativeName, false, null, false, false, false);
            SelfNode self = new SelfNode(this.getContext(), sourceSection);
            if (this.isGetter) {
                accessInstanceVariable = new ReadInstanceVariableNode(this.getContext(), sourceSection, ivar, self, false);
            } else {
                ReadPreArgumentNode readArgument = new ReadPreArgumentNode(this.getContext(), sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
                accessInstanceVariable = new WriteInstanceVariableNode(this.getContext(), sourceSection, ivar, self, readArgument, false);
            }
            RubyNode sequence = SequenceNode.sequence(this.getContext(), sourceSection, checkArity, accessInstanceVariable);
            RubyRootNode rootNode = new RubyRootNode(this.getContext(), sourceSection, null, sharedMethodInfo, sequence);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
            InternalMethod method = new InternalMethod(sharedMethodInfo, accessorName, module, visibility, callTarget);
            Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method);
            return this.nil();
        }
    }

    @CoreMethod(names={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class AppendFeaturesNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        TaintResultNode taintResultNode;

        public AppendFeaturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @Specialization(guards={"isRubyModule(target)"})
        public DynamicObject appendFeatures(DynamicObject features, DynamicObject target) {
            if (RubyGuards.isRubyClass(features)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("append_features must be called only on modules", this));
            }
            Layouts.MODULE.getFields(target).include(this.getContext(), this, features);
            this.taintResultNode.maybeTaint(features, target);
            return this.nil();
        }
    }

    @CoreMethod(names={"ancestors"})
    public static abstract class AncestorsNode
    extends CoreMethodArrayArgumentsNode {
        public AncestorsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject ancestors(DynamicObject self) {
            CompilerDirectives.transferToInterpreter();
            ArrayList<DynamicObject> ancestors = new ArrayList<DynamicObject>();
            for (DynamicObject module : Layouts.MODULE.getFields(self).ancestors()) {
                ancestors.add(module);
            }
            Object[] objects = ancestors.toArray(new Object[ancestors.size()]);
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"alias_method"}, required=2, raiseIfFrozenSelf=true, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(type=RubyNode.class, value="module"), @NodeChild(type=RubyNode.class, value="newName"), @NodeChild(type=RubyNode.class, value="oldName")})
    public static abstract class AliasMethodNode
    extends CoreMethodNode {
        public AliasMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CreateCast(value={"newName"})
        public RubyNode coercetNewNameToString(RubyNode newName) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), newName);
        }

        @CreateCast(value={"oldName"})
        public RubyNode coerceOldNameToString(RubyNode oldName) {
            return NameToJavaStringNodeGen.create(this.getContext(), this.getSourceSection(), oldName);
        }

        @Specialization
        public DynamicObject aliasMethod(DynamicObject module, String newName, String oldName) {
            Layouts.MODULE.getFields(module).alias(this.getContext(), this, newName, oldName);
            return module;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private IsSubclassOfOrEqualToNode subclassNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        private Object isSubclass(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            if (this.subclassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.subclassNode = this.insert(ModuleNodesFactory.IsSubclassOfOrEqualToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.subclassNode.executeIsSubclassOfOrEqualTo(frame, self, other);
        }

        private boolean booleanCast(VirtualFrame frame, Object value) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = this.insert(BooleanCastNodeGen.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.booleanCastNode.executeBoolean(frame, value);
        }

        @Specialization(guards={"isRubyModule(other)"})
        public Object compare(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other) {
                return 0;
            }
            Object isSubclass = this.isSubclass(frame, self, other);
            if (isSubclass == this.nil()) {
                return this.nil();
            }
            if (this.booleanCast(frame, isSubclass)) {
                return -1;
            }
            return 1;
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object compareOther(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            return this.nil();
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class IsSuperclassOfOrEqualToNode
    extends CoreMethodArrayArgumentsNode {
        public IsSuperclassOfOrEqualToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeIsSuperclassOfOrEqualTo(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        @Specialization(guards={"isRubyModule(other)"})
        public Object isSuperclassOfOrEqualTo(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other || ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return this.nil();
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object isSuperclassOfOrEqualToOther(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class IsSuperclassOfNode
    extends CoreMethodArrayArgumentsNode {
        public IsSuperclassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeIsSuperclassOf(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        @Specialization(guards={"isRubyModule(other)"})
        public Object isSuperclassOf(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return this.nil();
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object isSuperclassOfOther(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class IsSubclassOfOrEqualToNode
    extends CoreMethodArrayArgumentsNode {
        public IsSubclassOfOrEqualToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeIsSubclassOfOrEqualTo(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        @Specialization(guards={"isRubyModule(other)"})
        public Object isSubclassOfOrEqualTo(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other || ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return this.nil();
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object isSubclassOfOrEqualToOther(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class IsSubclassOfNode
    extends CoreMethodArrayArgumentsNode {
        public IsSubclassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object executeIsSubclassOf(VirtualFrame var1, DynamicObject var2, DynamicObject var3);

        @Specialization(guards={"isRubyModule(other)"})
        public Object isSubclassOf(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return this.nil();
        }

        @Specialization(guards={"!isRubyModule(other)"})
        public Object isSubclassOfOther(VirtualFrame frame, DynamicObject self, DynamicObject other) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class ContainsInstanceNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public ContainsInstanceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeGen.create(context, sourceSection, null);
        }

        @Specialization
        public boolean containsInstance(DynamicObject module, DynamicObject instance) {
            return this.includes(Layouts.BASIC_OBJECT.getMetaClass(instance), module);
        }

        @Specialization(guards={"!isDynamicObject(instance)"})
        public boolean containsInstance(VirtualFrame frame, DynamicObject module, Object instance) {
            return this.includes(this.metaClassNode.executeMetaClass(frame, instance), module);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean includes(DynamicObject metaClass, DynamicObject module) {
            assert (RubyGuards.isRubyModule(metaClass));
            assert (RubyGuards.isRubyModule(module));
            return ModuleOperations.includesModule(metaClass, module);
        }
    }
}

