/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core.hash;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;

public class HashNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode hashNode;
    private final ConditionProfile isIntegerProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isLongProfile = ConditionProfile.createBinaryProfile();

    public HashNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.hashNode = DispatchHeadNodeFactory.createMethodCall(context, true);
    }

    public int hash(VirtualFrame frame, Object key) {
        Object hashedObject = this.hashNode.call(frame, key, "hash", null, new Object[0]);
        if (this.isIntegerProfile.profile(hashedObject instanceof Integer)) {
            return (Integer)hashedObject;
        }
        if (this.isLongProfile.profile(hashedObject instanceof Long)) {
            return (int)((Long)hashedObject).longValue();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        throw new UnsupportedOperationException();
    }
}

