// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var checkers;

  exports.checkers = checkers = {
    username: {
      hint: "between 2 and 16 letters long",
      f: function(x) {
        return x.length >= 2 && x.length <= 16;
      }
    },
    remote_username: {
      hint: "between 1 and 40 letters long",
      f: function(x) {
        return x.length >= 1 && x.length <= 40;
      }
    },
    passphrase: {
      hint: "must be at least 12 letters long",
      f: function(x) {
        return x.length >= 12;
      }
    },
    passphrase_short: {
      hint: "password cannot be empty",
      f: function(x) {
        return x.length >= 1;
      }
    },
    passphrase_nls: {
      hint: "must be at least 12 letters long and can't have a leading space",
      f: function(x) {
        return x.length >= 12 && !(x.match(/^\s/));
      }
    },
    email: {
      hint: "must be a valid email address",
      f: function(x) {
        return (x.length > 3) && x.match(/^\S+@\S+\.\S+$/);
      }
    },
    invite_code: {
      hint: "invite codes are 24 digits long",
      f: function(x) {
        return x.length === 24;
      }
    },
    email_or_username: {
      hint: "valid usernames are 4-12 letters long"
    },
    intcheck: function(lo, hi, defint) {
      return {
        hint: "" + lo + "-" + hi,
        f: function(x) {
          var i;
          if ((defint != null) && x === "") {
            return true;
          } else {
            return !(isNaN(i = parseInt(x))) && i >= lo && i <= hi;
          }
        }
      };
    }
  };

  checkers.email_or_username.f = function(x) {
    return checkers.email.f(x) || checkers.username.f(x);
  };

}).call(this);
