/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.views.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.border.AbstractBorder;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.views.AnnotationComponent;
import org.icepdf.core.views.swing.AnnotationComponentImpl;

public class ResizableBorder
extends AbstractBorder {
    private static final Logger logger;
    private static Color selectColor;
    private static Color outlineColor;
    private static final int[] locations;
    private static final int[] cursors;
    protected int resizeWidgetDim;

    public ResizableBorder(int resizeBoxSize) {
        this.resizeWidgetDim = resizeBoxSize;
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(10, 10, 10, 10);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics g, int x, int y, int w, int h) {
        boolean isSelected = false;
        boolean isEditable = false;
        boolean isRollover = false;
        boolean isLinkAnnot = false;
        boolean isBorderStyle = false;
        if (component instanceof AnnotationComponent) {
            AnnotationComponent annot = (AnnotationComponent)((Object)component);
            isEditable = annot.isEditable();
            isRollover = annot.isRollover();
            isLinkAnnot = annot.isLinkAnnot();
            isBorderStyle = annot.isBorderStyle();
            isSelected = annot.isSelected();
        }
        if (!isEditable) {
            return;
        }
        if (isSelected || component.hasFocus() || isRollover) {
            g.setColor(selectColor);
        } else {
            g.setColor(outlineColor);
        }
        if (isSelected || isRollover || isLinkAnnot && !isBorderStyle) {
            g.drawRect(x, y, w - 1, h - 1);
        }
        if ((isSelected || isRollover) && isLinkAnnot) {
            for (int location : locations) {
                Rectangle rect = this.getRectangle(x, y, w, h, location);
                g.fillRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
                g.drawRect(rect.x, rect.y, rect.width - 1, rect.height - 1);
            }
        }
    }

    private Rectangle getRectangle(int x, int y, int w, int h, int location) {
        switch (location) {
            case 1: {
                return new Rectangle(x + w / 2 - this.resizeWidgetDim / 2, y, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 5: {
                return new Rectangle(x + w / 2 - this.resizeWidgetDim / 2, y + h - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 7: {
                return new Rectangle(x, y + h / 2 - this.resizeWidgetDim / 2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 3: {
                return new Rectangle(x + w - this.resizeWidgetDim, y + h / 2 - this.resizeWidgetDim / 2, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 8: {
                return new Rectangle(x, y, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 2: {
                return new Rectangle(x + w - this.resizeWidgetDim, y, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 6: {
                return new Rectangle(x, y + h - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
            case 4: {
                return new Rectangle(x + w - this.resizeWidgetDim, y + h - this.resizeWidgetDim, this.resizeWidgetDim, this.resizeWidgetDim);
            }
        }
        return null;
    }

    public int getCursor(MouseEvent me) {
        Component c = me.getComponent();
        boolean isEditable = false;
        boolean isLinkAnnot = false;
        if (c instanceof AnnotationComponentImpl) {
            AnnotationComponentImpl annot = (AnnotationComponentImpl)c;
            isEditable = annot.isEditable();
            isLinkAnnot = annot.isLinkAnnot();
        }
        int w = c.getWidth();
        int h = c.getHeight();
        if (isEditable && isLinkAnnot) {
            for (int i = 0; i < locations.length; ++i) {
                Rectangle rect = this.getRectangle(0, 0, w, h, locations[i]);
                if (!rect.contains(me.getPoint())) continue;
                return cursors[i];
            }
        }
        return 13;
    }

    static {
        block2: {
            logger = Logger.getLogger(ResizableBorder.class.toString());
            try {
                String color = Defs.sysProperty("org.icepdf.core.views.page.annotation.select.color", "#0000FF");
                int colorValue = ColorUtil.convertColor(color);
                selectColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("0000FF", 16));
                color = Defs.sysProperty("org.icepdf.core.views.page.annotation.outline.color", "#000000");
                colorValue = ColorUtil.convertColor(color);
                outlineColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("000000", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading page annotation outline colour");
            }
        }
        locations = new int[]{1, 5, 7, 3, 8, 2, 6, 4};
        cursors = new int[]{8, 9, 10, 11, 6, 7, 4, 5};
    }
}

