/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.commons.business;

import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class SoundPlayer {
    private static final Logger log = Logger.getLogger(SoundPlayer.class.getPackage().getName());
    private static final String SOUND = "/resources/sounds/ok_sound.wav";
    private static final String ERROR_SOUND = "/resources/sounds/error_sound.wav";
    private static SoundPlayer player = null;
    private Clip errorClip;
    private Clip soundClip;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    private SoundPlayer() {
    }

    public static synchronized SoundPlayer getInstance() {
        if (player == null) {
            player = new SoundPlayer();
        }
        return player;
    }

    public void playErrorSound() {
        if (Configuration.getInstance().isPlaySounds()) {
            try {
                if (this.errorClip == null) {
                    AudioInputStream sound = AudioSystem.getAudioInputStream(this.getClass().getResource(ERROR_SOUND));
                    DataLine.Info info = new DataLine.Info(Clip.class, sound.getFormat());
                    this.errorClip = (Clip)AudioSystem.getLine(info);
                    this.errorClip.open(sound);
                }
                this.executor.execute(new PlayThread(this.errorClip));
            }
            catch (Exception e) {
                log.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error playing sound") + ": " + e.getMessage());
            }
        }
    }

    public void playSound() {
        if (Configuration.getInstance().isPlaySounds()) {
            try {
                if (this.soundClip == null) {
                    AudioInputStream sound = AudioSystem.getAudioInputStream(this.getClass().getResource(SOUND));
                    DataLine.Info info = new DataLine.Info(Clip.class, sound.getFormat());
                    this.soundClip = (Clip)AudioSystem.getLine(info);
                    this.soundClip.open(sound);
                }
                this.executor.execute(new PlayThread(this.soundClip));
            }
            catch (Exception e) {
                log.warn(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error playing sound") + ": " + e.getMessage());
            }
        }
    }

    private class PlayThread
    extends Thread {
        private Clip clip;

        public PlayThread(Clip clip) {
            this.clip = clip;
        }

        @Override
        public void run() {
            try {
                this.clip.setFramePosition(0);
                this.clip.stop();
                this.clip.start();
            }
            catch (Exception e) {
                log.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error playing sound"), e);
            }
        }
    }
}

