/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.dto.commands;

import java.io.File;
import org.pdfsam.console.business.dto.PageLabel;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class PageLabelsParsedCommand
extends AbstractParsedCommand {
    private static final long serialVersionUID = -906202390144413350L;
    public static final String F_ARG = "f";
    public static final String O_ARG = "o";
    public static final String L_ARG = "l";
    public static final String LP_ARG = "lp";
    private File outputFile;
    private PdfFile inputFile;
    private PageLabel[] labels = null;

    public PageLabelsParsedCommand() {
    }

    public PageLabelsParsedCommand(PdfFile inputFile, File outputFile, PageLabel[] labels) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.labels = labels;
    }

    public PageLabelsParsedCommand(PdfFile inputFile, File outputFile, PageLabel[] labels, boolean overwrite, boolean compress, char outputPdfVersion) {
        super(overwrite, compress, outputPdfVersion);
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.labels = labels;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public PdfFile getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(PdfFile inputFile) {
        this.inputFile = inputFile;
    }

    public PageLabel[] getLabels() {
        return this.labels;
    }

    public void setLabels(PageLabel[] labels) {
        this.labels = labels;
    }

    public String getCommand() {
        return "pagelabels";
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(super.toString());
        retVal.append(this.inputFile == null ? "" : "[inputFile=" + this.inputFile + "]");
        retVal.append(this.outputFile == null ? "" : "[outputDir=" + this.outputFile.getAbsolutePath() + "]");
        if (this.labels != null) {
            for (int i = 0; i < this.labels.length; ++i) {
                retVal.append(this.labels[i] == null ? "" : "[inputFileList[" + i + "]=" + this.labels[i] + "]");
            }
        }
        retVal.append("[command=" + this.getCommand() + "]");
        return retVal.toString();
    }
}

