/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TextStyle
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String fontName;
    private final float fontSize;
    private final boolean bold;
    private final boolean italic;
    private static final List<WeakReference<TextStyle>> textStylesCache = new ArrayList<WeakReference<TextStyle>>();

    public TextStyle(float f) {
        this(f, false, false);
    }

    public TextStyle(float f, boolean bl, boolean bl2) {
        this(null, f, bl, bl2);
    }

    public TextStyle(String string, float f, boolean bl, boolean bl2) {
        this(string, f, bl, bl2, true);
    }

    private TextStyle(String string, float f, boolean bl, boolean bl2, boolean bl3) {
        this.fontName = string;
        this.fontSize = f;
        this.bold = bl;
        this.italic = bl2;
        if (bl3) {
            textStylesCache.add(new WeakReference<TextStyle>(this));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        textStylesCache.add(new WeakReference<TextStyle>(this));
    }

    private TextStyle getInstance(String string, float f, boolean bl, boolean bl2) {
        TextStyle textStyle = new TextStyle(string, f, bl, bl2, false);
        Iterator<WeakReference<TextStyle>> iterator = textStylesCache.iterator();
        while (iterator.hasNext()) {
            WeakReference<TextStyle> weakReference = iterator.next();
            TextStyle textStyle2 = (TextStyle)weakReference.get();
            if (textStyle2 == null) {
                iterator.remove();
                continue;
            }
            if (!textStyle2.equals(textStyle)) continue;
            return textStyle;
        }
        textStylesCache.add(new WeakReference<TextStyle>(textStyle));
        return textStyle;
    }

    public String getFontName() {
        return this.fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public TextStyle deriveStyle(String string) {
        if (this.getFontName() == string || string != null && string.equals(this.getFontName())) {
            return this;
        }
        return this.getInstance(string, this.getFontSize(), this.isBold(), this.isItalic());
    }

    public TextStyle deriveStyle(float f) {
        if (this.getFontSize() == f) {
            return this;
        }
        return this.getInstance(this.getFontName(), f, this.isBold(), this.isItalic());
    }

    public TextStyle deriveBoldStyle(boolean bl) {
        if (this.isBold() == bl) {
            return this;
        }
        return this.getInstance(this.getFontName(), this.getFontSize(), bl, this.isItalic());
    }

    public TextStyle deriveItalicStyle(boolean bl) {
        if (this.isItalic() == bl) {
            return this;
        }
        return this.getInstance(this.getFontName(), this.getFontSize(), this.isBold(), bl);
    }

    public boolean equals(Object object) {
        if (object instanceof TextStyle) {
            TextStyle textStyle = (TextStyle)object;
            return (textStyle.fontName == this.fontName || textStyle.fontName != null && textStyle.fontName.equals(this.fontName)) && textStyle.fontSize == this.fontSize && textStyle.bold == this.bold && textStyle.italic == this.italic;
        }
        return false;
    }

    public int hashCode() {
        int n = Float.floatToIntBits(this.fontSize);
        if (this.fontName != null) {
            n += this.fontName.hashCode();
        }
        if (this.bold) {
            ++n;
        }
        if (this.italic) {
            ++n;
        }
        return n;
    }
}

