/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control;

import java.util.ArrayList;
import java.util.List;

public class Matrix<T> {
    private List<List<T>> matrix = new ArrayList<List<T>>();

    public int rows() {
        return this.matrix.size();
    }

    public int cols() {
        int n = 0;
        for (List<T> list : this.matrix) {
            if (list.size() <= n) continue;
            n = list.size();
        }
        return n;
    }

    public List<T> row(int n) {
        return this.matrix.get(n);
    }

    public List<T> col(int n) {
        ArrayList<T> arrayList = new ArrayList<T>(this.cols());
        for (List<T> list : this.matrix) {
            if (n < list.size()) {
                arrayList.add(list.get(n));
                continue;
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public T cell(int n, int n2) {
        return this.row(n).get(n2);
    }

    public boolean hasMoreRowsThanCols() {
        return this.rows() > this.cols();
    }

    public void invert() {
        ArrayList<List<T>> arrayList = new ArrayList<List<T>>(this.cols());
        for (int i = 0; i < this.cols(); ++i) {
            arrayList.add(this.col(i));
        }
        this.matrix = arrayList;
    }

    public void addLine(List<T> list) {
        this.matrix.add(list);
    }

    public boolean isEmpty() {
        for (List<T> list : this.matrix) {
            if (list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("");
        for (List<T> list : this.matrix) {
            for (T t : list) {
                stringBuilder.append(t != null ? t : "null").append("\t");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

