/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.facet.specific;

import com.baselet.control.basics.XValues;
import com.baselet.control.basics.geom.Dimension;
import com.baselet.control.basics.geom.PointDouble;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.diagram.draw.DrawHandler;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.facet.KeyValueFacet;
import com.baselet.element.facet.PropertiesParserState;
import java.util.List;

public class SpecialStateTypeFacet
extends KeyValueFacet {
    public static final SpecialStateTypeFacet INSTANCE = new SpecialStateTypeFacet();

    private SpecialStateTypeFacet() {
    }

    @Override
    public KeyValueFacet.KeyValue getKeyValue() {
        return new KeyValueFacet.KeyValue("type", new KeyValueFacet.ValueInfo((Object)StateTypeEnum.INITIAL, "an initial state"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.FINAL, "a final state for the activity"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.FLOW_FINAL, "a final state for a flow"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.HISTORY_SHALLOW, "a shallow history state"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.HISTORY_DEEP, "a deep history state"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.TERMINATION, "a termination state"), new KeyValueFacet.ValueInfo((Object)StateTypeEnum.DECISION, "a decision"));
    }

    @Override
    public void handleValue(String string, PropertiesParserState propertiesParserState) {
        DrawHandler drawHandler = propertiesParserState.getDrawer();
        StateTypeEnum stateTypeEnum = StateTypeEnum.valueOf(string.toUpperCase());
        Dimension dimension = propertiesParserState.getGridElementSize();
        double d = this.getWidth(dimension);
        double d2 = this.getHeight(dimension);
        if (stateTypeEnum == StateTypeEnum.INITIAL) {
            this.drawBlackEllipse(drawHandler, d - 1.0, d2 - 1.0, 1.0);
        } else if (stateTypeEnum == StateTypeEnum.FINAL) {
            drawHandler.drawEllipse(0.0, 0.0, d, d2);
            ColorOwn colorOwn = drawHandler.getForegroundColor();
            drawHandler.setForegroundColor(ColorOwn.TRANSPARENT);
            double d3 = Math.max(d - 1.0, d2 - 1.0) / 5.5;
            this.drawBlackEllipse(drawHandler, d - d3 * 2.0, d2 - d3 * 2.0, d3);
            drawHandler.setForegroundColor(colorOwn);
        } else if (stateTypeEnum == StateTypeEnum.FLOW_FINAL) {
            drawHandler.drawEllipse(0.0, 0.0, d, d2);
            double d4 = d2 / 6.0;
            double d5 = d2 - d4;
            XValues xValues = XValues.createForEllipse(d4, d2, d);
            XValues xValues2 = XValues.createForEllipse(d5, d2, d);
            drawHandler.drawLine(xValues.getLeft(), d4, xValues2.getRight(), d5);
            drawHandler.drawLine(xValues2.getLeft(), d5, xValues.getRight(), d4);
        } else if (stateTypeEnum == StateTypeEnum.HISTORY_SHALLOW || stateTypeEnum == StateTypeEnum.HISTORY_DEEP) {
            String string2 = stateTypeEnum == StateTypeEnum.HISTORY_SHALLOW ? "*H*" : "*H**";
            drawHandler.drawEllipse(0.0, 0.0, d, d2);
            double d6 = (d - drawHandler.textWidth(string2)) / 2.0;
            double d7 = (d2 + drawHandler.textHeight(string2)) / 2.0;
            drawHandler.print(string2, new PointDouble(d6, d7), AlignHorizontal.LEFT);
        } else if (stateTypeEnum == StateTypeEnum.TERMINATION) {
            drawHandler.drawLine(0.0, 0.0, d, d2);
            drawHandler.drawLine(d, 0.0, 0.0, d2);
        } else if (stateTypeEnum == StateTypeEnum.DECISION) {
            this.drawDecision(drawHandler, d, d2);
        }
    }

    private void drawDecision(DrawHandler drawHandler, double d, double d2) {
        drawHandler.drawLines(new PointDouble(0.5 + d / 2.0, 1.0), new PointDouble(d, 0.5 + d2 / 2.0), new PointDouble(0.5 + d / 2.0, d2), new PointDouble(1.0, 0.5 + d2 / 2.0), new PointDouble(0.5 + d / 2.0, 1.0));
    }

    private void drawBlackEllipse(DrawHandler drawHandler, double d, double d2, double d3) {
        ColorOwn colorOwn = drawHandler.getBackgroundColor();
        if (drawHandler.getBackgroundColor() == ColorOwn.DEFAULT_BACKGROUND) {
            drawHandler.setBackgroundColor(ColorOwn.BLACK.transparency(ColorOwn.Transparency.FOREGROUND));
        } else {
            drawHandler.setBackgroundColor(drawHandler.getBackgroundColor().transparency(ColorOwn.Transparency.FOREGROUND));
        }
        drawHandler.drawEllipse(d3, d3, d, d2);
        drawHandler.setBackgroundColor(colorOwn);
    }

    @Override
    public void parsingFinished(PropertiesParserState propertiesParserState, List<String> list) {
        if (list.isEmpty()) {
            Dimension dimension = propertiesParserState.getGridElementSize();
            this.drawDecision(propertiesParserState.getDrawer(), this.getWidth(dimension), this.getHeight(dimension));
        }
    }

    private int getHeight(Dimension dimension) {
        return dimension.getHeight() - 1;
    }

    private int getWidth(Dimension dimension) {
        return dimension.getWidth() - 1;
    }

    private static enum StateTypeEnum {
        INITIAL,
        FINAL,
        FLOW_FINAL,
        TERMINATION,
        DECISION,
        HISTORY_SHALLOW,
        HISTORY_DEEP;

    }
}

