/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.generator;

import com.baselet.control.basics.geom.Rectangle;
import com.baselet.control.config.ConfigClassGen;
import com.baselet.control.enums.ElementId;
import com.baselet.control.enums.generator.FieldOptions;
import com.baselet.control.enums.generator.MethodOptions;
import com.baselet.control.enums.generator.SignatureOptions;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.DiagramHandler;
import com.baselet.diagram.FontHandler;
import com.baselet.element.ElementFactorySwing;
import com.baselet.element.NewGridElement;
import com.baselet.element.interfaces.GridElement;
import com.baselet.generator.java.Accessible;
import com.baselet.generator.java.Field;
import com.baselet.generator.java.JavaClass;
import com.baselet.generator.java.Method;
import com.baselet.generator.java.bcel.BcelJavaClass;
import com.baselet.generator.java.jp.ClassParserException;
import com.baselet.generator.java.jp.JpJavaClass;
import com.baselet.generator.sorting.AlphabetLayout;
import com.baselet.generator.sorting.HeightLayout;
import com.baselet.generator.sorting.PackageLayout;
import com.baselet.generator.sorting.RelationLayout;
import com.baselet.generator.sorting.SortableElement;
import com.baselet.gui.command.AddElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ClassDiagramConverter {
    private final int GRIDSIZE = CurrentDiagram.getInstance().getDiagramHandler().getGridSize();

    public void createClassDiagram(String filename) {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add(filename);
        this.createClassDiagrams(fileNames);
    }

    public void createClassDiagrams(List<String> filesToOpen) {
        ArrayList<SortableElement> elements = new ArrayList<SortableElement>();
        for (String filename : filesToOpen) {
            SortableElement element = this.createElement(filename);
            if (element == null) continue;
            elements.add(element);
        }
        switch (ConfigClassGen.getInstance().getGenerateClassSortings()) {
            case PACKAGE: {
                new PackageLayout().layout(elements);
                break;
            }
            case ALPHABET: {
                new AlphabetLayout().layout(elements);
                break;
            }
            case RELATIONS: {
                new RelationLayout().layout(elements);
                break;
            }
            default: {
                new HeightLayout().layout(elements);
            }
        }
        this.addElementsToDiagram(elements);
    }

    private SortableElement createElement(String filename) {
        JavaClass parsedClass = this.parseFile(filename);
        if (parsedClass == null) {
            return null;
        }
        String propertiesText = this.getElementProperties(parsedClass);
        List<String> propList = Arrays.asList(propertiesText.split("\n"));
        Rectangle initialSize = this.adjustSize(propList);
        NewGridElement clazz = ElementFactorySwing.create(ElementId.UMLClass, initialSize, propertiesText, null, CurrentDiagram.getInstance().getDiagramHandler());
        return new SortableElement((GridElement)clazz, parsedClass);
    }

    private void addElementsToDiagram(List<SortableElement> elements) {
        DiagramHandler handler = CurrentDiagram.getInstance().getDiagramHandler();
        for (SortableElement e : elements) {
            new AddElement(e.getElement(), handler.realignToGrid(e.getElement().getRectangle().x), handler.realignToGrid(e.getElement().getRectangle().y), false).execute(handler);
        }
        handler.setChanged(true);
    }

    private Rectangle adjustSize(List<String> strings) {
        FontHandler fontHandler = CurrentDiagram.getInstance().getDiagramHandler().getFontHandler();
        int width = 0;
        int height = strings.size();
        double heightTweaker = 0.1;
        for (String string : strings) {
            if (string.isEmpty()) {
                heightTweaker += 1.0;
            } else if (string.equals("--")) {
                heightTweaker += 0.5;
            }
            if (!(fontHandler.getTextWidth(string) > (double)width)) continue;
            width = (int)(fontHandler.getTextWidth(string) + fontHandler.getDistanceBetweenTexts()) + 10;
        }
        height = (int)(fontHandler.getFontSize() + fontHandler.getDistanceBetweenTexts()) * (height - (int)heightTweaker);
        return new Rectangle(0, 0, this.align(width), this.align(height));
    }

    private int align(int n) {
        return n - n % this.GRIDSIZE + this.GRIDSIZE;
    }

    private String getElementProperties(JavaClass parsedClass) {
        StringBuilder sb = new StringBuilder("");
        this.createTopSection(parsedClass, sb);
        sb.append("--\n");
        this.createFieldSection(parsedClass, sb);
        sb.append("--\n");
        this.createMethodSection(parsedClass, sb);
        sb.append("--\n");
        return sb.toString();
    }

    private void createMethodSection(JavaClass parsedClass, StringBuilder sb) {
        Method[] methodArray = parsedClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (ConfigClassGen.getInstance().getGenerateClassMethods() == MethodOptions.PUBLIC && method.getAccess() == Accessible.AccessFlag.PUBLIC) {
                sb.append(this.getMethodString(method));
            } else if (ConfigClassGen.getInstance().getGenerateClassMethods() == MethodOptions.ALL) {
                sb.append(this.getMethodString(method));
            }
            ++n2;
        }
    }

    private String getMethodString(Method method) {
        if (ConfigClassGen.getInstance().getGenerateClassSignatures() == SignatureOptions.PARAMS_ONLY) {
            return (Object)((Object)method.getAccess()) + method.getName() + "(" + method.getSignature() + ")\n";
        }
        if (ConfigClassGen.getInstance().getGenerateClassSignatures() == SignatureOptions.RETURN_ONLY) {
            return (Object)((Object)method.getAccess()) + method.getName() + ": " + method.getReturnType() + "\n";
        }
        return (Object)((Object)method.getAccess()) + method.getName() + "(" + method.getSignature() + "): " + method.getReturnType() + "\n";
    }

    private void createFieldSection(JavaClass parsedClass, StringBuilder sb) {
        Field[] fieldArray = parsedClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (ConfigClassGen.getInstance().getGenerateClassFields() == FieldOptions.PUBLIC && field.getAccess() == Accessible.AccessFlag.PUBLIC) {
                sb.append((Object)field.getAccess()).append(field.getName()).append(": ").append(field.getType()).append("\n");
            } else if (ConfigClassGen.getInstance().getGenerateClassFields() == FieldOptions.ALL) {
                sb.append((Object)field.getAccess()).append(field.getName()).append(": ").append(field.getType()).append("\n");
            }
            ++n2;
        }
    }

    private void createTopSection(JavaClass parsedClass, StringBuilder sb) {
        JavaClass.ClassRole role = parsedClass.getRole();
        if (role == JavaClass.ClassRole.INTERFACE) {
            sb.append("<<").append((Object)role).append(">>\n").append(AlphabetLayout.getClassName(parsedClass));
        } else if (role == JavaClass.ClassRole.ABSTRACT) {
            sb.append("/").append(AlphabetLayout.getClassName(parsedClass)).append("/");
        } else {
            sb.append(AlphabetLayout.getClassName(parsedClass));
        }
        sb.append("\n");
    }

    private JavaClass parseFile(String filename) {
        try {
            if (this.getExtension(filename).equals("java")) {
                return this.parseJavaFile(filename);
            }
            if (this.getExtension(filename).equals("class")) {
                return this.parseClassFile(filename);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private JavaClass parseJavaFile(String filename) {
        try {
            return new JpJavaClass(filename);
        }
        catch (ClassParserException e) {
            return null;
        }
    }

    private JavaClass parseClassFile(String filename) {
        return new BcelJavaClass(filename);
    }

    private String getExtension(String filename) {
        int dotPosition = filename.lastIndexOf(".");
        return filename.substring(dotPosition + 1, filename.length());
    }
}

