/*
  backgrid-select-all
  http://github.com/wyuenho/backgrid

  Copyright (c) 2013 Jimmy Yuen Ho Wong and contributors
  Licensed under the MIT @license.
*/

/*! http://mths.be/placeholder v2.0.7 by @mathias 
	Modified to work with Zepto.js by ZURB
*/

define("text!includes/wizard/WelcomeTemplate.html",[],function(){return'<h2><%- msg.Wizard.G_WelcomeMessage %></h2>\n<div class="row input">\n    <div class="large-12 columns">\n        <label for="country"><%- msg.Wizard.G_WelcomeSelectCountry %></label>\n        <span class="custom-dropdown custom-dropdown--white">\n            <select id="country" name="country" class="custom-dropdown__select custom-dropdown__select--white">\n                <% _(ccodes).each(function (ccode) {%><option value="<%= ccode.code %>"><%= ccode.name %></option><% }); %>\n            </select>\n        </span>\n    </div>\n    <div class="large-12 columns">\n        <label for="timezone"><%- msg.Wizard.G_WelcomeSelectTimezone %></label>\n        <span class="custom-dropdown custom-dropdown--white">\n            <select id="timezone" name="timezone" class="custom-dropdown__select custom-dropdown__select--white">\n                <%= timezoneOptionsTemplate() %>\n            </select>\n        </span>\n    </div>\n</div>\n<div class="row"><div class="large-12 columns">\n        <%- msg.Wizard.G_WelcomeRestoreLinkPrefix %> <a id="Backup" href="#Backup"><%- msg.Wizard.G_WelcomeRestoreLinkText %></a>.\n</div></div>\n<div class="row">\n    <div class="large-12 columns">\n        <input type="file" name="file" id="restoreFile"/>\n        <progress />\n    </div>\n</div>\n'}),define("unifi/view/wizard/WelcomeView",["underscore","backbone","msg/Msg","ubnt/view/dialogs/ConfirmDialogView","ubnt/view/dialogs/ErrorDialogView","ubnt/view/dialogs/AlertDialogView","text!includes/wizard/WelcomeTemplate.html","text!includes/global/timezoneOptions.html","libs/fileupload"],function(e,t,i,n,s,r,a,o,c){"use strict";return t.View.extend({template:e.template(a),el:"#Step",events:{"click #Backup":"onBackup",'change [type="file"]':"onFileChange","change #country":"onCountryChange","change #language":"onLanguageChange","change #timezone":"onTimezoneChange"},initialize:function(t){this.options=t,e.bindAll(this,"onProgress","restore"),this.listenTo(this.model,"change:up",this.backupRestored)},render:function(){this.$el.html(this.template({ccodes:this.model.get("ccodes"),languages:[{name:"English (US)",code:"en_us"}],timezoneOptionsTemplate:e.template(o),msg:i}));var t=this.$("#timezone");if(!this.model.get("timezone")){var n=this.model.getTimezoneOffset();if(n){var s=t.find('option[title="'+n+'"]');s&&this.model.set("timezone",s.val())}}return this.$("#country").val(this.model.get("country")),this.$("#language").val(this.model.get("language")),t.val(this.model.get("timezone")).change(),this.$progress=this.$("progress"),this.$file=this.$("#restoreFile"),this},onCountryChange:function(e){this.model.set("country",this.$(e.target).val())},onLanguageChange:function(e){this.model.set("language",this.$(e.target).val())},onTimezoneChange:function(e){this.model.set("timezone",this.$(e.target).val())},onBackup:function(e){e.preventDefault(),this.$file.show()},onFileChange:function(){this.$progress.show(),this.$file.hide();var e=new c,i=e.upload(t.$("form").get(0),{url:"/upload/backup"});i.progress(this.onProgress),i.done(this.restore),i.fail(this.restore)},onProgress:function(e){var t=this.$progress.get(0);this.$progress.val(e.loaded),e.total!==t.max&&(t.max=e.total)},restore:function(e,t,s){this.$progress.hide(),this.$file=this.$("#restoreFile").show();var r=this;return e&&e.meta&&"ok"==e.meta.rc?(e=e.meta,void(new n).show(i.localize(i.I_ConfirmRestore,e.filename,new Date(parseInt(e.timestamp,10))),function(){r.model.cmdRestore().done(function(e){"ok"===e.meta.rc?r.model.pollServer():alert("something went wrong:"+e.msg)})})):this.failedUpload(s,t,e)},backupRestored:function(e,t){return t?window.location.reload():(new r).open(i.Wizard.N_Restoring),this},failedUpload:function(e,t,n){var r,a=new s;r="api.err.InvalidBackupVersion"===n.meta.msg?i.localize(i.E_InvalidBackupVersion,n.meta.filename,n.meta.version):i.localize(i.E_InvalidBackup,n.meta.filename),a.open(r)}})}),define("text!includes/wizard/DiscoverTemplate.html",[],function(){return'<h2>\n    <%- msg.Wizard.G_DiscoverMessage %>\n</h2>\n<div class="row">\n    <div class="large-24 columns">\n        <div id="Devices" class="data-table untitled"></div>\n    </div>\n</div>\n<button id="Refresh" type="button" class="button secondary"><span class=ubnt-icon-refresh>   </span><%- msg.Wizard.G_Refresh %></button>\n'}),function(e){"object"==typeof exports?module.exports=e(require("backbone"),require("backgrid")):"undefined"!=typeof Backbone&&"undefined"!=typeof Backgrid&&e(Backbone,Backgrid)}(function(e,t){"use strict";var i=e.$,n=t.Extension.SelectRowCell=e.View.extend({className:"select-row-cell",tagName:"td",events:{"keydown :checkbox":"onKeydown","change :checkbox":"onChange","click :checkbox":"enterEditMode"},initialize:function(e){this.column=e.column,this.column instanceof t.Column||(this.column=new t.Column(this.column)),this.listenTo(this.model,"backgrid:select",function(e,t){this.$el.find(":checkbox").prop("checked",t).change()});var i=this.column,n=this.$el;this.listenTo(i,"change:renderable",function(e,t){n.toggleClass("renderable",t)}),i.get("renderable")&&n.addClass("renderable")},enterEditMode:function(){this.$el.find(":checkbox").focus()},exitEditMode:function(){this.$el.find(":checkbox").blur()},onKeydown:function(e){var i=new t.Command(e);return i.passThru()?!0:void(i.cancel()?(e.stopPropagation(),this.$el.find(":checkbox").blur()):(i.save()||i.moveLeft()||i.moveRight()||i.moveUp()||i.moveDown())&&(e.preventDefault(),e.stopPropagation(),this.model.trigger("backgrid:edited",this.model,this.column,i)))},onChange:function(e){var t=i(e.target).prop("checked");this.$el.parent().toggleClass("selected",t),this.model.trigger("backgrid:selected",this.model,t)},render:function(){return this.$el.empty().append('<input tabindex="-1" type="checkbox" />'),this.delegateEvents(),this}}),s=t.Extension.SelectAllHeaderCell=n.extend({className:"select-all-header-cell",tagName:"th",initialize:function(e){this.column=e.column,this.column instanceof t.Column||(this.column=new t.Column(this.column));var i=this.collection,n=this.selectedModels={};this.listenTo(i,"backgrid:selected",function(e,t){t?n[e.id||e.cid]=e:(delete n[e.id||e.cid],this.$el.find(":checkbox").prop("checked",!1))}),this.listenTo(i,"remove",function(e){delete n[e.id||e.cid]}),this.listenTo(i,"backgrid:refresh",function(){this.$el.find(":checkbox").prop("checked",!1);for(var e=0;e<i.length;e++){var t=i.at(e);n[t.id||t.cid]&&t.trigger("backgrid:select",t,!0)}});var s=this.column,r=this.$el;this.listenTo(s,"change:renderable",function(e,t){r.toggleClass("renderable",t)}),s.get("renderable")&&r.addClass("renderable")},onChange:function(e){var t=i(e.target).prop("checked"),n=this.collection;n.each(function(e){e.trigger("backgrid:select",e,t)}),n.trigger("backgrid:select-all",n,t)}});t.Grid.prototype.getSelectedModels=function(){for(var e,t=this.header.row.cells,i=0,n=t.length;n>i;i++){var r=t[i];if(r instanceof s){e=r;break}}var a=[],o=this.collection;if("fullCollection"in o&&(o=o.fullCollection),e)for(var c in e.selectedModels)a.push(o.get(c));return a}}),define("libs/backgrid-select-all",function(){}),define("unifi/view/wizard/SelectDevicesView",["jquery","underscore","backbone","libs/backgrid","ubnt/backgrid","msg/Msg","text!includes/wizard/WelcomeTemplate.html","libs/backgrid-select-all"],function(e,t,i,n,s,r){"use strict";var a=function(){};return a.prototype=new n.NumberFormatter,t.extend(a.prototype,s.Formatters.Seconds),i.View.extend({el:"#Devices",template:t.template('<div class="error"><p class="message"><%= message %></p><p><%= instructions %></p>'),events:{"click .prev":"_onChangePage","click .next":"_onChangePage"},initialize:function(){this.listenTo(this.collection,"add",this.sizeCheck),this.listenTo(this.collection,"remove",this.sizeCheck),this.listenTo(this.collection,"reset",this.sizeCheck)},sizeCheck:function(){0===this.collection.length||0===this.grid._collection().length?(this.$("table.backgrid").hide(),this.$error.show()):(this.$("table.backgrid").show(),this.$error.hide())},render:function(){return this.$error=i.$(this.template({message:r.Wizard.E_NoDevicesMsg,instructions:r.Wizard.E_NoDevicesInstructions})),this.grid=new s.Grid({columns:this.columns,collection:this.collection,pageable:!0,footer:s.Paginators.Mini}),this.grid.setFilter("default",!0,1),this.grid.paginate(1,10),this.$el.html(this.grid.render().el),this._selectFix(),this.$el.append(this.$error),this.sizeCheck(),this},_onChangePage:function(){var i,n,s,r=this.grid.getSelectedModels(),a=this;t.delay(function(){a.$("tbody").find("tr").each(function(){i=e(this),s=i.find("td:eq(1)").text(),n=i.find("td:first").find("input"),t.find(r,function(e){return e.attributes.mac===s})?n.attr("checked","checked"):n.removeAttr("checked")})},200)},_selectFix:function(){var t=this.grid.header.row.cells[0];t.collection=this.collection,t.initialize({column:t.column});var i=this;return this.grid.body.$el.on("refresh",function(){i.collection.length&&i.collection.trigger("backgrid:refresh")}),t.$el.on("change",":checkbox",function(){var t=e(this).is(":checked");i.collection.each(function(e){e.trigger("backgrid:selected",e,t)})}),this.collection.selectedDevices=t.selectedModels,this},columns:[{name:"",headerCell:"select-all",cell:"select-row"},{name:"name",label:r.G_PropertiesMACAddress,sortable:!1,editable:!1,headerCell:s.Headers.noLinkHeader,cell:s.Cells.ModelCell.extend({callback:"name"})},{name:"version",label:r.G_Version,sortable:!1,editable:!1,headerCell:s.Headers.noLinkHeader,cell:"string"},{name:"ip",label:r.G_IPAddress,sortable:!1,editable:!1,headerCell:s.Headers.noLinkHeader,cell:"string"},{name:"uptime",label:r.G_Uptime,editable:!1,cell:n.IntegerCell.extend({formatter:a})}]})}),define("unifi/view/wizard/DiscoverView",["backbone","underscore","msg/Msg","text!includes/wizard/DiscoverTemplate.html","unifi/view/wizard/SelectDevicesView"],function(e,t,i,n,s){"use strict";return e.View.extend({template:t.template(n),events:{"click #Refresh":"onRefresh"},el:"#Step",render:function(){return this.$el.html(this.template({msg:i})),this.devicesView=new s({collection:this.model.get("devices")}),this.devicesView.render(),this},onRefresh:function(){this.model.fetchDeviceStatus({type:"POST"})}})}),define("text!includes/wizard/WirelessTemplate.html",[],function(){return'<h2><%- msg.Wizard.G_WirelessMessage %></h2>\n<p><%- msg.Wizard.G_WirelessMessageSkip %></p>\n<div class="row">\n    <div class="large-9 columns">\n        <label for="SSID"><%- msg.Wizard.G_WirelessSecureSsid %></label>\n        <input id="SSID" name="SSID" type="text" value="<%- ssid %>" required pattern="(^([\\x20-\\x7E]){1,32}$)" title="<%- msg.Wizard.G_WirelessSecureSsidTitle %>"/>\n    </div>\n    <div class="large-9 columns large-offset-2">\n        <label for="SecurityKey"><%- msg.Wizard.G_WirelessSecurityKey %></label>\n        <input id="SecurityKey" name="SecurityKey" type="password" value="<%- securityKey %>" title="<%- msg.Wizard.G_WirelessSecurityKeyTitle %>" pattern="^([\\x20-\\x7E]){8,63}$" required/>\n    </div>\n    <div class="large-4 columns"></div>\n</div>\n<p><%- msg.Wizard.G_WirelessOptionMessage %></p>\n<div>\n    <input type="checkbox" name="Guest" id="Guest" value="true" <% if (guest) {%>checked<% } %> /> <label for="Guest"><%- msg.Wizard.G_WirelessEnableGuestAccess %></label>\n    <div class="row">\n        <div class="large-9 columns guest">\n            <label for="GuestSSID"><%- msg.Wizard.G_WirelessGuestSsid %></label>\n            <input id="GuestSSID" name="GuestSSID" type="text" value="<%- guest_ssid %>" required pattern="(^([\\x20-\\x7E]){1,32}$)" title="<%- msg.Wizard.G_WirelessSecureSsidTitle %>" <% if (guest) {%>disabled<% } %>/>\n        </div>\n    </div>\n</div>\n'}),define("unifi/view/wizard/WirelessView",["underscore","backbone","msg/Msg","text!includes/wizard/WirelessTemplate.html"],function(e,t,i,n){"use strict";return t.View.extend({events:{"change #Guest":"onGuestChange","change #SecurityKey":"onSecurityKeyChange","change #SSID":"onSSIDChange","change #GuestSSID":"onGuestSSIDChange"},template:e.template(n),el:"#Step",initialize:function(e){this.options=e,this.listenTo(this.model,"change:guest",this.showGuestSSID)},render:function(){return this.$el.html(this.template({securityKey:this.model.get("securityKey"),ssid:this.model.get("ssid"),guest:this.model.get("guest"),guest_ssid:this.model.get("guest_ssid"),msg:i})),this.showGuestSSID(this.model,this.model.get("guest")),this},onSSIDChange:function(e){this.model.set({ssid:e.target.value})},onSecurityKeyChange:function(e){this.model.set({securityKey:e.target.value})},onGuestChange:function(e){this.model.set({guest:e.target.checked})},onGuestSSIDChange:function(e){this.model.set({guest_ssid:e.target.value})},showGuestSSID:function(e,t){return t?(this.$(".guest").show(),this.$("#GuestSSID").get(0).disabled=!1):(this.$("#GuestSSID").get(0).disabled=!0,this.$(".guest").hide()),this}})}),define("text!includes/wizard/PasswordTemplate.html",[],function(){return'<h2><%- msg.Wizard.G_PasswordMessage %></h2>\n<div class="row">\n    <div class="large-9 columns">\n        <label for="admin"><%- msg.Wizard.G_PasswordAdminName %></label>\n        <input id="admin" name="admin" type="text" value="<%- admin %>" pattern="^[_A-Za-z0-9][-_.A-Za-z0-9]*$" title="<%- msg.Wizard.G_PasswordAdminNameTitle %>" required/>\n    </div>\n</div>\n<div class="row">\n    <div class="large-9 columns">\n        <label for="password"><%- msg.Wizard.G_Password %></label>\n        <input id="password" name="password" type="password" value="<%- password %>" required title=""/>\n    </div>\n    <div class="large-9 columns large-offset-2">\n        <label for="password"><%- msg.Wizard.G_ConfirmPassword %></label>\n        <input id="password-confirm" name="password-confirm" type="password" value="<%- passwordConfirm %>" required/>\n    </div>\n    <div class="large-4 columns"></div>\n</div>\n'}),define("unifi/view/wizard/PasswordView",["underscore","backbone","msg/Msg","text!includes/wizard/PasswordTemplate.html"],function(e,t,i,n){"use strict";return t.View.extend({events:{"change #password":"onPasswordChange","change #password-confirm":"onPasswordChangeConfirm","change #admin":"onAdminChange","keyup #password-confirm":"onPasswordChangeConfirm"},template:e.template(n),el:"#Step",initialize:function(e){this.options=e,this.listenTo(this.model,"invalid",this.setInvalid)},render:function(){return this.$el.html(this.template({password:this.model.get("password"),passwordConfirm:this.model.get("password-confirm"),admin:this.model.get("admin"),msg:i})),this.passwordConfirm=this.el.querySelector("#password-confirm"),this.$passwordConfirm=t.$(this.passwordConfirm),this},setInvalid:function(e,t){return"passwords do not match"===t&&(this.passwordConfirm.setCustomValidity("Passwords do not match"),this.$passwordConfirm.addClass("error")),this},setValid:function(){this.passwordConfirm.setCustomValidity(""),this.$passwordConfirm.removeClass("error")},onPasswordChange:function(){this.model.set("password",this.$el.find("#password").val()),this.model.isValid()&&this.setValid()},onPasswordChangeConfirm:function(){this.onPasswordChange(),this.onAdminChange(),this.passwordConfirm.setCustomValidity(""),this.$passwordConfirm.removeClass("error"),this.model.set("password-confirm",this.$el.find("#password-confirm").val()),this.model.isValid()},onAdminChange:function(){this.model.set("admin",this.$el.find("#admin").val())}})}),define("text!includes/wizard/FinishTemplate.html",[],function(){return'<h2><%- msg.Wizard.G_FinishMessage %></h2>\n<div class="row">\n    <div class="large-12 columns">\n        <label><%- msg.Wizard.G_WirelessSecureSsid %></label>\n    </div>\n    <div class="large-12 columns">\n        <label><%- msg.Wizard.G_PasswordAdminName %></label>\n    </div>\n</div>\n<div class="row">\n    <div class="large-12 columns">\n        <span><%- ssid %></span>\n    </div>\n    <div class="large-12 columns">\n        <span><%- admin %></span>\n    </div>\n</div>\n'}),define("unifi/view/wizard/FinishView",["underscore","backbone","msg/Msg","text!includes/wizard/FinishTemplate.html"],function(e,t,i,n){"use strict";return t.View.extend({template:e.template(n),el:"#Step",render:function(){return this.$el.html(this.template({admin:this.model.get("admin"),ssid:this.model.get("ssid")||i.Wizard.N_NoSSID,msg:i})),this}})}),define("text!includes/wizard/ProgressTemplate.html",[],function(){return'<ol>\n    <li class="welcome in-progress">\n        <button type=button name=step value=welcome>1</button>\n        <a href="#welcome"><%- msg.Wizard.G_Welcome %></a>\n    </li>\n    <li class="discover">\n        <button type=button name=step value=discover>2</button>\n        <div class="connection"></div>\n        <a href="#discover"><%- msg.Wizard.G_Discover %></a>\n    </li>\n    <li class="wireless">\n        <button type=button name=step value=wireless>3</button>\n        <div class="connection"></div>\n        <a href="#wireless"><%- msg.Wizard.G_Wireless %></a>\n    </li>\n    <li class="password">\n        <button type=button name=step value=password>4</button>\n        <div class="connection"></div>\n        <a href="#password"><%- msg.Wizard.G_Password %></a>\n    </li>\n    <li class="finish">\n        <button type=button name=step value=finish>5</button>\n        <div class="connection"></div>\n        <a href="#finish"><%- msg.Wizard.G_Finish %></a>\n    </li>\n</ol>\n'}),define("unifi/view/wizard/ProgressView",["backbone","underscore","msg/Msg","text!includes/wizard/ProgressTemplate.html"],function(e,t,i,n){"use strict";return e.View.extend({template:t.template(n),el:"#Progress",initialize:function(){this.listenTo(this.model,"change:step",this.showStep)},render:function(){return this.$el.html(this.template({msg:i})),this},showStep:function(e,t){return this.$("."+t).prevAll().removeClass("in-progress").addClass("complete"),this.$("."+t).removeClass("complete").addClass("in-progress"),this.$("."+t+" ~ li").removeClass("complete in-progress"),this},setStep:function(t){t.preventDefault();var i=e.$(t.target),n=i.val();n||(n=i.attr("href").slice(1)),this.model.set("step",n)}})}),function(e,t,i){function n(e){var t={},n=/^jQuery\d+$/;return i.each(e.attributes,function(e,i){i.specified&&!n.test(i.name)&&(t[i.name]=i.value)}),t}function s(e,n){var s=this,r=i(s);if(s.value==r.attr("placeholder")&&r.hasClass("placeholder"))if(r.data("placeholder-password")){if(r=r.hide().next().show().attr("id",r.removeAttr("id").data("placeholder-id")),e===!0)return r[0].value=n;r.focus()}else s.value="",r.removeClass("placeholder"),s==t.activeElement&&s.select()}function r(){var e,t=this,r=i(t),a=this.id;if(""==t.value){if("password"==t.type){if(!r.data("placeholder-textinput")){try{e=r.clone().attr({type:"text"})}catch(o){e=i("<input>").attr(i.extend(n(this),{type:"text"}))}e.removeAttr("name").data({"placeholder-password":!0,"placeholder-id":a}).bind("focus.placeholder",s),r.data({"placeholder-textinput":e,"placeholder-id":a}).before(e)}r=r.removeAttr("id").hide().prev().attr("id",a).show()}r.addClass("placeholder"),r[0].value=r.attr("placeholder")}else r.removeClass("placeholder")}var a,o,c="placeholder"in t.createElement("input"),l="placeholder"in t.createElement("textarea"),d=i.fn,u=i.valHooks;c&&l?(o=d.placeholder=function(){return this},o.input=o.textarea=!0):(o=d.placeholder=function(){var e=this;return e.filter((c?"textarea":":input")+"[placeholder]").not(".placeholder").bind({"focus.placeholder":s,"blur.placeholder":r}).data("placeholder-enabled",!0).trigger("blur.placeholder"),e},o.input=c,o.textarea=l,a={get:function(e){var t=i(e);return t.data("placeholder-enabled")&&t.hasClass("placeholder")?"":e.value},set:function(e,n){var a=i(e);return a.data("placeholder-enabled")?(""==n?(e.value=n,e!=t.activeElement&&r.call(e)):a.hasClass("placeholder")?s.call(e,!0,n)||(e.value=n):e.value=n,a):e.value=n}},c||(u.input=a),l||(u.textarea=a),i(function(){i(t).delegate("form","submit.placeholder",function(){var e=i(".placeholder",this).each(s);setTimeout(function(){e.each(r)},10)})}),i(e).bind("beforeunload.placeholder",function(){i(".placeholder").each(function(){this.value=""})}))}(this,document,Foundation.zj),define("foundation.placeholder",function(){}),define("unifi/view/wizard/ChromeView",["jquery","backbone","msg/Msg","unifi/view/wizard/WelcomeView","unifi/view/wizard/DiscoverView","unifi/view/wizard/WirelessView","unifi/view/wizard/PasswordView","unifi/view/wizard/FinishView","unifi/view/wizard/ProgressView","foundation.placeholder"],function(e,t,i,n,s,r,a,o,c){"use strict";return t.View.extend({events:{"submit form":"onNext","click #Skip":"onSkip","click #Back":"onBack","click #Finish":"onFinish"},el:"#Wizard",initialize:function(){this.localize(),this.listenTo(this.model,"change:step",this.renderStep),this.listenTo(this.model,"invalid",this.invalid)},localize:function(){var t=e(this.el).find("form");t.find("> h1").first().text(i.Wizard.G_UniFiSetupWizardTitle),t.find(".buttons > div > #Back").text(i.Wizard.G_Back),t.find(".buttons > div > #Skip").text(i.Wizard.G_Skip),t.find(".buttons > div > #Next").text(i.Wizard.G_Next),t.find(".buttons > div > #Finish").text(i.Wizard.G_Finish);var n=e("body > #Wrapper > #Modal > .modal-background");n.find("> h1").text(i.E_WontWork),n.find("> p").text(i.E_WontWorkDetail)},onNext:function(e){e.preventDefault();var t=this.model.get("step"),i={v:{}};switch(t){case"wireless":i.v={ssid:!0,securityKey:!0,guest_ssid:!0};break;case"password":i.v={password:!0,admin:!0}}this.el.querySelector("form").checkValidity()&&this.model.isValid(i)&&this.model.step()},onSkip:function(){this.model.resetStep(this.model.get("step")),this.model.step()},onBack:function(){this.model.stepBack()},onFinish:function(e){e.preventDefault(),this.model.save({},{success:function(){window.location.replace("/login")}})},render:function(){e("#Main").removeClass("loading");var t=new c({model:this.model});return t.render(),this.renderStep(this.model,this.model.get("step"))},renderStep:function(e,t,i){i=i||{};var c,l,d=!0;switch(t){case"discover":c=s;break;case"wireless":c=r,d=!1;break;case"password":c=a;break;case"finish":c=o;break;default:c=n}return i.model=e,l=new c(i),l.render(),d?this.$el.addClass("required"):this.$el.removeClass("required"),this.model.steps[t].p?this.$el.removeClass("first"):this.$el.addClass("first"),this.model.steps[t].n?this.$el.removeClass("last"):this.$el.addClass("last"),this},invalid:function(e,t){"finish"===e.get("step")&&alert(t)}})}),define("unifi/model/PortModel",["unifi/model/Model","underscore","backbone","msg/Msg","app","ubnt/backgrid"],function(e,t,i,n,s,r){"use strict";return e.extend({diagramClasses:function(){var e=[];return this.get("poe_enable")&&e.push("poe"),"mirror"==this.get("op_mode")&&e.push("mirror"),this.get("enable")||e.push("shutdown"),this.get("up")&&(e.push("up"),1e3==this.get("speed")?e.push("green"):(100==this.get("speed")||10==this.get("speed"))&&e.push("orange"),"discarding"==this.get("stp_state")&&e.push("block")),e.join(" ")},diagramTooltip:function(){var e="<table>",t=this.portIdxText(),i=this.get("name"),s=this.get("media"),a=this.statusText(),o=this.get("tx_bytes")&&r.Formatters.Bytes.fromRaw(this.get("tx_bytes")),c=this.get("rx_bytes")&&r.Formatters.Bytes.fromRaw(this.get("rx_bytes")),l=this.poeModeText(),d=this.networksVlansText(),u='<tr class="table-row"><td class="column-name">{1}</td><td class="column-value">{2}</td></tr>';if(t&&(e+=n.localize(u,n.G_Port,t)),i&&(e+=n.localize(u,n.G_Name,i)),a&&(e+=n.localize(u,n.G_Status,a)),o&&(e+=n.localize(u,n.G_DevicesTX,o)),c&&(e+=n.localize(u,n.G_DevicesRX,c)),l&&(e+=n.localize(u,n.G_PropertiesPoE,l)),d&&(e+=n.localize(u,n.G_PropertiesNetworksVLANs,d)),("SFP"===s||"SFP+"===s)&&this.get("sfp_found")){var p=this.get("sfp_vendor"),h=this.get("sfp_serial"),m=this.get("sfp_part"),g=this.get("sfp_rev"),f=this.get("sfp_compliance"),v=this.get("sfp_voltage"),w=this.get("sfp_current"),_=this.get("sfp_txpower"),y=this.get("sfp_rxpower"),b=this.get("sfp_temperature"),P=this.get("sfp_txfault"),S=this.get("sfp_rxfault");p&&(e+=n.localize(u,n.G_PropertiesSFPVendor,p)),h&&(e+=n.localize(u,n.G_PropertiesSFPSerial,h)),m&&(e+=n.localize(u,n.G_PropertiesSFPPartNum,m)),g&&(e+=n.localize(u,n.G_PropertiesSFPRev,g)),f&&(e+=n.localize(u,n.G_PropertiesSFPCompliance,f)),v&&(e+=n.localize(u,n.G_PropertiesSFPVoltage,v)),w&&(e+=n.localize(u,n.G_PropertiesSFPCurrent,w)),b&&(e+=n.localize(u,n.G_Temperature,b+n.G_DegreeCelsius)),_&&(e+=n.localize(u,n.G_PropertiesSFPOutputPower,_)),y&&(e+=n.localize(u,n.G_PropertiesSFPInputPower,y)),P&&(e+=n.localize(u,n.G_PropertiesSFPTXError,P)),S&&(e+=n.localize(u,n.G_PropertiesSFPRXError,S))}return e+="</table>"},portIdxText:function(){var e=this.get("port_idx");return this.get("masked")?"":("aggregate"==this.get("op_mode")&&(e+="-"+(parseInt(e,10)+parseInt(this.get("aggregate_num_ports")-1,10))),e)},statusText:function(){if(this.get("up")){var e=this.get("speed");return e+=" ",e+=this.get("full_duplex")?n.G_PropertiesFullDuplexAbbrv:n.G_PropertiesHalfDuplexAbbrv,this.get("is_uplink")&&(e+=" ("+n.G_PropertiesUplink+")"),"discarding"==this.get("stp_state")&&(e+=" ("+n.G_PropertiesBlocked+")"),e}return""},poeModeText:function(){if(!this.get("port_poe"))return"";if("switch"!==this.get("op_mode")||this.get("masked"))return"";var e=this.get("poe_mode");return"auto"===e&&this.get("poe_enable")?this.get("poe_power")+"w":"auto"===e?n.G_PropertiesPoEModePoEPlus:"pasv24"===e?n.G_PropertiesPoEModePassive:e},networksVlansText:function(){if(this.get("aggregated_by"))return n.G_PropertiesAggregatedByPort+" "+this.get("aggregated_by");if("mirror"==this.get("op_mode"))return n.G_PropertiesMirroringPort+" "+this.get("mirror_port_idx");var e=this.get("portconf_id");if(e){var t=s.collection("PortConf").get(e);if(t)return t.get("name")}}})}),define("unifi/model/Device",["unifi/model/Model","unifi/model/PortModel","jquery","backbone","ubnt/backgrid","msg/Msg","underscore","libs/moment","ubnt/ubnt.ip"],function(e,t,i,n,s,r,a,o){"use strict";return e.extend({typeMap:{gateway:"ugw","switch":"usw",ap:"uap",phone:"uph"},copyConfigMap:{US24:["US24P250","US24P500"],US24P250:["US24","US24P500"],US24P500:["US24","US24P250"],US48:["US48P500","US48P750"],US48P500:["US48","US48P750"],US48P750:["US48","US48P500"]},initialize:function(){this.collections={},this.listenTo(this,"change:port_table",this.syncPortTable),this.listenTo(this,"change:port_overrides",this.syncPortTable),(this.attributes.port_table||"usw"==this.attributes.type)&&this.syncPortTable()},validate:function(e,t){var i={},n=t?t.partial:null;if("advance-adopt"==n&&(e.username||(i.username=r.localize(r.E_CannotBeEmpty,r.G_UN)),e.password||(i.password=r.localize(r.E_CannotBeEmpty,r.G_PW))),e.port_overrides&&t.extra&&t.extra.portidx){var s=a.findWhere(e.port_overrides,{port_idx:t.extra.portidx});if(s){if("aggregate"==s.op_mode&&(!n||"aggregate_num_ports"==n)){for(var o=t.extra.portidx+1,c=t.extra.portidx+3,l=this.numPorts(),d=4,u=this.get("port_table"),p=(u.length,t.extra.portidx);c>p;p++)if(c>p){var h=u[p];if(h&&"switch"!==h.op_mode){c=p,d=c-t.extra.portidx+1;break}}c>l&&(c=l,d=c-t.extra.portidx+1),this.validator.range(s.aggregate_num_ports,2,d)||(i.aggregate_num_ports=r.localize(r.E_IncorrectNumberRange,r.G_PropertiesAggregatePorts,o,c))}"mirror"!=s.op_mode||n&&"mirror_port_idx"!=n||s.mirror_port_idx!=t.extra.portidx&&this.validator.range(s.mirror_port_idx,1,this.numPorts())||(i.mirror_port_idx=r.localize(r.E_InvalidMirroringPort,s.mirror_port_idx))}}return n&&"config_network_wan"!=n||e.config_network_wan&&(a.size(i.config_network_wan=this.validateNetwork(e,"config_network_wan"))||delete i.config_network_wan),n&&"config_network"!=n||e.config_network&&(a.size(i.config_network=this.validateNetwork(e,"config_network"))||delete i.config_network),n&&"wlan_overrides"!=n||e.wlan_overrides&&(i.wlan_overrides={},a.each(e.wlan_overrides,function(t,n){i.wlan_overrides[n]={};var s;if(e.hasOwnProperty("wlanconf")){var o=e.wlanconf.attributes.vlan_enabled;s=t.hasOwnProperty("vlan_enabled")?t.vlan_enabled:o}else s=t.vlan_enabled;s&&""===t.vlan?i.wlan_overrides[n].vlan=r.localize(r.E_CannotBeEmpty,r.G_PropertiesVLAN):t.vlan&&!this.validator.range(t.vlan,2,4095)&&(i.wlan_overrides[n].vlan=r.localize(r.E_IncorrectNumberRange,r.G_PropertiesVLAN,2,4095)),t.x_passphrase&&!this.validator.password(t.x_passphrase)&&(i.wlan_overrides[n].x_passphrase=r.localize(r.E_InvalidPassphrase,r.G_PropertiesPSK)),a.size(i.wlan_overrides[n])||delete i.wlan_overrides[n]},this),a.size(i.wlan_overrides)||delete i.wlan_overrides),e.name&&!this.validator.name(e.name)&&e.name.toLowerCase()!==e.mac.toLowerCase()&&(i.name=r.localize(r.E_InvalidName,r.G_PropertiesAlias)),a.size(i)?i:void 0},validateNetwork:function(e,t){var i={};switch(e[t].type){case"dhcp":e[t].dns1&&!this.validator.ip(e[t].dns1)&&(i.dns1=r.localize(r.E_IncorrectIPAddress,r.G_PropertiesPreferredDNS)),e[t].dns2&&!this.validator.ip(e[t].dns2)&&(i.dns2=r.localize(r.E_IncorrectIPAddress,r.G_PropertiesAlternateDNS));break;case"pppoe":e[t].username||(i.username=r.localize(r.E_CannotBeEmpty,r.G_UN)),e[t].x_password||(i.x_password=r.localize(r.E_CannotBeEmpty,r.G_PW)),e[t].dns1&&!this.validator.ip(e[t].dns1)&&(i.dns1=r.localize(r.E_IncorrectIPAddress,r.G_PropertiesPreferredDNS)),e[t].dns2&&!this.validator.ip(e[t].dns2)&&(i.dns2=r.localize(r.E_IncorrectIPAddress,r.G_PropertiesAlternateDNS));break;case"static":e[t].ip?this.validator.ip(e[t].ip)||(i.ip=r.localize(r.E_IncorrectIPAddress,r.G_IPAddress)):i.ip=r.localize(r.E_CannotBeEmpty,r.G_IPAddress),e[t].netmask?this.validator.netmask(e[t].netmask,e[t].ip)||(i.netmask=r.localize(r.E_IncorrectNetmask,r.G_Netmask)):i.netmask=r.localize(r.E_CannotBeEmpty,r.G_Netmask),e[t].gateway&&!this.validator.ip(e[t].gateway)&&(i.gateway=r.localize(r.E_IncorrectIPAddress,r.G_PropertiesGateway)),e[t].dns1&&!this.validator.ip(e[t].dns1)&&(i.dns1=r.localize(r.E_IncorrectIPAddress,r.G_PropertiesPreferredDNS)),e[t].dns2&&!this.validator.ip(e[t].dns2)&&(i.dns2=r.localize(r.E_IncorrectIPAddress,r.G_PropertiesAlternateDNS))}return i},parse:function(t,i){return t=e.prototype.parse.call(this,t,i),t&&0!==parseInt(t.state,10)&&(t.restarting=!1),t&&(t.uptime=t.uptime?parseInt(t.uptime,10):0),t},toSearch:function(){var e={name:this.attributes.name,mac:this.attributes.mac,ip:this.attributes.ip,status:this.status(),model:this.apModel(),version:this.attributes.version};return this.attributes.vap_table&&a.each(this.attributes.vap_table,function(t,i){e["bssid_"+i]=t.bssid}),e},name:function(){return this.get("name")||this.get("mac")},ip2long:function(){return i.ip2long(this.get("ip"))},getMacNoColons:function(){return this.get("mac").replace(/:/g,"")},apModel:function(){var e=this.get("model")||"";switch(e){case"BZ2":return"UniFi AP";case"BZ2LR":return"UniFi AP-LR";case"U2S48":return"UniFi AP";case"U2L48":return"UniFi AP-LR";case"U2HSR":return"UniFi AP-Outdoor+";case"U2O":return"UniFi AP-Outdoor";case"U5O":return"UniFi AP-Outdoor 5G";case"U7P":return"UniFi AP-Pro";case"U7PG2":return"UniFi AP-AC-Pro";case"U7LR":return"UniFi AP-AC-LR";case"U7LT":return"UniFi AP-AC-Lite";case"U2M":return"UniFi AP-Mini";case"U2IW":return"UniFi AP-In Wall";case"U7E":return"UniFi AP-AC";case"U7Ev2":return"UniFi AP-AC v2";case"U2Sv2":return"UniFi AP v2";case"U2Lv2":return"UniFi AP-LR v2";case"U7O":return"UniFi AP-AC Outdoor";case"p2N":return"PicoStation M2";case"US24":return"UniFi Switch 24";case"US24P250":return"UniFi Switch 24 POE-250W";case"US24P500":return"UniFi Switch 24 POE-500W";case"US48":return"UniFi Switch 48";case"US48P500":return"UniFi Switch 48 POE-500W";case"US48P750":return"UniFi Switch 48 POE-750W";case"US8P150":return"UniFi Switch 8 POE-150W";case"UGW3":return"UniFi Security Gateway 3P";case"UGW8":return"UniFi Security Gateway 8P";case"UP5":return"UniFi Phone";case"UP5t":return"UniFi Phone-Pro";case"UP7":return"UniFi Phone-Executive";case"UP4":return"UniFi Phone-X";
case"UP5c":return"UniFi Phone";case"UP5tc":return"UniFi Phone-Pro";case"UP7c":return"UniFi Phone-Executive"}return"UniFi "+e},isGen2Ap:function(){var e=this.get("model")||"";switch(e){case"U7PG2":case"U7LR":case"U7LT":return!0}return!1},isAntennaGainEditable:function(){var e=this.get("model")||"",t=["U2O","U5O","U2HSR"];return-1!==a.indexOf(t,e)?!0:!1},apIcon:function(){var e=this.get("model")||"";switch(e){case"U7P":return"ap-pro-icon";default:return"ap-icon"}},numPorts:function(){switch(this.get("model")){case"US24":case"US24P250":case"US24P500":return 26;case"US48":case"US48P500":case"US48P750":return 52;case"US8P150":return 8;case"UGW3":return 3;case"UGW8":return 8}},txPower:function(){var e=this.transmitPower("ng"),t=this.transmitPower("na");return a.isUndefined(t)||a.isUndefined(e)?a.isUndefined(t)?a.isUndefined(e)?void 0:e:t:e>t?e:t},getFrequency:function(e,t){if("ng"==e){var i={1:2412,2:2417,3:2422,4:2427,5:2432,6:2437,7:2442,8:2447,9:2452,10:2457,11:2462,12:2467,13:2472,14:2484};return i[t]}if("na"==e){var n={7:5035,8:5040,9:5045,11:5055,12:5060,16:5080,34:5170,36:5180,38:5190,40:5200,42:5210,44:5220,46:5230,48:5240,52:5260,56:5280,60:5300,64:5320,100:5500,104:5520,108:5540,112:5560,116:5580,120:5600,124:5620,128:5640,132:5660,136:5680,140:5700,149:5745,153:5765,157:5785,161:5805,165:5825,183:4915,184:4920,185:4925,187:4935,188:4940,189:4945,192:4960,196:4980};return n[t]}return void 0},transmitFrequency:function(e){if("ng"==e){var t=this.transmitPower("ng"),i=this.get("ng-channel");if(!a.isUndefined(t))return this.getFrequency(e,i)}if("na"==e){var n=this.transmitPower("na"),s=this.get("na-channel");if(!a.isUndefined(n))return this.getFrequency(e,s)}return void 0},uptime:function(e){return e=e||this.get("uptime"),e>0?s.Formatters.Duration.fromRaw(e||0):""},power:function(){var e=0;return a.each(this.get("port_table"),function(t){e+=parseFloat(t.poe_power||0,10)}),e.toFixed(2)},fan_level:function(){var e=this.get("fan_level");return e>=0?e:r.G_SettingsOff},uplink:function(){return this.isConnected()?this.get("uplink"):this.get("last_uplink")||this.get("uplink")},uplinks:function(){return this.get("uplink_table")||{}},uplinkDeviceMac:function(){var e=this.uplink();if(e){var t;if(e.hasOwnProperty("uplink_mac")?t=e.uplink_mac:"wireless"===e.type&&e.hasOwnProperty("ap_mac")&&(t=e.ap_mac),t)return t}return""},uplinkDeviceText:function(){var e=this.uplink();if(e){var t=this.uplinkDeviceMac(),i=this.collection.findWhere({mac:t});return i?i.name()+(e.uplink_remote_port?" #"+e.uplink_remote_port:""):t}return""},uplinkRemotePort:function(){var e=this.uplink();if(e){var t=this.uplinkDeviceMac(),i=this.collection.findWhere({mac:t});if(i&&e.uplink_remote_port)return e.uplink_remote_port}return null},uplinkRssi:function(){var e=this.uplink();return e?this.calcRssi(e.rssi):void 0},calcRssi:function(e){return void 0===e&&(e=this.get("rssi")),e=parseFloat(e),e?(e>45?e=45:5>e&&(e=5),e=(e-5)/40*99,(0===e?"0":e.toPrecision(2))+"%"):""},apXRate:function(e){return isNaN(e)?"":parseInt(e,10)/1e3+"M"},uplinkTxRate:function(){var e=this.uplink();return e?this.apXRate(e.tx_rate):""},uplinkRxRate:function(){var e=this.uplink();return e?this.apXRate(e.rx_rate):""},uplinkSpeed:function(){var e=this.uplink();return e?e.speed:"Unknown"},uplinkDuplex:function(){var e=this.uplink();return e&&e.full_duplex?"Full Duplex":"Half Duplex"},uplinkDownPackets:function(){var e=this.uplink();return e&&e.rx_packets&&e.rx_bytes?s.Formatters.Bytes.fromRaw(e.rx_packets)+"/"+s.Formatters.Bytes.fromRaw(e.rx_bytes):"0.00 / 0.00"},uplinkUpPackets:function(){var e=this.uplink();return e&&e.tx_packets&&e.tx_bytes?s.Formatters.Bytes.fromRaw(e.tx_packets)+"/"+s.Formatters.Bytes.fromRaw(e.tx_bytes):"0.00 / 0.00"},uplinkActivity:function(){var e=this.uplink(),t=e?e["tx_bytes-r"]:0,i=e?e["rx_bytes-r"]:0,n=t+i,r=0;return n&&(r=s.Formatters.Bytes.fromRaw(n)),r+"B / sec"},uplinkActivityDown:function(){var e=this.uplink(),t=e?e["rx_bytes-r"]:0,i=0;return t&&(i=s.Formatters.Bytes.fromRaw(t)),i+"B / sec"},uplinkActivityUp:function(){var e=this.uplink(),t=e?e["tx_bytes-r"]:0,i=0;return t&&(i=s.Formatters.Bytes.fromRaw(t)),i+"B / sec"},adoptIp:function(){return this.get("adopt_ip")||this.get("ip")},adoptPort:function(){return this.get("sshd_port")},adoptUrl:function(){return this.get("adopt_url")||this.get("inform_url")||"http://unifi:8080/inform"},downlinks:function(){return this.get("downlink_table")||[]},networks:function(){return this.get("network_table")||[]},getChannel:function(){var e=this.get("ng-channel"),t=this.get("na-channel"),i=[];return e&&i.push(e+" (2G)"),t&&i.push(t+" (5G)"),i.length?i.join(", "):""},apChannel:function(){if(!this.get("vap_table"))return"";var e,t,n,s=[];return n=this.get("model"),a.each(this.get("vap_table"),function(r){return 0===r.channel?!0:"RUN"!=(r.state||"RUN")?!0:(t=r.radio,"na"!=t||"U7E"!=n&&"U7O"!=n&&"U7Ev2"!=n&&"U7PG2"!=n&&"U7LR"!=n&&"U7LT"!=n||(t="ac"),e=r.channel+" ("+t+")",void(i.inArray(e,s)<0&&("ng"==r.radio?s=[e].concat(s):s.push(e))))}),s.join(", ")},sortApChannel:function(){if(!this.get("vap_table"))return-1;var e=0;return a.each(this.get("vap_table"),function(t){if(0===t.channel)return!0;if("RUN"!=(t.state||"RUN"))return!0;var i=t.radio;"na"==i?e+=1e3*(parseInt(t.channel,10)||0):"ng"==i&&(e+=parseInt(t.channel,10)||0)}),e},getRadio:function(e){return a.find(this.get("radio_table"),function(t){return t.hasOwnProperty("radio")?t.radio===e:void 0})},getNss:function(e){var t=this.getRadio(e);return t&&t.nss?t.nss:null},hasRadio:function(e){return void 0===this.getRadio(e)?!1:!0},channel:function(e){var t=this.get(e+"-state")||"INIT",i=this.get(e+"-extchannel")||0,n=i>0?",+1":0>i?",-1":"",s=this.get(e+"-channel")+n;return"INIT"==t?s="":"DFS_WAIT"==t&&(s+=" (DFS Waiting)"),s},transmitPower:function(e){var t=this.get(e+"-state")||"INIT";if("INIT"==t)return void 0;var i=Math.min(this.get(e+"-tx_power"),30),n=this.get(e+"-gain")||0,s=this.get(e+"-eirp")||parseInt(i,10)+n;return s},packetsPerBytes:function(e,t){var i=this.get("stat"),n=i?i[e+"-"+t+"_packets"]:0,r=i?i[e+"-"+t+"_bytes"]:0;return n=n||0,r=r||0,s.Formatters.Bytes.fromRaw(n)+" / "+s.Formatters.Bytes.fromRaw(r)},errorPercentage:function(e,t){var i,n=this.get("stat"),r=n?n[e+"-"+t+"_retries"]:0,a=n?n[e+"-"+t+"_packets"]:0,o=n?n[e+"-"+t+"_dropped"]:0;return r=r||0,a=a||0,o=o||0,i=a+o,s.Formatters.Percentage.fromRaw(r,i)+" / "+s.Formatters.Percentage.fromRaw(o,i)},getOverride:function(e,t){var i=null,n=this.get("wlan_overrides")||[];return a.each(n,function(n){return n.wlan_id==e&&n.radio==t?(i=n,!1):void 0}),i},hasOverrides:function(e,t){var i=!1,n=this.get("wlan_overrides")||[];return a.each(n,function(e){return e.radio==t?(i=!0,!1):void 0}),i},wlan2G:function(e){return this.wlangroup(this.get("wlangroup_id_ng"),"ng",e)},wlan5G:function(e){return this.wlangroup(this.get("wlangroup_id_na"),"na",e)},wlangroup:function(e,t,i){if(!(this.get("adopted")&&this.get("radio_"+t)&&i&&a.size(i)))return"";var n=i.findWhere({_id:e})||i.findWhere({attr_hidden_id:"Default"}),s=n.get("name");return n.get("roam_enabled")?s+=" (ZH)":this.hasOverrides(n.get("id"),t)&&(s+=" (*)"),s},radio2G:function(){return this.radioChannelAndPower(this.get("radio_ng"))},radio5G:function(){return this.radioChannelAndPower(this.get("radio_na"))},radioChannelAndPower:function(e){if(!this.get("adopted")||!e)return"";var t=e.channel&&!isNaN(e.channel)?parseInt(e.channel,10):"auto",i=e.tx_power_mode||"auto";return"custom"===i&&(i=e.builtin_antenna===!0?parseInt(e.tx_power,10)+parseInt(e.builtin_ant_gain,10)+" dBm":parseInt(e.tx_power,10)+parseInt(e.antenna_gain,10)+" dBm"),0===t&&(t="auto"),t+" / "+i},sortRadio2G:function(){return this.sortRadio(this.get("radio_ng"),"ng")},sortRadio5G:function(){return this.sortRadio(this.get("radio_na"),"na")},sortRadio:function(e,t){if(void 0===e||null===e)return-1;var i=e.channel&&!isNaN(e.channel)?parseInt(e.channel,10):0,n=this.transmitPower(t);return void 0===n&&(n=0),1e3*i+n},clientName:function(e){return e.hostname||e.mac},deviceName:function(e){return e.essid||e.mac},status:function(){var e,t=this.uplink()||{};switch(parseInt(this.get("state"),10)||0){case 0:e=this.get("restarting")?r.G_APRestarting:r.G_APDisconnected;break;case 1:e=r.G_APConnected,this.get("isolated")?e+=" (limited)":"wire"==t.type?"ugw"!==this.get("type")&&(t.max_speed==t.speed&&t.full_duplex||(e+=" ("+t.speed+" "+(t.full_duplex?"FDX":"HDX")+")")):"wireless"==t.type&&(e+=" (wireless)"),this.get("version_incompatible")&&(e+=" (needs upgrade)");break;case 2:e=this.get("default")?"scan"==this.get("discovered_via")?r.G_APIsolatedPending:r.G_APPending:r.G_APManagedByOthers;break;case 3:e=r.G_APFirmwareMismatch;break;case 4:e=r.G_APUpgrading;break;case 5:e=r.G_APProvisioning;break;case 6:e=r.G_APHeartbeatMissed;break;case 7:e=r.G_APAdopting,"wireless"==t.type&&(e+=" (wireless)");break;case 8:e=r.G_APDeleting;break;case 9:e=r.G_APDisconnected;break;case 10:e=r.G_APAdoptFailed;break;case 11:e=r.G_APIsolated}return e},statusType:function(){switch(parseInt(this.get("state"),10)||0){case 1:case 4:case 5:return"ok";case 2:case 7:case 13:return"pending";case 0:case 3:case 9:case 10:case 11:return"error";default:return"error"}},isConnected:function(){return"ok"===this.statusType()},is11ac:function(){return-1!==i.inArray(this.get("model"),["U7E","U7O","U7Ev2","U7PG2","U7LR","U7LT"])},hasDfs:function(){return-1!==i.inArray(this.get("model"),["U5O","U7P"])},noZh:function(){return-1!==i.inArray(this.get("model"),["U7E","U7O","U7Ev2","U7PG2","U7LR","U7LT"])},lastSeen:function(){var e,t=this.get("last_seen");return t?(e=(new Date).getTime()/1e3-parseInt(t,10),isNaN(e)?"":86400>e?s.Formatters.Duration.fromRaw(e)+" "+r.G_Ago:o(t+"","X").format("YYYY/MM/DD HH:mm:ss")):r.G_Never},lastScan:function(e){if(e){var t=(new Date).getTime()/1e3-parseInt(e,10);return isNaN(t)?r.G_Never:86400>t?s.Formatters.Duration.fromRaw(t)+" "+r.G_Ago:o(e+"","X").format("YYYY/MM/DD HH:mm:ss")}return r.G_Never},absoluteLastSeen:function(){var e=this.get("last_seen");return e?o(e+"","X").format("YYYY/MM/DD HH:mm:ss"):""},syncPortTable:function(){this.collections.portTable||(this.collections.portTable=new(n.Collection.extend({model:t.extend({idAttribute:"port_idx"})}))),a.each(this.attributes.port_table,i.proxy(function(e){var t=a.filter(this.attributes.port_overrides,function(t){return t.port_idx==e.port_idx});t.length&&(e=a.extend(e,t[0])),e.device=this.get("mac"),this.collections.portTable.add(e,{merge:!0})},this)),this.trigger("syncPortTable")},upgrade:function(e){return this.sync("upgrade",this,e)},adopt:function(e){return this.sync("adopt",this,e)},advanceAdopt:function(e){return this.validationError=this.validate(e.data,a.extend({partial:"advance-adopt"},e)),this.validationError?!1:this.sync("advance-adopt",this,e)},forget:function(e){return this.sync("forget",this,e)},restart:function(e){return this.sync("restart",this,e)},powerCyclePort:function(e){return this.sync("power-cycle",this,e)},clearSwitchCounters:function(e){return this.sync("clear-switch-counters",this,e)},clearPortCounters:function(e){return this.sync("clear-switch-port-counters",this,e)},setVwireUplink:function(e){return this.sync("set-vwire-uplink",this,e)},unsetVwireUplink:function(e){return this.sync("unset-vwire-uplink",this,e)},move:function(e){return this.sync("move",this,e)},copyConfig:function(e){return this.sync("copy-config",this,e)},update:function(e){return this.sync("update",this,e)},locate:function(e){return this.sync("locate",this,e)},spectrumScan:function(e){this.sync("spectrum-scan",this,e)},updateWlanGroup:function(e,t){var i={};return i["wlangroup_id_"+e]=t.wlangroup_id,i.wlan_overrides=a.reject(this.get("wlan_overrides"),function(t){return t.radio==e}),this.save(i,a.extend(t,{_method:"update-wlangroup-"+e}))},sort_Clients:function(){return void 0===this.get("num_sta")?-1:parseInt(this.get("num_sta"),10)},sort_2GClients:function(){return void 0===this.get("ng-num_sta")?-1:parseInt(this.get("ng-num_sta"),10)},sort_5GClients:function(){return void 0===this.get("na-num_sta")?-1:parseInt(this.get("na-num_sta"),10)},sort_txBytesD:function(){return void 0===this.get("tx_bytes-d")?-1:this.get("tx_bytes-d")},sort_rxBytesD:function(){return void 0===this.get("rx_bytes-d")?-1:this.get("rx_bytes-d")},sort_txBytes2g:function(){var e=(parseInt(this.get("ng_ast_be_xmit"),10)||0)+(parseInt(this.get("ng_tx_packets"),10)||0);return e},sort_txBytes5g:function(){var e=(parseInt(this.get("na_ast_be_xmit"),10)||0)+(parseInt(this.get("na_tx_packets"),10)||0);return e},sync:function(e,t,i){switch(i=i||{},i._method&&(e=i._method,delete i._method),e){case"read":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/stat/device/"+t.get("mac"),i.type="GET";break;case"update":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/upd/device/"+t.id,i.type="POST",i.data=JSON.stringify(i.data?i.data:t.changed);break;case"adopt":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{mac:t.get("mac"),cmd:"adopt"}));break;case"advance-adopt":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{mac:t.get("mac"),cmd:"adv-adopt"}));break;case"power-cycle":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{mac:t.get("mac"),cmd:"power-cycle"}));break;case"clear-switch-counters":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{mac:t.get("mac"),cmd:"clear-switch-counters"}));break;case"clear-switch-port-counters":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{mac:t.get("mac"),cmd:"clear-switch-port-counters"}));break;case"set-vwire-uplink":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{cmd:"set-vwire-uplink"}));break;case"unset-vwire-uplink":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{cmd:"unset-vwire-uplink"}));break;case"forget":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/sitemgr",i.type="POST",i.data=JSON.stringify({mac:t.get("mac"),cmd:"delete-device"});break;case"restart":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify({mac:t.get("mac"),cmd:"restart"});break;case"upgrade":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify({mac:t.get("mac"),cmd:"upgrade"});break;case"move":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/sitemgr/",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{mac:t.get("mac"),cmd:"move-device"}));break;case"copy-config":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr/",i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{mac:t.get("mac"),cmd:"clone-config",origin:i.selectedMac}));break;case"add-device":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/sitemgr/",i.type="POST",i.data=JSON.stringify({macid:i.macidqr,cmd:"add-device"});break;case"locate":t.set(t.get("adopted")?{locating:!t.get("locating")}:{locating:!1}),i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify({mac:t.get("mac"),cmd:t.get("adopted")?t.get("locating")?"set-locate":"unset-locate":"locate"});break;case"update-wlangroup-ng":i.contentType="application/json",i.url="/api/s/"+SITE.name+"/upd/device/"+t.id,i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{wlangroup_id_ng:t.get("wlangroup_id_ng"),wlan_overrides:t.get("wlan_overrides")}));break;case"update-wlangroup-na":i.contentType="application/json",i.url="/api/s/"+SITE.name+"/upd/device/"+t.id,i.type="POST",i.data=JSON.stringify(a.extend(i.data||{},{wlangroup_id_na:t.get("wlangroup_id_na"),wlan_overrides:t.get("wlan_overrides")}));break;case"spectrum-scan":i.contentType="application/json; charset=utf-8",i.url="/api/s/"+SITE.name+"/cmd/devmgr",i.type="POST",i.data=JSON.stringify({mac:t.get("mac"),cmd:"spectrum-scan"})}return n.sync.call(this,e,t,i)}})}),define("unifi/collection/Devices",["unifi/collection/Collection","underscore","backbone","unifi/model/Device"],function(e,t,i,n){"use strict";return e.extend({model:n,bySite:!0,initialize:function(t){e.prototype.initialize.call(this,t),this.typeMap=(new this.model).typeMap},get:function(i){var n=e.prototype.get.call(this,i);return!n&&t.isObject(i)&&!i.id&&i.get("mac")&&(n=this.getDeviceFromMac(i.get("mac"))),n},getInformIP:function(){var e=this.find(function(e){return e.get("adopted")&&1==e.get("state")&&e.get("inform_ip")});return void 0===e?"":e.get("inform_ip")},hasUpgradableAP:function(){var e=this.find(function(e){return"uap"==e.get("type")&&1==e.get("state")&&e.get("upgradable")});return e?!0:!1},hasUpgradablePhone:function(){var e=this.find(function(e){return"uph"==e.get("type")&&1==e.get("state")&&e.get("upgradable")});return e?!0:!1},isUpgradingDevices:function(){var e=this.find(function(e){return e.get("rollupgrade")});return e?!0:!1},getDeviceFromMac:function(e){return this.find(function(t){return t.get("mac")==e})},sortByBytes:function(){var e=this.sortBy(function(e){return-1*(e.get("bytes")||0)});return e},sortByBytesOnlyAps:function(){var e=this.sortByBytes();return t.filter(e,function(e){return"uap"===e.get("type")})},url:function(){return"/api/s/"+SITE.name+"/stat/device"},all:function(e){return this.fetch(t.extend(e,{_method:"read-all"}))},discover:function(){return this.fetch({_method:"discover"})},scanUplink:function(e){return this.sync("scan-uplink",this,e)},upgradeAPs:function(e){return this.sync("upgrade-aps",this,e)},upgradePhones:function(e){return this.sync("upgrade-phones",this,e)},sync:function(e,n,s){switch(s=s||{},s._method&&(e=s._method,delete s._method),e){case"read-all":s.contentType="application/json; charset=utf-8",s.url="/api/stat/device",s.type="POST",s.data=JSON.stringify(s.data||{});break;case"discover":s.contentType="application/json; charset=utf-8",s.url="/api/stat/device",s.type="POST",s.data=JSON.stringify({state:2,"default":!0});break;case"read":s.contentType="application/json; charset=utf-8",s.url="/api/s/"+SITE.name+"/stat/device",s.type="GET";break;case"scan-uplink":s.contentType="application/json; charset=utf-8",s.url="/api/s/"+SITE.name+"/cmd/devmgr",s.type="POST",s.data=JSON.stringify(t.extend(s.data||{},{cmd:"scan-uplink"}));break;case"upgrade-aps":s.contentType="application/json; charset=utf-8",s.url="/api/s/"+SITE.name+"/cmd/devmgr",s.type="POST",s.data=JSON.stringify(t.extend(s.data||{},{cmd:this.isUpgradingDevices()?"unset-rollupgrade":"set-rollupgrade"}));break;case"upgrade-phones":s.contentType="application/json; charset=utf-8",s.url="/api/s/"+SITE.name+"/cmd/devmgr",s.type="POST",s.data=JSON.stringify(t.extend(s.data||{},{cmd:"upgrade-all",type:"uph"}))}return i.sync.call(this,e,n,s)}})}),define("unifi/model/WizardModel",["underscore","backbone","unifi/collection/Devices","msg/Msg"],function(e,t,i,n){"use strict";return t.Model.extend({idAttribute:"_id",urlRoot:"/api/",defaults:{step:"welcome",country:840,language:"en_us",timezone:"",guest:!1,ssid:"",guest_ssid:"",securityKey:"",admin:"",up:!0},steps:{welcome:{p:!1,n:"discover"},discover:{p:"welcome",n:"wireless"},wireless:{p:"discover",n:"password"},password:{p:"wireless",n:"finish"},finish:{p:"password",n:!1}},validate:function(e,t){t=t||{};var i=t.v||{password:!0,ssid:!0,guest_ssid:!0,securityKey:!0,admin:!0};if(i.password&&!e.password)return n.Wizard.E_PasswordRequired;if(i.password&&e.password!==e["password-confirm"])return n.Wizard.E_PasswordsDontMatch;if(e.ssid){if(i.ssid&&!/^([\x20-\x7E]){1,32}$/.test(e.ssid))return n.Wizard.E_SsidAlphanumeric;if(i.guest_ssid&&e.guest&&!/^([\x20-\x7E]){1,32}$/.test(e.ssid))return n.Wizard.E_SsidAlphanumeric;if(i.securityKey&&!/(^([\x20-\x7E]){8,63}$)/.test(e.securityKey))return n.Wizard.E_SsidPasswordLength}return i.admin&&!/^[_.A-Za-z0-9][-\@_.A-Za-z0-9]*\$?$/.test(e.admin)?n.Wizard.E_AdminNameAlphanumeric:void 0},step:function(){return this.set({step:this.steps[this.get("step")].n})},stepBack:function(){return this.set({step:this.steps[this.get("step")].p})},resetStep:function(e){switch(e){case"wireless":this.unset("ssid"),this.unset("securityKey"),this.unset("guest"),this.unset("guest_ssid")}},set:function(i,n,s){var r=n,a=s;return"object"==typeof i?r=e.defaults({},n,{validate:!1}):a=e.defaults({},s,{validate:!1}),t.Model.prototype.set.call(this,i,n,s)},getTimezoneOffset:function(){var e,t=new Date,i=new Date(t.getFullYear(),0,1),n=new Date(t.getFullYear(),6,1),s=Math.max(i.getTimezoneOffset(),n.getTimezoneOffset()),r=t.getTimezoneOffset()<s,a=t.toString().match(/GMT([-|+]\d{2})/);return a&&a.length>1&&(e=parseInt(a[1],10),r&&(e-=1)),e},fetchWlanGroupId:function(e){var i=this;return e.url="/api/list/wlangroup",e.data={json:JSON.stringify({name:"Default"})},e.success=function(e){i.set({id:e.data[0]._id})},t.ajax(e)},fetchSysInfo:function(i){var n=this;return i.url="/api/stat/sysinfo",i.data={json:JSON.stringify({})},i.success=function(t){n.set({ccodes:e.map(t.data[0].ccodes,function(t){return e.pick(t,"code","name")})})},t.ajax(i)},fetchDeviceStatus:function(){return this.get("devices")||this.set({devices:new i}),this.get("devices").discover()},fetch:function(i){i=i?e.clone(i):{},void 0===i.parse&&(i.parse=!0);var n=this,s=i.success;return i=e.defaults(i,{type:"POST"}),t.$.when(this.fetchWlanGroupId(i),this.fetchSysInfo(i),this.fetchDeviceStatus(i)).then(function(){s&&s(n,null,i),n.trigger("sync",n,null,i)})},_saveSetting:function(e){return e.data={json:JSON.stringify(e.data)},e.success=!1,e.type="POST",t.ajax(e)},cmdSiteMgr:function(){var e={};return e.url="/api/cmd/sitemgr",e.data={name:this.get("admin"),lang:this.get("language"),timezone:this.get("timezone"),x_password:this.get("password"),cmd:"add-default-admin"},this._saveSetting(e)},addWlanConf:function(){if(!this.get("ssid"))return!0;var e={};e.url="/api/add/wlanconf",e.data={wlangroup_id:this.get("id"),enabled:!0,name:this.get("ssid"),security:"wpapsk",wpa_mode:"wpa2",wpa_enc:"ccmp",x_passphrase:this.get("securityKey")};var t={url:"/api/add/wlanconf",data:{wlangroup_id:this.get("id"),is_guest:!0,enabled:!0,name:this.get("guest_ssid"),security:"open"}},i=this._saveSetting(e),n=this;return this.get("guest")?i.then(function(){return n._saveSetting(t)}):i},cmdAdopt:function(){var i={};i.url="/api/cmd/devmgr";var n=new t.Collection(e.values(this.get("devices").selectedDevices));return i.data={cmd:"adopt",macs:n.pluck("mac")},this._saveSetting(i)},setCountry:function(){var e={};return e.url="/api/set/setting/country",e.data={code:parseInt(this.get("country"),10)},this._saveSetting(e)},setTimezone:function(){var e={};return e.url="/api/set/setting/locale",e.data={timezone:this.get("timezone")},this._saveSetting(e)},cmdInstalled:function(){var e={};return e.url="/api/cmd/system",e.data={cmd:"set-installed"},this._saveSetting(e)},cmdRestore:function(){this.set("up",!1);var e={};return e.url="/api/s/default/cmd/system",e.data={cmd:"restore"},this._saveSetting(e)},pollServer:function(){var e=this;t.$.getJSON("/status").done(function(t){"ok"===t.meta.rc&&t.meta.up?e.set("up",t.meta.up):window.setTimeout(function(){e.pollServer()},1500)}).fail(function(){window.setTimeout(function(){e.pollServer()},1500)})},initialize:function(){e.bindAll(this,"cmdInstalled","cmdAdopt","cmdSiteMgr","setCountry","setTimezone","addWlanConf")},sync:function(e){var t=e.success,i=this;return this.cmdSiteMgr(e).then(this.addWlanConf).then(this.cmdAdopt).then(this.setCountry).then(this.setTimezone).then(this.cmdInstalled).done(function(){t?t(i,null,e):window.location.href="/login"})}})}),define("wizard",["jquery","backbone","unifi/view/wizard/ChromeView","unifi/model/WizardModel","foundation"],function(e,t,i,n){"use strict";e(function(){e(document).foundation();var t=new n,s=new i({model:t});t.fetch({wait:!0}).done(function(){s.render()})})});