/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.Extension;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.ManageAddOnsDialog;

class AddOnDependencyChecker {
    private final AddOnCollection installedAddOns;
    private final AddOnCollection availableAddOns;

    public AddOnDependencyChecker(AddOnCollection addOnCollection, AddOnCollection addOnCollection2) {
        this.installedAddOns = addOnCollection;
        this.availableAddOns = addOnCollection2;
    }

    private static boolean contains(Collection<AddOn> collection, AddOn addOn) {
        for (AddOn addOn2 : collection) {
            if (!addOn.isSameAddOn(addOn2)) continue;
            return true;
        }
        return false;
    }

    public AddOnChangesResult calculateInstallChanges(AddOn addOn) {
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        hashSet.add(addOn);
        return this.calculateInstallChanges(hashSet);
    }

    public AddOnChangesResult calculateInstallChanges(Set<AddOn> set) {
        return this.calculateChanges(set, false);
    }

    public boolean confirmInstallChanges(Component component, AddOnChangesResult addOnChangesResult) {
        return this.confirmChanges(component, addOnChangesResult, false);
    }

    private boolean addDependencies(AddOn addOn, Set<AddOn> set, Set<AddOn> set2, Set<AddOn> set3, Set<AddOn> set4) {
        AddOn.AddOnRunRequirements addOnRunRequirements = addOn.calculateRunRequirements(this.availableAddOns.getAddOns());
        for (AddOn addOn2 : addOnRunRequirements.getDependencies()) {
            if (set.contains(addOn2)) continue;
            AddOn addOn3 = this.installedAddOns.getAddOn(addOn2.getId());
            if (addOn3 == null) {
                if (AddOn.InstallationStatus.AVAILABLE != this.availableAddOns.getAddOn(addOn2.getId()).getInstallationStatus()) continue;
                set4.add(addOn2);
                continue;
            }
            if (addOn.dependsOn(addOn3) || AddOn.InstallationStatus.AVAILABLE != this.availableAddOns.getAddOn(addOn2.getId()).getInstallationStatus()) continue;
            set2.add(addOn3);
            set3.add(addOn2);
        }
        return addOnRunRequirements.isNewerJavaVersionRequired();
    }

    private boolean confirmChanges(Component component, AddOnChangesResult addOnChangesResult, boolean bl) {
        boolean bl2;
        Serializable serializable;
        AddOnTableModel addOnTableModel;
        Object object;
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        for (AddOn object22 : addOnChangesResult.getSelectedAddOns()) {
            if (object22.canRunInCurrentJavaVersion()) continue;
            hashSet.add(object22);
        }
        HashSet<AddOn> hashSet2 = new HashSet<AddOn>(addOnChangesResult.getInstalls());
        HashSet<AddOn> hashSet3 = new HashSet<AddOn>(addOnChangesResult.getNewVersions());
        Set<AddOn> set = this.getDependents(hashSet3, addOnChangesResult.getUninstalls());
        if (bl) {
            object = Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUpdate");
            hashSet3.removeAll(addOnChangesResult.getSelectedAddOns());
        } else {
            object = Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithInstallation");
            hashSet2.removeAll(addOnChangesResult.getSelectedAddOns());
        }
        if (addOnChangesResult.getUninstalls().isEmpty() && hashSet3.isEmpty() && hashSet2.isEmpty() && set.isEmpty() && addOnChangesResult.getOptionalAddOns().isEmpty() && addOnChangesResult.getSoftUnloadExtensions().isEmpty() && addOnChangesResult.getUnloadExtensions().isEmpty()) {
            if (hashSet.isEmpty()) {
                return true;
            }
            int jPanel = addOnChangesResult.getSelectedAddOns().size();
            if (jPanel == 1) {
                String string = MessageFormat.format(Constant.messages.getString("cfu.confirmation.dialogue.message.selectedAddOnNewerJavaVersion"), addOnChangesResult.getSelectedAddOns().iterator().next().getMinimumJavaVersion());
                return JOptionPane.showConfirmDialog(component, string + (String)object, "OWASP ZAP", 0) == 0;
            }
            String jTabbedPane = hashSet.size() == jPanel ? Constant.messages.getString("cfu.confirmation.dialogue.message.addOnsNewerJavaVersion") : Constant.messages.getString("cfu.confirmation.dialogue.message.someSelectedAddOnsNewerJavaVersion");
            JLabel n = new JLabel(Constant.messages.getString("cfu.confirmation.dialogue.message.warnAddOnsNotRunJavaVersion"), ManageAddOnsDialog.ICON_ADD_ON_ISSUES, 10);
            Object[] addOnTableModel2 = new Object[]{jTabbedPane, AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(hashSet, hashSet.size())), n, object};
            return JOptionPane.showConfirmDialog(component, addOnTableModel2, "OWASP ZAP", 0) == 0;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add(jTabbedPane);
        int n = hashSet.size();
        if (!hashSet.isEmpty()) {
            jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.selectedAddOns"), AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(hashSet, hashSet.size())));
        }
        if (!addOnChangesResult.getUninstalls().isEmpty()) {
            jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.uninstallations"), AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(addOnChangesResult.getUninstalls(), false)));
        }
        if (!hashSet3.isEmpty()) {
            addOnTableModel = new AddOnTableModel(hashSet3);
            n += addOnTableModel.getMinimumJavaVersionIssues();
            jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.updats"), AddOnDependencyChecker.createScrollableTable(addOnTableModel));
        }
        if (!hashSet2.isEmpty()) {
            addOnTableModel = new AddOnTableModel(hashSet2);
            n += addOnTableModel.getMinimumJavaVersionIssues();
            jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.installations"), AddOnDependencyChecker.createScrollableTable(addOnTableModel));
        }
        if (!set.isEmpty()) {
            addOnTableModel = new AddOnTableModel(set);
            n += addOnTableModel.getMinimumJavaVersionIssues();
            jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.softUninstalls"), AddOnDependencyChecker.createScrollableTable(addOnTableModel));
        }
        addOnTableModel = null;
        if (!addOnChangesResult.getOptionalAddOns().isEmpty()) {
            addOnTableModel = new SelectableAddOnTableModel(addOnChangesResult.getOptionalAddOns());
            n += addOnTableModel.getMinimumJavaVersionIssues();
            jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.optionalAddOns"), AddOnDependencyChecker.createScrollableTable(addOnTableModel));
        }
        if (!addOnChangesResult.getUnloadExtensions().isEmpty()) {
            serializable = new ExtensionsTableModel(addOnChangesResult.getUnloadExtensions());
            jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.extensionUnloads"), AddOnDependencyChecker.createScrollableTable((TableModel)((Object)serializable)));
        }
        if (!addOnChangesResult.getSoftUnloadExtensions().isEmpty()) {
            serializable = new ExtensionsTableModel(addOnChangesResult.getSoftUnloadExtensions());
            jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.extensionSoftUnloads"), AddOnDependencyChecker.createScrollableTable((TableModel)((Object)serializable)));
        }
        serializable = new ArrayList();
        if (!addOnChangesResult.getOptionalAddOns().isEmpty() && addOnChangesResult.getUninstalls().isEmpty() && hashSet3.isEmpty() && hashSet2.isEmpty() && set.isEmpty() && addOnChangesResult.getSoftUnloadExtensions().isEmpty() && addOnChangesResult.getUnloadExtensions().isEmpty()) {
            serializable.add(Constant.messages.getString("cfu.confirmation.dialogue.message.suggestedChanges"));
        } else if (!addOnChangesResult.getOptionalAddOns().isEmpty()) {
            serializable.add(Constant.messages.getString("cfu.confirmation.dialogue.message.requiredSuggestedChanges"));
        } else {
            serializable.add(Constant.messages.getString("cfu.confirmation.dialogue.message.requiredChanges"));
        }
        serializable.add(jPanel);
        if (n != 0) {
            String bl22 = hashSet.size() == n ? (hashSet.size() == addOnChangesResult.getSelectedAddOns().size() ? Constant.messages.getString("cfu.confirmation.dialogue.message.selectedAddOnsNewerJavaVersion") : Constant.messages.getString("cfu.confirmation.dialogue.message.someUnnamedSelectedAddOnsNewerJavaVersion")) : (n == 1 ? Constant.messages.getString("cfu.confirmation.dialogue.message.addOnNewerJavaVersion") : Constant.messages.getString("cfu.confirmation.dialogue.message.someAddOnsNewerJavaVersion"));
            JLabel jLabel = new JLabel(Constant.messages.getString("cfu.confirmation.dialogue.message.warnUnknownNumberAddOnsNotRunJavaVersion"), ManageAddOnsDialog.ICON_ADD_ON_ISSUES, 10);
            serializable.add(bl22);
            serializable.add(jLabel);
        }
        serializable.add(object);
        boolean bl3 = bl2 = JOptionPane.showConfirmDialog(component, serializable.toArray(), "OWASP ZAP", 0) == 0;
        if (bl2 && addOnTableModel != null) {
            addOnChangesResult.getInstalls().addAll(((SelectableAddOnTableModel)addOnTableModel).getSelectedAddOns());
        }
        return bl2;
    }

    private Set<AddOn> getDependents(Set<AddOn> set, Set<AddOn> set2) {
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        for (AddOn addOn : set) {
            this.addDependents(hashSet, addOn, set2);
        }
        return hashSet;
    }

    private void addDependents(Set<AddOn> set, AddOn addOn, Set<AddOn> set2) {
        for (AddOn addOn2 : this.installedAddOns.getInstalledAddOns()) {
            if (set2.contains(addOn2) || !addOn2.dependsOn(addOn) || !set.contains(addOn2)) continue;
            set.add(addOn2);
            this.addDependents(set, addOn2, set2);
        }
    }

    private static JScrollPane createScrollableTable(TableModel tableModel) {
        JXTable jXTable = new JXTable(tableModel);
        jXTable.setColumnControlVisible(true);
        jXTable.setVisibleRowCount(Math.min(tableModel.getRowCount() + 1, 5));
        jXTable.packAll();
        return new JScrollPane((Component)jXTable);
    }

    public AddOnChangesResult calculateUpdateChanges(Set<AddOn> set) {
        return this.calculateChanges(set, true);
    }

    public boolean confirmUpdateChanges(Component component, AddOnChangesResult addOnChangesResult) {
        return this.confirmChanges(component, addOnChangesResult, true);
    }

    private AddOnChangesResult calculateChanges(Set<AddOn> set, boolean bl) {
        Object object;
        HashSet<AddOn> hashSet3 = new HashSet<AddOn>();
        HashSet<AddOn> hashSet4 = new HashSet<AddOn>();
        HashSet<AddOn> hashSet5 = new HashSet<AddOn>();
        HashSet<AddOn> hashSet6 = new HashSet<AddOn>();
        if (bl) {
            for (AddOn hashSet22 : set) {
                AddOn addOn = this.installedAddOns.getAddOn(hashSet22.getId());
                hashSet3.add(addOn);
            }
        }
        boolean bl2 = false;
        for (AddOn addOn : set) {
            bl2 |= this.addDependencies(addOn, set, hashSet3, hashSet5, hashSet6);
        }
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        for (AddOn addOn : this.installedAddOns.getAddOns()) {
            if (AddOnDependencyChecker.contains(set, addOn) || AddOnDependencyChecker.contains(hashSet5, addOn)) continue;
            hashSet.add(addOn);
        }
        HashSet<AddOn> hashSet2 = new HashSet<AddOn>(hashSet);
        hashSet2.addAll(set);
        hashSet2.addAll(hashSet6);
        hashSet2.addAll(hashSet5);
        for (AddOn addOn : hashSet) {
            if (!addOn.calculateRunRequirements(hashSet2).hasDependencyIssue()) continue;
            hashSet4.add(addOn);
        }
        Iterator iterator = hashSet4.iterator();
        while (iterator.hasNext()) {
            AddOn addOn = (AddOn)iterator.next();
            object = this.availableAddOns.getAddOn(addOn.getId());
            if (object == null || ((AddOn)object).equals(addOn)) continue;
            iterator.remove();
            hashSet3.add(addOn);
            hashSet5.add((AddOn)object);
            bl2 |= this.addDependencies((AddOn)object, set, hashSet3, hashSet5, hashSet6);
        }
        Iterator iterator2 = hashSet4.iterator();
        while (iterator2.hasNext()) {
            AddOn addOn = (AddOn)iterator2.next();
            if (!AddOnDependencyChecker.contains(hashSet6, addOn) && !AddOnDependencyChecker.contains(hashSet5, addOn) && (!addOn.calculateRunRequirements(this.installedAddOns.getAddOns()).hasDependencyIssue() || this.containsAny(addOn.getIdsAddOnDependencies(), hashSet4))) continue;
            iterator2.remove();
        }
        if (bl) {
            hashSet5.addAll(set);
        } else {
            hashSet6.addAll(set);
        }
        HashSet<AddOn> hashSet7 = new HashSet<AddOn>(hashSet);
        hashSet7.removeAll(hashSet4);
        hashSet7.removeAll(hashSet3);
        hashSet7.addAll(hashSet6);
        hashSet7.addAll(hashSet5);
        HashSet<Extension> hashSet8 = new HashSet<Extension>();
        HashSet<Extension> hashSet9 = new HashSet<Extension>();
        object = new HashSet();
        for (AddOn addOn : hashSet7) {
            AddOn.ExtensionRunRequirements extensionRunRequirements;
            AddOn.AddOnRunRequirements addOnRunRequirements;
            List<String> list = addOn.getExtensionsWithDeps();
            for (Extension extension : addOn.getLoadedExtensionsWithDeps()) {
                addOnRunRequirements = addOn.calculateExtensionRunRequirements(extension, hashSet7);
                extensionRunRequirements = addOnRunRequirements.getExtensionRequirements().get(0);
                if (!extensionRunRequirements.isRunnable()) {
                    hashSet8.add(extension);
                } else if (CollectionUtils.containsAny(extensionRunRequirements.getDependencies(), hashSet3)) {
                    hashSet9.add(extension);
                }
                list.remove(extensionRunRequirements.getClassname());
            }
            for (String string : list) {
                addOnRunRequirements = addOn.calculateExtensionRunRequirements(string, this.availableAddOns.getAddOns());
                extensionRunRequirements = addOnRunRequirements.getExtensionRequirements().get(0);
                if (!extensionRunRequirements.isRunnable()) continue;
                object.addAll(extensionRunRequirements.getDependencies());
            }
        }
        object.removeAll(hashSet6);
        object.removeAll(hashSet5);
        object.removeAll(hashSet);
        return new AddOnChangesResult(set, hashSet3, hashSet4, hashSet5, hashSet6, bl2, (Set)object, hashSet8, hashSet9);
    }

    public UninstallationResult calculateUninstallChanges(Set<AddOn> set) {
        Object object;
        Object object2;
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>(this.installedAddOns.getAddOns());
        arrayList.removeAll(set);
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        ArrayList<AddOn> arrayList2 = new ArrayList<AddOn>(arrayList);
        while (!arrayList2.isEmpty()) {
            object2 = (AddOn)arrayList2.remove(0);
            object = ((AddOn)object2).calculateRunRequirements(arrayList);
            if (!((AddOn.BaseRunRequirements)object).hasDependencyIssue()) {
                arrayList2.removeAll(((AddOn.BaseRunRequirements)object).getDependencies());
                continue;
            }
            if (AddOn.InstallationStatus.UNINSTALLATION_FAILED == ((AddOn)object2).getInstallationStatus()) continue;
            hashSet.add((AddOn)object2);
        }
        object2 = hashSet.iterator();
        while (object2.hasNext()) {
            object = (AddOn)object2.next();
            if (!((AddOn)object).calculateRunRequirements(this.installedAddOns.getAddOns()).hasDependencyIssue() || this.containsAny(((AddOn)object).getIdsAddOnDependencies(), hashSet)) continue;
            object2.remove();
        }
        arrayList.removeAll(hashSet);
        object2 = new HashSet<Extension>();
        for (AddOn addOn : arrayList) {
            if (!addOn.hasExtensionsWithDeps()) continue;
            for (Extension extension : addOn.getLoadedExtensions()) {
                AddOn.ExtensionRunRequirements extensionRunRequirements;
                AddOn.AddOnRunRequirements addOnRunRequirements = addOn.calculateExtensionRunRequirements(extension, arrayList);
                if (addOnRunRequirements.getExtensionRequirements().isEmpty() || (extensionRunRequirements = addOnRunRequirements.getExtensionRequirements().get(0)).isRunnable()) continue;
                object2.add(extension);
            }
        }
        hashSet.addAll(set);
        return new UninstallationResult(set, hashSet, (Set)object2);
    }

    private boolean containsAny(List<String> list, Collection<AddOn> collection) {
        for (String string : list) {
            for (AddOn addOn : collection) {
                if (!string.equals(addOn.getId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean confirmUninstallChanges(Component component, UninstallationResult uninstallationResult, Set<AddOn> set) {
        HashSet<AddOn> hashSet = new HashSet<AddOn>(uninstallationResult.getUninstallations());
        hashSet.removeAll(uninstallationResult.getSelectedAddOns());
        boolean bl = false;
        for (AddOn object2 : set) {
            if (!this.containsAny(object2.getIdsAddOnDependencies(), hashSet)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            for (AddOn addOn : set) {
                if (!this.containsAny(addOn.getIdsAddOnDependencies(), uninstallationResult.getSelectedAddOns())) continue;
                bl = true;
                break;
            }
        }
        if (bl && JOptionPane.showConfirmDialog(component, new Object[]{Constant.messages.getString("cfu.confirmation.dialogue.message.uninstallsRequiredByAddOnsDownloading"), Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUninstallation")}, "OWASP ZAP", 0) != 0) {
            return false;
        }
        if (hashSet.isEmpty() && uninstallationResult.getExtensions().isEmpty()) {
            return JOptionPane.showConfirmDialog(component, Constant.messages.getString("cfu.uninstall.confirm"), "OWASP ZAP", 0) == 0;
        }
        if (uninstallationResult.getExtensions().isEmpty()) {
            return JOptionPane.showConfirmDialog(component, new Object[]{Constant.messages.getString("cfu.uninstall.dependentAddOns.confirm"), AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(hashSet, false)), Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUninstallation")}, "OWASP ZAP", 0) == 0;
        }
        if (hashSet.isEmpty()) {
            return JOptionPane.showConfirmDialog(component, new Object[]{Constant.messages.getString("cfu.uninstall.dependentExtensions.confirm"), AddOnDependencyChecker.createScrollableTable(new ExtensionsTableModel(uninstallationResult.getExtensions())), Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUninstallation")}, "OWASP ZAP", 0) == 0;
        }
        JPanel jPanel = new JPanel(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        jPanel.add(jTabbedPane);
        jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.uninstallations"), AddOnDependencyChecker.createScrollableTable(new AddOnTableModel(hashSet, false)));
        jTabbedPane.add(Constant.messages.getString("cfu.confirmation.dialogue.tab.header.extensionUnloads"), AddOnDependencyChecker.createScrollableTable(new ExtensionsTableModel(uninstallationResult.getExtensions())));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(Constant.messages.getString("cfu.uninstall.dependentAddonsAndExtensions.confirm"));
        arrayList.add(jPanel);
        arrayList.add(Constant.messages.getString("cfu.confirmation.dialogue.message.continueWithUninstallation"));
        return JOptionPane.showConfirmDialog(component, arrayList.toArray(), "OWASP ZAP", 0) == 0;
    }

    private static class ExtensionsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5446781970087315105L;
        private static final String[] COLUMNS = new String[]{Constant.messages.getString("cfu.generic.table.header.extension")};
        private final List<Extension> extensions;

        public ExtensionsTableModel(Collection<Extension> collection) {
            this.extensions = new ArrayList<Extension>(collection);
        }

        @Override
        public String getColumnName(int n) {
            return COLUMNS[n];
        }

        @Override
        public int getColumnCount() {
            return COLUMNS.length;
        }

        @Override
        public int getRowCount() {
            return this.extensions.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Extension extension = this.extensions.get(n);
            switch (n2) {
                case 0: {
                    return extension.getName();
                }
            }
            return "";
        }
    }

    private static class SelectableAddOnTableModel
    extends AddOnTableModel {
        private static final long serialVersionUID = 2337381848530495407L;
        private final Boolean[] selections;

        public SelectableAddOnTableModel(Collection<AddOn> collection) {
            super(collection, true);
            this.selections = new Boolean[collection.size()];
            for (int i = 0; i < this.selections.length; ++i) {
                this.selections[i] = Boolean.FALSE;
            }
        }

        @Override
        public String getColumnName(int n) {
            if (n == 0) {
                return "";
            }
            return super.getColumnName(n - 1);
        }

        @Override
        public int getColumnCount() {
            return super.getColumnCount() + 1;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return super.getColumnClass(n - 1);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return this.selections[n];
            }
            return super.getValueAt(n, n2 - 1);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0 && object instanceof Boolean) {
                this.selections[n] = (Boolean)object;
                this.fireTableCellUpdated(n, n2);
            }
        }

        public List<AddOn> getSelectedAddOns() {
            ArrayList<AddOn> arrayList = new ArrayList<AddOn>(this.selections.length);
            for (int i = 0; i < this.selections.length; ++i) {
                if (!this.selections[i].booleanValue()) continue;
                arrayList.add(this.getAddOn(i));
            }
            return arrayList;
        }
    }

    private static class AddOnTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 5446781970087315105L;
        private static final String[] COLUMNS = new String[]{Constant.messages.getString("cfu.generic.table.header.addOn"), Constant.messages.getString("cfu.generic.table.header.version"), Constant.messages.getString("cfu.generic.table.header.minimumJavaVersion")};
        private final List<AddOn> addOns;
        private final int columnCount;
        private final int issues;

        public AddOnTableModel(Collection<AddOn> collection) {
            this(collection, true);
        }

        public AddOnTableModel(Collection<AddOn> collection, boolean bl) {
            this.addOns = new ArrayList<AddOn>(collection);
            int n = 0;
            if (bl) {
                for (AddOn addOn : collection) {
                    if (addOn.canRunInCurrentJavaVersion()) continue;
                    ++n;
                }
            }
            this.issues = n;
            this.columnCount = this.issues != 0 ? COLUMNS.length : COLUMNS.length - 1;
        }

        public AddOnTableModel(Collection<AddOn> collection, int n) {
            this.addOns = new ArrayList<AddOn>(collection);
            this.issues = n;
            this.columnCount = n != 0 ? COLUMNS.length : COLUMNS.length - 1;
        }

        public int getMinimumJavaVersionIssues() {
            return this.issues;
        }

        @Override
        public String getColumnName(int n) {
            return COLUMNS[n];
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public int getRowCount() {
            return this.addOns.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            AddOn addOn = this.getAddOn(n);
            switch (n2) {
                case 0: {
                    return addOn.getName();
                }
                case 1: {
                    return addOn.getFileVersion();
                }
                case 2: {
                    return addOn.getMinimumJavaVersion();
                }
            }
            return "";
        }

        protected AddOn getAddOn(int n) {
            return this.addOns.get(n);
        }
    }

    public static class UninstallationResult {
        private final Set<AddOn> selectedAddOns;
        private final Set<AddOn> uninstallations;
        private final Set<Extension> extensions;

        private UninstallationResult(Set<AddOn> set, Set<AddOn> set2, Set<Extension> set3) {
            this.selectedAddOns = set;
            this.uninstallations = set2;
            this.extensions = set3;
        }

        public Set<AddOn> getSelectedAddOns() {
            return this.selectedAddOns;
        }

        public Set<AddOn> getUninstallations() {
            return this.uninstallations;
        }

        public Set<Extension> getExtensions() {
            return this.extensions;
        }
    }

    public static class AddOnChangesResult {
        private final Set<AddOn> selectedAddOns;
        private final Set<AddOn> oldVersions;
        private final Set<AddOn> uninstalls;
        private final Set<AddOn> newVersions;
        private final Set<AddOn> installs;
        private final boolean newerJavaVersion;
        private final Set<AddOn> optionalAddOns;
        private final Set<Extension> unloadExtensions;
        private final Set<Extension> softUnloadExtensions;

        private AddOnChangesResult(Set<AddOn> set, Set<AddOn> set2, Set<AddOn> set3, Set<AddOn> set4, Set<AddOn> set5, boolean bl, Set<AddOn> set6, Set<Extension> set7, Set<Extension> set8) {
            this.selectedAddOns = set;
            this.oldVersions = set2;
            this.uninstalls = set3;
            this.newVersions = set4;
            this.installs = set5;
            this.newerJavaVersion = bl;
            this.optionalAddOns = set6;
            this.unloadExtensions = set7;
            this.softUnloadExtensions = set8;
        }

        public Set<AddOn> getSelectedAddOns() {
            return this.selectedAddOns;
        }

        public Set<AddOn> getOldVersions() {
            return this.oldVersions;
        }

        public Set<AddOn> getUninstalls() {
            return this.uninstalls;
        }

        public Set<AddOn> getNewVersions() {
            return this.newVersions;
        }

        public Set<AddOn> getInstalls() {
            return this.installs;
        }

        public boolean isNewerJavaVersionRequired() {
            return this.newerJavaVersion;
        }

        public Set<AddOn> getOptionalAddOns() {
            return this.optionalAddOns;
        }

        public Set<Extension> getUnloadExtensions() {
            return this.unloadExtensions;
        }

        public Set<Extension> getSoftUnloadExtensions() {
            return this.softUnloadExtensions;
        }
    }
}

