/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiDynamicActionImplementor;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseElement;
import org.zaproxy.zap.extension.api.ApiResponseList;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.authentication.ExtensionAuthentication;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.ApiUtils;

public class UsersAPI
extends ApiImplementor {
    private static final Logger log = Logger.getLogger(UsersAPI.class);
    private static final String PREFIX = "users";
    private static final String VIEW_USERS_LIST = "usersList";
    private static final String VIEW_GET_USER_BY_ID = "getUserById";
    private static final String VIEW_GET_AUTH_CREDENTIALS = "getAuthenticationCredentials";
    private static final String VIEW_GET_AUTH_CREDENTIALS_CONFIG_PARAMETERS = "getAuthenticationCredentialsConfigParams";
    private static final String ACTION_NEW_USER = "newUser";
    private static final String ACTION_REMOVE_USER = "removeUser";
    private static final String ACTION_SET_ENABLED = "setUserEnabled";
    private static final String ACTION_SET_NAME = "setUserName";
    private static final String ACTION_SET_AUTH_CREDENTIALS = "setAuthenticationCredentials";
    public static final String PARAM_CONTEXT_ID = "contextId";
    public static final String PARAM_USER_ID = "userId";
    private static final String PARAM_USER_NAME = "name";
    private static final String PARAM_ENABLED = "enabled";
    private static final String PARAM_CREDENTIALS_CONFIG_PARAMS = "authCredentialsConfigParams";
    private ExtensionUserManagement extension;
    private Map<Integer, ApiDynamicActionImplementor> loadedAuthenticationMethodActions;

    public UsersAPI(ExtensionUserManagement extensionUserManagement) {
        this.extension = extensionUserManagement;
        this.addApiView(new ApiView(VIEW_USERS_LIST, null, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_USER_BY_ID, null, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiView(new ApiView(VIEW_GET_AUTH_CREDENTIALS_CONFIG_PARAMETERS, new String[]{PARAM_CONTEXT_ID}));
        this.addApiView(new ApiView(VIEW_GET_AUTH_CREDENTIALS, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_NEW_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_NAME}));
        this.addApiAction(new ApiAction(ACTION_REMOVE_USER, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}));
        this.addApiAction(new ApiAction(ACTION_SET_ENABLED, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID, PARAM_ENABLED}));
        this.addApiAction(new ApiAction(ACTION_SET_NAME, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID, PARAM_USER_NAME}));
        this.addApiAction(new ApiAction(ACTION_SET_AUTH_CREDENTIALS, new String[]{PARAM_CONTEXT_ID, PARAM_USER_ID}, new String[]{PARAM_CREDENTIALS_CONFIG_PARAMS}));
        if (Control.getSingleton() != null) {
            ExtensionAuthentication extensionAuthentication = (ExtensionAuthentication)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAuthentication");
            this.loadedAuthenticationMethodActions = new HashMap<Integer, ApiDynamicActionImplementor>();
            if (extensionAuthentication != null) {
                for (AuthenticationMethodType authenticationMethodType : extensionAuthentication.getAuthenticationMethodTypes()) {
                    ApiDynamicActionImplementor apiDynamicActionImplementor = authenticationMethodType.getSetCredentialsForUserApiAction();
                    if (apiDynamicActionImplementor == null) continue;
                    this.loadedAuthenticationMethodActions.put(authenticationMethodType.getUniqueIdentifier(), apiDynamicActionImplementor);
                }
            }
        }
    }

    @Override
    public String getPrefix() {
        return PREFIX;
    }

    @Override
    public ApiResponse handleApiView(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiView " + string + " " + jSONObject.toString()));
        switch (string) {
            case "usersList": {
                List<Object> list;
                ApiResponseList apiResponseList = new ApiResponseList(string);
                if (this.hasContextId(jSONObject)) {
                    list = this.extension.getContextUserAuthManager(this.getContextId(jSONObject)).getUsers();
                } else {
                    list = new ArrayList();
                    for (Context object : Model.getSingleton().getSession().getContexts()) {
                        list.addAll(this.extension.getContextUserAuthManager(object.getIndex()).getUsers());
                    }
                }
                for (User user : list) {
                    apiResponseList.addItem(this.buildResponseFromUser(user));
                }
                return apiResponseList;
            }
            case "getUserById": {
                return this.buildResponseFromUser(this.getUser(jSONObject));
            }
            case "getAuthenticationCredentials": {
                return this.getUser(jSONObject).getAuthenticationCredentials().getApiResponseRepresentation();
            }
            case "getAuthenticationCredentialsConfigParams": {
                AuthenticationMethodType authenticationMethodType = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID).getAuthenticationMethod().getType();
                ApiDynamicActionImplementor apiDynamicActionImplementor = this.loadedAuthenticationMethodActions.get(authenticationMethodType.getUniqueIdentifier());
                return apiDynamicActionImplementor.buildParamsDescription();
            }
        }
        throw new ApiException(ApiException.Type.BAD_VIEW);
    }

    @Override
    public ApiResponse handleApiAction(String string, JSONObject jSONObject) throws ApiException {
        log.debug((Object)("handleApiAction " + string + " " + jSONObject.toString()));
        switch (string) {
            case "newUser": {
                Context context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                String string2 = ApiUtils.getNonEmptyStringParam(jSONObject, PARAM_USER_NAME);
                User user = new User(context.getIndex(), string2);
                user.setAuthenticationCredentials(context.getAuthenticationMethod().createAuthenticationCredentials());
                this.extension.getContextUserAuthManager(context.getIndex()).addUser(user);
                return new ApiResponseElement(PARAM_USER_ID, String.valueOf(user.getId()));
            }
            case "removeUser": {
                int n = ApiUtils.getIntParam(jSONObject, PARAM_CONTEXT_ID);
                int n2 = ApiUtils.getIntParam(jSONObject, PARAM_USER_ID);
                boolean bl = this.extension.getContextUserAuthManager(n).removeUserById(n2);
                if (bl) {
                    return ApiResponseElement.OK;
                }
                return ApiResponseElement.FAIL;
            }
            case "setUserEnabled": {
                boolean bl = false;
                try {
                    bl = jSONObject.getBoolean(PARAM_ENABLED);
                }
                catch (JSONException jSONException) {
                    throw new ApiException(ApiException.Type.ILLEGAL_PARAMETER, "enabled - should be boolean");
                }
                this.getUser(jSONObject).setEnabled(bl);
                return ApiResponseElement.OK;
            }
            case "setUserName": {
                String string3 = jSONObject.getString(PARAM_USER_NAME);
                if (string3 == null || string3.isEmpty()) {
                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, PARAM_USER_NAME);
                }
                this.getUser(jSONObject).setName(string3);
                return ApiResponseElement.OK;
            }
            case "setAuthenticationCredentials": {
                JSONObject jSONObject2 = jSONObject.has(PARAM_CREDENTIALS_CONFIG_PARAMS) ? API.getParams(jSONObject.getString(PARAM_CREDENTIALS_CONFIG_PARAMS)) : new JSONObject();
                Context context = ApiUtils.getContextByParamId(jSONObject, PARAM_CONTEXT_ID);
                jSONObject2.put((Object)PARAM_CONTEXT_ID, (Object)context.getIndex());
                jSONObject2.put((Object)PARAM_USER_ID, (Object)this.getUserId(jSONObject));
                ApiDynamicActionImplementor apiDynamicActionImplementor = this.loadedAuthenticationMethodActions.get(context.getAuthenticationMethod().getType().getUniqueIdentifier());
                apiDynamicActionImplementor.handleAction(jSONObject2);
                return ApiResponseElement.OK;
            }
        }
        throw new ApiException(ApiException.Type.BAD_ACTION);
    }

    private ApiResponse buildResponseFromUser(User user) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(PARAM_USER_NAME, user.getName());
        hashMap.put("id", Integer.toString(user.getId()));
        hashMap.put(PARAM_CONTEXT_ID, Integer.toString(user.getContextId()));
        hashMap.put(PARAM_ENABLED, Boolean.toString(user.isEnabled()));
        hashMap.put("credentials", user.getAuthenticationCredentials().getApiResponseRepresentation().toJSON().toString());
        ApiResponseSet apiResponseSet = new ApiResponseSet("user", hashMap);
        return apiResponseSet;
    }

    private int getUserId(JSONObject jSONObject) throws ApiException {
        return ApiUtils.getIntParam(jSONObject, PARAM_USER_ID);
    }

    private User getUser(JSONObject jSONObject) throws ApiException {
        int n = this.getContextId(jSONObject);
        int n2 = this.getUserId(jSONObject);
        User user = this.extension.getContextUserAuthManager(n).getUserById(n2);
        if (user == null) {
            throw new ApiException(ApiException.Type.USER_NOT_FOUND, PARAM_USER_ID);
        }
        return user;
    }

    private int getContextId(JSONObject jSONObject) throws ApiException {
        return ApiUtils.getIntParam(jSONObject, PARAM_CONTEXT_ID);
    }

    private boolean hasContextId(JSONObject jSONObject) {
        try {
            jSONObject.getInt(PARAM_CONTEXT_ID);
        }
        catch (JSONException jSONException) {
            return false;
        }
        return true;
    }
}

