/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.tools;

import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.instrument.InstrumentationTool;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeListener;
import com.oracle.truffle.api.instrument.StandardSyntaxTag;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.instrument.impl.DefaultProbeListener;
import com.oracle.truffle.api.instrument.impl.DefaultSimpleInstrumentListener;
import com.oracle.truffle.api.source.LineLocation;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.source.SourceTag;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public final class CoverageTracker
extends InstrumentationTool {
    private final Map<LineLocation, CoverageRecord> coverageMap = new HashMap<LineLocation, CoverageRecord>();
    private final List<Instrument> instruments = new ArrayList<Instrument>();
    private final SyntaxTag countingTag;
    private final ProbeListener probeListener = new CoverageProbeListener();

    public CoverageTracker() {
        this(StandardSyntaxTag.STATEMENT);
    }

    public CoverageTracker(SyntaxTag tag) {
        this.countingTag = tag;
    }

    @Override
    protected boolean internalInstall() {
        Probe.addProbeListener(this.probeListener);
        return true;
    }

    @Override
    protected void internalReset() {
        this.coverageMap.clear();
    }

    @Override
    protected void internalDispose() {
        Probe.removeProbeListener(this.probeListener);
        for (Instrument instrument : this.instruments) {
            instrument.dispose();
        }
    }

    public Map<Source, Long[]> getCounts() {
        TreeSet<Map.Entry<LineLocation, CoverageRecord>> entries = new TreeSet<Map.Entry<LineLocation, CoverageRecord>>(new LineLocationEntryComparator());
        for (Map.Entry<LineLocation, CoverageRecord> entry : this.coverageMap.entrySet()) {
            entries.add(entry);
        }
        HashMap<Source, Long[]> result = new HashMap<Source, Long[]>();
        Source curSource = null;
        Long[] curLineTable = null;
        for (Map.Entry<LineLocation, CoverageRecord> entry : entries) {
            LineLocation key = entry.getKey();
            Source source = key.getSource();
            int lineNo = key.getLineNumber();
            if (source != curSource) {
                if (curSource != null) {
                    result.put(curSource, curLineTable);
                }
                curSource = source;
                curLineTable = new Long[source.getLineCount()];
            }
            curLineTable[lineNo - 1] = entry.getValue().count;
        }
        if (curSource != null) {
            result.put(curSource, curLineTable);
        }
        return result;
    }

    public void print(PrintStream out) {
        out.println();
        out.println(String.valueOf(this.countingTag.name()) + " coverage:");
        TreeSet<Map.Entry<LineLocation, CoverageRecord>> entries = new TreeSet<Map.Entry<LineLocation, CoverageRecord>>(new LineLocationEntryComparator());
        for (Map.Entry<LineLocation, CoverageRecord> entry : this.coverageMap.entrySet()) {
            entries.add(entry);
        }
        Source curSource = null;
        int curLineNo = 1;
        for (Map.Entry<LineLocation, CoverageRecord> entry : entries) {
            LineLocation key = entry.getKey();
            Source source = key.getSource();
            int lineNo = key.getLineNumber();
            if (source != curSource) {
                if (curSource != null) {
                    while (curLineNo <= curSource.getLineCount()) {
                        CoverageTracker.displayLine(out, null, curSource, curLineNo++);
                    }
                }
                curSource = source;
                curLineNo = 1;
                out.println();
                out.println(source.getPath());
            }
            while (curLineNo < lineNo) {
                CoverageTracker.displayLine(out, null, curSource, curLineNo++);
            }
            CoverageTracker.displayLine(out, entry.getValue(), curSource, curLineNo++);
        }
        if (curSource != null) {
            while (curLineNo <= curSource.getLineCount()) {
                CoverageTracker.displayLine(out, null, curSource, curLineNo++);
            }
        }
    }

    private static void displayLine(PrintStream out, CoverageRecord record, Source source, int lineNo) {
        if (record == null) {
            out.format("%14s", " ");
        } else {
            out.format("(%12d)", record.count);
        }
        out.format(" %3d: ", lineNo);
        out.println(source.getCode(lineNo));
    }

    private class CoverageProbeListener
    extends DefaultProbeListener {
        private CoverageProbeListener() {
        }

        @Override
        public void probeTaggedAs(Probe probe, SyntaxTag tag, Object tagValue) {
            SourceSection srcSection;
            if (CoverageTracker.this.countingTag == tag && (srcSection = probe.getProbedSourceSection()) != null && !srcSection.getSource().isTaggedAs(Tags.NO_COVERAGE)) {
                LineLocation lineLocation = srcSection.getLineLocation();
                CoverageRecord record = (CoverageRecord)CoverageTracker.this.coverageMap.get(lineLocation);
                if (record != null) {
                    if (srcSection.getCharIndex() > record.srcSection.getCharIndex()) {
                        return;
                    }
                    record.instrument.dispose();
                }
                CoverageRecord coverage = new CoverageRecord(srcSection);
                Instrument instrument = Instrument.create(coverage, CoverageTracker.class.getSimpleName());
                coverage.instrument = instrument;
                CoverageTracker.this.instruments.add(instrument);
                probe.attach(instrument);
                CoverageTracker.this.coverageMap.put(lineLocation, coverage);
            }
        }
    }

    private final class CoverageRecord
    extends DefaultSimpleInstrumentListener {
        private final SourceSection srcSection;
        private Instrument instrument;
        private long count = 0L;

        CoverageRecord(SourceSection srcSection) {
            this.srcSection = srcSection;
        }

        @Override
        public void enter(Probe probe) {
            if (CoverageTracker.this.isEnabled()) {
                ++this.count;
            }
        }
    }

    private static final class LineLocationEntryComparator
    implements Comparator<Map.Entry<LineLocation, CoverageRecord>> {
        private LineLocationEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<LineLocation, CoverageRecord> e1, Map.Entry<LineLocation, CoverageRecord> e2) {
            return LineLocation.COMPARATOR.compare(e1.getKey(), e2.getKey());
        }
    }

    public static enum Tags implements SourceTag
    {
        NO_COVERAGE("No Coverage", "Coverage Tracker will igore");

        private final String name;
        private final String description;

        private Tags(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

