/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.interop.messages;

import com.oracle.truffle.api.interop.messages.Message;
import com.oracle.truffle.interop.messages.MessageUtil;
import com.oracle.truffle.interop.messages.Receiver;

public final class Execute
implements Message {
    private final Object receiver;
    private final int arity;

    public static Execute create(Receiver receiver, int arity) {
        return new Execute(receiver, arity);
    }

    public static Execute create(Message receiver, int arity) {
        return new Execute(receiver, arity);
    }

    private Execute(Object receiver, int arity) {
        this.receiver = receiver;
        this.arity = arity;
    }

    public Object getReceiver() {
        return this.receiver;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    public boolean matchStructure(Object message) {
        if (!(message instanceof Execute)) {
            return false;
        }
        Execute m1 = this;
        Execute m2 = (Execute)message;
        return MessageUtil.compareMessage(m1.getReceiver(), m2.getReceiver());
    }

    public String toString() {
        return String.format("Execute(%s)", this.receiver.toString());
    }
}

