/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;

@NodeChild(value="child")
public abstract class HashCastNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toHashNode;

    public HashCastNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toHashNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
    }

    protected abstract RubyNode getChild();

    @Specialization
    public DynamicObject cast(boolean value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(int value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(long value) {
        return this.nil();
    }

    @Specialization
    public DynamicObject cast(double value) {
        return this.nil();
    }

    @Specialization(guards={"isNil(nil)"})
    public DynamicObject castNil(DynamicObject nil) {
        return this.nil();
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public DynamicObject castBignum(DynamicObject value) {
        return this.nil();
    }

    @Specialization(guards={"isRubyHash(hash)"})
    public DynamicObject castHash(DynamicObject hash) {
        return hash;
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubyHash(object)"})
    public Object cast(VirtualFrame frame, DynamicObject object) {
        Object result = this.toHashNode.call(frame, object, "to_hash", null, new Object[0]);
        if (result == DispatchNode.MISSING) {
            return this.nil();
        }
        if (!RubyGuards.isRubyHash(result)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertTo(object, "Hash", "to_hash", result, this));
        }
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.getChild().executeVoid(frame);
    }
}

