/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.ja.tokenAttributes.BasicFormAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;

public final class JapaneseBasicFormFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final BasicFormAttribute basicFormAtt = (BasicFormAttribute)this.addAttribute(BasicFormAttribute.class);
    private final KeywordAttribute keywordAtt = (KeywordAttribute)this.addAttribute(KeywordAttribute.class);

    public JapaneseBasicFormFilter(TokenStream input) {
        super(input);
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String basicForm;
            if (!this.keywordAtt.isKeyword() && (basicForm = this.basicFormAtt.getBasicForm()) != null && !basicForm.equals("*")) {
                this.termAtt.setEmpty().append(this.basicFormAtt.getBasicForm());
            }
            return true;
        }
        return false;
    }
}

