/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.split.components;

import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.SimpleBookmark;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.pdfsam.console.utils.PdfUtility;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.i18n.GettextResource;

public class JBLevelCombo
extends JPanel {
    private static final long serialVersionUID = -1413124292303614507L;
    private static final Logger LOG = Logger.getLogger((String)JBLevelCombo.class.getPackage().getName());
    private JComboBox levelCombo;
    private JButton fillCombo;
    private JPdfSelectionPanel inputPanel;
    private Thread filler = null;

    public JBLevelCombo(JPdfSelectionPanel inputPanel) {
        this.inputPanel = inputPanel;
        this.init();
    }

    private void init() {
        this.levelCombo = new JComboBox();
        this.levelCombo.setPreferredSize(new Dimension(45, 20));
        this.fillCombo = new JButton();
        this.fillCombo.setText("< " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Fill from document"));
        this.levelCombo.setEditable(true);
        this.fillCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PdfSelectionTableItem[] items = JBLevelCombo.this.inputPanel.getTableRows();
                    if (items != null && items.length == 1) {
                        if (JBLevelCombo.this.filler == null) {
                            JBLevelCombo.this.filler = new Thread(new FillThread(items[0]));
                            JBLevelCombo.this.filler.start();
                        }
                    } else {
                        JOptionPane.showMessageDialog(JBLevelCombo.this.getParent(), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Please select a pdf document."), GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Warning"), 2);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
                }
            }
        });
        this.setLayout(new BoxLayout(this, 2));
        this.add(Box.createHorizontalGlue());
        this.add(this.levelCombo);
        this.add(Box.createRigidArea(new Dimension(10, 0)));
        this.add(this.fillCombo);
    }

    public void resetComponent() {
        this.levelCombo.removeAllItems();
        this.setEnabled(this.isEnabled());
    }

    public int getSelectedIndex() {
        return this.levelCombo.getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.levelCombo.getSelectedItem();
    }

    public void removeAllItems() {
        this.levelCombo.removeAllItems();
    }

    public void setSelectedItem(Object anObject) {
        this.levelCombo.setSelectedItem(anObject);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.levelCombo.setEnabled(enabled);
        this.fillCombo.setEnabled(enabled);
    }

    public JComboBox getLevelCombo() {
        return this.levelCombo;
    }

    public JButton getFillCombo() {
        return this.fillCombo;
    }

    public void requestFocus() {
        this.levelCombo.requestFocus();
    }

    private class FillThread
    implements Runnable {
        private PdfSelectionTableItem item;

        public FillThread(PdfSelectionTableItem item) {
            this.item = item;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            JBLevelCombo.this.fillCombo.setEnabled(false);
            JBLevelCombo.this.levelCombo.setEnabled(false);
            JBLevelCombo.this.fillCombo.setToolTipText(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Getting bookmarks max depth"));
            try {
                JBLevelCombo.this.levelCombo.removeAllItems();
                byte[] password = null;
                if (this.item.getPassword() != null && this.item.getPassword().length() > 0) {
                    password = this.item.getPassword().getBytes();
                }
                PdfReader pdfReader = new PdfReader(new RandomAccessFileOrArray(this.item.getInputFile().getAbsolutePath()), password);
                pdfReader.consolidateNamedDestinations();
                List bookmarks = SimpleBookmark.getBookmark((PdfReader)pdfReader);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                SimpleBookmark.exportToXML((List)bookmarks, (OutputStream)out, (String)"UTF-8", (boolean)false);
                ByteArrayInputStream input = new ByteArrayInputStream(out.toByteArray());
                int maxDepth = PdfUtility.getMaxBookmarksDepth((InputStream)input);
                for (int i = 1; i <= maxDepth; ++i) {
                    JBLevelCombo.this.levelCombo.addItem(i + "");
                }
            }
            catch (Throwable t) {
                LOG.error((Object)GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to retrieve bookmarks maximum depth."), t);
            }
            finally {
                JBLevelCombo.this.fillCombo.setEnabled(true);
                JBLevelCombo.this.levelCombo.setEnabled(true);
                JBLevelCombo.this.fillCombo.setToolTipText(null);
                JBLevelCombo.this.filler = null;
            }
        }
    }
}

