/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.ocsp;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.CertID;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPUtil;

public class CertificateID {
    public static final String HASH_SHA1 = "1.3.14.3.2.26";
    private CertID id;

    public CertificateID(CertID certID) {
        this.id = certID;
    }

    public CertificateID(String string, X509Certificate x509Certificate, BigInteger bigInteger, String string2) throws OCSPException {
        try {
            MessageDigest messageDigest = OCSPUtil.createDigestInstance(string, string2);
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(string), new DERNull());
            X509Principal x509Principal = PrincipalUtil.getSubjectX509Principal(x509Certificate);
            messageDigest.update(x509Principal.getEncoded());
            DEROctetString dEROctetString = new DEROctetString(messageDigest.digest());
            PublicKey publicKey = x509Certificate.getPublicKey();
            ASN1InputStream aSN1InputStream = new ASN1InputStream(publicKey.getEncoded());
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            messageDigest.update(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            DEROctetString dEROctetString2 = new DEROctetString(messageDigest.digest());
            DERInteger dERInteger = new DERInteger(bigInteger);
            this.id = new CertID(algorithmIdentifier, dEROctetString, dEROctetString2, dERInteger);
        }
        catch (Exception exception) {
            throw new OCSPException("problem creating ID: " + exception, exception);
        }
    }

    public CertificateID(String string, X509Certificate x509Certificate, BigInteger bigInteger) throws OCSPException {
        this(string, x509Certificate, bigInteger, "BC");
    }

    public String getHashAlgOID() {
        return this.id.getHashAlgorithm().getObjectId().getId();
    }

    public byte[] getIssuerNameHash() {
        return this.id.getIssuerNameHash().getOctets();
    }

    public byte[] getIssuerKeyHash() {
        return this.id.getIssuerKeyHash().getOctets();
    }

    public BigInteger getSerialNumber() {
        return this.id.getSerialNumber().getValue();
    }

    public CertID toASN1Object() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof CertificateID)) {
            return false;
        }
        CertificateID certificateID = (CertificateID)object;
        return this.id.getDERObject().equals(certificateID.id.getDERObject());
    }

    public int hashCode() {
        return this.id.getDERObject().hashCode();
    }
}

