/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.TransposeDescriptor;
import javax.media.jai.operator.TransposeType;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class ImageUtility {
    private static final Logger LOG = Logger.getLogger(ImageUtility.class.getPackage().getName());
    private static BufferedImage ERROR_IMAGE = null;
    private static BufferedImage HOURGLASS = null;

    public static BufferedImage rotateImage(Image inputImage, int degrees) {
        BufferedImage retVal = null;
        RenderedOp ri = JAI.create((String)"awtImage", (Object)inputImage);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(ri);
        TransposeType rotOp = null;
        RenderedOp op = null;
        if (degrees == 90) {
            rotOp = TransposeDescriptor.ROTATE_90;
        } else if (degrees == 180) {
            rotOp = TransposeDescriptor.ROTATE_180;
        } else if (degrees == 270) {
            rotOp = TransposeDescriptor.ROTATE_270;
        }
        if (rotOp != null) {
            pb.add(rotOp);
            op = JAI.create((String)"transpose", (ParameterBlock)pb);
        } else {
            pb.add((float)ri.getWidth() / 2.0f);
            pb.add((float)ri.getHeight() / 2.0f);
            pb.add((float)Math.toRadians(degrees));
            pb.add(new InterpolationNearest());
            op = JAI.create((String)"Rotate", (ParameterBlock)pb, null);
        }
        PlanarImage myPlanar = op.createInstance();
        retVal = myPlanar.getAsBufferedImage();
        return retVal;
    }

    public static BufferedImage getErrorImage() {
        try {
            if (ERROR_IMAGE == null) {
                InputStream is = ImageUtility.class.getResourceAsStream("/images/thumbnailerror.png");
                BufferedImage img = ImageIO.read(is);
                is.close();
                ERROR_IMAGE = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                Graphics2D g2d = (Graphics2D)ERROR_IMAGE.getGraphics();
                g2d.drawImage(img, 0, 0, img.getWidth(), img.getHeight(), null);
                g2d.dispose();
            }
        }
        catch (IOException e) {
            LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to create error image."));
        }
        return ERROR_IMAGE;
    }

    public static BufferedImage getHourglassImage() {
        try {
            if (HOURGLASS == null) {
                InputStream is = ImageUtility.class.getResourceAsStream("/images/hourglass.png");
                BufferedImage img = ImageIO.read(is);
                is.close();
                HOURGLASS = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                Graphics2D g2d = (Graphics2D)HOURGLASS.getGraphics();
                g2d.drawImage(img, 0, 0, img.getWidth(), img.getHeight(), null);
                g2d.dispose();
            }
        }
        catch (IOException e) {
            LOG.error(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Unable to create error image."));
        }
        return HOURGLASS;
    }

    public static byte[] toByteArray(BufferedImage o) throws IOException {
        if (o != null) {
            BufferedImage image = o;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ImageIO.write((RenderedImage)image, "jpeg", baos);
            byte[] b = baos.toByteArray();
            return b;
        }
        return new byte[0];
    }

    public static BufferedImage fromByteArray(byte[] imagebytes) throws IOException {
        BufferedImage retVal = null;
        if (imagebytes != null && imagebytes.length > 0) {
            retVal = ImageIO.read(new ByteArrayInputStream(imagebytes));
        }
        return retVal;
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w = img.getWidth();
        int h = img.getHeight();
        do {
            if (w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    static {
        System.setProperty("com.sun.media.jai.disableMediaLib", "true");
    }
}

