/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.content.CSVirtualDevice;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormNode;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDResources;
import java.util.HashSet;
import java.util.Set;

public class DefaultAppearance {
    private PDAcroFormNode node;
    protected COSName fontName;
    protected float fontSize;
    protected float[] nonStrokeColorValues;
    protected PDColorSpace nonStrokeColorSpace;
    protected float[] strokeColorValues;
    protected PDColorSpace strokeColorSpace;

    public DefaultAppearance(PDAcroFormNode pDAcroFormNode) {
        this.node = pDAcroFormNode;
        CSDeviceBasedInterpreter cSDeviceBasedInterpreter = new CSDeviceBasedInterpreter(null, new DefaultAppearanceDevice());
        cSDeviceBasedInterpreter.process(pDAcroFormNode.getDefaultAppearanceContent(), pDAcroFormNode.getAcroForm().getDefaultResources());
    }

    protected COSName addFontResource(PDAcroForm pDAcroForm, PDFont pDFont) {
        COSDictionary cOSDictionary;
        PDResources pDResources = pDAcroForm.getDefaultResources();
        if (pDResources == null) {
            pDResources = (PDResources)PDResources.META.createNew();
            pDAcroForm.setDefaultResources(pDResources);
        }
        if ((cOSDictionary = pDResources.cosGetResources(PDResources.CN_RT_Font)) == null) {
            cOSDictionary = pDResources.cosInitResources(PDResources.CN_RT_Font);
        }
        for (COSName cOSName : cOSDictionary.keySet()) {
            COSObject cOSObject = cOSDictionary.get(cOSName);
            if (!cOSObject.equals(pDFont.cosGetObject())) continue;
            return cOSName;
        }
        return pDResources.createFontResource(pDFont);
    }

    protected COSName addFontResource(PDFont pDFont) {
        return this.addFontResource(this.node.getAcroForm(), pDFont);
    }

    protected void cleanupFontResources(PDAcroForm pDAcroForm) {
        Set set = this.getReferencedFontKeys(pDAcroForm);
        HashSet<COSName> hashSet = new HashSet<COSName>();
        COSDictionary cOSDictionary = pDAcroForm.getDefaultResources().cosGetResources(PDResources.CN_RT_Font);
        if (cOSDictionary != null) {
            for (COSName cOSName : cOSDictionary.keySet()) {
                if (set.contains(cOSName)) continue;
                hashSet.add(cOSName);
            }
            for (COSName cOSName : hashSet) {
                cOSDictionary.remove(cOSName);
            }
        }
    }

    protected void collectDefaultAppearanceFonts(PDAcroFormNode pDAcroFormNode, Set set) {
        COSName cOSName = pDAcroFormNode.getDefaultAppearanceFontName();
        if (cOSName != null) {
            set.add(cOSName);
        }
        if (pDAcroFormNode.getGenericChildren() == null) {
            return;
        }
        for (PDAcroFormNode pDAcroFormNode2 : pDAcroFormNode.getGenericChildren()) {
            this.collectDefaultAppearanceFonts(pDAcroFormNode2, set);
        }
    }

    protected void contentReplaceColor(float[] fArray) {
        CSContent cSContent = this.node.getDefaultAppearanceContent();
        CSContent cSContent2 = CSContent.createNew();
        CSOperation cSOperation = null;
        switch (fArray.length) {
            case 1: {
                cSOperation = new CSOperation(CSOperators.CSO_g);
                break;
            }
            case 3: {
                cSOperation = new CSOperation(CSOperators.CSO_rg);
                break;
            }
            case 4: {
                cSOperation = new CSOperation(CSOperators.CSO_k);
            }
        }
        int n = 0;
        while (n < fArray.length) {
            cSOperation.addOperand(COSFixed.create(fArray[n]));
            ++n;
        }
        if (cSContent == null) {
            cSContent2.addOperation(cSOperation);
        } else {
            n = cSContent.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                CSOperation cSOperation2 = cSContent.getOperation(n2);
                if (cSOperation2.matchesOperator(CSOperators.CSO_g) || cSOperation2.matchesOperator(CSOperators.CSO_rg) || cSOperation2.matchesOperator(CSOperators.CSO_k)) {
                    cSContent2.addOperation(cSOperation);
                    bl = true;
                } else {
                    cSContent2.addOperation(cSOperation2);
                }
                ++n2;
            }
            if (!bl) {
                cSContent2.addOperation(cSOperation);
            }
        }
        this.node.setDefaultAppearanceContent(cSContent2);
    }

    protected void contentReplaceFont(COSName cOSName) {
        CSContent cSContent = this.node.getDefaultAppearanceContent();
        CSContent cSContent2 = CSContent.createNew();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tf);
        cSOperation.addOperand(cOSName);
        cSOperation.addOperand(COSInteger.create(0));
        if (cSContent == null) {
            cSContent2.addOperation(cSOperation);
        } else {
            int n = cSContent.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                CSOperation cSOperation2 = cSContent.getOperation(n2);
                if (cSOperation2.matchesOperator(CSOperators.CSO_Tf)) {
                    if (cSOperation2.operandSize() >= 2) {
                        cSOperation.setOperand(1, cSOperation2.getOperand(1));
                    }
                    cSContent2.addOperation(cSOperation);
                    bl = true;
                } else {
                    cSContent2.addOperation(cSOperation2);
                }
                ++n2;
            }
            if (!bl) {
                cSContent2.addOperation(cSOperation);
            }
        }
        this.node.setDefaultAppearanceContent(cSContent2);
    }

    protected void contentReplaceSize(float f) {
        CSContent cSContent = this.node.getDefaultAppearanceContent();
        CSContent cSContent2 = CSContent.createNew();
        CSOperation cSOperation = new CSOperation(CSOperators.CSO_Tf);
        cSOperation.addOperand(COSName.create("Helv"));
        cSOperation.addOperand(COSFixed.create(f));
        if (cSContent == null) {
            cSContent2.addOperation(cSOperation);
        } else {
            int n = cSContent.size();
            boolean bl = false;
            int n2 = 0;
            while (n2 < n) {
                CSOperation cSOperation2 = cSContent.getOperation(n2);
                if (cSOperation2.matchesOperator(CSOperators.CSO_Tf)) {
                    if (cSOperation2.operandSize() >= 1) {
                        cSOperation.setOperand(0, cSOperation2.getOperand(0));
                    }
                    cSContent2.addOperation(cSOperation);
                    bl = true;
                } else {
                    cSContent2.addOperation(cSOperation2);
                }
                ++n2;
            }
            if (!bl) {
                cSContent2.addOperation(cSOperation);
            }
        }
        this.node.setDefaultAppearanceContent(cSContent2);
    }

    public PDFont getFont() {
        PDResources pDResources = this.node.getAcroForm().getDefaultResources();
        if (pDResources == null) {
            return null;
        }
        return PDFontTools.getFont(pDResources, this.getFontName());
    }

    public float[] getFontColorValues() {
        return this.nonStrokeColorValues;
    }

    public COSName getFontName() {
        return this.fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public PDAcroFormNode getNode() {
        return this.node;
    }

    protected Set getReferencedFontKeys(PDAcroForm pDAcroForm) {
        HashSet hashSet = new HashSet();
        this.collectDefaultAppearanceFonts(pDAcroForm, hashSet);
        return hashSet;
    }

    public void setFont(PDFont pDFont) {
        COSName cOSName = this.addFontResource(pDFont);
        this.setFontName(cOSName);
        this.cleanupFontResources(this.node.getAcroForm());
    }

    public void setFontColorValues(float[] fArray) {
        this.contentReplaceColor(fArray);
        this.nonStrokeColorValues = fArray;
    }

    public void setFontName(COSName cOSName) {
        this.contentReplaceFont(cOSName);
        this.fontName = cOSName;
    }

    public void setFontSize(float f) {
        this.contentReplaceSize(f);
        this.fontSize = f;
    }

    public class DefaultAppearanceDevice
    extends CSVirtualDevice {
        @Override
        protected void basicSetNonStrokeColorSpace(PDColorSpace pDColorSpace) {
            DefaultAppearance.this.nonStrokeColorSpace = pDColorSpace;
        }

        @Override
        protected void basicSetNonStrokeColorValues(float[] fArray) {
            DefaultAppearance.this.nonStrokeColorValues = fArray;
        }

        @Override
        protected void basicSetStrokeColorSpace(PDColorSpace pDColorSpace) {
            DefaultAppearance.this.strokeColorSpace = pDColorSpace;
        }

        @Override
        protected void basicSetStrokeColorValues(float[] fArray) {
            DefaultAppearance.this.strokeColorValues = fArray;
        }

        @Override
        public void textSetFont(COSName cOSName, PDFont pDFont, float f) {
            DefaultAppearance.this.fontName = cOSName;
            DefaultAppearance.this.fontSize = f;
        }
    }
}

