/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.dto.commands;

import java.io.File;
import org.pdfsam.console.business.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;

public class SplitParsedCommand
extends AbstractParsedCommand {
    private static final long serialVersionUID = -2409191188152350607L;
    public static final String S_BURST = "BURST";
    public static final String S_SPLIT = "SPLIT";
    public static final String S_NSPLIT = "NSPLIT";
    public static final String S_EVEN = "EVEN";
    public static final String S_ODD = "ODD";
    public static final String S_SIZE = "SIZE";
    public static final String S_BLEVEL = "BLEVEL";
    public static final String F_ARG = "f";
    public static final String P_ARG = "p";
    public static final String S_ARG = "s";
    public static final String N_ARG = "n";
    public static final String B_ARG = "b";
    public static final String O_ARG = "o";
    public static final String BL_ARG = "bl";
    public static final String BREGEXP_ARG = "b_regexp";
    private File outputFile;
    private String outputFilesPrefix = "";
    private PdfFile inputFile;
    private String splitType = "";
    private Integer[] splitPageNumbers = new Integer[0];
    private Long splitSize;
    private Integer bookmarksLevel;
    private String bookmarkRegexp = "";

    public SplitParsedCommand() {
    }

    public SplitParsedCommand(File outputFile, String outputFilesPrefix, PdfFile inputFile, String splitType, Integer[] splitPageNumbers, Long splitSize, Integer bookmarksLevel, String bookmarkRegexp) {
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
        this.inputFile = inputFile;
        this.splitType = splitType;
        this.splitPageNumbers = splitPageNumbers;
        this.splitSize = splitSize;
        this.bookmarksLevel = bookmarksLevel;
        this.bookmarkRegexp = bookmarkRegexp;
    }

    public SplitParsedCommand(File outputFile, String outputFilesPrefix, PdfFile inputFile, String splitType, Integer[] splitPageNumbers, Long splitSize, Integer bookmarksLevel, boolean overwrite, boolean compress, File logFile, char outputPdfVersion) {
        super(overwrite, compress, logFile, outputPdfVersion);
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
        this.inputFile = inputFile;
        this.splitType = splitType;
        this.splitPageNumbers = splitPageNumbers;
        this.splitSize = splitSize;
        this.bookmarksLevel = bookmarksLevel;
    }

    public SplitParsedCommand(File outputFile, String outputFilesPrefix, PdfFile inputFile, String splitType, Integer[] splitPageNumbers, Long splitSize, Integer bookmarksLevel, String bookmarkRegexp, boolean overwrite, boolean compress, char outputPdfVersion) {
        super(overwrite, compress, outputPdfVersion);
        this.outputFile = outputFile;
        this.outputFilesPrefix = outputFilesPrefix;
        this.inputFile = inputFile;
        this.splitType = splitType;
        this.splitPageNumbers = splitPageNumbers;
        this.splitSize = splitSize;
        this.bookmarksLevel = bookmarksLevel;
        this.bookmarkRegexp = bookmarkRegexp;
    }

    public String getOutputFilesPrefix() {
        return this.outputFilesPrefix;
    }

    public void setOutputFilesPrefix(String outputFilesPrefix) {
        this.outputFilesPrefix = outputFilesPrefix;
    }

    public PdfFile getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(PdfFile inputFile) {
        this.inputFile = inputFile;
    }

    public String getSplitType() {
        return this.splitType;
    }

    public void setSplitType(String splitType) {
        this.splitType = splitType;
    }

    public Integer[] getSplitPageNumbers() {
        return this.splitPageNumbers;
    }

    public void setSplitPageNumbers(Integer[] splitPageNumbers) {
        this.splitPageNumbers = splitPageNumbers;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public Long getSplitSize() {
        return this.splitSize;
    }

    public void setSplitSize(Long splitSize) {
        this.splitSize = splitSize;
    }

    public Integer getBookmarksLevel() {
        return this.bookmarksLevel;
    }

    public void setBookmarksLevel(Integer bookmarksLevel) {
        this.bookmarksLevel = bookmarksLevel;
    }

    public String getCommand() {
        return "split";
    }

    public String getBookmarkRegexp() {
        return this.bookmarkRegexp;
    }

    public void setBookmarkRegexp(String bookmarkRegexp) {
        this.bookmarkRegexp = bookmarkRegexp;
    }

    public String toString() {
        StringBuffer retVal = new StringBuffer();
        retVal.append(super.toString());
        retVal.append(this.outputFile == null ? "" : "[outputDir=" + this.outputFile.getAbsolutePath() + "]");
        retVal.append(this.inputFile == null ? "" : "[inputFile=" + this.inputFile + "]");
        retVal.append("[outputFilesPrefix=" + this.outputFilesPrefix + "]");
        retVal.append("[splitType=" + this.splitType + "]");
        retVal.append("[splitSize=" + this.splitSize + "]");
        retVal.append("[bookmarksLevel=" + this.bookmarksLevel + "]");
        retVal.append("[bookmarkRegexp=" + this.bookmarkRegexp + "]");
        if (this.splitPageNumbers != null) {
            for (int i = 0; i < this.splitPageNumbers.length; ++i) {
                retVal.append("[splitPageNumbers[" + i + "]=" + this.splitPageNumbers[i] + "]");
            }
        }
        retVal.append("[command=" + this.getCommand() + "]");
        return retVal.toString();
    }
}

