/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.CountryPrefix;
import esmska.data.SMS;
import esmska.data.event.ActionEventSupport;
import esmska.gui.GatewayMessageFrame;
import esmska.utils.L10N;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.apache.commons.lang.StringUtils;

public abstract class GatewayMessage
extends JPanel {
    public static final int CLOSE_ME = 0;
    protected static final ResourceBundle l10n = L10N.l10nBundle;
    protected ActionEventSupport actionSupport = new ActionEventSupport(this);

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    public abstract void setBestFocus();

    public abstract void cancel();

    protected GatewayMessageFrame.TaskPane wrapAsTaskPane(GatewayMessage gm, String title, Icon icon) {
        GatewayMessageFrame.TaskPane pane = new GatewayMessageFrame.TaskPane(gm);
        pane.setTitle(title);
        pane.setIcon(icon);
        pane.setScrollOnExpand(true);
        pane.setAnimated(false);
        pane.setCollapsed(true);
        return pane;
    }

    protected String extractRecipient(SMS sms) {
        String number = CountryPrefix.stripCountryPrefix(sms.getNumber(), true);
        String recipient = null;
        recipient = StringUtils.isNotEmpty(sms.getName()) ? MessageFormat.format("{0} ({1}, {2})", sms.getName(), number, sms.getGateway()) : MessageFormat.format("{0} ({1})", number, sms.getGateway());
        return recipient;
    }
}

