# -*- Mode: Python -*-
# vi:si:et:sw=4:sts=4:ts=4

# Flumotion - a streaming media server
# Copyright (C) 2004,2005,2006,2007,2008,2009 Fluendo, S.L.
# Copyright (C) 2010,2011 Flumotion Services, S.A.
# All rights reserved.
#
# This file may be distributed and/or modified under the terms of
# the GNU Lesser General Public License version 2.1 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "LICENSE.LGPL" in the source distribution for more information.
#
# Headers in this file shall remain intact.

from flumotion.component import feedcomponent
# register gdpsink
import flumotion.component.common.fgdp.fgdp

__version__ = "$Rev$"


class FGDPConsumer(feedcomponent.ParseLaunchComponent):
    logCategory = 'fgdp-consumer'

    def get_pipeline_string(self, properties):
        return "fgdpsink name=sink"

    def configure_pipeline(self, pipeline, properties):
        sink = self.get_element('sink')
        sink.set_property('mode', properties.get('mode', 'push'))
        sink.set_property('host', properties.get('host', 'localhost'))
        sink.set_property('port', properties.get('port', 15000))
        sink.set_property('username', properties.get('username', 'user'))
        sink.set_property('password', properties.get('password', 'test'))
        sink.set_property('version', properties.get('version', '0.1'))
        sink.set_property('max-reconnection-delay',
                properties.get('max-reconnection-delay', 5))
        sink.connect('connected', self._on_connected)
        sink.connect('disconnected', self._on_disconnected)

    def _on_connected(self, element):
        self.info("FGDP consumer connected")

    def _on_disconnected(self, element, reason):
        self.info("FGDP consumer disconnected: %s", reason)
