/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontMetrics;
import org.apache.xmlgraphics.fonts.Glyphs;

public abstract class Typeface
implements FontMetrics {
    public static final char NOT_FOUND = '#';
    private static Log log = LogFactory.getLog(Typeface.class);
    private long charMapOps;
    protected FontEventListener eventListener;
    private Set<Character> warnedChars;

    public abstract String getEncodingName();

    public abstract char mapChar(char var1);

    protected void notifyMapOperation() {
        ++this.charMapOps;
    }

    public boolean hadMappingOperations() {
        return this.charMapOps > 0L;
    }

    public abstract boolean hasChar(char var1);

    public boolean isMultiByte() {
        return false;
    }

    public int getMaxAscent(int size) {
        return this.getAscender(size);
    }

    public boolean hasFeature(int tableType, String script, String language, String feature) {
        return false;
    }

    public void setEventListener(FontEventListener listener) {
        this.eventListener = listener;
    }

    protected void warnMissingGlyph(char c) {
        Character ch = new Character(c);
        if (this.warnedChars == null) {
            this.warnedChars = new HashSet<Character>();
        }
        if (this.warnedChars.size() < 8 && !this.warnedChars.contains(ch)) {
            this.warnedChars.add(ch);
            if (this.eventListener != null) {
                this.eventListener.glyphNotAvailable(this, c, this.getFontName());
            } else if (this.warnedChars.size() == 8) {
                log.warn((Object)("Many requested glyphs are not available in font " + this.getFontName()));
            } else {
                log.warn((Object)("Glyph " + c + " (0x" + Integer.toHexString(c) + ", " + Glyphs.charToGlyphName((char)c) + ") not available in font " + this.getFontName()));
            }
        }
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(super.toString());
        sbuf.append('{');
        sbuf.append(this.getFullName());
        sbuf.append('}');
        return sbuf.toString();
    }
}

