/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.awt.Graphics2D;
import org.scilab.forge.jlatexmath.Box;

public class ScaleBox
extends Box {
    private Box box;
    private double xscl;
    private double yscl;
    private float factor = 1.0f;

    public ScaleBox(Box box, double d, double d2) {
        this.box = box;
        this.xscl = Double.isNaN(d) || Double.isInfinite(d) ? 0.0 : d;
        this.yscl = Double.isNaN(d2) || Double.isInfinite(d2) ? 0.0 : d2;
        this.width = box.width * (float)Math.abs(this.xscl);
        this.height = this.yscl > 0.0 ? box.height * (float)this.yscl : -box.depth * (float)this.yscl;
        this.depth = this.yscl > 0.0 ? box.depth * (float)this.yscl : -box.height * (float)this.yscl;
        this.shift = box.shift * (float)this.yscl;
    }

    public ScaleBox(Box box, float f) {
        this(box, f, f);
        this.factor = f;
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        this.drawDebug(graphics2D, f, f2);
        if (this.xscl != 0.0 && this.yscl != 0.0) {
            float f3 = this.xscl < 0.0 ? this.width : 0.0f;
            graphics2D.translate(f + f3, f2);
            graphics2D.scale(this.xscl, this.yscl);
            this.box.draw(graphics2D, 0.0f, 0.0f);
            graphics2D.scale(1.0 / this.xscl, 1.0 / this.yscl);
            graphics2D.translate(-f - f3, -f2);
        }
    }

    public int getLastFontId() {
        return this.box.getLastFontId();
    }
}

