/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Arrays;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.java.BS;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class CrystalReader
extends AtomSetCollectionReader {
    private boolean isVersion3;
    private boolean isPrimitive;
    private boolean isPolymer;
    private boolean isSlab;
    private boolean isMolecular;
    private boolean haveCharges;
    private boolean inputOnly;
    private boolean isLongMode;
    private boolean getLastConventional;
    private boolean havePrimitiveMapping;
    private boolean isProperties;
    private int ac;
    private int atomIndexLast;
    private int[] atomFrag;
    private int[] primitiveToIndex;
    private float[] nuclearCharges;
    private Lst<String> vCoords;
    private Double energy;
    private P3 ptOriginShift = new P3();
    private M3 primitiveToCryst;
    private V3[] directLatticeVectors;
    private String spaceGroupName;
    private float primitiveVolume;
    private float primitiveDensity;
    private Lst<String> vPrimitiveMapping;

    @Override
    protected void initializeReader() throws Exception {
        this.doProcessLines = false;
        this.inputOnly = this.checkFilterKey("INPUT");
        this.isPrimitive = !this.inputOnly && !this.checkFilterKey("CONV");
        this.addVibrations &= !this.inputOnly;
        this.getLastConventional = !this.isPrimitive && this.desiredModelNumber == 0;
        this.setFractionalCoordinates(this.readHeader());
        this.asc.checkLatticeOnly = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" LATTICE PARAMETER")) {
            boolean bl;
            boolean bl2 = bl = this.line.indexOf("- CONVENTIONAL") >= 0;
            if (bl) {
                if (this.isPrimitive) {
                    return true;
                }
                this.readLatticeParams(true);
            } else if (!(this.isPrimitive || this.havePrimitiveMapping || this.getLastConventional)) {
                this.readLines(3);
                this.readPrimitiveMapping();
                if (this.setPrimitiveMapping()) {
                    return true;
                }
            }
            this.readLatticeParams(true);
            if (!this.isPrimitive) {
                this.discardLinesUntilContains(" TRANSFORMATION");
                this.readTransformationMatrix();
                this.discardLinesUntilContains(" CRYSTALLOGRAPHIC");
                this.readLatticeParams(false);
                this.discardLinesUntilContains(" CRYSTALLOGRAPHIC");
                this.readCoordLines();
                if (!this.getLastConventional) {
                    if (this.doGetModel(++this.modelNumber, null)) {
                        this.createAtomsFromCoordLines();
                    } else {
                        this.vCoords = null;
                        this.checkLastModel();
                    }
                }
            }
            return true;
        }
        if (!this.isPrimitive) {
            if (this.line.startsWith(" SHIFT OF THE ORIGIN")) {
                return this.readShift();
            }
            if (this.line.startsWith(" INPUT COORDINATES")) {
                this.readCoordLines();
                if (this.inputOnly) {
                    this.continuing = false;
                }
                return true;
            }
        }
        if (this.line.startsWith(" DIRECT LATTICE VECTOR")) {
            return this.setDirect();
        }
        if (this.line.indexOf("DIMENSIONALITY OF THE SYSTEM") >= 0) {
            if (this.line.indexOf("2") >= 0) {
                this.isSlab = true;
            }
            if (this.line.indexOf("1") >= 0) {
                this.isPolymer = true;
            }
            return true;
        }
        if (this.addVibrations && this.line.startsWith(" FREQUENCIES COMPUTED ON A FRAGMENT")) {
            return this.readFreqFragments();
        }
        if (this.line.indexOf("CONSTRUCTION OF A NANOTUBE FROM A SLAB") >= 0) {
            this.isPolymer = true;
            this.isSlab = false;
            return true;
        }
        if (this.line.indexOf("* CLUSTER CALCULATION") >= 0) {
            this.isMolecular = true;
            this.isSlab = false;
            this.isPolymer = false;
            return true;
        }
        if ((this.isPrimitive || this.isMolecular) && this.line.startsWith(" ATOMS IN THE ASYMMETRIC UNIT") || this.isProperties && this.line.startsWith("   ATOM N.AT.")) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            return this.readAtoms();
        }
        if (this.line.startsWith(" * SUPERCELL OPTION")) {
            this.discardLinesUntilContains("GENERATED");
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.startsWith(" TOTAL ENERGY(")) {
            this.line = PT.rep(this.line, "( ", "(");
            String[] stringArray = this.getTokens();
            this.energy = Double.parseDouble(stringArray[2]);
            this.setEnergy();
            this.rd();
            if (this.line.startsWith(" ********")) {
                this.discardLinesUntilContains("SYMMETRY ALLOWED");
            } else if (this.line.startsWith(" TTTTTTTT")) {
                this.discardLinesUntilContains2("PREDICTED ENERGY CHANGE", "HHHHHHH");
            }
            return true;
        }
        if (this.line.startsWith(" TYPE OF CALCULATION")) {
            this.calculationType = this.line.substring(this.line.indexOf(":") + 1).trim();
            return true;
        }
        if (this.line.startsWith(" MULLIKEN POPULATION ANALYSIS")) {
            return this.readPartialCharges();
        }
        if (this.line.startsWith(" TOTAL ATOMIC CHARGES")) {
            return this.readTotalAtomicCharges();
        }
        if (this.addVibrations && this.line.contains(this.isVersion3 ? "EIGENVALUES (EV) OF THE MASS" : "EIGENVALUES (EIGV) OF THE MASS") || this.line.indexOf("LONGITUDINAL OPTICAL (LO)") >= 0) {
            this.createAtomsFromCoordLines();
            this.isLongMode = this.line.indexOf("LONGITUDINAL OPTICAL (LO)") >= 0;
            return this.readFrequencies();
        }
        if (this.line.startsWith(" MAX GRADIENT")) {
            return this.readGradient();
        }
        if (this.line.startsWith(" ATOMIC SPINS SET")) {
            return this.readData("spin", 3);
        }
        if (this.line.startsWith(" TOTAL ATOMIC SPINS  :")) {
            return this.readData("magneticMoment", 1);
        }
        if (this.line.startsWith(" BORN CHARGE TENSOR.")) {
            return this.readBornChargeTensors();
        }
        if (!this.isProperties) {
            return true;
        }
        if (this.line.startsWith(" DEFINITION OF TRACELESS")) {
            return this.getQuadrupoleTensors();
        }
        if (this.line.startsWith(" MULTIPOLE ANALYSIS BY ATOMS")) {
            this.appendLoadNote("Multipole Analysis");
            return true;
        }
        return true;
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.createAtomsFromCoordLines();
        if (this.energy != null) {
            this.setEnergy();
        }
        this.finalizeReaderASCR();
    }

    private boolean setDirect() throws Exception {
        boolean bl = this.line.indexOf("(BOHR") >= 0;
        this.directLatticeVectors = this.read3Vectors(bl);
        V3 v3 = new V3();
        V3 v32 = new V3();
        if (this.isPrimitive) {
            v3 = this.directLatticeVectors[0];
            v32 = this.directLatticeVectors[1];
        } else {
            if (this.primitiveToCryst == null) {
                return true;
            }
            M3 m3 = new M3();
            m3.setColumnV(0, this.directLatticeVectors[0]);
            m3.setColumnV(1, this.directLatticeVectors[1]);
            m3.setColumnV(2, this.directLatticeVectors[2]);
            m3.mul(this.primitiveToCryst);
            v3 = new V3();
            v32 = new V3();
            m3.getColumnV(0, v3);
            m3.getColumnV(1, v32);
        }
        this.matUnitCellOrientation = Quat.getQuaternionFrame(new P3(), v3, v32).getMatrix();
        Logger.info("oriented unit cell is in model " + this.asc.atomSetCount);
        return !this.isProperties;
    }

    private void readTransformationMatrix() throws Exception {
        this.primitiveToCryst = M3.newA9(this.fillFloatArray(null, 0, new float[9]));
    }

    private boolean readShift() {
        String[] stringArray = this.getTokens();
        int n = stringArray.length - 3;
        this.ptOriginShift.set(PT.parseFloatFraction(stringArray[n++]), PT.parseFloatFraction(stringArray[n++]), PT.parseFloatFraction(stringArray[n]));
        return true;
    }

    private void setPrimitiveVolumeAndDensity() {
        if (this.primitiveVolume != 0.0f) {
            this.asc.setAtomSetModelProperty("volumePrimitive", DF.formatDecimal(this.primitiveVolume, 3));
        }
        if (this.primitiveDensity != 0.0f) {
            this.asc.setAtomSetModelProperty("densityPrimitive", DF.formatDecimal(this.primitiveDensity, 3));
        }
    }

    private boolean readHeader() throws Exception {
        String string;
        this.discardLinesUntilContains("*******************************************************************************");
        this.readLines(2);
        this.isVersion3 = this.line.indexOf("CRYSTAL03") >= 0;
        this.discardLinesUntilContains("EEEEEEEEEE");
        if (this.rd().length() == 0) {
            string = this.readLines(2).trim();
        } else {
            string = this.line.trim();
            this.rd();
        }
        String string2 = this.rd().trim();
        int n = string2.indexOf("- PROPERTIES");
        if (n >= 0) {
            this.isProperties = true;
            string2 = string2.substring(0, n).trim();
        }
        if (string2.indexOf("EXTERNAL FILE") >= 0) {
            string2 = this.rd().trim();
            this.isPolymer = string2.equals("1D - POLYMER");
            this.isSlab = string2.equals("2D - SLAB");
        } else {
            this.isPolymer = string2.equals("POLYMER CALCULATION");
            this.isSlab = string2.equals("SLAB CALCULATION");
        }
        this.asc.setCollectionName(string + (!this.isProperties && this.desiredModelNumber == 0 ? " (optimized)" : ""));
        this.asc.setInfo("symmetryType", string2);
        if ((this.isPolymer || this.isSlab) && !this.isPrimitive) {
            Logger.error("Cannot use FILTER \"conventional\" with POLYMER or SLAB");
            this.isPrimitive = true;
        }
        this.asc.setInfo("unitCellType", this.isPrimitive ? "primitive" : "conventional");
        if (string2.indexOf("MOLECULAR") >= 0) {
            this.doProcessLines = true;
            this.isMolecular = true;
            this.rd();
            this.asc.setInfo("molecularCalculationPointGroup", this.line.substring(this.line.indexOf(" OR ") + 4).trim());
            return false;
        }
        this.spaceGroupName = "P1";
        if (!this.isPrimitive) {
            this.discardLinesUntilContains2("SPACE GROUP", "****");
            n = this.line.indexOf(":");
            if (n >= 0) {
                this.spaceGroupName = this.line.substring(n + 1).trim();
            }
        }
        this.doApplySymmetry = this.isProperties;
        return !this.isProperties;
    }

    private void readLatticeParams(boolean bl) throws Exception {
        float f;
        float f2 = f = this.line.indexOf("(BOHR") >= 0 ? 0.5291772f : 1.0f;
        if (bl) {
            this.newAtomSet();
        }
        if (this.isPolymer && !this.isPrimitive) {
            this.setUnitCell(this.parseFloatStr(this.line.substring(this.line.indexOf("CELL") + 4)) * f, -1.0f, -1.0f, 90.0f, 90.0f, 90.0f);
        } else {
            while (this.rd().indexOf("GAMMA") < 0) {
                if (this.line.indexOf("VOLUME=") < 0) continue;
                this.primitiveVolume = this.parseFloatStr(this.line.substring(43));
                this.primitiveDensity = this.parseFloatStr(this.line.substring(66));
            }
            String[] stringArray = PT.getTokens(this.rd());
            if (this.isSlab) {
                if (this.isPrimitive) {
                    this.setUnitCell(this.parseFloatStr(stringArray[0]) * f, this.parseFloatStr(stringArray[1]) * f, -1.0f, this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]), this.parseFloatStr(stringArray[5]));
                } else {
                    this.setUnitCell(this.parseFloatStr(stringArray[0]) * f, this.parseFloatStr(stringArray[1]) * f, -1.0f, 90.0f, 90.0f, this.parseFloatStr(stringArray[2]));
                }
            } else if (this.isPolymer) {
                this.setUnitCell(this.parseFloatStr(stringArray[0]) * f, -1.0f, -1.0f, this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]), this.parseFloatStr(stringArray[5]));
            } else {
                this.setUnitCell(this.parseFloatStr(stringArray[0]) * f, this.parseFloatStr(stringArray[1]) * f, this.parseFloatStr(stringArray[2]) * f, this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]), this.parseFloatStr(stringArray[5]));
            }
        }
    }

    private void readPrimitiveMapping() throws Exception {
        if (this.havePrimitiveMapping) {
            return;
        }
        this.vPrimitiveMapping = new Lst();
        while (this.rd() != null && this.line.indexOf("NUMBER") < 0) {
            this.vPrimitiveMapping.addLast(this.line);
        }
    }

    private boolean setPrimitiveMapping() throws Exception {
        int n;
        int n2;
        int n3;
        if (this.vCoords == null || this.vPrimitiveMapping == null || this.havePrimitiveMapping) {
            return false;
        }
        this.havePrimitiveMapping = true;
        BS bS = new BS();
        int n4 = this.vCoords.size();
        int[] nArray = new int[n4];
        this.primitiveToIndex = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = -1;
        }
        n3 = 0;
        for (n2 = 0; n2 < this.vPrimitiveMapping.size(); ++n2) {
            this.line = (String)this.vPrimitiveMapping.get(n2);
            if (this.line.indexOf(" NOT IRREDUCIBLE") >= 0) {
                bS.set(this.parseIntRange(this.line, 21, 25) - 1);
                continue;
            }
            while (this.rd() != null && this.line.indexOf("NUMBER") < 0) {
                if (this.line.length() < 2 || this.line.indexOf("ATOM") >= 0 || nArray[n = this.parseIntRange(this.line, 4, 8) - 1] >= 0) continue;
                nArray[n] = n3++;
            }
        }
        if (bS.nextSetBit(0) >= 0) {
            n2 = n4;
            while (--n2 >= 0) {
                if (!bS.get(n2)) continue;
                this.vCoords.remove(n2);
            }
        }
        this.ac = this.vCoords.size();
        Logger.info(n3 + " primitive atoms and " + this.ac + " conventionalAtoms");
        this.primitiveToIndex = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            this.primitiveToIndex[n2] = -1;
        }
        n2 = this.ac;
        while (--n2 >= 0) {
            n = nArray[this.parseIntStr(((String)this.vCoords.get(n2)).substring(0, 4)) - 1];
            if (n < 0) continue;
            this.primitiveToIndex[n] = n2;
        }
        this.vPrimitiveMapping = null;
        return true;
    }

    private boolean readAtoms() throws Exception {
        if (this.isMolecular) {
            this.newAtomSet();
        }
        this.vCoords = null;
        while (this.rd() != null && this.line.indexOf("*") < 0) {
            if (this.line.indexOf("X(ANGSTROM") < 0) continue;
            this.setFractionalCoordinates(false);
            this.isMolecular = true;
        }
        int n = this.atomIndexLast;
        boolean bl = false;
        this.atomIndexLast = this.asc.ac;
        while (this.rd() != null && this.line.length() > 0 && this.line.indexOf(this.isPrimitive ? "*" : "=") < 0) {
            Atom atom = this.asc.addNewAtom();
            String[] stringArray = this.getTokens();
            int n2 = this.isProperties ? 1 : 2;
            atom.elementSymbol = CrystalReader.getElementSymbol(this.getAtomicNumber(stringArray[n2++]));
            atom.atomName = CrystalReader.fixAtomName(stringArray[n2++]);
            if (this.isProperties) {
                // empty if block
            }
            int n3 = ++n2;
            float f = this.parseFloatStr(stringArray[n3]);
            int n4 = ++n2;
            float f2 = this.parseFloatStr(stringArray[n4]);
            float f3 = this.parseFloatStr(stringArray[++n2]);
            if (this.haveCharges) {
                atom.partialCharge = this.asc.atoms[n++].partialCharge;
            }
            if (this.iHaveFractionalCoordinates && !this.isProperties) {
                if (f < 0.0f && (this.isPolymer || this.isSlab || bl)) {
                    f += 1.0f;
                }
                if (f2 < 0.0f && (this.isSlab || bl)) {
                    f2 += 1.0f;
                }
                if (f3 < 0.0f && bl) {
                    f3 += 1.0f;
                }
            }
            this.setAtomCoordXYZ(atom, f, f2, f3);
        }
        this.ac = this.asc.ac - this.atomIndexLast;
        return true;
    }

    private static String fixAtomName(String string) {
        return string.length() > 1 && PT.isLetter(string.charAt(1)) ? string.substring(0, 1) + Character.toLowerCase(string.charAt(1)) + string.substring(2) : string;
    }

    private int getAtomicNumber(String string) {
        return this.parseIntStr(string) % 100;
    }

    private void readCoordLines() throws Exception {
        this.rd();
        this.rd();
        this.vCoords = new Lst();
        while (this.rd() != null && this.line.length() > 0) {
            this.vCoords.addLast(this.line);
        }
    }

    private void createAtomsFromCoordLines() throws Exception {
        if (this.vCoords == null) {
            return;
        }
        this.ac = this.vCoords.size();
        for (int i = 0; i < this.ac; ++i) {
            int n;
            int n2;
            Atom atom = this.asc.addNewAtom();
            String[] stringArray = PT.getTokens((String)this.vCoords.get(i));
            atom.atomSerial = this.parseIntStr(stringArray[0]);
            if (stringArray.length == 7) {
                n2 = this.getAtomicNumber(stringArray[2]);
                n = 2;
            } else {
                n2 = this.getAtomicNumber(stringArray[1]);
                n = 0;
            }
            float f = this.parseFloatStr(stringArray[2 + n]) + this.ptOriginShift.x;
            float f2 = this.parseFloatStr(stringArray[3 + n]) + this.ptOriginShift.y;
            float f3 = this.parseFloatStr(stringArray[4 + n]) + this.ptOriginShift.z;
            this.setAtomCoordXYZ(atom, f, f2, f3);
            atom.elementSymbol = CrystalReader.getElementSymbol(n2);
        }
        this.vCoords = null;
        this.setPrimitiveVolumeAndDensity();
    }

    private void newAtomSet() throws Exception {
        if (this.ac > 0 && this.asc.ac > 0) {
            this.applySymmetryAndSetTrajectory();
            this.asc.newAtomSet();
        }
        if (this.spaceGroupName != null) {
            this.setSpaceGroupName(this.spaceGroupName);
        }
        this.ac = 0;
    }

    private void setEnergy() {
        this.asc.setAtomSetEnergy("" + this.energy, this.energy.floatValue());
        this.asc.setCurrentModelInfo("Energy", this.energy);
        this.asc.setInfo("Energy", this.energy);
        this.asc.setAtomSetName("Energy = " + this.energy + " Hartree");
    }

    private boolean readPartialCharges() throws Exception {
        if (this.haveCharges || this.asc.ac == 0) {
            return true;
        }
        this.haveCharges = true;
        this.readLines(3);
        Atom[] atomArray = this.asc.atoms;
        int n = this.asc.getLastAtomSetAtomIndex();
        int n2 = 0;
        while (this.rd() != null && this.line.length() > 3) {
            if (this.line.charAt(3) == ' ') continue;
            int n3 = this.getAtomIndexFromPrimitiveIndex(n2);
            if (n3 >= 0) {
                atomArray[n + n3].partialCharge = this.parseFloatRange(this.line, 9, 11) - this.parseFloatRange(this.line, 12, 18);
            }
            ++n2;
        }
        return true;
    }

    private boolean readTotalAtomicCharges() throws Exception {
        SB sB = new SB();
        while (this.rd() != null && this.line.indexOf("T") < 0) {
            sB.append(this.line);
        }
        String[] stringArray = PT.getTokens(sB.toString());
        float[] fArray = new float[stringArray.length];
        if (this.nuclearCharges == null) {
            this.nuclearCharges = fArray;
        }
        if (this.asc.ac == 0) {
            return true;
        }
        Atom[] atomArray = this.asc.atoms;
        int n = this.asc.getLastAtomSetAtomIndex();
        for (int i = 0; i < fArray.length; ++i) {
            int n2 = this.getAtomIndexFromPrimitiveIndex(i);
            if (n2 < 0) continue;
            fArray[i] = this.parseFloatStr(stringArray[i]);
            atomArray[n + n2].partialCharge = this.nuclearCharges[i] - fArray[i];
        }
        return true;
    }

    private int getAtomIndexFromPrimitiveIndex(int n) {
        return this.primitiveToIndex == null ? n : this.primitiveToIndex[n];
    }

    private boolean readFreqFragments() throws Exception {
        int n = this.parseIntRange(this.line, 39, 44);
        if (n < 0) {
            return true;
        }
        this.atomFrag = new int[n];
        String string = "";
        while (this.rd() != null && this.line.indexOf("(") >= 0) {
            string = string + this.line;
        }
        string = PT.rep(string, "(", " ");
        string = PT.rep(string, ")", " ");
        String[] stringArray = PT.getTokens(string);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            this.atomFrag[n2] = this.getAtomIndexFromPrimitiveIndex(this.parseIntStr(stringArray[n3]) - 1);
            ++n2;
            n3 += 3;
        }
        Arrays.sort(this.atomFrag);
        return true;
    }

    private boolean readFrequencies() throws Exception {
        int n;
        Object object;
        Object object2;
        int n2;
        this.energy = null;
        this.discardLinesUntilContains("MODES");
        boolean bl = this.line.indexOf("INTENS") >= 0;
        this.rd();
        Lst<String[]> lst = new Lst<String[]>();
        int n3 = this.ac;
        while (this.rd() != null && this.line.length() > 0) {
            n2 = this.parseIntRange(this.line, 1, 5);
            int n4 = this.parseIntRange(this.line, 6, 10);
            object2 = (this.isLongMode ? this.line.substring(48, 51) : this.line.substring(49, 52)).trim();
            String string = !bl ? "not available" : (this.isLongMode ? this.line.substring(53, 61) : this.line.substring(59, 69).replace(')', ' ')).trim();
            object = this.isLongMode ? "A" : this.line.substring(55, 58).trim();
            String string2 = this.isLongMode ? "I" : this.line.substring(71, 73).trim();
            String[] stringArray = new String[]{object2, string, object, string2};
            for (n = n2; n <= n4; ++n) {
                lst.addLast(stringArray);
            }
        }
        this.discardLinesUntilContains(this.isLongMode ? "LO MODES FOR IRREP" : (this.isVersion3 ? "THE CORRESPONDING MODES" : "NORMAL MODES NORMALIZED TO CLASSICAL AMPLITUDES"));
        this.rd();
        n2 = -1;
        while (this.rd() != null && this.line.startsWith(" FREQ(CM**-1)")) {
            String[] stringArray = PT.getTokens(this.line.substring(15));
            object2 = new float[stringArray.length];
            int n5 = ((Object)object2).length;
            for (int i = 0; i < n5; ++i) {
                object2[i] = this.parseFloatStr(stringArray[i]);
                if (!this.debugging) continue;
                Logger.debug(this.vibrationNumber + i + " frequency=" + (float)object2[i]);
            }
            object = new boolean[n5];
            int n6 = 0;
            int n7 = lst.size();
            for (n = 0; n < n5; ++n) {
                stringArray = (String[])lst.get(this.vibrationNumber % n7);
                object[n] = !this.doGetVibration(++this.vibrationNumber) || stringArray == null;
                if (object[n] != false) continue;
                this.applySymmetryAndSetTrajectory();
                n2 = this.cloneLastAtomSet(this.ac, null);
                if (n == 0) {
                    n6 = this.asc.getLastAtomSetAtomIndex();
                }
                this.setFreqValue((float)object2[n], stringArray);
            }
            this.rd();
            this.fillFrequencyData(n6, n3, n2, (boolean[])object, false, 14, 10, this.atomFrag, 0);
            this.rd();
        }
        return true;
    }

    private void setFreqValue(float f, String[] stringArray) {
        String string = "IR: " + stringArray[2] + ", Ram.: " + stringArray[3];
        this.asc.setAtomSetFrequency(null, string, "" + f, null);
        this.asc.setAtomSetModelProperty("IRintensity", stringArray[1] + " km/Mole");
        this.asc.setAtomSetModelProperty("vibrationalSymmetry", stringArray[0]);
        this.asc.setAtomSetModelProperty("IRactivity", stringArray[2]);
        this.asc.setAtomSetModelProperty("Ramanactivity", stringArray[3]);
        this.asc.setAtomSetName((this.isLongMode ? "LO " : "") + stringArray[0] + " " + DF.formatDecimal(f, 2) + " cm-1 (" + DF.formatDecimal(PT.fVal(stringArray[1]), 0) + " km/Mole), " + string);
    }

    private boolean readGradient() throws Exception {
        String string = null;
        while (this.line != null) {
            String[] stringArray = this.getTokens();
            if (this.line.indexOf("MAX GRAD") >= 0) {
                string = "maxGradient";
            } else if (this.line.indexOf("RMS GRAD") >= 0) {
                string = "rmsGradient";
            } else if (this.line.indexOf("MAX DISP") >= 0) {
                string = "maxDisplacement";
            } else {
                if (this.line.indexOf("RMS DISP") < 0) break;
                string = "rmsDisplacement";
            }
            if (this.asc.ac > 0) {
                this.asc.setAtomSetModelProperty(string, stringArray[2]);
            }
            this.rd();
        }
        return true;
    }

    private boolean readData(String string, int n) throws Exception {
        this.createAtomsFromCoordLines();
        float[] fArray = new float[this.ac];
        for (int i = 0; i < this.ac; ++i) {
            fArray[i] = 0.0f;
        }
        String string2 = "";
        while (this.rd() != null && (this.line.length() < 4 || PT.isDigit(this.line.charAt(3)))) {
            string2 = string2 + this.line;
        }
        string2 = PT.rep(string2, "-", " -");
        String[] stringArray = PT.getTokens(string2);
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < this.ac) {
            int n4 = this.getAtomIndexFromPrimitiveIndex(n2);
            if (n4 >= 0) {
                fArray[n4] = this.parseFloatStr(stringArray[n3]);
            }
            ++n2;
            n3 += n;
        }
        this.asc.setAtomProperties(string, fArray, -1, false);
        return true;
    }

    private boolean getQuadrupoleTensors() throws Exception {
        this.readLines(6);
        Atom[] atomArray = this.asc.atoms;
        while (this.rd() != null && this.line.startsWith(" *** ATOM")) {
            String[] stringArray = this.getTokens();
            int n = this.parseIntStr(stringArray[3]) - 1;
            stringArray = PT.getTokens(this.readLines(3));
            V3[] v3Array = new V3[3];
            for (int i = 0; i < 3; ++i) {
                v3Array[i] = V3.newV(this.directLatticeVectors[i]);
                v3Array[i].normalize();
            }
            atomArray[n].addTensor(new Tensor().setFromEigenVectors(v3Array, new float[]{this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[5])}, "quadrupole", atomArray[n].atomName, null), null, false);
            this.rd();
        }
        this.appendLoadNote("Ellipsoids set \"quadrupole\": Quadrupole tensors");
        return true;
    }

    private boolean readBornChargeTensors() throws Exception {
        this.createAtomsFromCoordLines();
        this.rd();
        Atom[] atomArray = this.asc.atoms;
        while (this.rd().startsWith(" ATOM")) {
            int n = this.parseIntAt(this.line, 5) - 1;
            Atom atom = atomArray[n];
            this.readLines(2);
            double[][] dArray = new double[3][3];
            for (int i = 0; i < 3; ++i) {
                String[] stringArray = PT.getTokens(this.rd());
                for (int j = 0; j < 3; ++j) {
                    dArray[i][j] = this.parseFloatStr(stringArray[j + 1]);
                }
            }
            atom.addTensor(new Tensor().setFromAsymmetricTensor(dArray, "charge", atom.elementSymbol + (n + 1)), null, false);
            this.rd();
        }
        this.appendLoadNote("Ellipsoids set \"charge\": Born charge tensors");
        return false;
    }
}

