/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import javajs.util.SB;
import org.jmol.c.CBK;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.viewer.JmolChimeMessenger;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.Viewer;

public class ChimeMessenger
implements JmolChimeMessenger {
    private Viewer vwr;

    @Override
    public JmolChimeMessenger set(Viewer viewer) {
        this.vwr = viewer;
        return this;
    }

    @Override
    public String getInfoXYZ(Atom atom) {
        String string = atom.getGroup3(true);
        int n = atom.group.chain.chainID;
        return "Atom: " + (string == null ? atom.getElementSymbol() : atom.getAtomName()) + " " + atom.getAtomNumber() + (string != null && string.length() > 0 ? (atom.isHetero() ? " Hetero: " : " Group: ") + string + " " + atom.getResno() + (n != 0 && n != 32 ? " Chain: " + atom.group.chain.getIDStr() : "") : "") + " Model: " + atom.getModelNumber() + " Coordinates: " + atom.x + " " + atom.y + " " + atom.z;
    }

    @Override
    public void showHash(SB sB, String string) {
        if (string == null) {
            return;
        }
        if (sB == null) {
            this.vwr.warn(string);
            this.vwr.scriptStatus(string);
        } else {
            sB.append(string).appendC('\n');
        }
    }

    @Override
    public void reportSelection(int n) {
        this.vwr.reportSelection((n == 0 ? "No atoms" : (n == 1 ? "1 atom" : n + " atoms")) + " selected!");
    }

    @Override
    public void update(String string) {
        string = string == null ? "script <exiting>" : "Requesting " + string;
        this.vwr.scriptStatus(string);
    }

    @Override
    public String scriptCompleted(StatusManager statusManager, String string, String string2) {
        Object[] objectArray = new Object[]{null, "script <exiting>", string, -1, string2};
        if (statusManager.notifyEnabled(CBK.SCRIPT)) {
            statusManager.cbl.notifyCallback(CBK.SCRIPT, objectArray);
        }
        statusManager.processScript(objectArray);
        return "Jmol script completed.";
    }

    @Override
    public void getAllChimeInfo(SB sB) {
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        ModelSet modelSet = this.vwr.ms;
        if (modelSet.haveBioModels) {
            int n5 = 0;
            Model[] modelArray = modelSet.am;
            int n6 = modelSet.mc;
            int n7 = modelSet.ac;
            Atom[] atomArray = modelSet.at;
            sB.append("\nMolecule name ....... " + modelSet.getInfoM("COMPND"));
            sB.append("\nSecondary Structure . PDB Data Records");
            sB.append("\nBrookhaven Code ..... " + modelSet.modelSetName);
            int n8 = n6;
            while (--n8 >= 0) {
                n5 += modelArray[n8].getChainCount(false);
            }
            sB.append("\nNumber of Chains .... " + n5);
            n8 = 0;
            int n9 = 0;
            Hashtable<Group, Boolean> hashtable = new Hashtable<Group, Boolean>();
            int n10 = -1;
            n2 = 0;
            int n11 = n7;
            while (--n11 >= 0) {
                int n12;
                Group group;
                boolean bl = atomArray[n11].isHetero();
                if (bl) {
                    ++n;
                }
                if (!hashtable.containsKey(group = atomArray[n11].group)) {
                    hashtable.put(group, Boolean.TRUE);
                    if (bl) {
                        ++n9;
                    } else {
                        ++n8;
                    }
                }
                if (atomArray[n11].mi != 0 || (n12 = group.getStrucNo()) == n10 || n12 == 0) continue;
                n10 = n12;
                switch (group.getProteinStructureType()) {
                    case HELIX: {
                        ++n2;
                        break;
                    }
                    case SHEET: {
                        ++n3;
                        break;
                    }
                    case TURN: {
                        ++n4;
                    }
                }
            }
            sB.append("\nNumber of Groups .... " + n8);
            if (n9 > 0) {
                sB.append(" (" + n9 + ")");
            }
        }
        sB.append("\nNumber of Atoms ..... " + (modelSet.ac - n));
        if (n > 0) {
            sB.append(" (" + n + ")");
        }
        sB.append("\nNumber of Bonds ..... " + modelSet.bondCount);
        sB.append("\nNumber of Models ...... " + modelSet.mc);
        if (n2 >= 0) {
            sB.append("\nNumber of Helices ... " + n2);
            sB.append("\nNumber of Strands ... " + n3);
            sB.append("\nNumber of Turns ..... " + n4);
        }
    }
}

