/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialogConfig;

abstract class NBODialogModel
extends NBODialogConfig {
    private static final String INPUT_FILE_EXTENSIONS = ";adf;cfi;gau;gms;jag;mm2;mnd;mp;nw;orc;pqs;qc;vfi;";
    private static final String[] SAVE_OPTIONS = new String[]{"-Type-", "(.adf) ADF", "(.cfi) Cartesian Coordinate", "(.gau) Gaussian", "(.gms) GAMESS", "(.jag) Jaguar", "(.mm2) MM2-type", "(.mnd) MINDO/AM1", "(.mp) Molpro", "(.nw) NWChem", "(.orc) Orca", "(.pqs) PQS", "(.qc) Q-Chem", "(.vfi) Valence Coordinate"};
    private static final int ALTER = 1;
    private static final int CLIP = 2;
    private static final int MUTATE = 3;
    private static final String LOAD_SCRIPT = ";set zoomlarge false;zoomTo 0.5 {*} 0;";
    private int editMode;
    private String savePath;
    private String selected = "";
    protected String usePath;
    protected JComboBox<String> jComboUse;
    protected JComboBox<String> jComboSave;
    protected Box editBox;
    protected JButton jbEdit;
    protected JButton jbSym;
    protected JTextField jtSelectAtoms;
    protected JTextField tfFolderS;
    protected JTextField tfNameS;
    protected JTextField tfExtS;
    protected JCheckBox jCheckAtomNum;
    protected JRadioButton jrJmolIn;
    protected JRadioButton jrLineIn;
    protected JRadioButton jrFileIn;
    protected JTextField jtJmolInput;
    protected JTextField jtLineInput;

    protected abstract void nboResetV();

    protected NBODialogModel(JFrame jFrame) {
        super(jFrame);
    }

    protected void buildModel(Container container) {
        Properties properties = JmolPanel.historyFile.getProperties();
        this.savePath = properties.getProperty("savePath", System.getProperty("user.home"));
        this.usePath = properties.getProperty("usePath", System.getProperty("user.home"));
        container.removeAll();
        container.setLayout(new BorderLayout());
        if (this.topPanel == null) {
            this.topPanel = this.buildTopPanel();
        }
        container.add((Component)this.topPanel, "First");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.useBox());
        jPanel.add(this.saveBox());
        jPanel.add(this.editBox());
        JSplitPane jSplitPane = new JSplitPane(1, jPanel, this.modelOut());
        jSplitPane.setDividerLocation(430);
        jSplitPane.setBorder(BorderFactory.createLoweredBevelBorder());
        container.add((Component)jSplitPane, "Center");
        container.add((Component)this.statusPanel, "Last");
        if (this.vwr.ms.ac != 0 && !this.isJmolNBO) {
            this.loadModel();
            this.enableComps();
        }
    }

    private Component editBox() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Edit"));
        Box box = Box.createVerticalBox();
        jPanel.add(box);
        Box box2 = Box.createHorizontalBox();
        String[] stringArray = new String[]{"-Action-", "alter - atomic charge, distance, angle, or dihedral angle", "clip - ", "fuse - ", "link - ", "mutate - ", "rebond - ", "switch - ", "twist - ", "unify - ", " 3chb - "};
        this.action = new JComboBox<String>(stringArray);
        this.action.setEnabled(false);
        box2.add(this.action);
        this.action.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.actionSelected();
            }
        });
        box2.setBorder(BorderFactory.createEmptyBorder(20, 0, 10, 5));
        box.add(box2).setMaximumSize(new Dimension(500, 60));
        this.editBox = Box.createVerticalBox();
        this.editBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.editBox.add(Box.createRigidArea(new Dimension(200, 60)));
        this.jtSelectAtoms = new JTextField("Select atoms...");
        this.jtSelectAtoms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.editModel();
            }
        });
        this.jtSelectAtoms.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (!NBODialogModel.this.jtSelectAtoms.getText().equals("")) {
                    NBODialogModel.this.jbEdit.setEnabled(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (NBODialogModel.this.jtSelectAtoms.getText().equals("")) {
                    NBODialogModel.this.jbEdit.setEnabled(false);
                }
            }
        });
        this.jbEdit = new JButton("Apply");
        this.jbEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.editModel();
            }
        });
        box.add(this.editBox);
        this.jbSym = new JButton("Symmety");
        box2 = Box.createVerticalBox();
        box2.setAlignmentX(0.5f);
        box2.setBorder(BorderFactory.createEmptyBorder(10, 0, 20, 5));
        this.jbSym.setAlignmentX(0.5f);
        box2.add(this.jbSym).setEnabled(false);
        this.jbSym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.getSymmetry();
            }
        });
        box2.add(Box.createRigidArea(new Dimension(30, 30)));
        this.jCheckAtomNum = new JCheckBox("View atom numbers");
        this.jCheckAtomNum.setEnabled(false);
        this.jCheckAtomNum.setAlignmentX(0.5f);
        this.jCheckAtomNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NBODialogModel.this.jCheckAtomNum.isSelected()) {
                    NBODialogModel.this.nboService.runScriptQueued("select {*};label off");
                } else {
                    NBODialogModel.this.nboService.runScriptQueued("select {*};label %a");
                }
                NBODialogModel.this.nboService.runScriptQueued("color labels white;select remove {*}");
            }
        });
        box2.add(this.jCheckAtomNum);
        box.add(box2);
        return jPanel;
    }

    private Component saveBox() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Save As"));
        Box box = Box.createHorizontalBox();
        this.jComboSave = new JComboBox<String>(SAVE_OPTIONS);
        this.jComboSave.setEnabled(false);
        this.jComboSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = NBODialogModel.this.jComboSave.getSelectedItem();
                if (!object.equals("-Type-")) {
                    String string = object.toString();
                    NBODialogModel.this.showSaveDialog(string.substring(string.indexOf("(") + 2, string.indexOf(")")));
                }
            }
        });
        Box box2 = Box.createVerticalBox();
        box2.add(this.jComboSave);
        box2.add(this.folderSaveBox());
        box.add(box2);
        box.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 5));
        jPanel.add(box);
        return jPanel;
    }

    private Component useBox() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("Structure"));
        Box box = Box.createHorizontalBox();
        this.jrJmolIn = new JRadioButton("Jmol Input");
        this.jrJmolIn.setFont(this.nboFont);
        this.jrJmolIn.setSelected(true);
        this.jrJmolIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.browse.setEnabled(false);
            }
        });
        this.jrLineIn = new JRadioButton("Line Formula");
        this.jrLineIn.setFont(this.nboFont);
        this.jrLineIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.browse.setEnabled(false);
            }
        });
        this.jrFileIn = new JRadioButton("File Input");
        this.jrFileIn.setFont(this.nboFont);
        this.jrFileIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.browse.setEnabled(true);
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.jrJmolIn);
        buttonGroup.add(this.jrLineIn);
        buttonGroup.add(this.jrFileIn);
        this.jtJmolInput = new JTextField();
        this.createInput(this.jtJmolInput, this.jrJmolIn);
        this.jtLineInput = new JTextField();
        this.createInput(this.jtLineInput, this.jrLineIn);
        String[] stringArray = new String[]{"-Type-", "(.47) NBOarchive ", "(.adf) ADF ", "(.cfi) Cartesian Coordinate", "(.gau) Gaussian", "(.gms) GAMESS", "(.jag) Jaguar", "(.log) Gaussian log", "(.mp) Molpro", "(.nw) NWChem", "(.orc) Orca", "(.pqs) PQS", "(.qc) Q-Chem", "(.vfi) Valence Coordinate"};
        this.jComboUse = new JComboBox<String>(stringArray);
        this.jComboUse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = NBODialogModel.this.jComboUse.getSelectedItem();
                if (!object.equals("-Type-")) {
                    String string = object.toString();
                    NBODialogModel.this.showWorkpathDialogM(NBODialogModel.this.usePath, string.substring(string.indexOf("(") + 2, string.indexOf(")")));
                }
            }
        });
        this.browse.setEnabled(false);
        JPanel jPanel2 = new JPanel(new GridLayout(3, 2));
        jPanel2.add(this.jrJmolIn);
        jPanel2.add(this.jtJmolInput);
        jPanel2.add(this.jrLineIn);
        jPanel2.add(this.jtLineInput);
        jPanel2.add(this.jrFileIn);
        jPanel2.add(this.jComboUse);
        this.addListenersAndSize(this.jComboUse, this.jrFileIn);
        box.add(jPanel2);
        jPanel.add(box);
        jPanel.add(this.folderBox());
        return jPanel;
    }

    private void createInput(final JTextField jTextField, JRadioButton jRadioButton) {
        jTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.getModel(jTextField);
            }
        });
        this.addListenersAndSize(jTextField, jRadioButton);
    }

    private void addListenersAndSize(JComponent jComponent, final JRadioButton jRadioButton) {
        jComponent.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                jRadioButton.setSelected(true);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        jComponent.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                jRadioButton.setSelected(true);
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }
        });
        jComponent.setMinimumSize(new Dimension(226, 25));
        jComponent.setMaximumSize(new Dimension(226, 25));
    }

    private JPanel folderSaveBox() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.tfFolderS = new JTextField();
        this.tfFolderS.setPreferredSize(new Dimension(130, 20));
        this.tfFolderS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.showWorkpathDialogM(NBODialogModel.this.tfFolder.getText() + "/new", null);
            }
        });
        jPanel.add((Component)this.tfFolderS, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.tfNameS = new JTextField();
        this.tfNameS.setPreferredSize(new Dimension(100, 20));
        jPanel.add((Component)this.tfNameS, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("         folder"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel("          name"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.tfExtS = new JTextField();
        this.tfExtS.setPreferredSize(new Dimension(40, 20));
        jPanel.add((Component)this.tfExtS, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("  ext"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        JButton jButton = new JButton("Save");
        jPanel.add((Component)jButton, gridBagConstraints);
        jPanel.setPreferredSize(new Dimension(350, 50));
        return jPanel;
    }

    protected void actionSelected() {
        this.nboService.runScriptQueued("select remove {*}; select on");
        String string = this.action.getSelectedItem().toString().split(" ")[0];
        if (string.equals("-Action-")) {
            return;
        }
        if (string.equals("clip") || string.equals("fuse") || string.equals("link") || string.equals("switch")) {
            this.editMode = 2;
            this.clip("Select two atoms:", null);
        } else if (string.equals("mutate")) {
            this.editMode = 3;
            this.clip("Formula: ", this.jtSelectAtoms);
        } else if (string.equals("rebond")) {
            this.clip("Symtype: ", this.jtSelectAtoms);
        } else if (string.equals("alter") || string.equals("twist")) {
            this.editMode = 1;
            this.clip("New Value: ", this.jtSelectAtoms);
        }
        this.setComponents(this.editBox);
    }

    protected void clip(String string, Component component) {
        this.editBox.removeAll();
        this.editBox.setMaximumSize(new Dimension(200, 60));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(string));
        if (component != null) {
            this.jtSelectAtoms.setText("Select atoms...");
            box.add(component);
            this.jtSelectAtoms.setEnabled(false);
        } else {
            this.jtSelectAtoms.setText("");
        }
        this.editBox.add(box);
        box = Box.createHorizontalBox();
        JButton jButton = new JButton("Clear Selected");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.clearSelected();
            }
        });
        box.add(jButton);
        box.add(this.jbEdit);
        this.editBox.add(box);
        this.editBox.repaint();
        this.editBox.revalidate();
    }

    protected void clearSelected() {
        if (!this.jCheckAtomNum.isSelected()) {
            this.nboService.runScriptQueued("label off");
        }
        this.nboService.runScriptQueued("measure off;select remove {selected};refresh");
        this.selected = "";
        this.jtSelectAtoms.setText("Select atoms...");
        this.jtSelectAtoms.setEnabled(false);
        this.appendOutputWithCaret("Selection cleared");
    }

    protected void editModel() {
        SB sB = new SB();
        String string = this.action.getSelectedItem().toString().split(" ")[0] + " " + this.selected;
        this.selected = "";
        if (this.jtSelectAtoms != null) {
            string = string + " " + this.jtSelectAtoms.getText();
        }
        this.appendToFile("CMD " + string, sB);
        this.appendOutput(string);
        this.jbEdit.setEnabled(false);
        this.modelCmd(sB);
    }

    protected JPanel modelOut() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Session Dialog");
        jLabel.setFont(this.nboFont);
        jPanel.add((Component)jLabel, "First");
        JScrollPane jScrollPane = new JScrollPane();
        this.jpNboOutput = new JTextPane();
        this.jpNboOutput.setEditable(false);
        this.jpNboOutput.setFont(new Font("Arial", 0, 18));
        jScrollPane.getViewport().add(this.jpNboOutput);
        jPanel.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton("Clear");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogModel.this.clearOutput();
            }
        });
        jPanel.add((Component)jButton, "South");
        return jPanel;
    }

    private void saveHistoryM() {
        Properties properties = new Properties();
        properties.setProperty("savePath", this.savePath);
        properties.setProperty("usePath", this.usePath);
        JmolPanel.historyFile.addProperties(properties);
    }

    protected void getSymmetry() {
        this.jbSym.setSelected(false);
        SB sB = new SB();
        this.appendToFile("CMD symmetry", sB);
        this.appendOutputWithCaret("Symmetry: ");
        this.modelCmd(sB);
    }

    protected void getModel(JTextField jTextField) {
        if (jTextField.getText().equals("")) {
            return;
        }
        this.action.setSelectedIndex(0);
        String string = "";
        if (jTextField.equals(this.jtJmolInput)) {
            this.jrJmolIn.setSelected(true);
            this.nboService.runScriptNow("zap");
            string = "load $" + jTextField.getText();
            if (this.nboService.runScriptNow(string) == null) {
                if (this.nboService.runScriptNow("load :" + jTextField.getText()) != null) {
                    while (this.vwr.ms.ac == 0) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            System.out.println("HELLO");
                            return;
                        }
                    }
                    this.loadModel();
                    return;
                }
                this.appendOutputWithCaret("File not found");
                return;
            }
            while (this.vwr.ms.ac == 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    System.out.println("HELLO");
                    return;
                }
            }
            this.loadModel();
        } else if (jTextField.equals(this.jtLineInput)) {
            this.jrLineIn.setSelected(true);
            SB sB = new SB();
            string = "show " + jTextField.getText();
            this.appendToFile("CMD " + string, sB);
            this.modelCmd(sB);
        }
        this.appendOutputWithCaret(string);
    }

    private void loadModel(String string, String string2, String string3) {
        String string4 = this.getEss(string3);
        SB sB = new SB();
        this.appendToFile("GLOBAL C_PATH " + string + sep, sB);
        this.appendToFile("GLOBAL C_ESS " + string4 + sep, sB);
        this.appendToFile("GLOBAL C_FNAME " + string2 + sep, sB);
        this.appendToFile("GLOBAL C_IN_EXT " + string3.toLowerCase() + sep, sB);
        this.appendToFile("CMD use", sB);
        this.appendOutputWithCaret("use." + string4 + " " + string2 + "." + string3);
        this.modelCmd(sB);
    }

    protected void loadModel() {
        File file = new File(new File(this.nboService.serverPath).getParent() + "/jmol_outfile.cfi");
        SB sB = new SB();
        this.vwr.script(LOAD_SCRIPT);
        try {
            String string = this.nboService.evaluateJmolString("data({visible},'cfi')");
            this.nboService.writeToFile(string, file);
            this.setInputFile(file, "cfi", null);
            this.appendToFile("GLOBAL C_PATH " + file.getParent() + sep, sB);
            this.appendToFile("GLOBAL C_ESS c" + sep, sB);
            this.appendToFile("GLOBAL C_FNAME jmol_outfile" + sep, sB);
            this.appendToFile("GLOBAL C_IN_EXT cfi" + sep, sB);
            this.appendToFile("CMD use", sB);
            this.modelCmd(sB);
            this.enableComps();
        }
        catch (IOException iOException) {
            System.out.println("could not write file contents to " + file);
        }
    }

    private void saveModel(String string, String string2, String string3) {
        String string4 = this.getEss(string3);
        SB sB = new SB();
        this.appendToFile("GLOBAL C_PATH " + string + sep, sB);
        this.appendToFile("GLOBAL C_ESS " + string4 + sep, sB);
        this.appendToFile("GLOBAL C_FNAME " + string2 + sep, sB);
        this.appendToFile("GLOBAL C_OUT_EXT " + string3 + sep, sB);
        this.appendToFile("CMD save", sB);
        this.modelCmd(sB);
        this.appendOutputWithCaret("save." + string4 + " " + string2 + "\n--Model Saved--");
    }

    private String getEss(String string) {
        if (string.equals("cfi") || string.equals("vfi") || string.equals("gau") || string.equals("log")) {
            return "" + string.charAt(0);
        }
        if (string.equals("47")) {
            return "a";
        }
        if (string.equals("mm2")) {
            return "mm";
        }
        return string;
    }

    protected synchronized void modelCmd(final SB sB) {
        this.nboService.queueJob("model", "creating model...", new Runnable(){

            @Override
            public void run() {
                NBODialogModel.this.nboService.rawCmdNew("m", sB, false, 1);
            }
        });
    }

    @Override
    protected void showWorkpathDialogM(String string, String string2) {
        if (string == null) {
            string = this.usePath;
            string2 = "47, adf, cfi, gau, gms, jag, log, mp, nw, orc, pqs, qc, vfi";
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (string2 != null) {
            jFileChooser.setFileFilter(new FileNameExtensionFilter(string2, string2.split(", ")));
        }
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setSelectedFile(new File(string));
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            this.jtJmolInput.setText("");
            File file = jFileChooser.getSelectedFile();
            this.loadModel(file.getParent(), this.getJobStem(file), this.getExt(file));
            this.setInputFile(file, this.getExt(file), null);
            this.nboResetV();
            this.enableComps();
            this.usePath = file.toString();
            this.saveHistoryM();
        } else if (n == 1) {
            this.jComboUse.setSelectedIndex(0);
        }
    }

    protected void showSaveDialog(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileNameExtensionFilter(string, string.split(", ")));
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setSelectedFile(new File(new File(this.savePath).getParent() + "/new"));
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string2 = this.getExt(file);
            if (string2.equals(file.toString())) {
                String string3 = this.jComboSave.getSelectedItem().toString();
                string2 = string3.substring(string3.indexOf("(") + 2, string3.indexOf(")"));
            }
            if (PT.isOneOf(string2, INPUT_FILE_EXTENSIONS)) {
                this.setInputFile(file, string2, null);
                this.savePath = file.toString();
                this.saveModel(file.getParent(), this.jobStem, string2);
                this.saveHistoryM();
            }
        } else {
            this.jComboSave.setSelectedIndex(0);
        }
    }

    protected void enableComps() {
        this.action.setEnabled(true);
        this.jComboSave.setEnabled(true);
        this.jbSym.setEnabled(true);
        this.jCheckAtomNum.setEnabled(true);
    }

    protected void notifyCallbackM(String string) {
        if (this.editMode != 0) {
            String string2 = this.nboService.runScriptNow("print {*}[" + string + "].selected");
            if (string2.contains("1.0")) {
                this.appendOutputWithCaret("Atom # " + string + " deselected");
                this.selected = this.selected.replace(string + " ", "");
                this.nboService.runScriptNow("select remove {*}[" + string + "]");
                return;
            }
            this.appendOutputWithCaret("Atom # " + string + " selected");
            this.selected = this.selected + string + " ";
            this.nboService.runScriptNow("select add {*}[" + string + "]");
            int n = this.selected.split(" ").length;
            switch (this.editMode) {
                case 1: {
                    if (n == 1) {
                        this.jtSelectAtoms.setEnabled(true);
                        this.jtSelectAtoms.setText("");
                        this.nboService.runScriptQueued("label %a");
                        break;
                    }
                    if (n == 5) {
                        this.nboService.runScriptNow("measure off;select remove {*};select add {*}[" + string + "]");
                        this.selected = string + " ";
                        break;
                    }
                    if (!this.jCheckAtomNum.isSelected()) {
                        this.nboService.runScriptQueued("label off");
                    }
                    if (n == 2) {
                        this.nboService.runScriptQueued("measure off;measure " + this.selected + "\"2:%0.4VALUE //A\"" + ";measure " + this.selected + "\"2:%0.4VALUE //A\"");
                        break;
                    }
                    this.nboService.runScriptQueued("measure off;measure " + this.selected);
                    break;
                }
                case 2: {
                    if (n == 2) {
                        this.jbEdit.setEnabled(true);
                        break;
                    }
                    if (n != 3) break;
                    this.nboService.runScriptNow("select remove {*};select add {*}[" + string + "]");
                    this.selected = string + " ";
                    break;
                }
                case 3: {
                    if (n == 1) {
                        this.jtSelectAtoms.setEnabled(true);
                        this.jtSelectAtoms.setText("");
                    }
                    if (n != 2) break;
                    this.nboService.runScriptNow("select remove {*};select add {*}[" + string + "]");
                    this.selected = string + " ";
                }
            }
        }
    }

    protected boolean helpDialogM(JTextPane jTextPane, String string) {
        if (string == null) {
            string = this.action.getSelectedIndex() == 0 ? "" : this.action.getSelectedItem().toString().split(" ")[0].toLowerCase();
        }
        if (string.equals("")) {
            if ((this.jtJmolInput.hasFocus() || this.jComboUse.hasFocus()) && this.jComboUse.getSelectedIndex() == 0) {
                jTextPane.setText("SHOW <formula> (create a molecule model from\n                its 'formula')\nSHOW <acceptor> <donor-1> <donor-2>...\n               (create supramolecular model from\n                radical 'acceptor' and ligand\n                'donor-i' formulas)\nThe chemical 'formula' is a valid Lewis-typeline formula, similar to textbook examples.Use colons to denote multiple bonds (C::O doublebond, C:::N triple bond, etc.) and parenthesesto identify repeat units or side groups.Atomic symbols in the range H-Cf (Z = 1-98)and repetition numbers 1-9 are allowed.Chemical formula symbols are case-sensitive.\n \nLigated free radicals (with free-valent acceptorsites) can also be formed in specified hapticitymotifs with chosen molecular ligands. Radical<acceptor> and ligand <donor-i> monomers arespecified by valid line formulas, with eachligand <donor> formula preceded by a number ofcolons (:) representing the number of 2e sitesin the desired ligand denticity (such as ':NH3'for monodentate ammine ligand, '::NH2CH::CH2'for bidentate vinylamine ligand, or ':::Bz' fortridentate benzene ligand). Each such ligationsymbol may be prefixed with a stoichiometriccoefficient 2-9 for the number of ligands.\n \nIn both molecular and supramolecular formulas,valid transition metal duodectet structuresare also accepted. For d-block molecular species,the default idealized metal hybridization isomercan be altered with the REBOND command.For d-block species one can also includecoordinative ligands (:Lig), enclosed inparentheses and preceded by a colon symbol.Formal 'ylidic' charges are allowed only foradjacent atom pairs (e.g., dative pi-bonds).\n \nModels may also be specified by using acronymsfrom a library of pre-formed species (manyat B3LYP/6-31+G* optimized level). Each suchacronym can also be used as a monovalent ligandin MUTATE commands, as illustrated below.\n \nCommon cyclic aromatic species\n Bz        C6H6   benzene\n A10R2L    C10H8  naphthalene\n A14R3L    C14H12 anthracene\n A18R4L    C18H16 tetracene\n A22R5L    C22H20 pentacene\n A14R3     C14H10 phenanthrene\n A14R4     C14H12 chrysene\n A16R4     C16H10 pyrene\n A18R4     C18H12 triphenylene\n A20R5     C20H12 benzopyrene\n A20R6     C20H10 corannulene\n A24R7     C24H12 coronene\n A32R10    C32H14 ovalene\nCommon cyclic saturated species\n R6C       C6H12 cyclohexane (chair)\n R6B         '        '      (boat t.s.) \n R6T         '        '      (twist-boat)\n R5        C5H10 cyclopentane\n R4        C4H8  cyclobutane\n R3        C3H6  cyclopropane\n RB222     [2,2,2]bicyclooctane\n RB221     [2,2,1]bicycloheptane (norbornane)\n RB211     [2,1,1]bicyclohexane\n RB111     [1,1,1]bicyclopentane (propellane)\n R5S       spiropentane\n RAD       adamantane\n \nCommon inorganic ligands\n acac   acetylacetonate anion   (bidentate)\n bipy   2,2\"\"-bipyridine         (bidentate)\n cp     cyclopentadienyl anion  (:, ::, :::)\n dien   diethylenetriamine      (tridentate)\n dppe   1,2-bis(diphenylphosphino)ethane\n                                (bidentate)\n edta   ethylenediaminetetraacetate anion\n                                (hexadentate)\n en     ethylenediamine         (bidentate)\n phen   1,10-phenanthroline     (bidentate)\n tren   tris(2-aminoethyl)amine (tetradentate)\n trien  triethylenetetramine    (tetradentate)\n \nPeptide fragments (HC::ONHCH2R)\n GLY       glycine\n ALA       alanine\n VAL       valine\n LEU       leucine\n ILE       isoleucine\n PRO       proline\n PHE       phenylalanine\n TYR       tyrosine\n TRP       tryptophan\n SER       serine\n THR       threonine\n CYS       cysteine\n MET       methionine\n ASN       asparagine\n GLN       glutamine\n ASP       aspartate\n GLU       glutamate\n LYS       lysine\n ARG       argenine\n HIS       histidine\n \nNucleic acid fragments\n NA_G      guanine\n NA_C      cytosine\n NA_A      adenine\n NA_T      thymine\n NA_U      uracil\n NA_R      ribose backbone fragment\n \nIn addition, the SHOW command recognizes\n'D3H' (trigonal bipyramid) or 'D4H' (octahedral)\nspecies, created as SF5, SF6, respectively.\n \n('SHOW' and 'FORM' are synonymous commands.) \nMolecular examples:\n SHOW CH3C::OOH      acetic acid\n SHOW CH3(CH2)4CH3   n-hexane\n SHOW WH2(:NH3)2     diammine of WH2\n SHOW NA_C           cytosine\n SHOW CH4            methane\n  MUTATE 3 RAD       methyladamantane\n SHOW ALA            alanine\n  MUTATE 7 ALA       ala-ala\n  MUTATE 17 ALA      ala-ala-ala, etc.\nSupramolecular examples:\n SHOW CH3 :H2O       hydrated methyl radical\n SHOW Cr 2:::Bz      dibenzene chromium\n SHOW CrCl3 2:H2O :NH3\n SHOW Cr 3::acac\n SHOW Cr ::::::edta\n");
            } else if (this.jComboSave.hasFocus()) {
                jTextPane.setText("SAVE.t filename     (save current model as file\n              'filename' of type 't' extension)\n \nParameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .mm  = MM2 molecular mechanics file (.mm2)\n .mnd = AM1/MINDO-type input file (.mnd)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n SAVE.G job   [save Gaussian-type 'job.gau' file]\n");
            } else {
                jTextPane.setText("NBOModel COMMAND SYNTAX\n \nCommand verbs are case-insensitive and canbe abbreviated by the leading unique characters.Arguments are separated by commas or spaces.Parameters are attached to the command verbafter a dot (viz., DRAW.ap MODEL).  Argumentsand parameters are case-insensitive, exceptfor chemical formulas and group acronyms.Use 'HELP <command>' (e.g., 'HELP SHOW') forfurther specifics of each COMMAND type.\n \nCOMMAND(.t)   arguments\n------------------------------------\nALTER         IA [IB IC ID] newvalue\nCLIP          IA IB\nDRAW          filename\nFUSE(.R)      IA IB\nHELP          command\nLINK          IA IB\nMUTATE        IA formula\nREBOND        IA symtype\nROTATE        AXIS angle\nSAVE.t        filename\nSHOW          formula\nSWITCH        IA IB\nSYMMETRY\nTRANSLATE     AXIS shift\nTWIST         IA IB IC ID newvalue\nUNIFY         CFI1 CFI2 IA1 IB1 IA2 IB2 dist\nUSE.t         filename\nVALUE         IA [IB IC ID]\n3CHB          IA IB :Ligand\n\n\nSHOW <formula> (create a molecule model from\n                its 'formula')\nSHOW <acceptor> <donor-1> <donor-2>...\n               (create supramolecular model from\n                radical 'acceptor' and ligand\n                'donor-i' formulas)\nThe chemical 'formula' is a valid Lewis-typeline formula, similar to textbook examples.Use colons to denote multiple bonds (C::O doublebond, C:::N triple bond, etc.) and parenthesesto identify repeat units or side groups.Atomic symbols in the range H-Cf (Z = 1-98)and repetition numbers 1-9 are allowed.Chemical formula symbols are case-sensitive.\n \nLigated free radicals (with free-valent acceptorsites) can also be formed in specified hapticitymotifs with chosen molecular ligands. Radical<acceptor> and ligand <donor-i> monomers arespecified by valid line formulas, with eachligand <donor> formula preceded by a number ofcolons (:) representing the number of 2e sitesin the desired ligand denticity (such as ':NH3'for monodentate ammine ligand, '::NH2CH::CH2'for bidentate vinylamine ligand, or ':::Bz' fortridentate benzene ligand). Each such ligationsymbol may be prefixed with a stoichiometriccoefficient 2-9 for the number of ligands.\n \nIn both molecular and supramolecular formulas,valid transition metal duodectet structuresare also accepted. For d-block molecular species,the default idealized metal hybridization isomercan be altered with the REBOND command.For d-block species one can also includecoordinative ligands (:Lig), enclosed inparentheses and preceded by a colon symbol.Formal 'ylidic' charges are allowed only foradjacent atom pairs (e.g., dative pi-bonds).\n \nModels may also be specified by using acronymsfrom a library of pre-formed species (manyat B3LYP/6-31+G* optimized level). Each suchacronym can also be used as a monovalent ligandin MUTATE commands, as illustrated below.\n \nCommon cyclic aromatic species\n Bz        C6H6   benzene\n A10R2L    C10H8  naphthalene\n A14R3L    C14H12 anthracene\n A18R4L    C18H16 tetracene\n A22R5L    C22H20 pentacene\n A14R3     C14H10 phenanthrene\n A14R4     C14H12 chrysene\n A16R4     C16H10 pyrene\n A18R4     C18H12 triphenylene\n A20R5     C20H12 benzopyrene\n A20R6     C20H10 corannulene\n A24R7     C24H12 coronene\n A32R10    C32H14 ovalene\nCommon cyclic saturated species\n R6C       C6H12 cyclohexane (chair)\n R6B         '        '      (boat t.s.) \n R6T         '        '      (twist-boat)\n R5        C5H10 cyclopentane\n R4        C4H8  cyclobutane\n R3        C3H6  cyclopropane\n RB222     [2,2,2]bicyclooctane\n RB221     [2,2,1]bicycloheptane (norbornane)\n RB211     [2,1,1]bicyclohexane\n RB111     [1,1,1]bicyclopentane (propellane)\n R5S       spiropentane\n RAD       adamantane\n \nCommon inorganic ligands\n acac   acetylacetonate anion   (bidentate)\n bipy   2,2\"\"-bipyridine         (bidentate)\n cp     cyclopentadienyl anion  (:, ::, :::)\n dien   diethylenetriamine      (tridentate)\n dppe   1,2-bis(diphenylphosphino)ethane\n                                (bidentate)\n edta   ethylenediaminetetraacetate anion\n                                (hexadentate)\n en     ethylenediamine         (bidentate)\n phen   1,10-phenanthroline     (bidentate)\n tren   tris(2-aminoethyl)amine (tetradentate)\n trien  triethylenetetramine    (tetradentate)\n \nPeptide fragments (HC::ONHCH2R)\n GLY       glycine\n ALA       alanine\n VAL       valine\n LEU       leucine\n ILE       isoleucine\n PRO       proline\n PHE       phenylalanine\n TYR       tyrosine\n TRP       tryptophan\n SER       serine\n THR       threonine\n CYS       cysteine\n MET       methionine\n ASN       asparagine\n GLN       glutamine\n ASP       aspartate\n GLU       glutamate\n LYS       lysine\n ARG       argenine\n HIS       histidine\n \nNucleic acid fragments\n NA_G      guanine\n NA_C      cytosine\n NA_A      adenine\n NA_T      thymine\n NA_U      uracil\n NA_R      ribose backbone fragment\n \nIn addition, the SHOW command recognizes\n'D3H' (trigonal bipyramid) or 'D4H' (octahedral)\nspecies, created as SF5, SF6, respectively.\n \n('SHOW' and 'FORM' are synonymous commands.) \nMolecular examples:\n SHOW CH3C::OOH      acetic acid\n SHOW CH3(CH2)4CH3   n-hexane\n SHOW WH2(:NH3)2     diammine of WH2\n SHOW NA_C           cytosine\n SHOW CH4            methane\n  MUTATE 3 RAD       methyladamantane\n SHOW ALA            alanine\n  MUTATE 7 ALA       ala-ala\n  MUTATE 17 ALA      ala-ala-ala, etc.\nSupramolecular examples:\n SHOW CH3 :H2O       hydrated methyl radical\n SHOW Cr 2:::Bz      dibenzene chromium\n SHOW CrCl3 2:H2O :NH3\n SHOW Cr 3::acac\n SHOW Cr ::::::edta\n\nUSE.t filename  (use file 'filename' of type 't'\n                 to initiate a modeling session)\n \n't' parameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .a   = NBO archive file (.47)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .l   = Gaussian log file (.log)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n USE.G ACETIC   (use Gaussian-type ACETIC.GAU\n                input file to start session)\n\nSYMMETRY           (determine point group)\n \nNote that exact point-group symmetry is amathematical idealization. NBOModel recognizes'effective' symmetry, adequate for chemicalpurposes even if actual atom positions deviateslightly (say, ~0.02A) from idealized symmetry.");
            }
        } else if (string.equals("alter")) {
            jTextPane.setText("ALTER IA newval     (nuclear charge of atom IA)\n      IA IB newval          (bond length IA-IB)\n      IA IB IC newval  (valence angle IA-IB-IC)\n      IA IB IC ID newval (dihedral IA-IB-IC-IC)\n \nExamples:\n ALTER 10 14.   [change atom 10 to Si (Z = 14)]\n ALTER  2 5 1.69  [change R(5-8) bond to 1.69A]\n ALTER  1 2 3 4 180.   [change 1-2-3-4 dihedral\n                          angle to 180 degrees]\n \nNote that 'ALTER 1 2 3 4 180.' changes ONLYthe 1-2-3-4 dihedral (often giving unphysicaldistorted geometry).  Use 'TWIST 1 2 3 4 180.'to form a proper torsional rotamer.\n \nUse VFILE to determine which angles can besafely ALTERed.  Otherwise, the coordinatesmay be re-defined, with unexpected effectson other variables.");
        } else if (string.equals("clip")) {
            jTextPane.setText("CLIP IA IB          (erase bond between IA, IB)\n \nExample:\n CLIP 1 2        [erase bond between atoms 1,2]\n \nNote that CLIP takes no account of electronicrequirements for a Lewis-compliant model.");
        } else if (string.equals("fuse")) {
            jTextPane.setText("FUSE IA,IB       (remove IA,IB and join the two\n                'dangling' sites by a new bond)\n \nAllowed parameter:\n .r = ring-forming (conformational search)\n \nExamples:\n FUSE 4 12    [remove atoms 4, 12 and draw a new\n          bond between resulting radical centers\n          (e.g., 3-11), with no geometry change]\n FUSE.r 4 12      [similar, but a conformational\n            search is performed to find the most\n                 suitable ring-closing geometry]\n \nNote that IA, IB must have similar valency, so\nthe resulting structure remains Lewis-compliant.\n");
        } else if (string.equals("link")) {
            jTextPane.setText("LINK IA IB  (draw a 'bond' between atoms IA, IB)\nExamples:\n LINK 3 17    [draws a 'bond: between atoms 3-17\nNote that this command (unlike FUSE) takes no\naccount of chemical reasonability.\n");
        } else if (string.equals("mutate")) {
            jTextPane.setText("MUTATE IA formula (replace atom IA by the group\n               of specified chemical 'formula',\n             if both are of consistent valency)\n \nExample:\n MUTATE 4 CH3     [remove monovalent atom 4 and\n           attach a methyl (CH3) radical in its\n         place, preserving valence consistency]\n");
        } else if (string.equals("rebond")) {
            jTextPane.setText("REBOND IA symtype   (select a new Lewis valence\n                   isomer of 'symtype' symmetry\n                   at transition metal atom IA)\n \nAllowed 'symtype' parameters (TM species only):\n \n ML6 bonding: c3vo      ('Outer' C3v [default])\n              c3vi       ('Inner' C3v symmetry)\n              c5vo       ('Outer' C5v symmetry)\n              c5vi       ('Inner' C5v symmetry)\n \n ML5 bonding: c4vo      ('Outer' C4v [default])\n              c4vi       ('Inner' C4v symmetry)\n \n ML4 bonding: td        (Td symmetry [default])\n              c3vi       ('Inner' C3v symmetry)\n              c4v        (C4v symmetry)\nExample:\n SHOW WH6       [Tungsten hexahydride, in ideal\n                        'c3vo' isomer geometry]\n REBOND 2 c5vi     [reform preceding WH6 isomer\n                     to alternative 'inner C5v'\n                         geometry at TM atom 2]\n");
        } else if (string.equals("switch")) {
            jTextPane.setText("SWITCH IA IB      [switch atoms IA, IB (and\n                  attached groups) to invert\n                  configuration at an attached\n                  stereocenter.]\nExample:\n SHOW ALA         (L-alanine)\n SWITCH 6 7       (switch to D-alanine)\n");
        } else if (string.equals("twist")) {
            jTextPane.setText("TWIST IA IB IC IC newval\n              IA-IB-IC-ID angle to 'newval')\n \nExample:\n SHOW C2H6          ethane (staggered)\n TWIST 1 2 3 4 0.   ethane (eclipsed)\n");
        } else if (string.equals("unify")) {
            jTextPane.setText("UNIFY CFI-1 CFI-2 IA1 IB1 IA2 IB2 dist\n          (form a complex from molecules in\n           cfiles CFI-1, CFI-2, chosen to have\n           linear IA1-IB1-IB2-IA2 alignment\n           and IA1-IA2 separation 'dist')\n \nCFI-1 and CFI-2 are two CFILES (previously\ncreated with SAVE.C); IA1, IB1 are two atoms\nof CFI-1 and IA2, IB2 are two atoms of CFI-2\nthat will be 'unified' in linear IA1-IB1-IB2-IA2\narrangement, with specified IA1-IA2 'dist'.\n \nExample:\n SHOW H2C::O       (create formaldehyde)\n SAVE.C H2CO       (save H2CO.cfi)\n SHOW NH3          (create ammonia)\n SAVE.C NH3        (save NH3.cfi)\n UNIFY H2CO.cfi NH3.cfi 2 3 1 2 4.3\n                   (creates H-bonded complex)\n");
        } else if (string.equals("3chb")) {
            jTextPane.setText("3CHB IA IB :Lig     (form 3-center hyperbond\n                    IA-IB-Lig to ligand :Lig)\nExamples:\n SHOW W(:NH3)3      (normal-valent W triammine)\n 3CHB  1 2 :NH3     (hyperbonded N-W-N triad)\n SHOW H2O           (water monomer)\n 3CHB  2 3 :OH2     (H-bonded water dimer)\n");
        } else if (string.equals("save")) {
            jTextPane.setText("SAVE.t filename     (save current model as file\n              'filename' of type 't' extension)\n \nParameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .mm  = MM2 molecular mechanics file (.mm2)\n .mnd = AM1/MINDO-type input file (.mnd)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n SAVE.G job   [save Gaussian-type 'job.gau' file]\n");
        } else if (string.equals("use")) {
            jTextPane.setText("USE.t filename  (use file 'filename' of type 't'\n                 to initiate a modeling session)\n \n't' parameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .a   = NBO archive file (.47)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .l   = Gaussian log file (.log)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n USE.G ACETIC   (use Gaussian-type ACETIC.GAU\n                input file to start session)\n");
        } else if (string.contains("sym")) {
            jTextPane.setText("SYMMETRY           (determine point group)\n \nNote that exact point-group symmetry is amathematical idealization. NBOModel recognizes'effective' symmetry, adequate for chemicalpurposes even if actual atom positions deviateslightly (say, ~0.02A) from idealized symmetry.");
        } else {
            this.appendOutputWithCaret("Unkown command type");
            return false;
        }
        return true;
    }

    protected void rawInputM(String string) {
        SB sB = new SB();
        this.appendToFile("CMD " + string, sB);
        this.appendOutputWithCaret(string);
        this.modelCmd(sB);
    }
}

