/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import javajs.util.Lst;
import jspecview.common.Coordinate;
import jspecview.common.ScaleData;
import jspecview.common.Spectrum;
import jspecview.common.ViewData;
import jspecview.common.XYScaleConverter;

class ImageView
implements XYScaleConverter {
    private int[] buf2d;
    private double grayFactorLast;
    private double averageGray;
    int xPixel0;
    int yPixel0;
    int xPixel1;
    int yPixel1;
    int imageWidth;
    int imageHeight;
    int xPixels;
    int yPixels;
    int xPixelZoom1;
    int yPixelZoom1;
    int xPixelZoom2;
    int yPixelZoom2;
    int xView1;
    int yView1;
    int xView2;
    int yView2;
    double minX = Double.NaN;
    double maxX;
    double minY;
    double maxY;
    double minZ;
    double maxZ;
    private ScaleData scaleData;
    private static final double DEFAULT_MIN_GRAY = 0.05;
    private static final double DEFAULT_MAX_GRAY = 0.3;

    ImageView() {
    }

    void set(ScaleData scaleData) {
        if (Double.isNaN(this.minX)) {
            this.minX = scaleData.minX;
            this.maxX = scaleData.maxX;
        }
        this.minZ = scaleData.minY;
        this.maxZ = scaleData.maxY;
        this.scaleData = new ScaleData();
    }

    void setZoom(int n, int n2, int n3, int n4) {
        this.xPixelZoom1 = Math.min(n, n3);
        this.yPixelZoom1 = Math.min(n2, n4);
        this.xPixelZoom2 = Math.max(n, n3);
        this.yPixelZoom2 = Math.max(n2, n4);
        this.setView();
    }

    void setXY0(Spectrum spectrum, int n, int n2) {
        this.xPixel0 = n;
        this.yPixel0 = n2;
        this.xPixel1 = this.xPixel0 + this.xPixels - 1;
        this.yPixel1 = this.yPixel0 + this.yPixels - 1;
        this.setMinMaxY(spectrum);
    }

    void setPixelWidthHeight(int n, int n2) {
        this.xPixels = n;
        this.yPixels = n2;
    }

    void resetView() {
        this.xView1 = 0;
        this.yView1 = 0;
        this.xView2 = this.imageWidth - 1;
        this.yView2 = this.imageHeight - 1;
    }

    void setView() {
        if (this.xPixelZoom1 == 0) {
            this.resetZoom();
        }
        int n = this.toImageX(this.xPixelZoom1);
        int n2 = this.toImageY(this.yPixelZoom1);
        int n3 = this.toImageX(this.xPixelZoom2);
        int n4 = this.toImageY(this.yPixelZoom2);
        this.xView1 = Math.min(n, n3);
        this.yView1 = Math.min(n2, n4);
        this.xView2 = Math.max(n, n3);
        this.yView2 = Math.max(n2, n4);
        this.setScaleData();
        this.resetZoom();
    }

    void resetZoom() {
        this.xPixelZoom1 = this.xPixel0;
        this.yPixelZoom1 = this.yPixel0;
        this.xPixelZoom2 = this.xPixel1;
        this.yPixelZoom2 = this.yPixel1;
    }

    int toImageX(int n) {
        return this.xView1 + (int)Math.floor((double)(n - this.xPixel0) / ((double)this.xPixels - 1.0) * (double)(this.xView2 - this.xView1));
    }

    int toImageY(int n) {
        return this.yView1 + (int)Math.floor((double)(n - this.yPixel0) / ((double)this.yPixels - 1.0) * (double)(this.yView2 - this.yView1));
    }

    int toImageX0(int n) {
        return Coordinate.intoRange((int)((1.0 * (double)n - (double)this.xPixel0) / (double)(this.xPixels - 1) * (double)(this.imageWidth - 1)), 0, this.imageWidth - 1);
    }

    int toImageY0(int n) {
        return Coordinate.intoRange((int)((1.0 * (double)n - (double)this.yPixel0) / (double)(this.yPixels - 1) * (double)(this.imageHeight - 1)), 0, this.imageHeight - 1);
    }

    boolean isXWithinRange(int n) {
        return n >= this.xPixel0 - 5 && n < this.xPixel0 + this.xPixels + 5;
    }

    int toSubspectrumIndex(int n) {
        return Coordinate.intoRange(this.imageHeight - 1 - this.toImageY(n), 0, this.imageHeight - 1);
    }

    double toX0(int n) {
        return this.maxX + (this.minX - this.maxX) * (double)(this.fixX(n) - this.xPixel0) / (double)(this.xPixels - 1);
    }

    int toPixelX0(double d) {
        return this.xPixel1 - (int)((d - this.minX) / (this.maxX - this.minX) * (double)(this.xPixels - 1));
    }

    int toPixelY0(double d) {
        return this.yPixel1 - (int)(d / (double)(this.imageHeight - 1) * (double)(this.yPixels - 1));
    }

    int subIndexToPixelY(int n) {
        double d = 1.0 * (double)(this.imageHeight - 1 - n - this.yView1) / (double)(this.yView2 - this.yView1);
        int n2 = this.yPixel0 + (int)(d * (double)(this.yPixels - 1));
        return n2;
    }

    int fixSubIndex(int n) {
        return Coordinate.intoRange(n, this.imageHeight - 1 - this.yView2, this.imageHeight - 1 - this.yView1);
    }

    void setView0(int n, int n2, int n3, int n4) {
        int n5 = this.toImageX0(n);
        int n6 = this.toImageY0(n2);
        int n7 = this.toImageX0(n3);
        int n8 = this.toImageY0(n4);
        this.xView1 = Math.min(n5, n7);
        this.yView1 = Math.min(n6, n8);
        this.xView2 = Math.max(n5, n7);
        this.yView2 = Math.max(n6, n8);
        this.resetZoom();
    }

    synchronized int[] get2dBuffer(Spectrum spectrum, boolean bl) {
        Lst<Spectrum> lst = spectrum.getSubSpectra();
        if (lst == null || !((Spectrum)lst.get(0)).isContinuous()) {
            return null;
        }
        Coordinate[] coordinateArray = spectrum.getXYCoords();
        int n = lst.size();
        this.imageWidth = coordinateArray.length;
        this.imageHeight = n;
        double d = 255.0 / (this.maxZ - this.minZ);
        if (!bl && this.buf2d != null && d == this.grayFactorLast) {
            return this.buf2d;
        }
        this.grayFactorLast = d;
        int n2 = this.imageWidth * this.imageHeight;
        int[] nArray = new int[n2];
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            Coordinate[] coordinateArray2 = ((Spectrum)lst.get((int)i)).xyCoords;
            if (coordinateArray2.length != coordinateArray.length) {
                return null;
            }
            double d3 = ((Spectrum)lst.get(i)).getUserYFactor();
            for (int j = 0; j < coordinateArray.length; ++j) {
                double d4 = coordinateArray2[j].getYVal();
                int n3 = 255 - Coordinate.intoRange((int)((d4 * d3 - this.minZ) * d), 0, 255);
                nArray[--n2] = n3;
                d2 += (double)n3;
            }
        }
        this.averageGray = 1.0 - d2 / (double)(this.imageWidth * this.imageHeight) / 255.0;
        System.out.println("Average gray = " + this.averageGray);
        this.buf2d = nArray;
        return nArray;
    }

    int[] adjustView(Spectrum spectrum, ViewData viewData) {
        int n = 0;
        boolean bl = false;
        while (((bl = this.averageGray < 0.05) || this.averageGray > 0.3) && n++ < 10) {
            viewData.scaleSpectrum(-2, bl ? 2.0 : 0.5);
            this.set(viewData.getScale());
            this.get2dBuffer(spectrum, false);
        }
        return this.buf2d;
    }

    int[] getBuffer() {
        return this.buf2d;
    }

    void setMinMaxY(Spectrum spectrum) {
        Lst<Spectrum> lst = spectrum.getSubSpectra();
        Spectrum spectrum2 = (Spectrum)lst.get(0);
        this.maxY = spectrum2.getY2D();
        this.minY = ((Spectrum)lst.get(lst.size() - 1)).getY2D();
        if (spectrum2.y2DUnits.equalsIgnoreCase("Hz")) {
            this.maxY /= spectrum2.freq2dY;
            this.minY /= spectrum2.freq2dY;
        }
        this.setScaleData();
    }

    private void setScaleData() {
        this.scaleData.minY = this.minY;
        this.scaleData.maxY = this.maxY;
        this.scaleData.setYScale(this.toY(this.yPixel0), this.toY(this.yPixel1), false, false);
    }

    @Override
    public int fixX(int n) {
        return n < this.xPixel0 ? this.xPixel0 : (n > this.xPixel1 ? this.xPixel1 : n);
    }

    @Override
    public int fixY(int n) {
        return Coordinate.intoRange(n, this.yPixel0, this.yPixel1);
    }

    @Override
    public ScaleData getScale() {
        return this.scaleData;
    }

    @Override
    public double toX(int n) {
        return this.maxX + (this.minX - this.maxX) * (double)this.toImageX(this.fixX(n)) / (double)(this.imageWidth - 1);
    }

    @Override
    public double toY(int n) {
        int n2 = this.toSubspectrumIndex(n);
        return this.maxY + (this.minY - this.maxY) * (double)n2 / (double)(this.imageWidth - 1);
    }

    @Override
    public int toPixelX(double d) {
        double d2 = this.toX(this.xPixel0);
        double d3 = this.toX(this.xPixel1);
        return this.xPixel0 + (int)((d - d2) / (d3 - d2) * (double)(this.xPixels - 1));
    }

    @Override
    public int toPixelY(double d) {
        double d2 = (d - this.scaleData.minYOnScale) / (this.scaleData.maxYOnScale - this.scaleData.minYOnScale);
        return (int)((double)this.yPixel0 + d2 * (double)this.yPixels);
    }

    @Override
    public int getXPixels() {
        return this.xPixels;
    }

    @Override
    public int getYPixels() {
        return this.yPixels;
    }

    @Override
    public int getXPixel0() {
        return this.xPixel0;
    }
}

