/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import javajs.util.PT;
import javajs.util.T3;
import org.jmol.adapter.readers.more.ForceFieldReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;

public class Mol2Reader
extends ForceFieldReader {
    private int nAtoms = 0;
    private int ac = 0;
    private boolean isPDB = false;
    private int lastSequenceNumber = Integer.MAX_VALUE;
    private int chainID = 64;

    @Override
    protected void initializeReader() throws Exception {
        this.setUserAtomTypes();
    }

    @Override
    public boolean checkLine() throws Exception {
        if (this.line.equals("@<TRIPOS>MOLECULE")) {
            if (!this.processMolecule()) {
                return true;
            }
            this.continuing = !this.isLastModel(this.modelNumber);
            return false;
        }
        if (this.line.length() != 0 && this.line.charAt(0) == '#') {
            this.checkCurrentLineForScript();
        }
        return true;
    }

    private boolean processMolecule() throws Exception {
        this.isPDB = false;
        String string = this.rd().trim();
        if (!this.doGetModel(++this.modelNumber, string)) {
            return false;
        }
        this.lastSequenceNumber = Integer.MAX_VALUE;
        this.chainID = 64;
        this.rd();
        this.line = this.line + " 0 0 0 0 0 0";
        this.ac = this.parseIntStr(this.line);
        int n = this.parseInt();
        int n2 = this.parseInt();
        this.rd();
        this.rd();
        if (this.rd() != null && (this.line.length() == 0 || this.line.charAt(0) != '@') && this.rd() != null && this.line.length() != 0 && this.line.charAt(0) != '@') {
            if (this.line.indexOf("jmolscript:") >= 0) {
                this.checkCurrentLineForScript();
                if (this.line.equals("#")) {
                    this.line = "";
                }
            }
            if (this.line.length() != 0) {
                string = string + ": " + this.line.trim();
            }
        }
        this.newAtomSet(string);
        while (this.line != null && !this.line.equals("@<TRIPOS>MOLECULE")) {
            if (this.line.equals("@<TRIPOS>ATOM")) {
                this.readAtoms(this.ac);
                this.asc.setAtomSetName(string);
            } else if (this.line.equals("@<TRIPOS>BOND")) {
                this.readBonds(n);
            } else if (this.line.equals("@<TRIPOS>SUBSTRUCTURE")) {
                this.readResInfo(n2);
            } else if (this.line.equals("@<TRIPOS>CRYSIN")) {
                this.readCrystalInfo();
            }
            this.rd();
        }
        this.nAtoms += this.ac;
        if (this.isPDB) {
            this.setIsPDB();
            this.setModelPDB(true);
        }
        this.applySymmetryAndSetTrajectory();
        return true;
    }

    private void readAtoms(int n) throws Exception {
        int n2;
        Object object;
        if (n == 0) {
            return;
        }
        int n3 = this.asc.ac;
        for (int i = 0; i < n; ++i) {
            object = this.asc.addNewAtom();
            String[] stringArray = PT.getTokens(this.rd());
            String string = stringArray[5];
            ((Atom)object).atomName = stringArray[1] + '\u0000' + string;
            n2 = string.indexOf(".");
            ((Atom)object).elementSymbol = n2 == 0 ? ((Atom)object).atomName : (n2 > 0 ? string.substring(0, n2) : string);
            ((T3)object).set(this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]));
            if (stringArray.length > 6) {
                ((Atom)object).sequenceNumber = this.parseIntStr(stringArray[6]);
                if (((Atom)object).sequenceNumber < this.lastSequenceNumber) {
                    if (this.chainID == 90) {
                        this.chainID = 96;
                    }
                    ++this.chainID;
                }
                this.lastSequenceNumber = ((Atom)object).sequenceNumber;
                this.setChainID((Atom)object, "" + (char)this.chainID);
            }
            if (stringArray.length > 7) {
                ((Atom)object).group3 = stringArray[7];
            }
            if (stringArray.length <= 8) continue;
            ((Atom)object).partialCharge = this.parseFloatStr(stringArray[8]);
            if (((Atom)object).partialCharge != (float)((int)((Atom)object).partialCharge)) continue;
            ((Atom)object).formalCharge = (int)((Atom)object).partialCharge;
        }
        Atom[] atomArray = this.asc.atoms;
        object = atomArray[n3].group3;
        if (object == null) {
            return;
        }
        boolean bl = false;
        if (!((String)object).equals("UNK") && !((String)object).startsWith("RES")) {
            int n4 = this.asc.ac;
            while (--n4 >= n3) {
                if (((String)object).equals(atomArray[this.asc.ac - 1].group3)) continue;
                bl = true;
                break;
            }
            if (bl) {
                bl = false;
                n4 = this.asc.ac;
                while (--n4 >= n3 && (n2 = this.getPDBGroupLength(atomArray[n4].group3)) != 0 && n2 <= 3) {
                    if (!this.vwr.getJBR().isKnownPDBGroup(((String)object).substring(0, n2), Integer.MAX_VALUE)) continue;
                    this.isPDB = true;
                    bl = true;
                    break;
                }
            }
        }
        int n5 = this.asc.ac;
        while (--n5 >= n3) {
            if (bl) {
                object = atomArray[n5].group3;
                object = ((String)object).substring(0, this.getPDBGroupLength((String)object));
                atomArray[n5].isHetero = this.vwr.getJBR().isHetero((String)object);
            } else {
                object = null;
            }
            atomArray[n5].group3 = object;
        }
    }

    private int getPDBGroupLength(String string) {
        int n;
        int n2 = n = string.length();
        while (--n2 > 0 && Character.isDigit(string.charAt(n2))) {
        }
        return ++n2;
    }

    private void readBonds(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            String[] stringArray = PT.getTokens(this.rd());
            int n2 = this.parseIntStr(stringArray[1]);
            int n3 = this.parseIntStr(stringArray[2]);
            int n4 = this.parseIntStr(stringArray[3]);
            if (n4 == Integer.MIN_VALUE) {
                n4 = stringArray[3].equals("ar") ? 515 : (stringArray[3].equals("am") ? 1 : 17);
            }
            this.asc.addBond(new Bond(this.nAtoms + n2 - 1, this.nAtoms + n3 - 1, n4));
        }
    }

    private void readResInfo(int n) throws Exception {
        for (int i = 0; i < n; ++i) {
            this.rd();
        }
    }

    private void readCrystalInfo() throws Exception {
        int n;
        this.rd();
        String[] stringArray = this.getTokens();
        if (stringArray.length < 6) {
            return;
        }
        String string = "";
        for (n = 6; n < stringArray.length; ++n) {
            string = string + " " + stringArray[n];
        }
        string = string == "" ? " P1" : string + " *";
        string = string.substring(1);
        this.setSpaceGroupName(string);
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (n = 0; n < 6; ++n) {
            this.setUnitCellItem(n, this.parseFloatStr(stringArray[n]));
        }
        Atom[] atomArray = this.asc.atoms;
        for (int i = 0; i < this.ac; ++i) {
            this.setAtomCoord(atomArray[this.nAtoms + i]);
        }
    }
}

