/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.dssx;

import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.JmolAnnotationParser;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.modelsetbio.Resolver;
import org.jmol.script.SV;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class AnnotationParser
implements JmolAnnotationParser {
    private static Map<String, String> pdbAtomForH;

    private void getAnnotationKVPairs(SV sV, String string, String string2, SB sB, String string3, boolean bl, boolean bl2, int n) {
        Map map = sV.getMap();
        if (map == null || map.isEmpty()) {
            return;
        }
        if (map.containsKey("_map")) {
            map = ((SV)map.get("_map")).getMap();
        }
        String string4 = this.getDataKey(n);
        if (bl && map.containsKey(string4)) {
            if (string == null || string2.indexOf(string) >= 0) {
                sB.append(((SV)map.get(string4)).asString()).append("\n");
            }
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string5 = (String)entry.getKey();
            if (string5.equals(string4)) continue;
            if (string5.equals("metadata")) {
                sB.append("\n");
            }
            SV sV2 = (SV)entry.getValue();
            if (sV2.tok == 6) {
                if (n == 1073742189 && !bl) {
                    sB.append(string5).append("\n");
                    continue;
                }
                this.getAnnotationKVPairs(sV2, string, (string2.length() == 0 ? "" : string2 + ".") + string5, sB, (string3.length() == 0 ? "" : string3 + "\t") + string5, bl, bl2, n);
                continue;
            }
            String string6 = sV2.asString();
            if (string != null && string6.indexOf(string) < 0 && string3.indexOf(string) < 0 && string5.indexOf(string) < 0 && string2.indexOf(string) < 0 || bl && bl2) continue;
            if (string3.length() > 0) {
                sB.append(string3).append("\t");
            }
            sB.append(string5).append("=");
            sB.append(string6).append("\n");
        }
    }

    private String getDataKey(int n) {
        switch (n) {
            case 1073741925: {
                return "mappings";
            }
            case 1073742189: {
                return "outliers";
            }
        }
        return null;
    }

    public String catalogStructureUnits(Viewer viewer, SV sV, int[] nArray, Map<String, int[]> map, Object object, Map<String, Integer> map2) {
        String string = "Use within(rna3d, TYPE) where TYPE is one of: ";
        Map map3 = sV.getMap();
        if (map3 == null) {
            return null;
        }
        try {
            sV.mapPut("_map", SV.newV((int)6, (Object)map3));
            Lst lst = new Lst();
            Set set = map3.entrySet();
            for (Map.Entry entry : set) {
                SV sV2 = (SV)entry.getValue();
                Lst lst2 = sV2.getList();
                if (lst2 == null) continue;
                String string2 = (String)entry.getKey();
                string = string + "\"" + string2 + "\" ";
                SV sV3 = SV.newS((String)string2);
                int n = lst2.size();
                while (--n >= 0) {
                    int n2;
                    BS bS;
                    SV sV4 = (SV)lst2.get(n);
                    Map map4 = sV4.getMap();
                    sV2 = (SV)map4.get("units");
                    map4.put("_isres", SV.vT);
                    Object object2 = sV2 == null || sV2.tok == 7 ? sV2.getList() : (sV2.tok == 4 ? new Lst() : null);
                    if (object2 == null) continue;
                    if (sV2.tok == 4) {
                        bS = PT.split((String)sV2.asString(), (String)",");
                        n2 = ((String[])bS).length;
                        while (--n2 >= 0) {
                            object2.addLast((Object)SV.newS((String)bS[n2].trim()));
                        }
                    }
                    if (object2.size() <= 0) continue;
                    bS = new BS();
                    map4.put("_atoms", SV.getVariable((Object)bS));
                    map4.put("_path", sV3);
                    lst.addLast((Object)sV4);
                    n2 = object2.size();
                    while (--n2 >= 0) {
                        this.catalogUnit(viewer, null, ((SV)object2.get(n2)).asString(), 0.0f, bS, nArray, map, null, map2);
                    }
                }
            }
            sV.mapPut("_list", SV.newV((int)7, (Object)lst));
        }
        catch (Exception exception) {
            Logger.info((String)(exception + " while cataloging structures"));
            return null;
        }
        return string;
    }

    public Lst<Object> catalogValidations(Viewer viewer, SV sV, int[] nArray, Map<String, int[]> map, Map<String, Integer> map2, Map<String, Integer> map3) {
        Map map4 = sV.getMap();
        if (map4 == null) {
            return null;
        }
        Lst lst = new Lst();
        int n = nArray.length - 1;
        try {
            map4 = this.getMainItem(map4).getMap();
            sV.mapPut("_map", SV.newV((int)6, (Object)map4));
            Lst lst2 = new Lst();
            sV.mapPut("_list", SV.newV((int)7, (Object)lst2));
            Set set = map4.entrySet();
            for (Map.Entry entry : set) {
                Map map5;
                float[][] fArray = AU.newFloat2((int)n);
                int n2 = n;
                while (--n2 >= 0) {
                    fArray[n2] = new float[nArray[n2 + 1] - nArray[n2]];
                }
                SV sV2 = (SV)entry.getValue();
                Lst lst3 = sV2.getList();
                if (lst3 == null && (map5 = sV2.getMap()) != null && (sV2 = (SV)map5.get("outliers")) != null) {
                    lst3 = sV2.getList();
                }
                if (lst3 == null) continue;
                boolean bl = false;
                String string = (String)entry.getKey();
                SV sV3 = SV.newS((String)string);
                boolean bl2 = false;
                int n3 = lst3.size();
                while (--n3 >= 0) {
                    int n4;
                    BS bS;
                    float f;
                    SV sV4 = (SV)lst3.get(n3);
                    map5 = sV4.getMap();
                    sV2 = (SV)map5.get("units");
                    SV sV5 = (SV)map5.get("value");
                    float f2 = f = sV5 == null ? 1.0f : SV.fValue((T)sV5);
                    Object object = f == 0.0f || sV2 == null || sV2.tok == 7 ? sV2.getList() : (sV2.tok == 4 ? new Lst() : null);
                    if (object == null) continue;
                    if (sV2.tok == 4) {
                        bS = PT.split((String)sV2.asString(), (String)",");
                        n4 = ((String[])bS).length;
                        while (--n4 >= 0) {
                            object.addLast((Object)SV.newS((String)bS[n4].trim()));
                        }
                    }
                    if (object.size() <= 0) continue;
                    bS = new BS();
                    map5.put("_atoms", SV.getVariable((Object)bS));
                    map5.put("_path", sV3);
                    bl = true;
                    lst2.addLast((Object)sV4);
                    n4 = object.size();
                    while (--n4 >= 0) {
                        boolean bl3 = this.catalogUnit(viewer, fArray, ((SV)object.get(n4)).asString(), f, bS, nArray, map, map2, map3);
                        if (bl3) {
                            map5.put("_isres", SV.vT);
                        }
                        bl2 |= bl3;
                    }
                }
                if (!bl) continue;
                n3 = n;
                while (--n3 >= 0) {
                    if (fArray[n3] == null) continue;
                    lst.addLast((Object)string);
                    lst.addLast((Object)fArray[n3]);
                    lst.addLast((Object)n3);
                    lst.addLast((Object)bl2);
                }
            }
            return lst;
        }
        catch (Exception exception) {
            Logger.info((String)(exception + " while cataloging validations"));
            return null;
        }
    }

    private SV getMainItem(Map<String, SV> map) {
        for (Map.Entry<String, SV> entry : map.entrySet()) {
            String string = entry.getKey();
            if (string.contains("metadata")) continue;
            return entry.getValue();
        }
        return null;
    }

    public Lst<SV> initializeAnnotation(SV sV, int n, int n2) {
        Map map = sV.getMap();
        SV sV2 = (SV)map.get("_list");
        if (sV2 != null) {
            return sV2.getList();
        }
        String string = this.getDataKey(n);
        SV sV3 = this.getMainItem(map);
        map.put("_map", sV3);
        boolean bl = true;
        Hashtable<String, SV> hashtable = new Hashtable<String, SV>();
        map.put("_cat", SV.newV((int)6, hashtable));
        Lst lst = new Lst();
        sV2 = SV.newV((int)7, (Object)lst);
        map.put("_list", sV2);
        for (Map.Entry entry : sV3.getMap().entrySet()) {
            String string2 = (String)entry.getKey();
            SV sV4 = (SV)entry.getValue();
            hashtable.putAll(sV4.getMap());
            for (Map.Entry entry2 : sV4.getMap().entrySet()) {
                String string3 = (String)entry2.getKey();
                SV sV5 = (SV)entry2.getValue();
                SV sV6 = sV5.mapGet(string);
                Lst lst2 = sV6.getList();
                int n3 = lst2.size();
                while (--n3 >= 0) {
                    SV sV7;
                    SV sV8 = (SV)lst2.get(n3);
                    lst.addLast((Object)sV8);
                    Map map2 = sV8.getMap();
                    SV sV9 = (SV)map2.get("chain_id");
                    SV sV10 = (SV)map2.get("start");
                    SV sV11 = (SV)map2.get("end");
                    int n4 = 0;
                    int n5 = 0;
                    String string4 = "modelIndex=" + n2 + "&chain='" + sV9.value + "'";
                    if (sV10 != null && sV11 != null) {
                        n4 = sV10.mapGet((String)"residue_number").intValue;
                        n5 = sV11.mapGet((String)"residue_number").intValue;
                        string4 = string4 + "&seqid>=" + n4 + "&seqid<=" + n5;
                    } else {
                        n5 = 1;
                        string4 = string4 + "&seqid>0";
                    }
                    SV sV12 = sV7 = bl && n4 >= n5 ? SV.getVariable((Object)new BS()) : (SV)hashtable.get(string4);
                    if (sV7 == null) {
                        sV7 = SV.newS((String)string4);
                        hashtable.put(string4, sV7);
                    }
                    map2.put("_atoms", sV7);
                    map2.put("_path", SV.newS((String)(string2 + "." + string3)));
                    map2.put("domain", sV5);
                }
            }
        }
        return lst;
    }

    private void findAnnotationAtoms(Viewer viewer, String string, Lst<SV> lst, String string2, BS bS) {
        if (lst == null) {
            return;
        }
        System.out.println("Checking " + string + " for " + string2);
        Object object = viewer.extractProperty(lst, (Object)("[" + string2 + "]"), -1);
        Lst lst2 = null;
        if (object instanceof Lst) {
            lst2 = (Lst)object;
        } else if (object instanceof SV) {
            lst2 = ((SV)object).getList();
        }
        if (lst2 == null) {
            return;
        }
        int n = lst2.size();
        for (int i = 0; i < n; ++i) {
            Map map;
            Object object2 = lst2.get(i);
            Map map2 = map = object2 instanceof SV ? ((SV)object2).getMap() : (Map)object2;
            if (map == null) {
                return;
            }
            bS.or(this.setAnnotationAtoms(viewer, map, i));
        }
    }

    private BS setAnnotationAtoms(Viewer viewer, Map<String, SV> map, int n) {
        SV sV = map.get("_atoms");
        if (sV.tok != 10) {
            BS bS = viewer.getAtomBitSet(sV.value);
            if (n >= 0) {
                Logger.info((String)("#" + (n + 1) + " found " + bS.cardinality() + " atoms for " + sV.value));
            }
            sV.tok = 10;
            sV.value = bS;
        }
        return (BS)sV.value;
    }

    private boolean catalogUnit(Viewer viewer, float[][] fArray, String string, float f, BS bS, int[] nArray, Map<String, int[]> map, Map<String, Integer> map2, Map<String, Integer> map3) {
        boolean bl;
        Integer n;
        String[] stringArray = PT.split((String)(string + (fArray == null ? "||||" : "|||")), (String)"|");
        if (stringArray.length < 8 || stringArray[1].length() == 0 || stringArray[2].length() == 0 || stringArray[3].length() == 0 || stringArray[4].length() == 0) {
            return false;
        }
        String string2 = stringArray[1].length() == 0 ? "1" : stringArray[1];
        int n2 = map3 == null ? PT.parseInt((String)string2) - 1 : -1;
        Integer n3 = n = n2 >= 0 ? null : map3.get(string2);
        if (n != null) {
            n2 = n;
        }
        if (n2 >= nArray.length) {
            return false;
        }
        String string3 = stringArray[1] + "_" + viewer.getChainID(stringArray[2], true) + "_" + stringArray[4] + "_" + stringArray[7].toLowerCase();
        int n4 = nArray[n2];
        boolean bl2 = bl = map2 == null || stringArray[5].length() == 0;
        if (bl) {
            int[] nArray2 = map.get(string3);
            if (nArray2 != null) {
                int n5 = nArray2[1];
                int n6 = nArray2[0];
                while (--n5 >= n6) {
                    bS.set(n4 + n5);
                    if (fArray == null) continue;
                    float[] fArray2 = fArray[n2];
                    int n7 = n5;
                    fArray2[n7] = fArray2[n7] + Math.abs(f);
                }
            }
        } else {
            String string4;
            Integer n8;
            if (stringArray[5].charAt(0) == 'H') {
                stringArray[5] = this.getAttachedAtomForPDBH(stringArray[3], stringArray[5]);
            }
            if ((n8 = map2.get(string4 = string3 + "_" + stringArray[5] + "_" + stringArray[6].toLowerCase())) != null) {
                int n9 = n8;
                bS.set(n4 + n9);
                if (fArray != null) {
                    float[] fArray3 = fArray[n2];
                    int n10 = n9;
                    fArray3[n10] = fArray3[n10] + Math.abs(f);
                }
            }
        }
        return bl;
    }

    public BS getAtomBits(Viewer viewer, String string, Object object, Map<String, Object> map, int n, int n2, BS bS) {
        BS bS2;
        boolean bl;
        if (object == null) {
            return new BS();
        }
        boolean bl2 = bl = !string.contains("NOCACHE");
        if (!bl) {
            string = PT.rep((String)string, (String)"NOCACHE", (String)"").trim();
        }
        BS bS3 = bS2 = bl ? (BS)map.get(string) : null;
        if (bS2 != null) {
            return bS2;
        }
        bS2 = new BS();
        if (bl) {
            map.put(string, bS2);
        }
        try {
            Lst<SV> lst = this.initializeAnnotation((SV)object, n, n2);
            int n3 = string.toLowerCase().indexOf(" where ");
            String string2 = PT.rep((String)(n3 < 0 ? string : string.substring(0, n3)), (String)" ", (String)"");
            String string3 = n3 < 0 ? "" : string.substring(n3 + 7).trim();
            string2 = string2.indexOf(".") < 0 ? " _path like '" + string2 + "*'" : " _path='" + string2 + "'";
            string3 = "select * where " + (n3 < 0 ? string2 : "(" + string3 + ") and (" + string2 + ")");
            Logger.info((String)("looking for " + string3));
            this.findAnnotationAtoms(viewer, string2, lst, string3, bS2);
            bS2.and(bS);
        }
        catch (Exception exception) {
            System.out.println(exception.toString() + " in AnnotationParser");
            bS2.clearAll();
        }
        return bS2;
    }

    public Lst<Float> getAtomValidation(Viewer viewer, String string, Atom atom) {
        int n = 0;
        int n2 = 0;
        Lst lst = null;
        Map map = null;
        Lst lst2 = null;
        try {
            int n3 = atom.i;
            lst = new Lst();
            lst2 = ((SV)viewer.ms.getModelAuxiliaryInfo((int)atom.mi).get("validation")).mapGet("_list").getList();
            n2 = lst2.size();
            for (n = 0; n < n2; ++n) {
                map = ((SV)lst2.get(n)).getMap();
                if (!((SV)map.get((Object)"_path")).value.equals(string) || !((BS)((SV)map.get((Object)"_atoms")).value).get(n3)) continue;
                SV sV = (SV)map.get("value");
                lst.addLast((Object)(sV.tok == 3 ? (Float)sV.value : Float.valueOf(sV.asFloat())));
            }
            return lst;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getAnnotationInfo(Viewer viewer, SV sV, String string, int n, int n2) {
        boolean bl;
        SB sB = new SB();
        if ("".equals(string)) {
            string = null;
        }
        boolean bl2 = bl = string != null && (string.equals("all") || string.endsWith(" all"));
        if (bl) {
            Lst<SV> lst = this.initializeAnnotation(sV, n, n2);
            int n3 = lst.size();
            while (--n3 >= 0) {
                this.setAnnotationAtoms(viewer, ((SV)lst.get(n3)).getMap(), -1);
            }
            string = string.substring(0, Math.max(0, string.length() - 4)).trim();
        }
        if ("".equals(string)) {
            string = null;
        }
        if (n == 1073742189 && !bl && string == null) {
            return sV.mapGet("_note").asString();
        }
        boolean bl3 = string != null && string.indexOf(".") >= 0 && string.indexOf(".*") < 0;
        string = PT.rep((String)string, (String)"*", (String)"");
        try {
            this.getAnnotationKVPairs(sV, string, "", sB, "", bl, bl3, n);
        }
        catch (Exception exception) {
            System.out.println(exception.getStackTrace());
        }
        return sB.toString();
    }

    public String getAttachedAtomForPDBH(String string, String string2) {
        if (string2.charAt(0) == 'H') {
            String string3;
            if (pdbAtomForH == null) {
                pdbAtomForH = new Hashtable<String, String>();
                this.assignPDBH("", "N H H1 H2 H3 CB HB2 HB3 CD HD2 HD3 CG HG2 HG3 C2' H2'' H2' C5' H5'' H5' OXT HXT");
                int n = Resolver.pdbBondInfo.length;
                while (--n >= 1) {
                    this.assignPDBH(Group.group3Names[n], Resolver.pdbBondInfo[n]);
                }
            }
            if ((string3 = pdbAtomForH.get(string2)) == null) {
                string3 = pdbAtomForH.get(string + string2);
            }
            if (string3 != null) {
                return string3;
            }
        }
        return string2;
    }

    private void assignPDBH(String string, String string2) {
        String[] stringArray = PT.getTokens((String)PT.rep((String)string2, (String)"@", (String)" "));
        String string3 = null;
        for (String string4 : stringArray) {
            if (string4.charAt(0) != 'H') {
                string3 = string4;
                continue;
            }
            string4 = string + string4;
            if (string4.indexOf("?") >= 0) {
                string4 = string4.substring(0, string4.length() - 1);
                pdbAtomForH.put(string4 + "1", string3);
                pdbAtomForH.put(string4 + "2", string3);
                pdbAtomForH.put(string4 + "3", string3);
                continue;
            }
            pdbAtomForH.put(string4, string3);
        }
    }

    public void fixAtoms(int n, SV sV, BS bS, int n2, int n3) {
        Lst<SV> lst = this.initializeAnnotation(sV, n2, n);
        int n4 = lst.size();
        while (--n4 >= 0) {
            Map map = ((SV)lst.get(n4)).getMap();
            SV sV2 = (SV)map.get("_atoms");
            if (sV2 == null || sV2.tok != 10) continue;
            BSUtil.shiftBits((BS)((BS)sV2.value), (BS)bS, (((SV)lst.get(n4)).mapGet("_isres") != null ? 1 : 0) != 0, (int)(((BS)sV2.value).length() + n3));
        }
    }

    public void getBasePairs(Viewer viewer, int n) {
    }

    public String calculateDSSRStructure(Viewer viewer, BS bS) {
        return null;
    }

    public String fixDSSRJSONMap(Map<String, Object> map) {
        return null;
    }

    public String getHBonds(ModelSet modelSet, int n, Lst<Bond> lst, boolean bl) {
        return null;
    }

    public void setGroup1(ModelSet modelSet, int n) {
    }
}

